/*
 * Decompiled with CFR 0.152.
 */
package hermes.util;

import java.nio.CharBuffer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import org.apache.log4j.Logger;

public class MappedStringContent
implements AbstractDocument.Content {
    private static final Logger log = Logger.getLogger(MappedStringContent.class);
    private CharBuffer chars;

    public MappedStringContent(CharBuffer chars) {
        this.chars = chars;
    }

    @Override
    public Position createPosition(int offset) throws BadLocationException {
        this.CheckLocation(offset);
        return new MyPosition(offset);
    }

    @Override
    public void getChars(int where, int len, Segment txt) throws BadLocationException {
        log.debug((Object)("getChars() where=" + where + " len=" + len));
        this.chars.position(where);
        char[] rval = new char[len];
        this.chars.get(rval, where, len);
        txt.array = rval;
        txt.count = len;
        txt.offset = 0;
    }

    private final void CheckLocation(int offset) throws BadLocationException {
        if (offset >= this.chars.limit()) {
            throw new BadLocationException("Max size is " + this.chars.limit(), offset);
        }
    }

    @Override
    public String getString(int where, int len) throws BadLocationException {
        this.CheckLocation(where);
        char[] rval = new char[len];
        this.chars.get(rval, where, len);
        String string = new String(rval);
        log.debug((Object)("getString() rval=" + string));
        return string;
    }

    @Override
    public UndoableEdit insertString(int where, String str) throws BadLocationException {
        return null;
    }

    @Override
    public int length() {
        log.debug((Object)("length=" + this.chars.limit()));
        return this.chars.limit();
    }

    @Override
    public UndoableEdit remove(int where, int nitems) throws BadLocationException {
        return null;
    }

    public class MyPosition
    implements Position {
        private int offset;

        MyPosition(int offset) {
            this.offset = offset;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }
}

