/*
 * Decompiled with CFR 0.152.
 */
package hermes.taglib;

import hermes.Hermes;
import hermes.taglib.TagValueBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

public class MessageBean {
    private static final Logger log = Logger.getLogger(MessageBean.class);
    private Message message;
    private Hermes hermes;
    private String id;
    private String attributeId;
    private Collection content = new ArrayList();
    private Collection header = new ArrayList();

    public MessageBean(String attributeId, Hermes hermes, Message message) {
        this.message = message;
        this.hermes = hermes;
        this.attributeId = attributeId;
    }

    public MessageBean(String attributeId, Hermes hermes, String id, Message message) {
        this(attributeId, hermes, message);
        this.id = id;
    }

    public String getId() throws JMSException {
        if (this.id == null) {
            return this.message.getJMSMessageID();
        }
        return this.id;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.message.getJMSTimestamp();
    }

    public String getJMSDestination() throws JMSException {
        return this.hermes.getDestinationName(this.message.getJMSDestination());
    }

    public String getMessageType() {
        if (this.message instanceof TextMessage) {
            return "TextMessage";
        }
        if (this.message instanceof MapMessage) {
            return "MapMessage";
        }
        if (this.message instanceof ObjectMessage) {
            return "ObjectMessage";
        }
        if (this.message instanceof BytesMessage) {
            return "BytesMessage";
        }
        if (this.message instanceof StreamMessage) {
            return "StreamMessage";
        }
        return "Unknown";
    }

    public Message getMessage() {
        return this.message;
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(String attributeId) {
        this.attributeId = attributeId;
    }

    public Collection getContent() {
        try {
            if (this.content.size() == 0) {
                if (this.message instanceof MapMessage) {
                    MapMessage mapMessage = (MapMessage)this.message;
                    Enumeration iter = mapMessage.getMapNames();
                    while (iter.hasMoreElements()) {
                        String propertyName = (String)iter.nextElement();
                        Object propertyValue = mapMessage.getObject(propertyName);
                        if (propertyValue == null) {
                            propertyValue = "";
                        }
                        this.content.add(new TagValueBean(propertyName, propertyValue.toString()));
                    }
                } else if (this.message instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)this.message;
                    this.content.add(new TagValueBean("text", textMessage.getText()));
                } else if (this.message instanceof ObjectMessage) {
                    ObjectMessage objectMessage = (ObjectMessage)this.message;
                    this.content.add(new TagValueBean("object", objectMessage.getObject().toString()));
                } else {
                    this.content.add(new TagValueBean("error", "Cannot display " + this.getMessageType()));
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage());
            this.content.add(new TagValueBean("error", e.getMessage()));
        }
        return this.content;
    }

    public Collection getFullContent() {
        return this.getContent();
    }

    public Collection getHeader() {
        if (this.header.size() == 0) {
            try {
                this.header.add(new TagValueBean("JMSDestination", this.hermes.getDestinationName(this.message.getJMSDestination())));
                this.header.add(new TagValueBean("JMSType", this.message.getJMSType()));
                Enumeration e = this.message.getPropertyNames();
                while (e.hasMoreElements()) {
                    String propertyName = (String)e.nextElement();
                    Object propertyValue = this.message.getObjectProperty(propertyName);
                    this.header.add(new TagValueBean(propertyName, propertyValue.toString()));
                }
            }
            catch (JMSException e) {
                log.error((Object)e.getMessage());
            }
        }
        return this.header;
    }

    public String getXML() {
        try {
            ArrayList<Message> c = new ArrayList<Message>();
            c.add(this.getMessage());
            return this.hermes.toXML(c);
        }
        catch (JMSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }

    public void setContent(Collection content) {
        this.content = content;
    }
}

