/*
 * Decompiled with CFR 0.152.
 */
package hermes.store.jdbc;

import hermes.HermesException;
import hermes.impl.pool.ObjectPool;
import hermes.impl.pool.ObjectPoolProxy;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.dbutils.DbUtils;
import org.apache.log4j.Logger;

public class JDBCConnectionPool
extends ObjectPool<Connection> {
    private static final Logger log = Logger.getLogger(JDBCConnectionPool.class);
    private String url;
    private boolean autoCommit;

    public JDBCConnectionPool(String url, int poolSize, boolean autoCommit) {
        super(poolSize);
        this.url = url;
        this.autoCommit = autoCommit;
    }

    @Override
    protected Connection makeObject() throws HermesException {
        try {
            Connection connection = DriverManager.getConnection(this.url);
            connection.setAutoCommit(this.autoCommit);
            connection.setTransactionIsolation(2);
            return connection;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HermesException(e);
        }
    }

    @Override
    protected Connection newProxyInstance(Connection connection) {
        return (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, new ObjectPoolProxy<Connection>(connection, this, "close"));
    }

    @Override
    protected void closeObject(Connection connection) {
        DbUtils.closeQuietly((Connection)connection);
    }

    @Override
    public boolean beforeCheckin(Connection connection) {
        try {
            if (connection.isClosed()) {
                return false;
            }
            if (!connection.getAutoCommit()) {
                connection.rollback();
            }
        }
        catch (SQLException ex) {
            log.warn((Object)("beforeCheckin failed:" + ex.getMessage()), (Throwable)ex);
            return false;
        }
        return true;
    }
}

