/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl.jms;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class ContextImpl
implements Context {
    private Hashtable environment;
    private Map context = new TreeMap();

    public ContextImpl(Hashtable environment) throws NamingException {
        this.environment = environment;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public void destroySubcontext(String binding) throws NamingException {
        this.assertBindingExist(binding);
        if (!(this.context.get(binding) instanceof Context)) {
            throw new NamingException("binding " + binding + " is not a Context");
        }
        this.context.remove(binding);
    }

    @Override
    public void unbind(String arg0) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void destroySubcontext(Name arg0) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public void unbind(Name arg0) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public Object lookup(String binding) throws NamingException {
        this.assertBindingExist(binding);
        return this.context.get(binding);
    }

    @Override
    public Object lookupLink(String arg0) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public Object removeFromEnvironment(String arg0) throws NamingException {
        return this.environment.remove(arg0);
    }

    @Override
    public void bind(String arg0, Object arg1) throws NamingException {
        this.context.put(arg0, arg1);
    }

    @Override
    public void rebind(String arg0, Object arg1) throws NamingException {
        this.context.put(arg0, arg1);
    }

    @Override
    public Object lookup(Name arg0) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public Object lookupLink(Name arg0) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public void bind(Name arg0, Object arg1) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public void rebind(Name arg0, Object arg1) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public void rename(String oldBinding, String newBinding) throws NamingException {
        this.assertBindingExist(oldBinding);
        this.assertBindingDoesNotExist(newBinding);
        Object object = this.context.remove(oldBinding);
        this.context.put(newBinding, object);
    }

    private void assertBindingExist(String binding) throws NameNotFoundException {
        if (!this.context.containsKey(binding)) {
            throw new NameNotFoundException("binding " + binding + " does not exist");
        }
    }

    private void assertBindingDoesNotExist(String binding) throws NamingException {
        if (this.context.containsKey(binding)) {
            throw new NamingException("binding " + binding + " already exists");
        }
    }

    @Override
    public Context createSubcontext(String binding) throws NamingException {
        this.assertBindingDoesNotExist(binding);
        ContextImpl ctx = new ContextImpl(this.environment);
        this.bind(binding, (Object)ctx);
        return ctx;
    }

    @Override
    public Context createSubcontext(Name arg0) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public void rename(Name arg0, Name arg1) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public NameParser getNameParser(String arg0) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public NameParser getNameParser(Name arg0) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    public NamingEnumeration list(String binding) throws NamingException {
        if (binding.equals("")) {
            return new NameClassPairEnumerationIterator(this.context.keySet().iterator());
        }
        this.assertBindingExist(binding);
        Object object = this.context.get(binding);
        if (object instanceof Context) {
            Context ctx = (Context)object;
            return ctx.list("");
        }
        throw new NamingException("binding " + binding + " is not a Context");
    }

    public NamingEnumeration listBindings(String binding) throws NamingException {
        if (binding.equals("")) {
            return new BindingEnumerationIterator(this.context.keySet().iterator());
        }
        this.assertBindingExist(binding);
        Object object = this.context.get(binding);
        if (object instanceof Context) {
            Context ctx = (Context)object;
            return ctx.listBindings("");
        }
        throw new NamingException("binding " + binding + " is not a Context");
    }

    public NamingEnumeration list(Name arg0) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    public NamingEnumeration listBindings(Name arg0) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public Object addToEnvironment(String arg0, Object arg1) throws NamingException {
        Object rval = this.environment.remove(arg0);
        this.environment.put(arg0, arg1);
        return rval;
    }

    @Override
    public String composeName(String arg0, String arg1) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    @Override
    public Name composeName(Name arg0, Name arg1) throws NamingException {
        throw new NamingException("Not Implemented");
    }

    private class NameClassPairEnumerationIterator
    implements NamingEnumeration {
        private Iterator iter;

        public NameClassPairEnumerationIterator(Iterator iter) {
            this.iter = iter;
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.iter.hasNext();
        }

        public Object next() throws NamingException {
            Object name = this.iter.next();
            Object object = ContextImpl.this.context.get(name);
            String className = object == null ? Object.class.getName() : object.getClass().getName();
            NameClassPair ncPair = new NameClassPair((String)name, className);
            return ncPair;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        @Override
        public Object nextElement() {
            return this.iter.next();
        }
    }

    private class BindingEnumerationIterator
    implements NamingEnumeration {
        private Iterator iter;

        public BindingEnumerationIterator(Iterator iter) {
            this.iter = iter;
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.iter.hasNext();
        }

        public Object next() throws NamingException {
            Object name = this.iter.next();
            Object object = ContextImpl.this.context.get(name);
            String className = object == null ? Object.class.getName() : object.getClass().getName();
            Binding binding = new Binding((String)name, className, object);
            return binding;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        @Override
        public Object nextElement() {
            return this.iter.next();
        }
    }
}

