/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.Domain;
import hermes.HermesException;
import hermes.HermesMessageListener;
import hermes.HermesRuntimeException;
import hermes.config.DestinationConfig;
import hermes.impl.DestinationManager;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import org.apache.log4j.Logger;

public class TopicBrowser
implements QueueBrowser {
    private static final Logger log = Logger.getLogger(TopicBrowser.class);
    private Session session;
    private Enumeration iter;
    private DestinationConfig dConfig;
    private DestinationManager destinationManager;
    private MessageConsumer consumer = null;

    public TopicBrowser(Session session, DestinationManager destinationManager, DestinationConfig dConfig) {
        this.session = session;
        this.dConfig = dConfig;
        this.destinationManager = destinationManager;
    }

    public void close() throws JMSException {
        if (this.iter != null) {
            this.iter.stop();
            this.iter = null;
        }
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized java.util.Enumeration getEnumeration() throws JMSException {
        if (this.iter != null) return this.iter;
        Topic topic = (Topic)this.destinationManager.getDestination(this.session, this.dConfig.getName(), Domain.TOPIC);
        if (this.dConfig.isDurable()) {
            log.debug((Object)("creating DuableSubscriber for topic=" + this.dConfig.getName() + ", ClientID=" + this.dConfig.getClientID() + ", selector=" + this.dConfig.getSelector()));
            try {
                this.consumer = this.session.createDurableSubscriber(topic, this.dConfig.getClientID(), this.dConfig.getSelector(), false);
            }
            catch (NoSuchMethodError ex) {
            }
            catch (AbstractMethodError ex) {
                // empty catch block
            }
            if (this.consumer == null) {
                if (!(this.session instanceof TopicSession)) throw new HermesException("Session is 1.0.2 and not in the topic domain");
                TopicSession topicSession = (TopicSession)this.session;
                this.consumer = this.session.createDurableSubscriber(topic, this.dConfig.getClientID(), this.dConfig.getSelector(), false);
            }
        } else {
            try {
                this.consumer = this.dConfig.getSelector() == null ? this.session.createConsumer((Destination)topic) : this.session.createConsumer((Destination)topic, this.dConfig.getSelector(), false);
            }
            catch (NoSuchMethodError ex) {
            }
            catch (AbstractMethodError ex) {
                // empty catch block
            }
            if (this.consumer == null) {
                if (!(this.session instanceof TopicSession)) throw new HermesRuntimeException("The session is JMS 1.0.2b and not in the topic domain.");
                TopicSession topicSession = (TopicSession)this.session;
                this.consumer = this.dConfig.getSelector() == null ? topicSession.createSubscriber(topic) : topicSession.createSubscriber(topic, this.dConfig.getSelector(), false);
            }
        }
        this.iter = new Enumeration();
        return this.iter;
    }

    public String getMessageSelector() throws JMSException {
        return this.dConfig.getSelector();
    }

    public Queue getQueue() throws JMSException {
        return null;
    }

    private class Enumeration
    implements java.util.Enumeration {
        private List messages = new ArrayList();
        private int maxSize = 1000;
        private int receiveTimeout = 1000;
        private boolean keepRunning = true;
        private JMSException ex;

        private Enumeration() throws JMSException {
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            log.debug((Object)("stopping iteration for " + TopicBrowser.this.dConfig.getName()));
            List list = this.messages;
            synchronized (list) {
                this.keepRunning = false;
                this.messages.notify();
                this.messages.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            List list = this.messages;
            synchronized (list) {
                if (this.keepRunning) {
                    while (this.keepRunning && this.messages.size() == 0) {
                        try {
                            this.messages.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.keepRunning && this.messages.size() > 0) {
                        return this.messages.remove(0);
                    }
                }
                if (this.ex != null) {
                    throw new RuntimeException(this.ex);
                }
                return null;
            }
        }

        private void init() throws JMSException {
            log.debug((Object)("itereration running for " + TopicBrowser.this.dConfig.getName()));
            HermesMessageListener listener = new HermesMessageListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMessage(Message m) {
                    List list = Enumeration.this.messages;
                    synchronized (list) {
                        if (m != null) {
                            Enumeration.this.messages.add(m);
                            if (Enumeration.this.messages.size() == 1) {
                                Enumeration.this.messages.notify();
                            }
                        }
                    }
                }

                @Override
                public void onException(JMSException ex) {
                    Enumeration.this.keepRunning = false;
                    Enumeration.this.ex = ex;
                }
            };
            try {
                if (this.keepRunning) {
                    TopicBrowser.this.consumer.setMessageListener((MessageListener)listener);
                }
            }
            catch (JMSException ex) {
                log.error((Object)("in browse thread: " + ex.getMessage()));
                this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreElements() {
            List list = this.messages;
            synchronized (list) {
                return this.keepRunning;
            }
        }
    }
}

