/*
 * Decompiled with CFR 0.152.
 */
package hermes.impl;

import hermes.HermesDispatcher;
import hermes.HermesException;
import hermes.HermesMessageListener;
import hermes.impl.DefaultHermesImpl;
import hermes.impl.DestinationKeyWrapper;
import hermes.util.JMSUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.log4j.Category;

public class DefaultHermesDispatcherImpl
implements HermesDispatcher,
Runnable {
    private static final Category cat = Category.getInstance(DefaultHermesDispatcherImpl.class);
    private static int numDispatchers = 0;
    private Map<DestinationKeyWrapper, MessageListener> destinations = new HashMap<DestinationKeyWrapper, MessageListener>();
    private Set<DestinationKeyWrapper> removedDestinations = new HashSet<DestinationKeyWrapper>();
    private List queue = new ArrayList();
    private DefaultHermesImpl hermes;
    private boolean keepRunning = true;
    private long sleepPeriod = 50L;
    private Thread dispatchThread;
    private boolean synchronizeThreadStart = false;

    public DefaultHermesDispatcherImpl(DefaultHermesImpl hermes) {
        this.hermes = hermes;
    }

    public DefaultHermesDispatcherImpl(DefaultHermesImpl hermes, boolean synchronizeThreadStart) {
        this.hermes = hermes;
        this.synchronizeThreadStart = synchronizeThreadStart;
    }

    private final String getName(Destination d) throws JMSException {
        return this.hermes.getDestinationName(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDestination(Destination d, MessageListener ml) throws JMSException {
        Map<DestinationKeyWrapper, MessageListener> map = this.destinations;
        synchronized (map) {
            if (this.dispatchThread == null) {
                this.start();
            }
            this.destinations.put(new DestinationKeyWrapper(d), ml);
        }
        cat.debug((Object)("new destination: " + this.getName(d)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(Destination d) throws JMSException {
        Map<DestinationKeyWrapper, MessageListener> map = this.destinations;
        synchronized (map) {
            DestinationKeyWrapper key = new DestinationKeyWrapper(d);
            if (this.destinations.remove(key) == null) {
                if (this.dispatchThread != null) {
                    throw new JMSException("destination " + this.getName(d) + " not being dispatched on " + this.dispatchThread.getName());
                }
                throw new JMSException("destination " + this.getName(d) + " not registered");
            }
            this.removedDestinations.add(key);
        }
        cat.debug((Object)("removed destination: " + JMSUtils.getDestinationName(d)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Runnable runnable) throws JMSException {
        List list = this.queue;
        synchronized (list) {
            this.queue.add(runnable);
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = this.dispatchThread = Thread.currentThread();
        synchronized (thread) {
            this.dispatchThread.notifyAll();
        }
        cat.debug((Object)"dispatcher starting");
        while (this.keepRunning) {
            int messagesRead = 0;
            Object object = this.queue;
            synchronized (object) {
                while (this.queue.size() > 0) {
                    Runnable r = (Runnable)this.queue.remove(0);
                    r.run();
                }
            }
            object = this.destinations;
            synchronized (object) {
                if (this.removedDestinations.size() > 0) {
                    for (DestinationKeyWrapper destinationKeyWrapper : this.removedDestinations) {
                        this.destinations.remove(destinationKeyWrapper);
                        try {
                            this.hermes.closeConsumer(destinationKeyWrapper.getDestination());
                        }
                        catch (JMSException e) {
                            cat.error((Object)("closing async consumer: " + e.getMessage()), (Throwable)e);
                        }
                    }
                    this.removedDestinations.clear();
                }
                if (this.destinations.size() == 0 && this.hermes.isOpen()) {
                    try {
                        cat.debug((Object)("nothing to dispatch, closing Hermes " + this.hermes.getId()));
                        this.hermes.close();
                    }
                    catch (JMSException e) {
                        cat.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    for (Map.Entry entry : this.destinations.entrySet()) {
                        MessageListener ml = null;
                        try {
                            ml = (MessageListener)entry.getValue();
                            Destination d = ((DestinationKeyWrapper)entry.getKey()).getDestination();
                            Message m = this.hermes.receiveNoWait(d);
                            if (m == null) continue;
                            if (ml != null) {
                                ml.onMessage(m);
                            } else {
                                cat.fatal((Object)("no message listener available for destination " + this.hermes.getDestinationName(d) + " message discarded"));
                            }
                            ++messagesRead;
                        }
                        catch (JMSException ex) {
                            cat.error((Object)ex.getMessage(), (Throwable)ex);
                            this.removedDestinations.add((DestinationKeyWrapper)entry.getKey());
                            if (!(ml instanceof HermesMessageListener)) break;
                            ((HermesMessageListener)ml).onException(ex);
                            break;
                        }
                    }
                }
            }
            if (messagesRead != 0) continue;
            try {
                Thread.sleep(this.sleepPeriod);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.dispatchThread = null;
        cat.debug((Object)"dispatcher stopping");
    }

    public long getSleepPeriod() {
        return this.sleepPeriod;
    }

    public void setSleepPeriod(long sleepPeriod) {
        this.sleepPeriod = sleepPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAndWait(final Runnable runnable) throws JMSException {
        Runnable myRunnable;
        if (this.dispatchThread == null) {
            throw new HermesException("dispatcher thread not running so cannot invokeAndWait");
        }
        Runnable runnable2 = myRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                runnable.run();
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.notifyAll();
                }
            }
        };
        synchronized (runnable2) {
            this.invoke(myRunnable);
            try {
                myRunnable.wait();
            }
            catch (Exception ex) {
                cat.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread start() throws JMSException {
        Class<DefaultHermesDispatcherImpl> clazz = DefaultHermesDispatcherImpl.class;
        synchronized (DefaultHermesDispatcherImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.start("dispatcher-" + numDispatchers++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread start(String threadName) throws JMSException {
        Thread thread;
        if (this.dispatchThread != null) {
            throw new HermesException("Dispatcher thread not running");
        }
        Thread thread2 = thread = new Thread((Runnable)this, threadName);
        synchronized (thread2) {
            thread.start();
            if (this.synchronizeThreadStart) {
                try {
                    thread.wait();
                }
                catch (InterruptedException ex) {
                    cat.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return thread;
    }

    @Override
    public void close() throws JMSException {
        this.keepRunning = false;
        this.hermes.removeDispatcher(this);
    }

    @Override
    public void setMessageListener(Destination from, MessageListener ml) throws JMSException {
        if (ml != null) {
            this.addDestination(from, ml);
        } else {
            this.removeDestination(from);
        }
    }
}

