/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.seebeyond.jcaps;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.ext.seebeyond.SeeBeyondAdmin;
import hermes.ext.seebeyond.jcaps.SeeBeyondJCAPSAdminFactory;
import hermes.ext.seebeyond.jcaps.SunSeeBeyond51Admin;
import java.awt.Component;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.swing.ProgressMonitor;
import org.apache.log4j.Logger;

public class SeeBeyondJCAPSAdmin
extends SeeBeyondAdmin {
    private static final Logger log = Logger.getLogger(SeeBeyondJCAPSAdmin.class);

    public SeeBeyondJCAPSAdmin(SeeBeyondJCAPSAdminFactory factory, Hermes hermes, ConnectionFactory connectionFactory) throws JMSException {
        super(hermes);
        this.connectionFactory = connectionFactory;
        this.factory = factory;
        if (factory.getLogicalHostIP() == null || factory.getLogicalHostPort() == null || factory.getLogicalHostUser() == null || factory.getLogicalHostUserPassword() == null) {
            throw new HermesException("Edit the session and provide the following plugin properties: \r\nlogicalHost, logicalHostPort, logicalHostUser, logicalHostUserPassword");
        }
        this.seeBeyondAdmin = new SunSeeBeyond51Admin(factory, hermes, connectionFactory);
    }

    public int truncate(DestinationConfig dConfig) throws JMSException {
        ProgressMonitor monitor = new ProgressMonitor((Component)((Object)HermesBrowser.getBrowser()), "Deleting from " + dConfig.getName(), "Discovering size of " + dConfig.getName(), 0, 102);
        int rval = 0;
        String destName = this.getRealDestinationName(dConfig);
        monitor.setMillisToDecideToPopup(100);
        monitor.setMillisToPopup(400);
        try {
            Properties queueStats;
            if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                queueStats = this.seeBeyondAdmin.getQueueStatistics(destName);
                int start = Integer.parseInt(queueStats.getProperty("MIN_SEQ"));
                int finish = Integer.parseInt(queueStats.getProperty("MAX_SEQ"));
                for (int i = start; i <= finish; ++i) {
                    this.seeBeyondAdmin.deleteQueueMessage(destName, "" + i);
                    ++rval;
                    if (!monitor.isCanceled()) continue;
                    int n = rval;
                    return n;
                }
            } else if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                queueStats = this.seeBeyondAdmin.getTopicStatistics(destName);
                int start = Integer.parseInt(queueStats.getProperty("FIRST_SEQ"));
                int finish = Integer.parseInt(queueStats.getProperty("LAST_SEQ"));
                for (int i = start; i <= finish; ++i) {
                    this.seeBeyondAdmin.deleteTopicMessage(destName, "" + i);
                    ++rval;
                    if (!monitor.isCanceled()) continue;
                    int n = rval;
                    return n;
                }
            } else {
                log.error((Object)("Unsupported destination domain " + dConfig.getDomain()));
            }
        }
        catch (HermesException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HermesException(e);
        }
        finally {
            if (monitor != null) {
                monitor.close();
            }
        }
        return rval;
    }
}

