/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.transferable;

import hermes.browser.components.BrowserTree;
import hermes.browser.transferable.MessagesTransferable;
import hermes.fix.FIXMessageTable;
import hermes.swing.actions.ActionRegistry;
import hermes.swing.actions.CopyMessagesToClipboardAction;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;

public class MessagesTransferHandler
extends TransferHandler {
    private static final Logger log = Logger.getLogger(MessagesTransferHandler.class);
    private FIXMessageTable table;

    public static Action getCopyAction() {
        return ActionRegistry.getAction(CopyMessagesToClipboardAction.class);
    }

    public MessagesTransferHandler(FIXMessageTable table) {
        this.table = table;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new MessagesTransferable(this.table.getSelectedMessages());
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        super.exportAsDrag(comp, e, action);
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (c instanceof FIXMessageTable) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if (comp instanceof BrowserTree) {
            return ((BrowserTree)comp).isCurrentSelectionADestination();
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (comp instanceof BrowserTree) {
            BrowserTree browserTree = (BrowserTree)comp;
            return browserTree.doTransfer(t, 1);
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent comp, Transferable data, int dndAction) {
    }
}

