/*
 * Decompiled with CFR 0.152.
 */
package hermes.browser.tasks;

import hermes.BrowseInterruptedException;
import hermes.Hermes;
import hermes.HermesRepository;
import hermes.browser.IconCache;
import hermes.browser.tasks.TaskSupport;
import java.util.Collection;
import java.util.Iterator;
import javax.jms.Message;
import org.apache.log4j.Logger;

public class BrowseRepositoryFileTask
extends TaskSupport {
    private static final Logger log = Logger.getLogger(BrowseRepositoryFileTask.class);
    private Hermes hermes;
    private HermesRepository repository;

    public BrowseRepositoryFileTask(Hermes hermes, HermesRepository repository) {
        super(IconCache.getIcon("jms.queue"));
        this.hermes = hermes;
        this.repository = repository;
    }

    public BrowseRepositoryFileTask(HermesRepository repository) {
        this(null, repository);
    }

    @Override
    public String getTitle() {
        return "Browse";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() throws Exception {
        int nmessages = 0;
        try {
            Collection<Message> messages = this.repository.getMessages(this.hermes);
            Iterator<Message> iter = messages.iterator();
            while (iter.hasNext() && this.isRunning()) {
                Message m = iter.next();
                if (m == null) continue;
                ++nmessages;
                this.notifyMessage(m);
            }
        }
        catch (BrowseInterruptedException ex) {
            log.error((Object)("browse stopped: " + ex.getMessage()));
        }
        finally {
            log.debug((Object)("nmessages=" + nmessages));
        }
        this.notifyStatus("Read " + nmessages + " messages from " + this.repository.getId());
        if (this.hermes != null) {
            this.hermes.close();
        }
    }
}

