/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.rss.FeedReader;
import com.jidesoft.rss.PreferencePanel;
import com.jidesoft.rss.m;
import de.nava.informa.core.ChannelFormat;
import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.core.ChannelIF;
import de.nava.informa.core.CloudIF;
import de.nava.informa.core.ImageIF;
import de.nava.informa.core.ItemIF;
import de.nava.informa.core.TextInputIF;
import de.nava.informa.impl.basic.Channel;
import de.nava.informa.impl.basic.ChannelGroup;
import de.nava.informa.impl.basic.Image;
import de.nava.informa.impl.basic.Item;
import de.nava.informa.impl.basic.TextInput;
import de.nava.informa.utils.ItemComparator;
import de.nava.informa.utils.manager.PersistenceManagerException;
import de.nava.informa.utils.manager.PersistenceManagerIF;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedDatabasePersistenceManager
implements PersistenceManagerIF {
    private FeedReader a = null;
    private Logger b = Logger.getLogger(FeedDatabasePersistenceManager.class.getName());

    public FeedDatabasePersistenceManager(FeedReader feedReader) {
        this.a = feedReader;
        try {
            this.initializeDB();
        }
        catch (Exception exception) {
            this.b.warning(exception.getLocalizedMessage());
        }
    }

    public ChannelGroupIF createGroup(String string) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(this.getTableName("CHANNEL_GROUPS")).append("(TITLE) ");
        stringBuffer.append("VALUES(?)");
        Connection connection = this.getConnection();
        try {
            long l2;
            block5: {
                ResultSet resultSet;
                block4: {
                    PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
                    preparedStatement.setString(1, string);
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("SELECT CHANNEL_GROUP_ID FROM ").append(this.getTableName("CHANNEL_GROUPS")).append(" ");
                    stringBuffer.append("WHERE TITLE = ? ORDER BY CHANNEL_GROUP_ID DESC ");
                    preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
                    preparedStatement.setString(1, string);
                    ResultSet resultSet2 = preparedStatement.executeQuery();
                    l2 = 0L;
                    resultSet = resultSet2;
                    if (PreferencePanel.h) break block4;
                    if (!resultSet.next()) break block5;
                    resultSet = resultSet2;
                }
                l2 = resultSet.getLong("CHANNEL_GROUP_ID");
            }
            ChannelGroup channelGroup = new ChannelGroup();
            channelGroup.setId(l2);
            channelGroup.setTitle(string);
            return channelGroup;
        }
        catch (SQLException sQLException) {
            throw new PersistenceManagerException(sQLException.fillInStackTrace());
        }
    }

    public void updateGroup(ChannelGroupIF channelGroupIF) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(this.getTableName("CHANNEL_GROUPS")).append(" ");
        stringBuffer.append("SET TITLE = ? ");
        stringBuffer.append("WHERE CHANNEL_GROUP_ID = ? ");
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setString(1, channelGroupIF.getTitle());
            preparedStatement.setLong(2, channelGroupIF.getId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new PersistenceManagerException(sQLException.fillInStackTrace());
        }
    }

    public void deleteGroup(ChannelGroupIF channelGroupIF) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ").append(this.getTableName("CHANNEL_GROUPS")).append(" ");
        stringBuffer.append("WHERE CHANNEL_GROUP_ID = ?");
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelGroupIF.getId());
            preparedStatement.executeUpdate();
            stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM ").append(this.getTableName("CAT_GROUP_CHANNEL")).append(" ");
            stringBuffer.append("WHERE GROUP_ID = ?");
            preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelGroupIF.getId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new PersistenceManagerException(sQLException.fillInStackTrace());
        }
    }

    public void mergeGroups(ChannelGroupIF channelGroupIF, ChannelGroupIF channelGroupIF2) throws PersistenceManagerException {
        block11: {
            boolean bl = PreferencePanel.h;
            try {
                ArrayList<String> arrayList;
                ResultSet resultSet;
                block10: {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("SELECT CHANNEL_ID FROM ").append(this.getTableName("CAT_GROUP_CHANNEL")).append(" ");
                    stringBuffer.append("WHERE GROUP_ID = ? ");
                    Connection connection = this.getConnection();
                    PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
                    preparedStatement.setLong(1, channelGroupIF.getId());
                    resultSet = preparedStatement.executeQuery();
                    arrayList = new ArrayList<String>();
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString("CHANNEL_ID"));
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block10;
                    }
                    preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
                    preparedStatement.setLong(1, channelGroupIF2.getId());
                    resultSet = preparedStatement.executeQuery();
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                while (resultSet.next()) {
                    arrayList2.add(resultSet.getString("CHANNEL_ID"));
                    if (!bl) continue;
                }
                Channel channel = new Channel();
                for (String string : arrayList2) {
                    block13: {
                        block12: {
                            if (bl) break block11;
                            if (bl) break block12;
                            if (arrayList.contains(string)) break block13;
                            channel.setId(Long.parseLong(string));
                        }
                        this.addChannelToGroup((ChannelIF)channel, channelGroupIF);
                    }
                    if (!bl) continue;
                }
                this.deleteGroup(channelGroupIF2);
            }
            catch (SQLException sQLException) {
                throw new PersistenceManagerException(sQLException.fillInStackTrace());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChannelGroupIF[] getGroups() throws PersistenceManagerException {
        boolean bl = PreferencePanel.h;
        try {
            block9: {
                ChannelGroup[] channelGroupArray;
                ChannelGroup[] channelGroupArray2;
                block11: {
                    void var7_15;
                    int n2;
                    ArrayList<ChannelGroup[]> arrayList;
                    block12: {
                        ArrayList<ChannelGroup[]> arrayList2;
                        block10: {
                            if (!this.a.isAllowGroup()) break block9;
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("SELECT CHANNEL_GROUP_ID, TITLE, PARENT_ID ");
                            stringBuffer.append("FROM ").append(this.getTableName("CHANNEL_GROUPS"));
                            Connection connection = this.getConnection();
                            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
                            ResultSet resultSet = preparedStatement.executeQuery();
                            arrayList = new ArrayList<ChannelGroup[]>();
                            while (resultSet.next()) {
                                channelGroupArray2 = new ChannelGroup();
                                channelGroupArray2.setId(resultSet.getLong("CHANNEL_GROUP_ID"));
                                channelGroupArray2.setTitle(resultSet.getString("TITLE"));
                                channelGroupArray2.setParent(resultSet.getLong("PARENT_ID") == 0L ? null : this.e(resultSet.getLong("PARENT_ID")));
                                arrayList.add(channelGroupArray2);
                                if (!bl) continue;
                            }
                            block3: for (ChannelGroupIF channelGroupIF : arrayList) {
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("SELECT CHANNEL_ID FROM ").append(this.getTableName("CAT_GROUP_CHANNEL")).append(" ");
                                stringBuffer.append("WHERE GROUP_ID = ? ");
                                preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
                                preparedStatement.setLong(1, channelGroupIF.getId());
                                resultSet = preparedStatement.executeQuery();
                                while (resultSet.next()) {
                                    channelGroupIF.add(this.b(resultSet.getLong("CHANNEL_ID")));
                                    if (bl) continue block3;
                                    if (!bl) continue;
                                }
                                if (!bl) continue;
                            }
                            channelGroupArray2 = null;
                            arrayList2 = arrayList;
                            if (bl) break block10;
                            if (arrayList2 == null) break block11;
                            arrayList2 = arrayList;
                        }
                        n2 = arrayList2.isEmpty();
                        if (bl) break block12;
                        if (n2 != 0) break block11;
                        n2 = arrayList.size();
                    }
                    channelGroupArray2 = new ChannelGroup[n2];
                    boolean bl2 = false;
                    while (var7_15 < channelGroupArray2.length) {
                        channelGroupArray = channelGroupArray2;
                        if (bl) return channelGroupArray;
                        channelGroupArray[var7_15] = (ChannelGroupIF)arrayList.get((int)var7_15);
                        ++var7_15;
                        if (!bl) continue;
                    }
                }
                channelGroupArray = channelGroupArray2;
                return channelGroupArray;
            }
            ChannelGroup channelGroup = new ChannelGroup();
            channelGroup.setId(0L);
            channelGroup.setTitle("Default");
            channelGroup.setParent(null);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT CHANNEL_ID FROM ").append(this.getTableName("CHANNELS"));
            Connection connection = this.getConnection();
            ResultSet resultSet = connection.createStatement().executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                channelGroup.add(this.b(resultSet.getLong("CHANNEL_ID")));
                if (!bl) continue;
            }
            return new ChannelGroupIF[]{channelGroup};
        }
        catch (Exception exception) {
            throw new PersistenceManagerException(exception.fillInStackTrace());
        }
    }

    public ChannelIF createChannel(String string, URL uRL) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(this.getTableName("CHANNELS")).append(" ");
        stringBuffer.append("(TITLE, LOCSTRING) ");
        stringBuffer.append("VALUES (?, ?)");
        Connection connection = this.getConnection();
        if (connection == null || uRL == null) {
            return null;
        }
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, uRL.toExternalForm());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT CHANNEL_ID FROM ").append(this.getTableName("CHANNELS")).append(" ");
            stringBuffer.append("WHERE TITLE = ? AND LOCSTRING = ? ORDER BY CHANNEL_ID DESC ");
            preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, uRL.toExternalForm());
            Channel channel = new Channel();
            channel.setTitle(string);
            channel.setLocation(uRL);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!PreferencePanel.h) {
                if (resultSet.next()) {
                    channel.setId(resultSet.getLong("CHANNEL_ID"));
                }
                preparedStatement.close();
            }
            Channel channel2 = channel;
            return channel2;
        }
        catch (Exception exception) {
            throw new PersistenceManagerException(exception.fillInStackTrace());
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                this.b.warning(sQLException.getLocalizedMessage());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateChannel(ChannelIF var1_1) throws PersistenceManagerException {
        var14_2 = PreferencePanel.h;
        var2_3 = new StringBuffer();
        var2_3.append("UPDATE ").append(this.getTableName("CHANNELS")).append(" SET TITLE = ?, DESCRIPTION = ?, LOCSTRING = ?, SITE = ?, CREATOR = ?, PUBLISHER = ?, LANGUAGE = ?, FORMAT = ?, IMAGE_ID = ?, TEXTINPUT_ID = ?, COPYRIGHT = ?, RATING = ?, CLOUD_ID = ?, GENERATOR = ?, DOCS = ?, TTL = ?, LAST_UPDATED = ?, LAST_BUILD_DATE = ?, PUB_DATE = ?, UPDATE_PERIOD = ?, UPDATE_FREQUENCY = ?, UPDATE_BASE = ? ");
        var2_3.append("WHERE CHANNEL_ID = ?");
        var3_4 = this.getConnection();
        try {
            block41: {
                block38: {
                    block40: {
                        block39: {
                            block37: {
                                block36: {
                                    block33: {
                                        block35: {
                                            block34: {
                                                block32: {
                                                    var4_5 = this.prepareStatement(var3_4, var2_3.toString());
                                                    var4_5.setString(1, m.toDbString(var1_1.getTitle()));
                                                    var4_5.setString(2, m.toDbString(var1_1.getDescription()));
                                                    v0 = var1_1.getLocation();
                                                    if (var14_2) ** GOTO lbl18
                                                    if (v0 == null) {
                                                        v1 = null;
                                                    } else {
                                                        v0 = var1_1.getLocation();
lbl18:
                                                        // 2 sources

                                                        v1 = v0.toExternalForm();
                                                    }
                                                    var4_5.setString(3, v1);
                                                    v2 = var1_1.getSite();
                                                    if (var14_2) ** GOTO lbl26
                                                    if (v2 == null) {
                                                        v3 = null;
                                                    } else {
                                                        v2 = var1_1.getSite();
lbl26:
                                                        // 2 sources

                                                        v3 = m.objectToBytes(v2);
                                                    }
                                                    var4_5.setBytes(4, v3);
                                                    var4_5.setString(5, m.toDbString(var1_1.getCreator()));
                                                    var4_5.setString(6, m.toDbString(var1_1.getPublisher()));
                                                    var4_5.setString(7, m.toDbString(var1_1.getLanguage()));
                                                    v4 = var1_1.getFormat();
                                                    if (var14_2) ** GOTO lbl37
                                                    if (v4 == null) {
                                                        v5 = null;
                                                    } else {
                                                        v4 = var1_1.getFormat();
lbl37:
                                                        // 2 sources

                                                        v5 = m.toDbString(v4.toString());
                                                    }
                                                    var4_5.setString(8, v5);
                                                    v6 = var1_1.getImage();
                                                    if (var14_2) break block32;
                                                    if (v6 == null) break block33;
                                                    v7 = this;
                                                    v8 = var1_1.getImage();
                                                    if (var14_2) break block34;
                                                    v6 = v7.d(v8.getId());
                                                }
                                                if (v6 != null) break block35;
                                                v7 = this;
                                                v8 = var1_1.getImage();
                                            }
                                            v7.b(v8);
                                        }
                                        var4_5.setLong(9, var1_1.getImage().getId());
                                        if (!var14_2) break block36;
                                        var15_6 = FeedReader.V;
                                        FeedReader.V = ++var15_6;
                                    }
                                    var4_5.setObject(9, null);
                                }
                                v9 = var1_1.getTextInput();
                                if (var14_2) break block37;
                                if (v9 == null) break block38;
                                v10 = this;
                                v11 = var1_1.getTextInput();
                                if (var14_2) break block39;
                                v9 = v10.a(v11.getId());
                            }
                            if (v9 != null) break block40;
                            v10 = this;
                            v11 = var1_1.getTextInput();
                        }
                        v10.b(v11);
                    }
                    var4_5.setLong(10, var1_1.getTextInput().getId());
                    if (!var14_2) break block41;
                }
                var4_5.setObject(10, null);
            }
            var4_5.setString(11, m.toDbString(var1_1.getCopyright()));
            var4_5.setString(12, m.toDbString(var1_1.getRating()));
            v12 = var1_1.getCloud();
            if (var14_2) ** GOTO lbl87
            if (v12 == null) {
                v13 = null;
            } else {
                v12 = var1_1.getCloud();
lbl87:
                // 2 sources

                v13 = m.toDbString(v12.toString());
            }
            var4_5.setString(13, v13);
            var4_5.setString(14, m.toDbString(var1_1.getGenerator()));
            var4_5.setString(15, m.toDbString(var1_1.getDocs()));
            var4_5.setInt(16, var1_1.getTtl());
            var4_5.setDate(17, var1_1.getLastUpdated() == null ? null : new Date(var1_1.getLastUpdated().getTime()));
            var4_5.setDate(18, var1_1.getLastBuildDate() == null ? null : new Date(var1_1.getLastBuildDate().getTime()));
            var4_5.setDate(19, var1_1.getPubDate() == null ? null : new Date(var1_1.getPubDate().getTime()));
            v14 = var5_7 = var1_1.getUpdatePeriod();
            if (var14_2) ** GOTO lbl101
            if (v14 == null) {
                v15 = "hourly";
            } else {
                v14 = var5_7;
lbl101:
                // 2 sources

                v15 = v14.toString();
            }
            var4_5.setString(20, m.toDbString(v15));
            var4_5.setInt(21, var1_1.getUpdateFrequency());
            var4_5.setDate(22, var1_1.getUpdateBase() == null ? null : new Date(var1_1.getUpdateBase().getTime()));
            var4_5.setLong(23, var1_1.getId());
            var4_5.executeUpdate();
            var4_5.close();
            var6_9 = this.b(var1_1.getId());
            var7_10 = var1_1.getItems();
            var8_11 = var7_10.toArray(new ItemIF[var7_10.size()]);
            Arrays.sort(var8_11, new ItemComparator(true));
            for (ItemIF var12_15 : var8_11) {
                var13_16 = this.a(var6_9, var12_15);
                if (!var14_2) {
                    v16 = var13_16;
                    if (var14_2) continue;
                    if (v16 != null) {
                        var12_15.setUnRead(var13_16.getUnRead());
                        this.deleteItem(var13_16);
                    }
                    v16 = this.createItem(var1_1, var12_15);
                    if (!var14_2) continue;
                }
                break;
            }
        }
        catch (Exception var5_8) {
            throw new PersistenceManagerException(var5_8.fillInStackTrace());
        }
    }

    public void addChannelToGroup(ChannelIF channelIF, ChannelGroupIF channelGroupIF) throws PersistenceManagerException {
        boolean bl = PreferencePanel.h;
        try {
            FeedDatabasePersistenceManager feedDatabasePersistenceManager = this;
            long l2 = channelGroupIF.getId();
            if (!bl) {
                if (feedDatabasePersistenceManager.e(l2) == null) {
                    this.createGroup(channelGroupIF.getTitle());
                }
                feedDatabasePersistenceManager = this;
                l2 = channelIF.getId();
            }
            ChannelIF channelIF2 = feedDatabasePersistenceManager.b(l2);
            if (!bl && channelIF2 == null) {
                channelIF2 = this.createChannel(channelIF.getTitle(), channelIF.getLocation());
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO ").append(this.getTableName("CAT_GROUP_CHANNEL")).append(" ");
            stringBuffer.append("(GROUP_ID, CHANNEL_ID) ");
            stringBuffer.append("VALUES (?, ?)");
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelGroupIF.getId());
            preparedStatement.setLong(2, channelIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            channelGroupIF.add(channelIF);
        }
        catch (Exception exception) {
            throw new PersistenceManagerException(exception.fillInStackTrace());
        }
    }

    public void removeChannelFromGroup(ChannelIF channelIF, ChannelGroupIF channelGroupIF) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        Connection connection = this.getConnection();
        try {
            stringBuffer.append("DELETE FROM ").append(this.getTableName("CAT_GROUP_CHANNEL")).append(" ");
            stringBuffer.append("WHERE GROUP_ID = ? AND CHANNEL_ID = ?");
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelGroupIF.getId());
            preparedStatement.setLong(2, channelIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            channelGroupIF.remove(channelIF);
        }
        catch (SQLException sQLException) {
            throw new PersistenceManagerException(sQLException.fillInStackTrace());
        }
    }

    public void deleteChannel(ChannelIF channelIF) throws PersistenceManagerException {
        try {
            this.a(channelIF);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM ").append(this.getTableName("CHANNELS")).append(" ");
            stringBuffer.append("WHERE CHANNEL_ID = ?");
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, channelIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
            ChannelIF channelIF2 = channelIF;
            if (!PreferencePanel.h) {
                if (channelIF2.getImage() != null) {
                    this.a(channelIF.getImage());
                }
                channelIF2 = channelIF;
            }
            if (channelIF2.getTextInput() != null) {
                this.a(channelIF.getTextInput());
            }
        }
        catch (Exception exception) {
            throw new PersistenceManagerException(exception.fillInStackTrace());
        }
    }

    public ItemIF createItem(ChannelIF channelIF, String string) throws PersistenceManagerException {
        Item item = new Item();
        item.setTitle(string);
        return this.createItem(channelIF, (ItemIF)item);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ItemIF createItem(ChannelIF var1_1, ItemIF var2_2) throws PersistenceManagerException {
        var7_3 = PreferencePanel.h;
        var3_4 = new StringBuffer();
        var3_4.append("INSERT INTO ").append(this.getTableName("ITEMS")).append(" ");
        var3_4.append("(ITEM_ID, CHANNEL_ID, TITLE, DESCRIPTION, UNREAD, LINK, CREATOR, SUBJECT, DATE, FOUND, GUID, COMMENTS, SOURCE, ENCLOSURE) ");
        var3_4.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        var4_5 = this.getConnection();
        try {
            var5_6 = this.prepareStatement(var4_5, var3_4.toString());
            var5_6.setLong(1, var2_2.getId());
            var5_6.setLong(2, var1_1.getId());
            var5_6.setString(3, m.toDbString(var2_2.getTitle()));
            var5_6.setString(4, m.toDbString(var2_2.getDescription()));
            v0 = var2_2.getUnRead();
            if (!var7_3) {
                v0 = v0 != 0 ? 1 : 0;
            }
            var5_6.setInt(5, v0);
            v1 = var2_2.getLink();
            if (var7_3) ** GOTO lbl26
            if (v1 == null) {
                v2 = null;
            } else {
                v1 = var2_2.getLink();
lbl26:
                // 2 sources

                v2 = m.objectToBytes(v1);
            }
            var5_6.setBytes(6, v2);
            var5_6.setString(7, m.toDbString(var2_2.getCreator()));
            var5_6.setString(8, m.toDbString(var2_2.getSubject()));
            var5_6.setString(9, var2_2.getDate() == null ? null : new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(var2_2.getDate()));
            var5_6.setDate(10, var2_2.getFound() == null ? null : new Date(var2_2.getFound().getTime()));
            var5_6.setObject(11, null);
            v3 = var2_2.getComments();
            if (var7_3) ** GOTO lbl39
            if (v3 == null) {
                v4 = null;
            } else {
                v3 = var2_2.getComments();
lbl39:
                // 2 sources

                v4 = m.objectToBytes(v3);
            }
            var5_6.setBytes(12, v4);
            var5_6.setObject(13, null);
            var5_6.setObject(14, null);
            var5_6.executeUpdate();
            var5_6.close();
        }
        catch (Exception var6_7) {
            throw new PersistenceManagerException(var6_7.fillInStackTrace());
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void updateItem(ItemIF var1_1) throws PersistenceManagerException {
        var6_2 = PreferencePanel.h;
        var2_3 = new StringBuffer();
        var2_3.append("UPDATE ").append(this.getTableName("ITEMS")).append(" SET ");
        var2_3.append("CHANNEL_ID = ?, ");
        var2_3.append("TITLE = ?, ");
        var2_3.append("DESCRIPTION = ?, ");
        var2_3.append("UNREAD = ?, ");
        var2_3.append("LINK = ?, ");
        var2_3.append("CREATOR = ?, ");
        var2_3.append("SUBJECT = ?, ");
        var2_3.append("DATE = ?, ");
        var2_3.append("FOUND = ?, ");
        var2_3.append("GUID = ?, ");
        var2_3.append("COMMENTS = ?, ");
        var2_3.append("SOURCE = ?, ");
        var2_3.append("ENCLOSURE = ? ");
        var2_3.append("WHERE ITEM_ID = ? ");
        var3_4 = this.getConnection();
        try {
            var4_5 = this.prepareStatement(var3_4, var2_3.toString());
            var4_5.setLong(1, var1_1.getChannel().getId());
            var4_5.setString(2, m.toDbString(var1_1.getTitle()));
            var4_5.setString(3, m.toDbString(var1_1.getDescription()));
            v0 = var1_1.getUnRead();
            if (!var6_2) {
                v0 = v0 != 0 ? 1 : 0;
            }
            var4_5.setInt(4, v0);
            v1 = var1_1.getLink();
            if (var6_2) ** GOTO lbl49
            if (v1 == null) {
                v2 = null;
            } else {
                v1 = var1_1.getLink();
lbl49:
                // 2 sources

                v2 = m.objectToBytes(v1);
            }
            var4_5.setBytes(5, v2);
            var4_5.setString(6, m.toDbString(var1_1.getCreator()));
            var4_5.setString(7, m.toDbString(var1_1.getSubject()));
            var4_5.setString(8, var1_1.getDate() == null ? null : new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(var1_1.getDate()));
            var4_5.setDate(9, var1_1.getFound() == null ? null : new Date(var1_1.getFound().getTime()));
            var4_5.setObject(10, null);
            v3 = var1_1.getComments();
            if (var6_2) ** GOTO lbl62
            if (v3 == null) {
                v4 = null;
            } else {
                v3 = var1_1.getComments();
lbl62:
                // 2 sources

                v4 = m.objectToBytes(v3);
            }
            var4_5.setBytes(11, v4);
            var4_5.setObject(12, null);
            var4_5.setObject(13, null);
            var4_5.setLong(14, var1_1.getId());
            var4_5.executeUpdate();
            var4_5.close();
        }
        catch (Exception var5_6) {
            throw new PersistenceManagerException(var5_6.fillInStackTrace());
        }
    }

    public void deleteItem(ItemIF itemIF) throws PersistenceManagerException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ").append(this.getTableName("ITEMS")).append(" ");
        stringBuffer.append("WHERE ITEM_ID = ?");
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, itemIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new PersistenceManagerException(sQLException.fillInStackTrace());
        }
    }

    private void a(ChannelIF channelIF) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ").append(this.getTableName("ITEMS")).append(" ");
        stringBuffer.append("WHERE CHANNEL_ID = ?");
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
        preparedStatement.setLong(1, channelIF.getId());
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    private void a(ImageIF imageIF) throws Exception {
        if (imageIF != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM ").append(this.getTableName("IMAGES")).append(" ");
            stringBuffer.append("WHERE IMAGE_ID = ?");
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, imageIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private TextInputIF a(long var1_1) throws Exception {
        block2: {
            block3: {
                var8_2 = PreferencePanel.h;
                var3_3 = new StringBuffer();
                var3_3.append("SELECT TEXTINPUT_ID, TITLE, DESCRIPTION, NAME, LINK ");
                var3_3.append("FROM ").append(this.getTableName("TEXTINPUTS")).append(" ");
                var3_3.append("WHERE TEXTINPUT_ID = ?");
                var4_4 = this.getConnection();
                var5_5 = this.prepareStatement(var4_4, var3_3.toString());
                var5_5.setLong(1, var1_1);
                v0 = var6_6 = var5_5.executeQuery();
                if (var8_2) break block2;
                if (!v0.next()) break block3;
                var7_7 = new TextInput();
                var7_7.setId(var6_6.getLong("TEXTINPUT_ID"));
                var7_7.setTitle(var6_6.getString("TITLE"));
                var7_7.setDescription(var6_6.getString("DESCRIPTION"));
                var7_7.setName(var6_6.getString("NAME"));
                v1 = var6_6.getObject("LINK");
                if (var8_2) ** GOTO lbl26
                if (v1 == null) {
                    v2 = null;
                } else {
                    v1 = m.bytesToObject(var6_6.getBytes("LINK"));
lbl26:
                    // 2 sources

                    v2 = (URL)v1;
                }
                var7_7.setLink(v2);
                var6_6.close();
                var5_5.close();
                return var7_7;
            }
            v0 = var6_6;
        }
        v0.close();
        var5_5.close();
        return null;
    }

    private void a(TextInputIF textInputIF) throws Exception {
        if (textInputIF != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE FROM ").append(this.getTableName("TEXTINPUTS")).append(" ");
            stringBuffer.append("WHERE TEXTINPUT_ID = ?");
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
            preparedStatement.setLong(1, textInputIF.getId());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
    }

    /*
     * Exception decompiling
     */
    private ChannelIF b(long var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ChannelFormat a(String string) {
        boolean bl = PreferencePanel.h;
        boolean bl2 = string.equals(ChannelFormat.RSS_0_90.toString());
        if (!bl) {
            if (bl2) {
                return ChannelFormat.RSS_0_90;
            }
            bl2 = string.equals(ChannelFormat.RSS_0_91.toString());
        }
        if (!bl) {
            if (bl2) {
                return ChannelFormat.RSS_0_91;
            }
            bl2 = string.equals(ChannelFormat.RSS_0_92.toString());
        }
        if (!bl) {
            if (bl2) {
                return ChannelFormat.RSS_0_92;
            }
            bl2 = string.equals(ChannelFormat.RSS_0_93.toString());
        }
        if (!bl) {
            if (bl2) {
                return ChannelFormat.RSS_0_93;
            }
            bl2 = string.equals(ChannelFormat.RSS_0_94.toString());
        }
        if (!bl) {
            if (bl2) {
                return ChannelFormat.RSS_0_94;
            }
            bl2 = string.equals(ChannelFormat.RSS_1_0.toString());
        }
        if (!bl) {
            if (bl2) {
                return ChannelFormat.RSS_1_0;
            }
            bl2 = string.equals(ChannelFormat.RSS_2_0.toString());
        }
        if (bl2) {
            return ChannelFormat.RSS_2_0;
        }
        return ChannelFormat.UNKNOWN_CHANNEL_FORMAT;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private List<ItemIF> a(ChannelIF var1_1, String var2_2) throws Exception {
        block10: {
            block12: {
                block11: {
                    var9_3 = PreferencePanel.h;
                    if (var1_1 == null) {
                        return null;
                    }
                    var3_4 = new ArrayList<ItemIF>();
                    var4_5 = new StringBuffer();
                    var4_5.append("SELECT ITEM_ID, CHANNEL_ID, TITLE, DESCRIPTION, UNREAD, LINK, CREATOR, SUBJECT, DATE, FOUND, GUID, COMMENTS, SOURCE, ENCLOSURE, TIMESTAMP ");
                    var4_5.append("FROM ").append(this.getTableName("ITEMS")).append(" WHERE CHANNEL_ID = ?");
                    if (var9_3) break block11;
                    if (var2_2 == null) break block12;
                    var4_5.append(" ORDER BY ");
                }
                var4_5.append(var2_2);
            }
            var5_6 = this.getConnection();
            var6_7 = this.prepareStatement(var5_6, var4_5.toString());
            var6_7.setLong(1, var1_1.getId());
            var7_8 = var6_7.executeQuery();
            while (var7_8.next()) {
                var8_9 = new Item();
                var8_9.setId(var7_8.getLong("ITEM_ID"));
                var8_9.setChannel(var1_1);
                var8_9.setTitle(var7_8.getString("TITLE"));
                var8_9.setDescription(var7_8.getString("DESCRIPTION"));
                if (var9_3) break block10;
                v0 = var7_8.getInt("UNREAD");
                if (!var9_3) {
                    v0 = v0 != false;
                }
                var8_9.setUnRead(v0);
                v1 = var7_8.getObject("LINK");
                if (var9_3) ** GOTO lbl39
                if (v1 == null) {
                    v2 = null;
                } else {
                    v1 = m.bytesToObject(var7_8.getBytes("LINK"));
lbl39:
                    // 2 sources

                    v2 = (URL)v1;
                }
                var8_9.setLink(v2);
                var8_9.setCreator(var7_8.getString("CREATOR"));
                var8_9.setSubject(var7_8.getString("SUBJECT"));
                var8_9.setDate(var7_8.getObject("DATE") == null ? null : new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").parse(var7_8.getString("DATE")));
                var8_9.setFound((java.util.Date)var7_8.getDate("FOUND"));
                v3 = var7_8.getObject("COMMENTS");
                if (var9_3) ** GOTO lbl51
                if (v3 == null) {
                    v4 = null;
                } else {
                    v3 = m.bytesToObject(var7_8.getBytes("COMMENTS"));
lbl51:
                    // 2 sources

                    v4 = (URL)v3;
                }
                var8_9.setComments(v4);
                var3_4.add((ItemIF)var8_9);
                if (!var9_3) continue;
            }
            var7_8.close();
            var6_7.close();
        }
        return var3_4;
    }

    private CloudIF c(long l2) throws Exception {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private ImageIF d(long var1_1) throws Exception {
        block4: {
            block5: {
                var8_2 = PreferencePanel.h;
                var3_3 = new StringBuffer();
                var3_3.append("SELECT IMAGE_ID, TITLE, DESCRIPTION, LOCATION, LINK, WIDTH, HEIGHT ");
                var3_3.append("FROM ").append(this.getTableName("IMAGES")).append(" WHERE IMAGE_ID = ?");
                var4_4 = this.getConnection();
                var5_5 = this.prepareStatement(var4_4, var3_3.toString());
                var5_5.setLong(1, var1_1);
                v0 = var6_6 = var5_5.executeQuery();
                if (var8_2) break block4;
                if (!v0.next()) break block5;
                var7_7 = new Image();
                var7_7.setId(var1_1);
                var7_7.setTitle(var6_6.getString("TITLE"));
                var7_7.setDescription(var6_6.getString("DESCRIPTION"));
                v1 = var6_6.getObject("LOCATION");
                if (var8_2) ** GOTO lbl23
                if (v1 == null) {
                    v2 = null;
                } else {
                    v1 = m.bytesToObject(var6_6.getBytes("LOCATION"));
lbl23:
                    // 2 sources

                    v2 = (URL)v1;
                }
                var7_7.setLocation(v2);
                v3 = var6_6.getObject("LINK");
                if (var8_2) ** GOTO lbl31
                if (v3 == null) {
                    v4 = null;
                } else {
                    v3 = m.bytesToObject(var6_6.getBytes("LINK"));
lbl31:
                    // 2 sources

                    v4 = (URL)v3;
                }
                var7_7.setLink(v4);
                var7_7.setWidth(var6_6.getInt("WIDTH"));
                var7_7.setHeight(var6_6.getInt("HEIGHT"));
                var6_6.close();
                var5_5.close();
                return var7_7;
            }
            v0 = var6_6;
        }
        v0.close();
        var5_5.close();
        return null;
    }

    private ChannelGroupIF e(long l2) throws Exception {
        ResultSet resultSet;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT CHANNEL_GROUP_ID, TITLE, PARENT_ID ");
        stringBuffer.append("FROM ").append(this.getTableName("CHANNEL_GROUPS")).append(" WHERE CHANNEL_GROUP_ID = ?");
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = this.prepareStatement(connection, stringBuffer.toString());
        preparedStatement.setLong(1, l2);
        ResultSet resultSet2 = resultSet = preparedStatement.executeQuery();
        if (!PreferencePanel.h) {
            if (resultSet2.next()) {
                ChannelGroup channelGroup = new ChannelGroup();
                channelGroup.setId(l2);
                channelGroup.setTitle(resultSet.getString("TITLE"));
                channelGroup.setParent(resultSet.getLong("PARENT_ID") == 0L ? null : this.e(resultSet.getLong("PARENT_ID")));
                return channelGroup;
            }
            resultSet2 = resultSet;
        }
        resultSet2.close();
        preparedStatement.close();
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void b(ImageIF var1_1) throws Exception {
        var5_2 = PreferencePanel.h;
        var2_3 = new StringBuffer();
        var2_3.append("INSERT INTO ").append(this.getTableName("IMAGES")).append(" ");
        var2_3.append("(IMAGE_ID, TITLE, DESCRIPTION, LOCATION, LINK, WIDTH, HEIGHT) ");
        var2_3.append("VALUES (?, ?, ?, ?, ?, ?, ?)");
        var3_4 = this.getConnection();
        var4_5 = this.prepareStatement(var3_4, var2_3.toString());
        var4_5.setLong(1, var1_1.getId());
        var4_5.setString(2, m.toDbString(var1_1.getTitle()));
        var4_5.setString(3, m.toDbString(var1_1.getDescription()));
        v0 = var1_1.getLocation();
        if (var5_2) ** GOTO lbl20
        if (v0 == null) {
            v1 = null;
        } else {
            v0 = var1_1.getLocation();
lbl20:
            // 2 sources

            v1 = m.objectToBytes(v0);
        }
        var4_5.setBytes(4, v1);
        v2 = var1_1.getLink();
        if (var5_2) ** GOTO lbl28
        if (v2 == null) {
            v3 = null;
        } else {
            v2 = var1_1.getLink();
lbl28:
            // 2 sources

            v3 = m.objectToBytes(v2);
        }
        var4_5.setBytes(5, v3);
        var4_5.setInt(6, var1_1.getWidth());
        var4_5.setInt(7, var1_1.getHeight());
        var4_5.executeUpdate();
        var4_5.close();
    }

    /*
     * Unable to fully structure code
     */
    private void b(TextInputIF var1_1) throws Exception {
        var2_2 = new StringBuffer();
        var2_2.append("INSERT INTO ").append(this.getTableName("TEXTINPUTS")).append(" ");
        var2_2.append("(TEXTINPUT_ID, TITLE, DESCRIPTION, NAME, LINK) ");
        var2_2.append("VALUES (?, ?, ?, ?, ?)");
        var3_3 = this.getConnection();
        var4_4 = this.prepareStatement(var3_3, var2_2.toString());
        var4_4.setLong(1, var1_1.getId());
        var4_4.setString(2, m.toDbString(var1_1.getTitle()));
        var4_4.setString(3, m.toDbString(var1_1.getDescription()));
        var4_4.setString(4, m.toDbString(var1_1.getName()));
        v0 = var1_1.getLink();
        if (PreferencePanel.h) ** GOTO lbl20
        if (v0 == null) {
            v1 = null;
        } else {
            v0 = var1_1.getLink();
lbl20:
            // 2 sources

            v1 = m.objectToBytes(v0);
        }
        var4_4.setBytes(5, v1);
        var4_4.executeUpdate();
        var4_4.close();
    }

    public void close() throws Exception {
        block3: {
            Connection connection;
            block2: {
                Connection connection2;
                connection = connection2 = this.getConnection();
                if (PreferencePanel.h) break block2;
                if (connection == null) break block3;
                connection = connection2;
            }
            connection.createStatement().execute("shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean initializeDB() throws Exception {
        block17: {
            var7_1 = PreferencePanel.h;
            var1_2 = null;
            var2_3 = false;
            try {
                Class.forName("org.hsqldb.jdbcDriver");
                v0 = var1_2 = this.getConnection();
                if (!var7_1) {
                    if (v0 != null) {
                        var3_4 = var1_2.createStatement();
                        try {
                            var4_6 = var3_4.executeQuery("select * from " + this.getTablePrefix() + "config" + this.getTablePostfix());
                            var4_6.close();
                        }
                        catch (SQLException var4_7) {
                            this.installDB(var1_2);
                            var2_3 = true;
                        }
                    }
                    v0 = var1_2;
                }
                if (var7_1) ** GOTO lbl35
            }
            catch (Throwable var5_8) {
                block16: {
                    v1 = var1_2;
                    if (var7_1) ** GOTO lbl26
                    if (v1 == null) break block16;
                    try {
                        v1 = var1_2;
lbl26:
                        // 2 sources

                        v1.close();
                    }
                    catch (SQLException var6_9) {
                        this.b.warning(var6_9.getLocalizedMessage());
                    }
                }
                throw var5_8;
            }
            if (v0 == null) break block17;
            try {
                v0 = var1_2;
lbl35:
                // 2 sources

                v0.close();
            }
            catch (SQLException var3_5) {
                this.b.warning(var3_5.getLocalizedMessage());
            }
        }
        return var2_3;
    }

    protected void installDB(Connection connection) {
        try {
            byte[] byArray = m.getBytes(this.getScriptURL());
            Statement statement = connection.createStatement();
            try {
                statement.executeUpdate(new String(byArray));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            statement.close();
        }
        catch (Exception exception) {
            this.b.warning(exception.getLocalizedMessage());
        }
    }

    protected URL getScriptURL() {
        return m.class.getResource("rssdbscript.ddl");
    }

    protected Connection getConnection() {
        try {
            String string = "jdbc:hsqldb:file:" + this.a.getUserDataPath() + "/db/";
            return DriverManager.getConnection(string, "sa", "");
        }
        catch (SQLException sQLException) {
            this.b.warning(sQLException.getLocalizedMessage());
            return null;
        }
    }

    protected String getTableName(String string) {
        return this.getTablePrefix() + string + this.getTablePostfix();
    }

    protected String getTablePrefix() {
        return "";
    }

    protected String getTablePostfix() {
        return "";
    }

    protected PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    private ItemIF a(ChannelIF channelIF, ItemIF itemIF) {
        String string = m.toDbString(itemIF.getTitle());
        Set set = channelIF.getItems();
        ItemIF[] itemIFArray = set.toArray(new ItemIF[set.size()]);
        Arrays.sort(itemIFArray, new ItemComparator(true));
        for (ItemIF itemIF2 : set) {
            boolean bl = itemIF2.getTitle().equals(string);
            if (bl) {
                return itemIF2;
            }
            if (!PreferencePanel.h) continue;
        }
        return null;
    }
}

