/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.arjuna;

import com.arjuna.ams.admin.Admin;
import com.arjuna.ams.admin.AdminException;
import com.arjuna.ams.admin.AuthorizationAdminException;
import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.ext.arjuna.ArjunaMSAdminFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class ArjunaMSAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(ArjunaMSAdmin.class);
    private static final String NAME = "Name";
    private Context context;
    private Admin admin;
    private ArjunaMSAdminFactory factory;

    public ArjunaMSAdmin(Hermes hermes, ArjunaMSAdminFactory factory, Context context) {
        super(hermes);
        this.context = context;
        this.factory = factory;
    }

    protected synchronized Admin getAdmin() throws JMSException {
        try {
            if (this.admin == null) {
                this.admin = (Admin)this.context.lookup(this.factory.getAdminBinding());
            }
        }
        catch (NamingException ex) {
            throw new HermesException((Exception)ex);
        }
        return this.admin;
    }

    public int getDepth(DestinationConfig dest) throws JMSException {
        try {
            Hashtable stats = this.getAdmin().getDestinationStatistics(this.getRealDestinationName(dest));
            return (Integer)stats.get("NumMessagesOustanding");
        }
        catch (AdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }

    public void close() throws JMSException {
        if (this.admin != null) {
            this.admin.close();
            this.admin = null;
        }
    }

    public Map getStatistics(DestinationConfig destination) throws JMSException {
        try {
            return this.getAdmin().getDestinationStatistics(this.getRealDestinationName(destination));
        }
        catch (Exception e) {
            throw new HermesException(e);
        }
    }

    private DestinationConfig createDestinationConfig(Hashtable info, Domain domain) {
        DestinationConfig dConfig = new DestinationConfig();
        String name = (String)info.get(NAME);
        dConfig.setName(name);
        dConfig.setDomain(Integer.valueOf(domain.getId()));
        return dConfig;
    }

    public Collection discoverDestinationConfigs() throws JMSException {
        try {
            if (this.getHermes().getConnectionFactory() instanceof JNDIConnectionFactory) {
                return super.discoverDestinationConfigs();
            }
            ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
            if (this.getHermes().getConnectionFactory() instanceof QueueConnectionFactory) {
                Hashtable[] queueDetails = this.getAdmin().getAllQueuesDetails();
                for (int i = 0; i < queueDetails.length; ++i) {
                    Hashtable t = queueDetails[i];
                    rval.add(this.createDestinationConfig(t, Domain.QUEUE));
                }
            } else if (this.getHermes().getConnectionFactory() instanceof TopicConnectionFactory) {
                Hashtable[] topicDetails = this.getAdmin().getAllTopicsDetails();
                for (int i = 0; i < topicDetails.length; ++i) {
                    Hashtable t = topicDetails[i];
                    rval.add(this.createDestinationConfig(t, Domain.TOPIC));
                    rval.addAll(this.discoverDurableSubscriptions((String)t.get(NAME), null));
                }
            }
            return rval;
        }
        catch (AuthorizationAdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
        catch (AdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }
}

