/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.margin.AbstractLineMargin;
import com.jidesoft.editor.margin.AbstractMargin;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class LineNumberMargin
extends AbstractLineMargin
implements DocumentListener,
PropertyChangeListener {
    private static Color b = new Color(128, 0, 0);
    private transient int c;
    private transient int d;

    public LineNumberMargin(CodeEditor codeEditor) {
        super(codeEditor);
        SyntaxDocument syntaxDocument = codeEditor.getDocument();
        if (AbstractMargin.a == 0) {
            if (syntaxDocument != null) {
                syntaxDocument.addDocumentListener(this);
            }
            codeEditor.addPropertyChangeListener(this);
            this.setForeground(b);
        }
    }

    public void paintLineMargin(Graphics graphics, Rectangle rectangle, int n) {
        CodeEditor codeEditor = this.getCodeEditor();
        int n2 = codeEditor.viewToModelLine(n) + 1;
        if (n2 <= codeEditor.getLineCount()) {
            String string = "" + n2;
            graphics.setColor(this.getForeground());
            graphics.drawString(string, rectangle.x + rectangle.width - codeEditor.getPainter().getFontMetrics().stringWidth(string) - 3, rectangle.y + codeEditor.getPainter().getFontMetrics().getAscent());
        }
    }

    public int getPreferredWidth() {
        CodeEditor codeEditor = this.getCodeEditor();
        String string = "" + codeEditor.getLineCount();
        this.c = string.length();
        return codeEditor.getPainter().getFontMetrics().stringWidth(string) + 6;
    }

    public String getToolTipText(int n) {
        if (n >= this.getCodeEditor().getLineCount()) {
            return null;
        }
        return "" + (n + 1);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block6: {
            String string;
            block7: {
                String string2;
                Object object;
                int n;
                block5: {
                    n = AbstractMargin.a;
                    object = "document";
                    if (n != 0) break block5;
                    if (!((String)object).equals(propertyChangeEvent.getPropertyName())) break block6;
                    object = propertyChangeEvent.getOldValue();
                }
                String string3 = object;
                Object object2 = string3;
                if (n == 0) {
                    if (object2 instanceof Document) {
                        ((Document)((Object)string3)).removeDocumentListener(this);
                    }
                    object2 = propertyChangeEvent.getNewValue();
                }
                string = string2 = object2;
                if (n != 0) break block7;
                if (!(string instanceof Document)) break block6;
                string = string2;
            }
            ((Document)((Object)string)).addDocumentListener(this);
        }
    }

    protected void checkLineNumberWidthChanged() {
        block6: {
            int n;
            int n2;
            int n3;
            block4: {
                block5: {
                    int n4;
                    int n5 = AbstractMargin.a;
                    n3 = this._editor.getLineCount();
                    n2 = n4 = (int)(Math.log(n3) / Math.log(10.0) + 1.0);
                    n = this.c;
                    if (n5 != 0) break block4;
                    if (n2 == n) break block5;
                    this.invalidate();
                    this._editor.validate();
                    if (n5 == 0) break block6;
                }
                n2 = n3;
                n = this.d;
            }
            if (n2 != n) {
                this.d = n3;
                this.repaint();
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkLineNumberWidthChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkLineNumberWidthChanged();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkLineNumberWidthChanged();
    }
}

