/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.KeywordMap;
import com.jidesoft.editor.LineBreak;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import com.jidesoft.swing.DelayUndoManager;
import com.jidesoft.utils.PortingUtils;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class SyntaxDocument
extends PlainDocument
implements LineBreak {
    protected UndoManager _undoManager = new DelayUndoManager();
    protected CompoundEdit _compoundEdit;
    protected int _compoundEditCount = 0;
    private static final long serialVersionUID = -6307295612809666540L;
    protected TokenMarker tokenMarker;

    public SyntaxDocument() {
        this.addUndoableEditListener(new MyUndoableEditListener());
    }

    public String getLineText(int n) throws BadLocationException {
        Element element = this.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        int n3 = element.getElement(n2).getStartOffset();
        int n4 = element.getElement(n2).getEndOffset();
        return this.getText(n3, n4 - n3);
    }

    public int getLineNumber(int n) {
        return this.getDefaultRootElement().getElementIndex(n);
    }

    public void undo() {
        block4: {
            block3: {
                UndoManager undoManager;
                int n;
                block2: {
                    n = KeywordMap.c;
                    undoManager = this.getUndoManager();
                    if (n != 0) break block2;
                    if (!undoManager.canUndo()) break block3;
                    undoManager = this.getUndoManager();
                }
                undoManager.undo();
                if (n == 0) break block4;
            }
            PortingUtils.notifyUser();
        }
    }

    public void redo() {
        block4: {
            block3: {
                UndoManager undoManager;
                int n;
                block2: {
                    n = KeywordMap.c;
                    undoManager = this.getUndoManager();
                    if (n != 0) break block2;
                    if (!undoManager.canRedo()) break block3;
                    undoManager = this.getUndoManager();
                }
                undoManager.redo();
                if (n == 0) break block4;
            }
            PortingUtils.notifyUser();
        }
    }

    public UndoManager getUndoManager() {
        return this._undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this._undoManager = undoManager;
    }

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        this.tokenMarker = tokenMarker;
        TokenMarker tokenMarker2 = tokenMarker;
        if (KeywordMap.c == 0) {
            if (tokenMarker2 == null) {
                return;
            }
            tokenMarker2 = this.tokenMarker;
        }
        tokenMarker2.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    public void tokenizeLines(int n, int n2) {
        int n3;
        block8: {
            block7: {
                TokenMarker tokenMarker;
                block6: {
                    n3 = KeywordMap.c;
                    tokenMarker = this.tokenMarker;
                    if (n3 != 0) break block6;
                    if (tokenMarker == null) break block7;
                    tokenMarker = this.tokenMarker;
                }
                if (tokenMarker.supportsMultilineTokens()) break block8;
            }
            return;
        }
        Segment segment = new Segment();
        Element element = this.getDefaultRootElement();
        n2 += n;
        try {
            for (int i = n; i < n2; ++i) {
                Element element2 = element.getElement(i);
                int n4 = element2.getStartOffset();
                int n5 = element2.getEndOffset() - n4 - 1;
                this.getText(n4, n5, segment);
                this.tokenMarker.markTokens(segment, i);
                if (n3 == 0 && n3 == 0) continue;
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isInCommentOrLiteral(int var1_1) throws BadLocationException {
        block14: {
            var11_2 = KeywordMap.c;
            var2_3 = this.getTokenMarker();
            if (var2_3 == null) {
                return false;
            }
            var3_4 = new Segment();
            var4_5 = this.getDefaultRootElement();
            var5_6 = 0;
            block0: while (true) {
                v0 = var5_6;
                v1 = var4_5.getElementCount();
                block1: while (v0 < v1) {
                    block21: {
                        block15: {
                            block16: {
                                var6_7 = var4_5.getElement(var5_6);
                                var7_8 = var6_7.getStartOffset();
                                var8_9 = var6_7.getEndOffset() - var7_8 - 1;
                                v2 = var1_1;
                                if (var11_2 != 0) break block14;
                                v3 = var7_8;
                                if (var11_2 != 0) break block15;
                                if (v2 < v3) break block16;
                                v4 = var1_1;
                                v3 = var7_8 + var8_9;
                                if (var11_2 != 0) break block15;
                                if (v4 >= v3) break block16;
                                this.getText(var7_8, var8_9, var3_4);
                                var9_10 = var2_3.markTokens(var3_4, var5_6);
                                var10_11 = 0;
                                while (var9_10 != null) {
                                    block19: {
                                        block20: {
                                            block17: {
                                                block18: {
                                                    v0 = var9_10.id;
                                                    v1 = 127;
                                                    if (var11_2 != 0) continue block1;
                                                    if (var11_2 == 0) {
                                                        if (v0 == v1) break;
                                                        v5 = var9_10.id;
                                                        v6 = 1;
                                                    }
                                                    if (var11_2 != 0) break block17;
                                                    if (v5 == v6) break block18;
                                                    v5 = var9_10.id;
                                                    v6 = 2;
                                                    if (var11_2 != 0) break block17;
                                                    if (v5 == v6) break block18;
                                                    v5 = var9_10.id;
                                                    v6 = 3;
                                                    if (var11_2 != 0) break block17;
                                                    if (v5 == v6) break block18;
                                                    v5 = var9_10.id;
                                                    v6 = 4;
                                                    if (var11_2 != 0) break block19;
                                                    if (v5 != v6) break block20;
                                                }
                                                v5 = var7_8 + var10_11;
                                                v6 = var1_1;
                                            }
                                            if (var11_2 != 0) break block19;
                                            if (v5 <= v6) {
                                                v5 = var7_8 + var10_11 + var9_10.length;
                                                v6 = var1_1;
                                                if (var11_2 == 0) {
                                                    if (v5 > v6) {
                                                        return true;
                                                    } else {
                                                        ** GOTO lbl62
                                                    }
                                                } else {
                                                    ** GOTO lbl61
                                                }
                                            }
                                            break block20;
lbl61:
                                            // 2 sources

                                            break block19;
                                        }
                                        v5 = var10_11;
                                        v6 = var9_10.length;
                                    }
                                    var10_11 = v5 + v6;
                                    var9_10 = var9_10.next;
                                    if (var11_2 == 0) continue;
                                }
                                if (var11_2 == 0) break block21;
                            }
                            v4 = var1_1;
                            v3 = var7_8;
                        }
                        if (v4 < v3) break block0;
                    }
                    ++var5_6;
                    if (var11_2 == 0) continue block0;
                }
                break;
            }
            v2 = 0;
        }
        return (boolean)v2;
    }

    public void beginCompoundEdit() {
        SyntaxDocument syntaxDocument = this;
        if (KeywordMap.c == 0) {
            if (syntaxDocument._compoundEdit == null) {
                this._compoundEdit = new CompoundEdit();
            }
            syntaxDocument = this;
        }
        ++syntaxDocument._compoundEditCount;
    }

    public void endCompoundEdit() {
        block3: {
            block2: {
                --this._compoundEditCount;
                SyntaxDocument syntaxDocument = this;
                if (KeywordMap.c != 0) break block2;
                if (syntaxDocument._compoundEditCount != 0) break block3;
                this._compoundEdit.end();
                this.getUndoManager().undoableEditHappened(new UndoableEditEvent(this, this._compoundEdit));
                syntaxDocument = this;
            }
            syntaxDocument._compoundEdit = null;
        }
    }

    public void addUndoableEdit(UndoableEdit undoableEdit) {
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        block6: {
            SyntaxDocument syntaxDocument;
            block4: {
                block5: {
                    int n = KeywordMap.c;
                    syntaxDocument = this;
                    if (n != 0) break block4;
                    if (syntaxDocument.tokenMarker == null) break block5;
                    DocumentEvent.ElementChange elementChange = documentEvent.getChange(this.getDefaultRootElement());
                    if (n != 0) break block6;
                    if (elementChange != null) {
                        this.tokenMarker.insertLines(elementChange.getIndex() + 1, elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length);
                    }
                }
                syntaxDocument = this;
            }
            super.fireInsertUpdate(documentEvent);
        }
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        block6: {
            SyntaxDocument syntaxDocument;
            block4: {
                block5: {
                    int n = KeywordMap.c;
                    syntaxDocument = this;
                    if (n != 0) break block4;
                    if (syntaxDocument.tokenMarker == null) break block5;
                    DocumentEvent.ElementChange elementChange = documentEvent.getChange(this.getDefaultRootElement());
                    if (n != 0) break block6;
                    if (elementChange != null) {
                        this.tokenMarker.deleteLines(elementChange.getIndex() + 1, elementChange.getChildrenRemoved().length - elementChange.getChildrenAdded().length);
                    }
                }
                syntaxDocument = this;
            }
            super.fireRemoveUpdate(documentEvent);
        }
    }

    public static int convertLineBreaks(String string, StringBuffer stringBuffer) {
        return SyntaxDocument.a(string, stringBuffer, "\n", null);
    }

    public static int convertLineBreaks(String string, StringBuffer stringBuffer, String string2) {
        return SyntaxDocument.a(string, stringBuffer, string2, null);
    }

    private static int a(String string, StringBuffer stringBuffer, String string2, int[] nArray) {
        int n;
        block5: {
            int n2 = KeywordMap.c;
            int n3 = -2;
            int n4 = 0;
            if (string == null) {
                return n3;
            }
            int n5 = 0;
            while (n5 < string.length()) {
                block8: {
                    block9: {
                        int n6;
                        block14: {
                            block27: {
                                int n7;
                                int n8;
                                block25: {
                                    block26: {
                                        int n9;
                                        block20: {
                                            block21: {
                                                block24: {
                                                    int n10;
                                                    block22: {
                                                        block23: {
                                                            int n11;
                                                            block15: {
                                                                block16: {
                                                                    block19: {
                                                                        int n12;
                                                                        block17: {
                                                                            block18: {
                                                                                block13: {
                                                                                    block6: {
                                                                                        block7: {
                                                                                            block12: {
                                                                                                int n13;
                                                                                                int n14;
                                                                                                block10: {
                                                                                                    block11: {
                                                                                                        n6 = string.charAt(n5);
                                                                                                        n = n6;
                                                                                                        if (n2 != 0) break block5;
                                                                                                        n11 = 10;
                                                                                                        if (n2 != 0) break block6;
                                                                                                        if (n != n11) break block7;
                                                                                                        stringBuffer.append(string2);
                                                                                                        SyntaxDocument.a(nArray, stringBuffer.length(), 1, string2.length());
                                                                                                        if (n2 != 0) break block8;
                                                                                                        if (n4 != 0) break block9;
                                                                                                        n14 = n3;
                                                                                                        n13 = -2;
                                                                                                        if (n2 != 0) break block10;
                                                                                                        if (n14 != n13) break block11;
                                                                                                        n3 = 1;
                                                                                                        if (n2 == 0) break block9;
                                                                                                    }
                                                                                                    n14 = n3;
                                                                                                    if (n2 != 0) break block12;
                                                                                                    n13 = 1;
                                                                                                }
                                                                                                if (n14 == n13) break block9;
                                                                                                n3 = -1;
                                                                                                n14 = n4 = 1;
                                                                                            }
                                                                                            if (n2 == 0) break block9;
                                                                                        }
                                                                                        n9 = n6;
                                                                                        n11 = 13;
                                                                                    }
                                                                                    if (n2 != 0) break block13;
                                                                                    if (n9 != n11) break block14;
                                                                                    stringBuffer.append(string2);
                                                                                    n9 = n5;
                                                                                    n11 = string.length() - 1;
                                                                                }
                                                                                if (n2 != 0) break block15;
                                                                                if (n9 >= n11) break block16;
                                                                                n9 = string.charAt(n5 + 1);
                                                                                n11 = 10;
                                                                                if (n2 != 0) break block15;
                                                                                if (n9 != n11) break block16;
                                                                                ++n5;
                                                                                SyntaxDocument.a(nArray, stringBuffer.length(), 2, string2.length());
                                                                                if (n2 != 0) break block8;
                                                                                if (n4 != 0) break block9;
                                                                                n12 = n3;
                                                                                if (n2 != 0) break block17;
                                                                                if (n12 != -2) break block18;
                                                                                n3 = 0;
                                                                                if (n2 == 0) break block9;
                                                                            }
                                                                            n12 = n3;
                                                                        }
                                                                        if (n2 != 0) break block19;
                                                                        if (n12 == 0) break block9;
                                                                        n3 = -1;
                                                                        n12 = n4 = 1;
                                                                    }
                                                                    if (n2 == 0) break block9;
                                                                }
                                                                n9 = n5;
                                                                if (n2 != 0) break block20;
                                                                n11 = string.length() - 2;
                                                            }
                                                            if (n9 >= n11) break block21;
                                                            n9 = string.charAt(n5 + 1);
                                                            if (n2 != 0) break block20;
                                                            if (n9 != 13) break block21;
                                                            n9 = string.charAt(n5 + 2);
                                                            if (n2 != 0) break block20;
                                                            if (n9 != 10) break block21;
                                                            n5 += 2;
                                                            SyntaxDocument.a(nArray, stringBuffer.length(), 3, string2.length());
                                                            if (n2 != 0) break block8;
                                                            if (n4 != 0) break block9;
                                                            n10 = n3;
                                                            if (n2 != 0) break block22;
                                                            if (n10 != -2) break block23;
                                                            n3 = 0;
                                                            if (n2 == 0) break block9;
                                                        }
                                                        n10 = n3;
                                                    }
                                                    if (n2 != 0) break block24;
                                                    if (n10 == 0) break block9;
                                                    n3 = -1;
                                                    n10 = n4 = 1;
                                                }
                                                if (n2 == 0) break block9;
                                            }
                                            SyntaxDocument.a(nArray, stringBuffer.length(), 1, string2.length());
                                            if (n2 != 0) break block8;
                                            n9 = n4;
                                        }
                                        if (n9 != 0) break block9;
                                        n8 = n3;
                                        n7 = -2;
                                        if (n2 != 0) break block25;
                                        if (n8 != n7) break block26;
                                        n3 = 2;
                                        if (n2 == 0) break block9;
                                    }
                                    n8 = n3;
                                    if (n2 != 0) break block27;
                                    n7 = 2;
                                }
                                if (n8 == n7) break block9;
                                n3 = -1;
                                n8 = n4 = 1;
                            }
                            if (n2 == 0) break block9;
                        }
                        stringBuffer.append((char)n6);
                    }
                    ++n5;
                }
                if (n2 == 0) continue;
            }
            n = n3;
        }
        return n;
    }

    private static void a(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = KeywordMap.c;
        if (nArray == null) {
            return;
        }
        int n7 = n5 = n3 - n2;
        if (n6 == 0) {
            if (n7 == 0) {
                return;
            }
            n7 = n4 = 0;
        }
        while (n4 < nArray.length) {
            int n8 = nArray[n4];
            if (n6 == 0) {
                if (n8 >= n + n2) {
                    int n9 = n4;
                    nArray[n9] = nArray[n9] + n5;
                }
                ++n4;
            }
            if (n6 == 0) continue;
        }
    }

    public char charAt(int n) throws BadLocationException {
        Segment segment = new Segment();
        this.getContent().getChars(n, 1, segment);
        return segment.first();
    }

    protected class MyUndoableEditListener
    implements UndoableEditListener {
        protected MyUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            block4: {
                SyntaxDocument syntaxDocument;
                block2: {
                    block3: {
                        int n = KeywordMap.c;
                        syntaxDocument = SyntaxDocument.this;
                        if (n != 0) break block2;
                        if (syntaxDocument._compoundEdit == null) break block3;
                        SyntaxDocument.this._compoundEdit.addEdit(undoableEditEvent.getEdit());
                        if (n == 0) break block4;
                    }
                    syntaxDocument = SyntaxDocument.this;
                }
                syntaxDocument.getUndoManager().undoableEditHappened(undoableEditEvent);
            }
        }
    }
}

