/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.alert.InputPopup;
import com.jidesoft.editor.ClipboardsDialog;
import com.jidesoft.editor.CodeEditorFindAndReplaceTarget;
import com.jidesoft.editor.CodeEditorPainter;
import com.jidesoft.editor.CodeEditorResource;
import com.jidesoft.editor.CodeEditorSearchable;
import com.jidesoft.editor.CodeEditorSelectionFindAndReplaceTarget;
import com.jidesoft.editor.CodeEditorSettings;
import com.jidesoft.editor.CodeInspector;
import com.jidesoft.editor.ColumnGuide;
import com.jidesoft.editor.DefaultCodeEditorSettings;
import com.jidesoft.editor.DefaultSettings;
import com.jidesoft.editor.KeywordMap;
import com.jidesoft.editor.LineBreak;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.editor.SyntaxStyleSchema;
import com.jidesoft.editor.TextUtils;
import com.jidesoft.editor.a;
import com.jidesoft.editor.action.InputHandler;
import com.jidesoft.editor.b;
import com.jidesoft.editor.c;
import com.jidesoft.editor.caret.CaretEvent;
import com.jidesoft.editor.caret.CaretListener;
import com.jidesoft.editor.caret.CaretModel;
import com.jidesoft.editor.caret.CaretPosition;
import com.jidesoft.editor.caret.DefaultCaretModel;
import com.jidesoft.editor.folding.DefaultFoldingModel;
import com.jidesoft.editor.folding.FoldingModel;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.highlight.DefaultHighlighter;
import com.jidesoft.editor.highlight.Highlighter;
import com.jidesoft.editor.margin.LineNumberMargin;
import com.jidesoft.editor.margin.MarginArea;
import com.jidesoft.editor.marker.DefaultMarkerModel;
import com.jidesoft.editor.marker.Marker;
import com.jidesoft.editor.marker.MarkerArea;
import com.jidesoft.editor.marker.MarkerEvent;
import com.jidesoft.editor.marker.MarkerListener;
import com.jidesoft.editor.marker.MarkerModel;
import com.jidesoft.editor.selection.DefaultSelectionModel;
import com.jidesoft.editor.selection.SelectionEvent;
import com.jidesoft.editor.selection.SelectionListener;
import com.jidesoft.editor.selection.SelectionModel;
import com.jidesoft.editor.tokenmarker.Token;
import com.jidesoft.editor.tokenmarker.TokenMarker;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.search.FindAndReplace;
import com.jidesoft.search.FindAndReplaceDialog;
import com.jidesoft.search.FindAndReplaceTarget;
import com.jidesoft.search.FindResult;
import com.jidesoft.search.FindResultIntepreter;
import com.jidesoft.search.FindResults;
import com.jidesoft.swing.DelayUndoManager;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import com.jidesoft.utils.W;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.undo.UndoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeEditor
extends JComponent
implements SelectionListener,
CaretListener,
PropertyChangeListener,
FindResultIntepreter,
LineBreak {
    private static final Logger a;
    private boolean b;
    public static String LEFT_OF_SCROLLBAR;
    public static final String PROPERTY_OVERWRITE_ENABLED = "overwriteEnabled";
    public MarginArea _marginArea;
    public LineNumberMargin _lineNumberMargin;
    protected List<Transferable> _clipboards;
    private final String c = "nonwordDelimiters";
    public Searchable _searchable;
    private JidePopup d;
    public Timer _inspectionTimer;
    private FoldingModel e;
    private FoldingSpanListener f;
    private MarkerModel g;
    private FindAndReplace h;
    private k_ i;
    protected CodeEditorSettings _defaultSettings;
    protected DefaultCodeEditorSettings _localSettings;
    private transient Highlighter j;
    private List<ColumnGuide> k;
    private transient boolean l;
    private boolean m;
    private MarkerArea n;
    private MarkerListener o;
    private List<CodeInspector> p;
    private boolean q;
    public static final String PROPERTY_EDITABLE = "editable";
    protected static String CENTER;
    protected static String RIGHT;
    protected static String LEFT;
    protected static String BOTTOM;
    protected static CodeEditor focusedComponent;
    protected static Timer caretTimer;
    protected CodeEditorPainter _painter;
    protected boolean _caretVisible;
    private boolean r;
    protected boolean _editable;
    protected CodeEditorSettings _settings;
    protected int _firstLine;
    protected int _visibleLines;
    protected int _horizontalOffset;
    protected JScrollBar _verticalScrollBar;
    protected JScrollBar _horizontalScrollBar;
    protected boolean _scrollBarsInitialized;
    protected SyntaxDocument _document;
    protected j_ _documentHandler;
    protected UndoableEditListener _undoableEditListener;
    protected Segment lineSegment;
    protected boolean biasLeft;
    protected int bracketPosition;
    protected int bracketLine;
    protected int _magicCaret;
    protected boolean _overwrite;
    protected CaretModel _caretModel;
    protected SelectionModel _selectionModel;
    public static final String PROPERTY_TAB_SIZE = "tabSize";
    private int s;
    public static final String PROPERTY_REPLACE_TAB_WITH_SPACE = "replaceTabWithSpace";
    private boolean t;
    public static final String PROPERTY_LINE_BREAK_STYLE = "lineBreakStyle";
    private int u;
    public static final String PROPERTY_MAX_NUMBER_OF_CLIPBOARDS = "maxNumberOfClipboards";
    private int v;
    private boolean w;
    private static Insets x;
    public static final String SMART_HOME_END_PROPERTY = "InputHandler.homeEnd";
    private Dimension y;
    public static boolean A;

    public CodeEditor() {
        this(DefaultSettings.getDefaults());
    }

    private void a() {
        block4: {
            block3: {
                Highlighter highlighter;
                block2: {
                    Highlighter highlighter2;
                    this.u = this.getDefaultLineBreakStyle();
                    this.setBorder(UIDefaultsLookup.getBorder("TextField.border"));
                    this.addMouseWheelListener(new o_());
                    this._searchable = this.createSearchable(this);
                    highlighter = highlighter2 = this.getHighlighter();
                    if (KeywordMap.c != 0) break block2;
                    if (highlighter == null) break block3;
                    highlighter = highlighter2;
                }
                if (!(highlighter instanceof UIResource)) break block4;
            }
            this.setHighlighter(this.createHighlighter());
        }
        this.loadActionMap();
    }

    protected Searchable createSearchable(CodeEditor codeEditor) {
        return new CodeEditorSearchable(codeEditor);
    }

    public CodeEditor(DefaultSettings defaultSettings) {
        int n = KeywordMap.c;
        this.c = "nonwordDelimiters";
        this.h = null;
        this.l = false;
        this.m = false;
        this.p = new LinkedList<CodeInspector>();
        this.q = false;
        this._caretVisible = true;
        this.s = 4;
        this.t = true;
        this.u = -2;
        this.v = 10;
        this.enableEvents(8L);
        this._painter = this.createCodeEditorPainter(this);
        this._defaultSettings = defaultSettings;
        this._localSettings = new DefaultCodeEditorSettings();
        this._documentHandler = new j_();
        this.lineSegment = new Segment();
        this.bracketPosition = -1;
        this.bracketLine = -1;
        this.b(true);
        this._undoableEditListener = new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                CodeEditor.this.b();
            }
        };
        this._marginArea = new MarginArea(this);
        this._lineNumberMargin = new LineNumberMargin(this);
        this._marginArea.add(this._lineNumberMargin);
        this.setLayout(new p_());
        this.add(CENTER, this._painter);
        this.add(LEFT, this._marginArea);
        this._verticalScrollBar = this.createScrollBar(1);
        this.add(RIGHT, this._verticalScrollBar);
        this._horizontalScrollBar = this.createScrollBar(0);
        this.add(BOTTOM, this._horizontalScrollBar);
        this._verticalScrollBar.addAdjustmentListener(new h_());
        this._horizontalScrollBar.addAdjustmentListener(new h_());
        this._painter.addComponentListener(new b_());
        n_ n_2 = new n_();
        this._painter.addMouseListener(n_2);
        this._painter.addMouseMotionListener(n_2);
        a_ a_2 = new a_();
        this._painter.setDropTarget(new DropTarget(this._painter, a_2));
        this.addFocusListener(new l_());
        this.initializeDefaultSettings(defaultSettings);
        focusedComponent = this;
        this.i = new k_();
        this.i.reset();
        this.a();
        if (n != 0) {
            A = !A;
        }
    }

    protected CodeEditorPainter createCodeEditorPainter(CodeEditor codeEditor) {
        return new CodeEditorPainter(codeEditor);
    }

    private void b() {
        block12: {
            Action action;
            UndoManager undoManager;
            block11: {
                Action action2;
                int n;
                block10: {
                    boolean bl;
                    block9: {
                        n = KeywordMap.c;
                        undoManager = this.getDocument().getUndoManager();
                        bl = undoManager instanceof DelayUndoManager;
                        if (n != 0) break block9;
                        if (!bl) break block10;
                        bl = ((DelayUndoManager)undoManager).isCacheEmpty();
                    }
                    if (!bl) {
                        return;
                    }
                }
                action = action2 = this.d("undo");
                if (n == 0) {
                    if (action != null) {
                        action2.setEnabled(undoManager.canUndo());
                    }
                    action = action2 = this.d("redo");
                }
                if (n != 0) break block11;
                if (action == null) break block12;
                action = action2;
            }
            action.setEnabled(undoManager.canRedo());
        }
    }

    protected JScrollBar createScrollBar(int n) {
        return new JScrollBar(n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block10: {
            boolean bl;
            block22: {
                int n;
                block20: {
                    block21: {
                        block18: {
                            block19: {
                                block16: {
                                    block17: {
                                        block15: {
                                            block13: {
                                                block14: {
                                                    block12: {
                                                        block11: {
                                                            block8: {
                                                                block9: {
                                                                    block5: {
                                                                        block7: {
                                                                            block6: {
                                                                                block4: {
                                                                                    n = KeywordMap.c;
                                                                                    bl = "blockCaret".equals(propertyChangeEvent.getPropertyName());
                                                                                    if (n != 0) break block4;
                                                                                    if (bl) break block5;
                                                                                    bl = "selectionColor".equals(propertyChangeEvent.getPropertyName());
                                                                                }
                                                                                if (n != 0) break block6;
                                                                                if (bl) break block5;
                                                                                bl = "lineHighlight".equals(propertyChangeEvent.getPropertyName());
                                                                            }
                                                                            if (n != 0) break block7;
                                                                            if (bl) break block5;
                                                                            bl = "lineHighlightColor".equals(propertyChangeEvent.getPropertyName());
                                                                        }
                                                                        if (n != 0) break block8;
                                                                        if (!bl) break block9;
                                                                    }
                                                                    this._painter.invalidateSelectedLines();
                                                                    if (n == 0) break block10;
                                                                }
                                                                bl = "bracketHighlightColor".equals(propertyChangeEvent.getPropertyName());
                                                            }
                                                            if (n != 0) break block11;
                                                            if (bl) break block12;
                                                            bl = "bracketHighlight".equals(propertyChangeEvent.getPropertyName());
                                                        }
                                                        if (n != 0) break block13;
                                                        if (!bl) break block14;
                                                    }
                                                    this._painter.invalidateLine(this.getBracketLine());
                                                    if (n == 0) break block10;
                                                }
                                                bl = "specialCharactersColor".equals(propertyChangeEvent.getPropertyName());
                                            }
                                            if (n != 0) break block15;
                                            if (bl) break block16;
                                            bl = "specialCharacters".equals(propertyChangeEvent.getPropertyName());
                                        }
                                        if (n != 0) break block17;
                                        if (bl) break block16;
                                        bl = "styles".equals(propertyChangeEvent.getPropertyName());
                                    }
                                    if (n != 0) break block18;
                                    if (!bl) break block19;
                                }
                                this._painter.repaint();
                                if (n == 0) break block10;
                            }
                            bl = "font".equals(propertyChangeEvent.getPropertyName());
                        }
                        if (n != 0) break block20;
                        if (!bl) break block21;
                        this.setFont((Font)propertyChangeEvent.getNewValue());
                        if (n == 0) break block10;
                    }
                    bl = "caretBlinks".equals(propertyChangeEvent.getPropertyName());
                }
                if (n != 0) break block22;
                if (!bl) break block10;
                bl = Boolean.FALSE.equals(propertyChangeEvent.getNewValue());
            }
            if (bl) {
                this.b(false);
            }
            this._painter.invalidateSelectedLines();
        }
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public final SyntaxStyleSchema getStyles() {
        SyntaxStyleSchema syntaxStyleSchema = this._localSettings.getStyles();
        if (KeywordMap.c == 0) {
            if (syntaxStyleSchema != null) {
                return this._localSettings.getStyles();
            }
            syntaxStyleSchema = this._defaultSettings.getStyles();
        }
        return syntaxStyleSchema;
    }

    public final void setStyles(SyntaxStyleSchema syntaxStyleSchema) {
        this._localSettings.setStyles(syntaxStyleSchema);
        this.repaint();
    }

    public final Color getCaretColor() {
        Color color = this._localSettings.getCaretColor();
        if (KeywordMap.c == 0) {
            if (color != null) {
                return this._localSettings.getCaretColor();
            }
            color = this._defaultSettings.getCaretColor();
        }
        return color;
    }

    public final void setCaretColor(Color color) {
        this._localSettings.setCaretColor(color);
    }

    public final Color getSelectionColor() {
        Color color = this._localSettings.getSelectionColor();
        if (KeywordMap.c == 0) {
            if (color != null) {
                return this._localSettings.getSelectionColor();
            }
            color = this._defaultSettings.getSelectionColor();
        }
        return color;
    }

    public final void setSelectionColor(Color color) {
        this._localSettings.setSelectionColor(color);
    }

    public final Color getLineHighlightColor() {
        Color color = this._localSettings.getLineHighlightColor();
        if (KeywordMap.c == 0) {
            if (color != null) {
                return this._localSettings.getLineHighlightColor();
            }
            color = this._defaultSettings.getLineHighlightColor();
        }
        return color;
    }

    public final void setLineHighlightColor(Color color) {
        this._localSettings.setLineHighlightColor(color);
    }

    public final boolean isLineHighlightVisible() {
        boolean bl = this._localSettings.isLineHighlightVisibleSet();
        if (KeywordMap.c == 0) {
            if (bl) {
                return this._localSettings.isLineHighlightVisible();
            }
            bl = this._defaultSettings.isLineHighlightVisible();
        }
        return bl;
    }

    public final void setLineHighlight(boolean bl) {
        this._localSettings.setLineHighlightVisible(bl);
    }

    public final Color getBracketHighlightColor() {
        Color color = this._localSettings.getBracketHighlightColor();
        if (KeywordMap.c == 0) {
            if (color != null) {
                return this._localSettings.getBracketHighlightColor();
            }
            color = this._defaultSettings.getBracketHighlightColor();
        }
        return color;
    }

    public final void setBracketHighlightColor(Color color) {
        this._localSettings.setBracketHighlightColor(color);
    }

    public final boolean isBracketHighlightVisible() {
        boolean bl = this._localSettings.isBracketHighlightVisibleSet();
        if (KeywordMap.c == 0) {
            if (bl) {
                return this._localSettings.isBracketHighlightVisible();
            }
            bl = this._defaultSettings.isBracketHighlightVisible();
        }
        return bl;
    }

    public final void setBracketHighlightVisible(boolean bl) {
        this._localSettings.setBracketHighlightVisible(bl);
    }

    public final boolean isBlockCaret() {
        boolean bl = this._localSettings.isBlockCaretSet();
        if (KeywordMap.c == 0) {
            if (bl) {
                return this._localSettings.isBlockCaret();
            }
            bl = this._defaultSettings.isBlockCaret();
        }
        return bl;
    }

    public final void setBlockCaret(boolean bl) {
        this._localSettings.setBlockCaret(bl);
    }

    public final boolean isCaretBlinks() {
        boolean bl = this._localSettings.isCaretBlinksSet();
        if (KeywordMap.c == 0) {
            if (bl) {
                return this._localSettings.isCaretBlinks();
            }
            bl = this._defaultSettings.isCaretBlinks();
        }
        return bl;
    }

    public void setCaretBlinks(boolean bl) {
        this._localSettings.setCaretBlinks(bl);
    }

    public final Color getSpecialCharactersColor() {
        Color color = this._localSettings.getSpecialCharactersColor();
        if (KeywordMap.c == 0) {
            if (color != null) {
                return this._localSettings.getSpecialCharactersColor();
            }
            color = this._defaultSettings.getSpecialCharactersColor();
        }
        return color;
    }

    public final void setSpecialCharactersColor(Color color) {
        this._localSettings.setSpecialCharactersColor(color);
    }

    public final boolean isSpecialCharactersVisible() {
        boolean bl = this._localSettings.isSpecialCharactersSet();
        if (KeywordMap.c == 0) {
            if (bl) {
                return this._localSettings.isSpecialCharactersVisible();
            }
            bl = this._defaultSettings.isSpecialCharactersVisible();
        }
        return bl;
    }

    public final void setSpecialCharactersVisible(boolean bl) {
        this._localSettings.setSpecialCharactersVisible(bl);
    }

    public boolean isPaintInvalid() {
        boolean bl = this._localSettings.isPaintInvalidSet();
        if (KeywordMap.c == 0) {
            if (bl) {
                return this._localSettings.isPaintInvalid();
            }
            bl = this._defaultSettings.isPaintInvalid();
        }
        return bl;
    }

    public void setPaintInvalid(boolean bl) {
        this._localSettings.setPaintInvalid(bl);
    }

    public boolean isVirtualSpaceAllowed() {
        boolean bl = this._localSettings.isVirtualSpaceAllowedSet();
        if (KeywordMap.c == 0) {
            if (bl) {
                return this._localSettings.isVirtualSpaceAllowed();
            }
            bl = this._defaultSettings.isVirtualSpaceAllowed();
        }
        return bl;
    }

    public void setVirtualSpaceAllowed(boolean bl) {
        this._localSettings.setVirtualSpaceAllowed(bl);
    }

    public MarkerArea getMarkerArea() {
        return this.n;
    }

    public void setMarkerArea(MarkerArea markerArea) {
        this.n = markerArea;
    }

    public void initializeDefaultSettings(DefaultSettings defaultSettings) {
        this.setFont(defaultSettings.getFont());
        this.setDocument(new SyntaxDocument());
        this.getDocument().putProperty("nonwordDelimiters", "_");
        this._settings = defaultSettings;
        this._editable = true;
    }

    public void addCodeInspector(CodeInspector codeInspector) {
        this.p.add(codeInspector);
    }

    public void removeCodeInspector(CodeInspector codeInspector) {
        this.p.remove(codeInspector);
    }

    public CodeInspector[] getCodeInspectors() {
        return this.p.toArray(new CodeInspector[this.p.size()]);
    }

    public int getCodeInspectorCount() {
        return this.p.size();
    }

    public CodeInspector getCodeInspector(int n) {
        return this.p.get(n);
    }

    public boolean isAutoInspecting() {
        return this.q;
    }

    public void setAutoInspecting(boolean bl) {
        block3: {
            CodeEditor codeEditor;
            block4: {
                block5: {
                    boolean bl2;
                    int n;
                    block2: {
                        n = KeywordMap.c;
                        bl2 = this.q;
                        if (n != 0) break block2;
                        if (bl2 == bl) break block3;
                        this.q = bl;
                        codeEditor = this;
                        if (n != 0) break block4;
                        bl2 = codeEditor.isAutoInspecting();
                    }
                    if (!bl2) break block5;
                    this.inspectCode();
                    if (n == 0) break block3;
                }
                codeEditor = this;
            }
            codeEditor.stopInspectCode();
        }
    }

    public void stopInspectCode() {
        block3: {
            Timer timer;
            block4: {
                int n;
                block2: {
                    n = KeywordMap.c;
                    timer = this._inspectionTimer;
                    if (n != 0) break block2;
                    if (timer == null) break block3;
                    timer = this._inspectionTimer;
                }
                if (n != 0) break block4;
                if (!timer.isRunning()) break block3;
                timer = this._inspectionTimer;
            }
            timer.stop();
        }
    }

    public void inspectCode() {
        this.inspectCode(null);
    }

    public void inspectCode(final DocumentEvent documentEvent) {
        block7: {
            Timer timer;
            block5: {
                block6: {
                    int n = KeywordMap.c;
                    timer = this._inspectionTimer;
                    if (n == 0) {
                        if (timer == null) {
                            this._inspectionTimer = new Timer(500, new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    Thread thread = new Thread(){

                                        public void run() {
                                            int n = KeywordMap.c;
                                            CodeEditor codeEditor = CodeEditor.this;
                                            if (n == 0) {
                                                if (codeEditor.n != null) {
                                                    CodeEditor.this.n.setInspecting(true);
                                                }
                                                codeEditor = CodeEditor.this;
                                            }
                                            for (CodeInspector codeInspector : codeEditor.p) {
                                                codeInspector.inspect(CodeEditor.this, documentEvent, CodeEditor.this.getMarkerModel());
                                                if (n == 0) continue;
                                            }
                                            Runnable runnable = new Runnable(){

                                                public void run() {
                                                    block3: {
                                                        MarkerArea markerArea;
                                                        block2: {
                                                            markerArea = CodeEditor.this.n;
                                                            if (KeywordMap.c != 0) break block2;
                                                            if (markerArea == null) break block3;
                                                            CodeEditor.this.n.requireMinimumMode(0);
                                                            markerArea = CodeEditor.this.n;
                                                        }
                                                        markerArea.setInspecting(false);
                                                    }
                                                }
                                            };
                                            SwingUtilities.invokeLater(runnable);
                                        }
                                    };
                                    thread.start();
                                }
                            });
                            this._inspectionTimer.setRepeats(false);
                        }
                        timer = this._inspectionTimer;
                    }
                    if (n != 0) break block5;
                    if (!timer.isRunning()) break block6;
                    this._inspectionTimer.restart();
                    if (n == 0) break block7;
                }
                timer = this._inspectionTimer;
            }
            timer.start();
        }
    }

    public int getLineHeight() {
        return this._painter.getLineHeight();
    }

    @Override
    public final boolean isManagingFocus() {
        return true;
    }

    public final CodeEditorPainter getPainter() {
        return this._painter;
    }

    public final InputHandler getInputHandler() {
        InputHandler inputHandler = this._localSettings.getInputHandler();
        if (KeywordMap.c == 0) {
            if (inputHandler != null) {
                return this._localSettings.getInputHandler();
            }
            inputHandler = this._defaultSettings.getInputHandler();
        }
        return inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this._localSettings.setInputHandler(inputHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCaretVisible() {
        boolean bl;
        int n;
        block2: {
            block3: {
                n = KeywordMap.c;
                bl = this.isCaretBlinks();
                if (n != 0) break block2;
                if (!bl) break block3;
                bl = this.c();
                if (n != 0) break block2;
                if (!bl) return false;
            }
            bl = this._caretVisible;
        }
        if (n != 0) return bl;
        if (!bl) return false;
        return true;
    }

    public void setCaretVisible(boolean bl) {
        this._caretVisible = bl;
        this.b(true);
        this._painter.invalidateSelectedLines();
    }

    public final void blinkCaret() {
        block11: {
            CodeEditor codeEditor;
            block9: {
                block10: {
                    int n;
                    block8: {
                        Timer timer;
                        block7: {
                            n = KeywordMap.c;
                            timer = caretTimer;
                            if (n != 0) break block7;
                            if (timer != null) break block8;
                            caretTimer = new Timer(500, new i_());
                            caretTimer.setInitialDelay(500);
                            timer = caretTimer;
                        }
                        timer.start();
                    }
                    codeEditor = this;
                    if (n != 0) break block9;
                    if (!codeEditor.isCaretBlinks()) break block10;
                    boolean bl = this.r;
                    if (n == 0) {
                        bl = !bl;
                    }
                    this.b(bl);
                    this._painter.invalidateSelectedLines();
                    this._painter.invalidateLine(this.getCaretModel().getViewPosition().line);
                    if (n == 0) break block11;
                }
                codeEditor = this;
            }
            codeEditor.b(true);
        }
    }

    public final int getElectricScroll() {
        int n = this._localSettings.getElectricScroll();
        if (KeywordMap.c == 0) {
            if (n != -1) {
                return this._localSettings.getElectricScroll();
            }
            n = this._defaultSettings.getElectricScroll();
        }
        return n;
    }

    public final void setElectricScroll(int n) {
        this._localSettings.setElectricScroll(n);
    }

    public void updateScrollBars() {
        int n;
        block7: {
            int n2;
            CodeEditor codeEditor;
            block5: {
                block6: {
                    int n3 = KeywordMap.c;
                    codeEditor = this;
                    if (n3 != 0) break block5;
                    if (codeEditor._verticalScrollBar == null) break block6;
                    n2 = this._visibleLines;
                    if (n3 != 0) break block7;
                    if (n2 != 0) {
                        this._verticalScrollBar.setValues(this._firstLine, this._visibleLines, 0, this.getLineCount() + 1);
                        this._verticalScrollBar.setUnitIncrement(2);
                        this._verticalScrollBar.setBlockIncrement(this._visibleLines);
                    }
                }
                codeEditor = this;
            }
            n2 = n = codeEditor._painter.getWidth();
        }
        if (this._horizontalScrollBar != null && n != 0) {
            this._horizontalScrollBar.setValues(-this._horizontalOffset, n, 0, this.getContentSize().width);
            this._horizontalScrollBar.setUnitIncrement(this._painter.getFontMetrics().charWidth('w'));
            this._horizontalScrollBar.setBlockIncrement(n / 2);
        }
    }

    public final int getFirstLine() {
        return this._firstLine;
    }

    public void setFirstLine(int n) {
        block13: {
            int n2;
            block12: {
                int n3 = KeywordMap.c;
                n2 = n;
                if (n3 == 0) {
                    if (n2 == this._firstLine) {
                        return;
                    }
                    n2 = n;
                }
                if (n3 == 0) {
                    if (n2 < 0) {
                        n = 0;
                    }
                    n2 = n + this.getVisibleLines();
                }
                if (n3 == 0) {
                    if (n2 > this.getLineCount()) {
                        int n5 = this.getLineCount() - this.getVisibleLines();
                        n5 = this.b;
                        if (n3 == 0) {
                            n5 = n5 != 0 ? 1 : 0;
                        }
                        n = n4 + n5;
                    }
                    n2 = n;
                }
                if (n3 != 0) break block12;
                if (n2 < 0) {
                    n = 0;
                }
                this._firstLine = n;
                if (n3 != 0) break block13;
                n2 = n;
            }
            if (n2 != this._verticalScrollBar.getValue()) {
                this.updateScrollBars();
            }
            this._painter.repaint();
            this._marginArea.repaint();
        }
    }

    public final int getVisibleLines() {
        return this._visibleLines;
    }

    public final void recalculateVisibleLines() {
        CodeEditor codeEditor;
        block11: {
            block9: {
                int n;
                int n2;
                int n3;
                block10: {
                    int n4;
                    block7: {
                        block8: {
                            n3 = KeywordMap.c;
                            CodeEditorPainter codeEditorPainter = this._painter;
                            if (n3 == 0) {
                                if (codeEditorPainter == null) {
                                    return;
                                }
                                codeEditorPainter = this._painter;
                            }
                            n2 = codeEditorPainter.getHeight();
                            n4 = n = this._painter.getFontMetrics().getHeight();
                            if (n3 != 0) break block7;
                            if (n4 != 0) break block8;
                            this._visibleLines = 0;
                            if (n3 == 0) break block9;
                        }
                        n4 = n2;
                    }
                    if (n4 > 0) break block10;
                    this._visibleLines = 0;
                    this.b = false;
                    if (n3 == 0) break block9;
                }
                this._visibleLines = n2 / n;
                int n5 = n2 % n;
                if (n3 == 0) {
                    n5 = n5 != 0 ? 1 : 0;
                }
                this.b = n5;
                codeEditor = this;
                if (n3 != 0) break block11;
                if (codeEditor.b) {
                    ++this._visibleLines;
                }
            }
            codeEditor = this;
        }
        codeEditor.updateScrollBars();
    }

    public final int getHorizontalOffset() {
        return this._horizontalOffset;
    }

    public void setHorizontalOffset(int n) {
        block6: {
            int n2;
            int n3;
            block5: {
                int n4 = KeywordMap.c;
                n3 = n;
                n2 = this._horizontalOffset;
                if (n4 != 0) break block5;
                if (n3 == n2) {
                    return;
                }
                this._horizontalOffset = n;
                if (n4 != 0) break block6;
                n3 = n;
                n2 = this._horizontalScrollBar.getValue();
            }
            if (n3 != n2) {
                this.updateScrollBars();
            }
            this._painter.repaint();
        }
    }

    public boolean setOrigin(int n, int n2) {
        int n3;
        int n4;
        int n5;
        block8: {
            int n6;
            block7: {
                n5 = KeywordMap.c;
                n4 = 0;
                n3 = n2;
                n6 = this._horizontalOffset;
                if (n5 != 0) break block7;
                if (n3 != n6) {
                    this._horizontalOffset = n2;
                    n4 = 1;
                }
                n3 = n;
                if (n5 != 0) break block8;
                n6 = this._firstLine;
            }
            if (n3 != n6) {
                this._firstLine = n;
                n4 = 1;
            }
            n3 = n4;
        }
        if (n5 == 0) {
            if (n3) {
                this.updateScrollBars();
                this._painter.repaint();
                this._marginArea.repaint();
            }
            n3 = n4;
        }
        return n3;
    }

    public boolean scrollToCaret() {
        return this.scrollTo(this.getCaretModel().getModelPosition());
    }

    public boolean scrollTo(CaretPosition caretPosition) {
        int n;
        block19: {
            int n2;
            int n3;
            block18: {
                int n4;
                int n5;
                int n6;
                block16: {
                    block17: {
                        int n7;
                        block15: {
                            block14: {
                                int n8;
                                CaretPosition caretPosition2;
                                block12: {
                                    block13: {
                                        n6 = KeywordMap.c;
                                        caretPosition2 = this.modelToViewPosition(caretPosition);
                                        int n9 = this._visibleLines;
                                        if (n6 == 0) {
                                            if (n9 == 0) {
                                                this.setFirstLine(Math.max(0, caretPosition2.line - this.getElectricScroll()));
                                                return true;
                                            }
                                            n9 = this._firstLine;
                                        }
                                        n3 = n9;
                                        n2 = this._horizontalOffset;
                                        n7 = caretPosition2.line;
                                        n8 = this._firstLine + this.getElectricScroll();
                                        if (n6 != 0) break block12;
                                        if (n7 >= n8) break block13;
                                        n3 = Math.max(0, caretPosition2.line - this.getElectricScroll());
                                        if (n6 == 0) break block14;
                                    }
                                    n7 = caretPosition2.line + this.getElectricScroll();
                                    if (n6 != 0) break block15;
                                    n8 = this._firstLine + this._visibleLines;
                                }
                                if (n7 < n8) break block14;
                                n3 = caretPosition2.line - this._visibleLines + this.getElectricScroll() + 1;
                                n7 = n3 + this._visibleLines;
                                if (n6 == 0) {
                                    if (n7 >= this.getLineCount()) {
                                        n3 = this.getLineCount() - this._visibleLines + 1;
                                    }
                                    n7 = n3;
                                }
                                if (n6 != 0) break block15;
                                if (n7 < 0) {
                                    n3 = 0;
                                }
                            }
                            n7 = this._offsetToX(caretPosition.line, caretPosition.column);
                        }
                        n5 = n7;
                        n4 = this._painter.getFontMetrics().charWidth('w');
                        n = n5 + n4;
                        if (n6 != 0) break block16;
                        if (n < this._painter.getWidth()) break block17;
                        n2 = this._horizontalOffset + (this._painter.getWidth() - n5) - n4 - 5;
                        if (n6 == 0) break block18;
                    }
                    n = n5;
                }
                if (n6 != 0) break block19;
                if (n < 0) {
                    n2 = Math.min(0, this._horizontalOffset - n5 + n4 + 5);
                }
            }
            n = this.setOrigin(n3, n2) ? 1 : 0;
        }
        return n != 0;
    }

    public int lineToY(int n) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        return (n - this._firstLine) * fontMetrics.getHeight() - (fontMetrics.getLeading() + fontMetrics.getMaxDescent());
    }

    public int yToLine(int n) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        return Math.max(0, Math.min(this.getLineCount() - 1, n / n2 + this._firstLine));
    }

    public final int offsetToX(int n, int n2) {
        this._painter.b = null;
        return this._offsetToX(n, n2);
    }

    public int _offsetToX(int n, int n2) {
        Token token;
        int n3;
        int n4;
        FontMetrics fontMetrics;
        int n5;
        block29: {
            Token token2;
            block28: {
                CodeEditorPainter codeEditorPainter;
                TokenMarker tokenMarker;
                block26: {
                    block27: {
                        int n6;
                        int n7;
                        block24: {
                            block25: {
                                block22: {
                                    block23: {
                                        n5 = KeywordMap.c;
                                        tokenMarker = this.getTokenMarker();
                                        fontMetrics = this._painter.getFontMetrics();
                                        int n8 = this.getLineText(n, this.lineSegment);
                                        if (n5 == 0) {
                                            if (n8 == 0) {
                                                return 0;
                                            }
                                            n8 = this.lineSegment.offset;
                                        }
                                        n4 = n8;
                                        n3 = this._horizontalOffset;
                                        if (n5 != 0) break block22;
                                        if (tokenMarker == null) break block23;
                                        n7 = n;
                                        n6 = this.getLineCount();
                                        if (n5 != 0) break block24;
                                        if (n7 <= n6) break block25;
                                    }
                                    this.lineSegment.count = n2;
                                }
                                try {
                                    return n3 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n3, (TabExpander)this._painter, 0);
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    return n3;
                                }
                            }
                            codeEditorPainter = this._painter;
                            if (n5 != 0) break block26;
                            n7 = codeEditorPainter.a;
                            n6 = n;
                        }
                        if (n7 != n6) break block27;
                        token2 = this._painter.b;
                        if (n5 != 0) break block28;
                        if (token2 == null) break block27;
                        token = this._painter.b;
                        if (n5 == 0) break block29;
                    }
                    this._painter.a = n;
                    codeEditorPainter = this._painter;
                }
                token2 = codeEditorPainter.b = tokenMarker.markTokens(this.lineSegment, n);
            }
            token = token2;
        }
        Font font = this._painter.getFont();
        SyntaxStyleSchema syntaxStyleSchema = this.getStyles();
        while (true) {
            block33: {
                byte by;
                block32: {
                    CodeEditorPainter codeEditorPainter;
                    block31: {
                        block30: {
                            int n9;
                            if ((by = token.id) == 127) {
                                n9 = n3;
                                if (n5 == 0) {
                                    return n9;
                                }
                            } else {
                                n9 = by;
                            }
                            if (n9 == 0) break block30;
                            codeEditorPainter = this._painter;
                            if (n5 != 0) break block31;
                            if (codeEditorPainter.getGraphics() != null) break block32;
                        }
                        codeEditorPainter = this._painter;
                    }
                    fontMetrics = codeEditorPainter.getFontMetrics();
                    if (n5 == 0) break block33;
                }
                fontMetrics = syntaxStyleSchema.getStyle(by).getFontMetrics(font, this._painter.getGraphics());
            }
            int n10 = token.length;
            int n11 = n2 + n4;
            int n12 = this.lineSegment.offset + n10;
            if (n5 == 0) {
                if (n11 < n12) {
                    this.lineSegment.count = n2 - (this.lineSegment.offset - n4);
                    return n3 + Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n3, (TabExpander)this._painter, 0);
                }
                this.lineSegment.count = n10;
                n11 = n3;
                n12 = Utilities.getTabbedTextWidth(this.lineSegment, fontMetrics, n3, (TabExpander)this._painter, 0);
            }
            n3 = n11 + n12;
            this.lineSegment.offset += n10;
            token = token.next;
        }
    }

    public int xToColumn(int n) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        return (n - this.getHorizontalOffset()) / fontMetrics.charWidth('w');
    }

    public int xToColumn(int n, int n2) {
        int n3;
        int n4 = this.xToOffset(n, n2);
        int n5 = n3 = this.offsetToX(n, n4);
        if (KeywordMap.c == 0) {
            if (n5 < n2) {
                FontMetrics fontMetrics = this._painter.getFontMetrics();
                n4 += (n2 - n3) / fontMetrics.charWidth(' ');
            }
            n5 = n4;
        }
        return n5;
    }

    public int columnToX(int n) {
        FontMetrics fontMetrics = this._painter.getFontMetrics();
        return n * fontMetrics.charWidth('w') + this.getHorizontalOffset();
    }

    public int columnToX(int n, int n2) {
        int n3 = KeywordMap.c;
        int n4 = this.getLineLength(n) - 1;
        int n5 = n2;
        if (n3 == 0) {
            n5 = n5 > n4 ? n4 : n2;
        }
        int n6 = this.offsetToX(n, n5);
        int n7 = n2;
        if (n3 == 0) {
            if (n7 > n4) {
                FontMetrics fontMetrics = this._painter.getFontMetrics();
                n6 += (n2 - n4) * fontMetrics.charWidth(' ');
            }
            n7 = n6;
        }
        return n7;
    }

    /*
     * Unable to fully structure code
     */
    public int xToOffset(int var1_1, int var2_2) {
        block48: {
            block47: {
                block45: {
                    block46: {
                        block37: {
                            block35: {
                                var20_3 = KeywordMap.c;
                                var2_2 -= this.getHorizontalOffset();
                                var3_4 = this._painter.getFontMetrics();
                                var4_5 = this.getTokenMarker();
                                v0 = this;
                                if (var20_3 == 0) {
                                    if (!v0.getLineText(var1_1, this.lineSegment)) {
                                        return 0;
                                    }
                                    v0 = this;
                                }
                                var5_6 = v0.lineSegment.array;
                                var6_7 = this.lineSegment.offset;
                                var7_8 = this.lineSegment.count;
                                var8_9 = 0;
                                var9_10 = this.isBlockCaret();
                                if (var4_5 != null) break block37;
                                for (var10_11 = 0; var10_11 < var7_8; ++var10_11) {
                                    block43: {
                                        block44: {
                                            block41: {
                                                block42: {
                                                    block40: {
                                                        block38: {
                                                            block39: {
                                                                v1 = var11_13 = var5_6[var10_11 + var6_7];
                                                                if (var20_3 != 0) break block38;
                                                                v2 = 9;
                                                                if (var20_3 != 0) break block35;
                                                                if (v1 != v2) break block39;
                                                                var12_15 = (int)this._painter.nextTabStop(var8_9, var10_11) - var8_9;
                                                                if (var20_3 == 0) break block40;
                                                            }
                                                            v1 = var3_4.charWidth((char)var11_13);
                                                        }
                                                        var12_15 = v1;
                                                    }
                                                    v3 = var9_10;
                                                    if (var20_3 != 0) break block41;
                                                    if (v3 == 0) break block42;
                                                    v3 = var2_2 - var12_15;
                                                    v4 = var8_9;
                                                    if (var20_3 != 0) break block43;
                                                    if (v3 <= v4) {
                                                        return var10_11;
                                                    }
                                                    break block44;
                                                }
                                                v3 = var2_2 - var12_15 / 2;
                                            }
                                            v4 = var8_9;
                                            if (var20_3 == 0) {
                                                if (v3 <= v4) {
                                                    return var10_11;
                                                } else {
                                                    ** GOTO lbl46
                                                }
                                            }
                                            break block43;
                                        }
                                        v3 = var8_9;
                                        v4 = var12_15;
                                    }
                                    var8_9 = v3 + v4;
                                    if (var20_3 == 0) continue;
                                }
                                v5 = var7_8;
                                v2 = 1;
                            }
                            return v5 - v2;
                        }
                        v6 = this._painter;
                        if (var20_3 != 0) break block45;
                        if (v6.a != var1_1) break block46;
                        v7 = this._painter.b;
                        if (var20_3 != 0) break block47;
                        if (v7 == null) break block46;
                        var10_12 = this._painter.b;
                        if (var20_3 == 0) break block48;
                    }
                    this._painter.a = var1_1;
                    v6 = this._painter;
                }
                v7 = v6.b = var4_5.markTokens(this.lineSegment, var1_1);
            }
            var10_12 = v7;
        }
        var11_14 = 0;
        var12_16 = this._painter.getFont();
        var13_17 = this.getStyles();
        while (true) {
            block36: {
                block52: {
                    block51: {
                        block50: {
                            block49: {
                                if ((var14_18 = var10_12.id) == 127) {
                                    v8 = var11_14 - 1;
                                    if (var20_3 == 0) {
                                        return v8;
                                    }
                                } else {
                                    v8 = var14_18;
                                }
                                if (v8 == 0) break block49;
                                v9 = this._painter;
                                if (var20_3 != 0) break block50;
                                if (v9.getGraphics() != null) break block51;
                            }
                            v9 = this._painter;
                        }
                        var3_4 = v9.getFontMetrics();
                        if (var20_3 == 0) break block52;
                    }
                    var3_4 = var13_17.getStyle(var14_18).getFontMetrics(var12_16, this._painter.getGraphics());
                }
                var15_19 = var10_12.length;
                for (var16_20 = 0; var16_20 < var15_19; ++var16_20) {
                    block58: {
                        block59: {
                            block56: {
                                block57: {
                                    block55: {
                                        block53: {
                                            block54: {
                                                v10 = var17_21 = var6_7 + var11_14 + var16_20;
                                                if (var20_3 == 0) {
                                                    v11 = var5_6.length;
                                                    if (var20_3 != 0) break block36;
                                                    if (v10 >= v11) continue;
                                                    v10 = var5_6[var17_21];
                                                }
                                                v12 = var18_22 = v10;
                                                if (var20_3 != 0) break block53;
                                                if (v12 != 9) break block54;
                                                var19_23 = (int)this._painter.nextTabStop(var8_9, var11_14 + var16_20) - var8_9;
                                                if (var20_3 == 0) break block55;
                                            }
                                            v12 = var3_4.charWidth((char)var18_22);
                                        }
                                        var19_23 = v12;
                                    }
                                    v13 = var9_10;
                                    if (var20_3 != 0) break block56;
                                    if (v13 == 0) break block57;
                                    v13 = var2_2 - var19_23;
                                    v14 = var8_9;
                                    if (var20_3 != 0) break block58;
                                    if (v13 <= v14) {
                                        return var11_14 + var16_20;
                                    }
                                    break block59;
                                }
                                v13 = var2_2 - var19_23 * 7 / 8;
                            }
                            v14 = var8_9;
                            if (var20_3 == 0) {
                                if (v13 <= v14) {
                                    return var11_14 + var16_20;
                                } else {
                                    ** GOTO lbl130
                                }
                            }
                            break block58;
                        }
                        v13 = var8_9;
                        v14 = var19_23;
                    }
                    var8_9 = v13 + v14;
                    if (var20_3 == 0) continue;
                }
                v15 = var11_14;
                v11 = var15_19;
            }
            var11_14 = v15 + v11;
            var10_12 = var10_12.next;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int xyToOffset(int var1_1, int var2_2) {
        var3_3 = this.yToLine(var2_2);
        v0 = this;
        if (KeywordMap.c != 0) ** GOTO lbl8
        if (v0.isVirtualSpaceAllowed()) {
            v1 = this.xToColumn(var3_3, var1_1);
        } else {
            v0 = this;
lbl8:
            // 2 sources

            v1 = v0.xToOffset(var3_3, var1_1);
        }
        var4_4 = v1;
        return this.modelPositionToOffset(this.viewToModelPosition(new CaretPosition(var3_3, var4_4)));
    }

    public final SyntaxDocument getDocument() {
        return this._document;
    }

    public void setDocument(SyntaxDocument syntaxDocument) {
        int n = KeywordMap.c;
        SyntaxDocument syntaxDocument2 = this._document;
        if (n == 0) {
            if (syntaxDocument2 == syntaxDocument) {
                return;
            }
            syntaxDocument2 = this._document;
        }
        if (n == 0) {
            if (syntaxDocument2 != null) {
                this._document.removeDocumentListener(this._documentHandler);
                this._document.removeUndoableEditListener(this._undoableEditListener);
                this._document.removeDocumentListener((DefaultFoldingModel)this.getFoldingModel());
            }
            syntaxDocument2 = this._document;
        }
        SyntaxDocument syntaxDocument3 = syntaxDocument2;
        this._document = syntaxDocument;
        CodeEditor codeEditor = this;
        if (n == 0) {
            if (codeEditor._document != null) {
                this._document.addDocumentListener(this._documentHandler);
                this._document.addDocumentListener((DefaultFoldingModel)this.getFoldingModel());
                this._document.addUndoableEditListener(this._undoableEditListener);
            }
            this.select(0, 0);
            codeEditor = this;
        }
        if (n == 0) {
            if (codeEditor.i != null) {
                this.i.reset();
            }
            this.updateScrollBars();
            this._painter.repaint();
            codeEditor = this;
        }
        codeEditor.firePropertyChange("document", syntaxDocument3, this._document);
    }

    public final TokenMarker getTokenMarker() {
        return this._document.getTokenMarker();
    }

    public final void setTokenMarker(TokenMarker tokenMarker) {
        this._document.setTokenMarker(tokenMarker);
    }

    public final int getDocumentLength() {
        SyntaxDocument syntaxDocument = this._document;
        if (KeywordMap.c == 0) {
            if (syntaxDocument == null) {
                return 0;
            }
            syntaxDocument = this._document;
        }
        return syntaxDocument.getLength();
    }

    public final int getLineCount() {
        SyntaxDocument syntaxDocument = this._document;
        if (KeywordMap.c == 0) {
            if (syntaxDocument == null) {
                return 0;
            }
            syntaxDocument = this._document;
        }
        return syntaxDocument.getDefaultRootElement().getElementCount();
    }

    public int getVisualLineCount() {
        int n = this.getLineCount();
        return n -= ((DefaultFoldingModel)this.getFoldingModel()).getFoldedLinesCountBefore(this.getDocument().getLength() + 1);
    }

    public final int getLineNumber(int n) {
        return this._document.getLineNumber(n);
    }

    public int getLineStartOffset(int n) {
        Element element;
        int n2;
        block6: {
            int n3;
            int n4;
            block5: {
                n2 = KeywordMap.c;
                n4 = n;
                n3 = this.getLineCount();
                if (n2 != 0) break block5;
                if (n4 < n3) break block6;
                n4 = this.getLineCount();
                n3 = 1;
            }
            n = n4 - n3;
        }
        Element element2 = element = this._document.getDefaultRootElement().getElement(n);
        if (n2 == 0) {
            if (element2 == null) {
                return -1;
            }
            element2 = element;
        }
        return element2.getStartOffset();
    }

    public int getLineStartOffsetNoSpace(int n) {
        int n2;
        block8: {
            Element element;
            int n3 = KeywordMap.c;
            Element element2 = element = this._document.getDefaultRootElement().getElement(n);
            if (n3 == 0) {
                if (element2 == null) {
                    return -1;
                }
                element2 = element;
            }
            int n4 = element2.getStartOffset();
            while (n4 < this._document.getLength()) {
                try {
                    block10: {
                        block9: {
                            char c2 = this._document.getText(n4, 1).charAt(0);
                            if (n3 != 0) break block9;
                            n2 = Character.isSpaceChar(c2) ? 1 : 0;
                            if (n3 != 0) break block8;
                            if (n2 == 0) break block10;
                            ++n4;
                        }
                        if (n3 == 0) continue;
                    }
                    if (n3 == 0) break;
                }
                catch (BadLocationException badLocationException) {
                    a.warning(badLocationException.getLocalizedMessage());
                    if (n3 == 0) continue;
                }
            }
            n2 = n4;
        }
        return n2;
    }

    public int getLineEndOffset(int n) {
        Element element;
        int n2;
        block6: {
            int n3;
            int n4;
            block5: {
                n2 = KeywordMap.c;
                n4 = n;
                n3 = this.getLineCount();
                if (n2 != 0) break block5;
                if (n4 < n3) break block6;
                n4 = this.getLineCount();
                n3 = 1;
            }
            n = n4 - n3;
        }
        Element element2 = element = this._document.getDefaultRootElement().getElement(n);
        if (n2 == 0) {
            if (element2 == null) {
                return -1;
            }
            element2 = element;
        }
        return element2.getEndOffset() - 1;
    }

    public int getLineLength(int n) {
        Element element;
        Element element2 = element = this._document.getDefaultRootElement().getElement(n);
        if (KeywordMap.c == 0) {
            if (element2 == null) {
                return 0;
            }
            element2 = element;
        }
        return element2.getEndOffset() - element.getStartOffset();
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        this.exportText(this.getRawText(), stringBuffer);
        return stringBuffer.toString();
    }

    public void setText(String string) {
        block3: {
            block7: {
                int n;
                int n2;
                StringBuffer stringBuffer;
                int n3;
                block6: {
                    int n4;
                    block4: {
                        block5: {
                            block2: {
                                n3 = KeywordMap.c;
                                if (string != null) break block2;
                                this.setRawText("");
                                this.setLineBreakStyle(-2);
                                if (n3 == 0) break block3;
                            }
                            stringBuffer = new StringBuffer();
                            n2 = this.importText(string.substring(0, Math.min(1000, string.length())), stringBuffer);
                            n = string.length();
                            n4 = 1000;
                            if (n3 != 0) break block4;
                            if (n >= n4) break block5;
                            this.setLineBreakStyle(n2);
                            this.setRawText(stringBuffer.toString());
                            if (n3 == 0) break block3;
                        }
                        n = n2;
                        if (n3 != 0) break block6;
                        n4 = this.getLineBreakStyle();
                    }
                    if (n == n4) break block7;
                    stringBuffer = new StringBuffer();
                    n = this.importText(string, stringBuffer);
                }
                n2 = n;
                this.setLineBreakStyle(n2);
                this.setRawText(stringBuffer.toString());
                if (n3 == 0) break block3;
            }
            this.setRawText(string);
        }
    }

    public void append(String string) {
        SyntaxDocument syntaxDocument = this.getDocument();
        if (syntaxDocument != null) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                int n = this.importText(string, stringBuffer);
                if (KeywordMap.c == 0) {
                    if (n != -2 && n != this.getLineBreakStyle()) {
                        this.setLineBreakStyle(-1);
                    }
                    syntaxDocument.insertString(syntaxDocument.getLength(), stringBuffer.toString(), null);
                }
            }
            catch (BadLocationException badLocationException) {
                a.warning(badLocationException.getLocalizedMessage());
            }
        }
    }

    public final String getText(int n, int n2) {
        try {
            return this._document.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            a.warning(badLocationException.getLocalizedMessage());
            return null;
        }
    }

    public final void getText(int n, int n2, Segment segment) {
        try {
            if (n2 > 0) {
                this._document.getText(n, n2, segment);
            }
        }
        catch (BadLocationException badLocationException) {
            a.warning(badLocationException.getLocalizedMessage());
            segment.count = 0;
            segment.offset = 0;
        }
    }

    protected int exportText(String string, StringBuffer stringBuffer) {
        int n = this.getLineBreakStyle();
        String string2 = TextUtils.getLineBreak(n);
        return SyntaxDocument.convertLineBreaks(string, stringBuffer, string2);
    }

    protected int importText(String string, StringBuffer stringBuffer) {
        return SyntaxDocument.convertLineBreaks(string, stringBuffer);
    }

    public String getRawText() {
        try {
            return this._document.getText(0, this._document.getLength());
        }
        catch (BadLocationException badLocationException) {
            a.warning(badLocationException.getLocalizedMessage());
            return null;
        }
    }

    public void setRawText(String string) {
        try {
            this._document.remove(0, this._document.getLength());
            this._document.insertString(0, string, null);
            this.setTokenMarker(this._document.getTokenMarker());
            this.select(0);
            this.discardAllEdits();
        }
        catch (BadLocationException badLocationException) {
            a.warning(badLocationException.getLocalizedMessage());
        }
    }

    public final String getLineText(int n) {
        int n2 = this.getLineStartOffset(n);
        if (n2 != -1) {
            return this.getText(n2, this.getLineEndOffset(n) - n2);
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getLineText(int n, Segment segment) {
        int n2;
        int n3 = KeywordMap.c;
        int n4 = n;
        if (n3 != 0) return n4 != 0;
        if (n4 < 0) return 0 != 0;
        n4 = n;
        if (n3 != 0) return n4 != 0;
        if (n4 >= this.getLineCount()) return 0 != 0;
        n4 = n2 = this.getLineStartOffset(n);
        if (n3 != 0) return n4 != 0;
        if (n4 == -1) return 0 != 0;
        this.getText(n2, this.getLineEndOffset(n) - n2 + 1, segment);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLineText(int n, String string) {
        int n2;
        int n3;
        block14: {
            block15: {
                block13: {
                    block12: {
                        n3 = KeywordMap.c;
                        n2 = this.isEditable();
                        if (n3 != 0) break block12;
                        if (n2 == 0) break block13;
                        n2 = this.isEnabled();
                    }
                    if (n3 != 0) break block14;
                    if (n2 != 0) break block15;
                }
                PortingUtils.notifyUser();
                return;
            }
            this._document.beginCompoundEdit();
            n2 = this.getLineStartOffset(n);
        }
        int n4 = n2;
        int n5 = this.getLineEndOffset(n);
        try {
            this._document.remove(n4, n5 - n4);
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = this.importText(string, stringBuffer);
            if (n3 == 0) {
                if (n6 != -2 && n6 != this.getLineBreakStyle()) {
                    this.setLineBreakStyle(-1);
                }
                this._document.insertString(n4, stringBuffer.toString(), null);
            }
        }
        catch (BadLocationException badLocationException) {
            a.warning(badLocationException.getLocalizedMessage());
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int getSelectionStart() {
        int n;
        SelectionModel selectionModel = this.getSelectionModel();
        if (KeywordMap.c == 0) {
            if (selectionModel.getSelectionStart() < this.getSelectionModel().getSelectionEnd()) {
                n = this.getSelectionModel().getSelectionStart();
                return n;
            }
            selectionModel = this.getSelectionModel();
        }
        n = selectionModel.getSelectionEnd();
        return n;
    }

    public int getSelectionStart(int n) {
        int n2 = KeywordMap.c;
        int n3 = n;
        if (n2 == 0) {
            if (n3 == this.getSelectionStartLine()) {
                return this.getSelectionStart();
            }
            n3 = this.getSelectionModel().isColumnSelectionMode() ? 1 : 0;
        }
        if (n2 == 0) {
            if (n3 != 0) {
                Element element = this._document.getDefaultRootElement();
                int n4 = this.getSelectionStart() - element.getElement(this.getSelectionStartLine()).getStartOffset();
                Element element2 = element.getElement(n);
                int n5 = element2.getStartOffset();
                int n6 = element2.getEndOffset() - 1;
                return Math.min(n6, n5 + n4);
            }
            n3 = this.getLineStartOffset(n);
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int getSelectionStartLine() {
        int n;
        SelectionModel selectionModel = this.getSelectionModel();
        if (KeywordMap.c == 0) {
            if (selectionModel.getSelectionStartLine() <= this.getSelectionModel().getSelectionEndLine()) {
                n = this.getSelectionModel().getSelectionStartLine();
                return n;
            }
            selectionModel = this.getSelectionModel();
        }
        n = selectionModel.getSelectionEndLine();
        return n;
    }

    public final void setSelectionStart(int n) {
        this.select(n, this.getSelectionEnd());
    }

    public final void surroundSelection(String string, String string2) {
        block4: {
            block3: {
                int n;
                block2: {
                    n = KeywordMap.c;
                    String string3 = this.getSelectedText();
                    if (n != 0) break block2;
                    if (string3 == null) break block3;
                    this.setSelectedText(string + string3 + string2);
                }
                if (n == 0) break block4;
            }
            this.setSelectedText(string + string2);
        }
    }

    public void selectWord() {
        block8: {
            int n;
            String string;
            String string2;
            int n2;
            int n3;
            block7: {
                int n4 = KeywordMap.c;
                int n5 = this.getCaretModel().getModelPosition().line;
                n3 = this.getLineStartOffset(n5);
                n2 = this.getCaretModel().getOffset() - n3;
                CodeEditor codeEditor = this;
                int n6 = n5;
                if (n4 == 0) {
                    if (codeEditor.getLineLength(n6) == 0) {
                        return;
                    }
                    codeEditor = this;
                    n6 = n5;
                }
                string2 = codeEditor.getLineText(n6);
                string = (String)this.getDocument().getProperty("nonwordDelimiters");
                n = n2--;
                if (n4 == 0) {
                    if (n == this.getLineLength(n5)) {
                        // empty if block
                    }
                    n = string2.length();
                }
                if (n4 != 0) break block7;
                if (n <= 0) break block8;
                n = TextUtils.findWordStart(string2, n2, string);
            }
            int n7 = n;
            int n8 = TextUtils.findWordEnd(string2, n2 + 1, string);
            this.getSelectionModel().setSelection(n3 + n7, n3 + n8);
        }
    }

    public void selectWord(String string) {
        int[] nArray = this.getCurrentWordBounds(string);
        this.select(nArray[0], nArray[1]);
    }

    public int[] getCurrentWordBounds() {
        return this.getCurrentWordBounds((String)this.getDocument().getProperty("nonwordDelimiters"));
    }

    public String getLeftWordPart() {
        return this.getLeftWordPart((String)this.getDocument().getProperty("nonwordDelimiters"));
    }

    public String getLeftWordPart(String string) {
        String string2;
        int n;
        int n2;
        block3: {
            int n3;
            block2: {
                n2 = this.getCaretModel().getOffset();
                int n4 = this.getCaretModel().getModelPosition().line;
                int n5 = this.getLineStartOffset(n4);
                n = 0;
                string2 = this.getLineText(this.getCaretModel().getModelPosition().line);
                n3 = n2 -= n5;
                if (KeywordMap.c != 0) break block2;
                if (n3 <= 0) break block3;
                n3 = TextUtils.findWordStart(string2, n2, string);
            }
            n = n3;
        }
        return string2.substring(n, n2);
    }

    public int[] getCurrentWordBounds(String string) {
        int n;
        String string2;
        int n2;
        int n3;
        int n4;
        int n5;
        block9: {
            block8: {
                block6: {
                    block7: {
                        n5 = KeywordMap.c;
                        n4 = this.getCaretModel().getOffset();
                        int n6 = this.getCaretModel().getModelPosition().line;
                        n3 = this.getLineStartOffset(n6);
                        n2 = 0;
                        string2 = this.getLineText(this.getCaretModel().getModelPosition().line);
                        n = n4 -= n3;
                        if (n5 != 0) break block6;
                        if (n != 0) break block7;
                        n2 = n3;
                        if (n5 == 0) break block8;
                    }
                    n = n4;
                }
                if (n5 != 0) break block9;
                if (n > 0) {
                    n2 = n3 + TextUtils.findWordStart(string2, n4, string);
                }
            }
            n = n4;
        }
        int n7 = string2.length();
        if (n5 == 0) {
            if (n < n7) {
                n4 = TextUtils.findWordEnd(string2, n4, string);
            }
            n = n4;
            n7 = n3;
        }
        n4 = n + n7;
        return new int[]{n2, n4};
    }

    public String getCurrentWord() {
        int[] nArray = this.getCurrentWordBounds();
        return this.getText(nArray[0], nArray[1] - nArray[0]);
    }

    public String getCurrentWord(String string) {
        int[] nArray = this.getCurrentWordBounds(string);
        return this.getText(nArray[0], nArray[1] - nArray[0]);
    }

    public void selectToMatchingBracket() {
        block8: {
            block5: {
                int n;
                int n2;
                int n3;
                block7: {
                    int n4;
                    int n5;
                    block6: {
                        block4: {
                            n3 = KeywordMap.c;
                            n2 = this.getCaretModel().getOffset();
                            n = -1;
                            try {
                                n = TextUtils.findMatchingBracket(this._document, n2 - 1);
                            }
                            catch (BadLocationException badLocationException) {
                                a.warning(badLocationException.getLocalizedMessage());
                            }
                            n5 = n;
                            n4 = -1;
                            if (n3 != 0) break block4;
                            if (n5 == n4) break block5;
                            n5 = n;
                            n4 = n2;
                        }
                        if (n3 != 0) break block6;
                        if (n5 == n4) break block5;
                        n5 = n;
                        n4 = n2;
                    }
                    if (n5 <= n4) break block7;
                    this.select(n2 - 1, n + 1);
                    if (n3 == 0) break block8;
                }
                this.select(n, n2);
                if (n3 == 0) break block8;
            }
            this.selectBlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void selectBlock() {
        var12_1 = KeywordMap.c;
        var1_2 = this.getRawText();
        var2_3 = var1_2.length();
        var3_4 = "<({[";
        var4_5 = ">)}]";
        var5_6 = this.getSelectionStart();
        var6_7 = this.getSelectionEnd();
        var7_8 = 1;
        var8_9 = 0;
        var9_10 = 0;
        v0 = var5_6;
        if (var12_1 != 0) ** GOTO lbl18
        if (v0 == 0) {
            PortingUtils.notifyUser();
            return;
        }
        do {
            v0 = --var5_6;
lbl18:
            // 2 sources

            if (v0 <= 0) break;
            var10_11 = var1_2.charAt(var5_6);
            v1 = var11_12 = var3_4.indexOf(var10_11);
            v2 = -1;
            if (var12_1 != 0) ** GOTO lbl46
            if (var12_1 == 0) {
                if (v1 != v2) {
                    v3 = --var7_8;
                    if (var12_1 == 0) {
                        if (v3 != 0) continue;
                        var8_9 = var10_11;
                        v3 = var9_10 = (int)var4_5.charAt(var11_12);
                    }
                    if (var12_1 == 0) break;
                }
                v4 = var4_5.indexOf(var10_11);
                v5 = -1;
            }
            if (v4 == v5) continue;
            ++var7_8;
        } while (var12_1 == 0);
        var7_8 = 1;
        v6 = var8_9;
        if (var12_1 != 0) ** GOTO lbl44
        if (v6 == 0) {
            PortingUtils.notifyUser();
            return;
        }
        block1: while (true) {
            block10: {
                block9: {
                    v6 = var1_2.charAt(var6_7);
lbl44:
                    // 2 sources

                    v1 = var10_11 = v6;
                    v2 = var9_10;
lbl46:
                    // 2 sources

                    if (v1 != v2) break block9;
                    v7 = --var7_8;
                    if (var12_1 != 0) ** GOTO lbl61
                    if (v7 != 0) break block10;
                    ++var6_7;
                    if (var12_1 == 0) ** GOTO lbl63
                }
                v7 = var10_11;
                v8 = var8_9;
                if (var12_1 != 0) ** GOTO lbl62
                if (v7 == v8) {
                    ++var7_8;
                }
            }
            do {
                v7 = ++var6_7;
lbl61:
                // 2 sources

                v8 = var2_3;
lbl62:
                // 2 sources

                if (v7 < v8) continue block1;
lbl63:
                // 2 sources

                this.select(var5_6, var6_7);
            } while (var12_1 != 0);
            break;
        }
    }

    public void gotoEndOfLine() {
        this.select(this.getLineEndOffset(this.getCaretModel().getModelPosition().line));
    }

    public void commentLine(int n) {
        block4: {
            block2: {
                int n2;
                block3: {
                    int n3 = KeywordMap.c;
                    String string = this.getLineText(n);
                    n2 = this.getLineStartOffset(n);
                    if (n3 != 0) break block2;
                    if (!string.startsWith("//")) break block3;
                    this.select(n2, n2 + 2);
                    this.setSelectedText("");
                    if (n3 == 0) break block4;
                }
                this.select(n2);
            }
            this.setSelectedText("//");
        }
    }

    public void commentLine() {
        block5: {
            int n;
            int n2;
            int n3;
            block3: {
                int n4;
                int n5;
                block4: {
                    n3 = KeywordMap.c;
                    n5 = this.getLineNumber(this.getSelectionStart());
                    n2 = this.getLineNumber(this.getSelectionEnd());
                    n4 = n5;
                    if (n3 != 0) break block3;
                    if (n4 != n2) break block4;
                    this.commentLine(this.getCaretModel().getModelPosition().line);
                    if (n3 == 0) break block5;
                }
                n4 = n = n5;
            }
            while (n <= n2) {
                this.commentLine(n);
                ++n;
                if (n3 == 0) continue;
            }
        }
    }

    public void indentSelectedLines() {
        this.indentLinesBetween(this.getSelectionStartLine(), this.getSelectionEndLine());
    }

    public void indentLinesBetween(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this.indentLine(i);
            if (KeywordMap.c == 0) continue;
        }
    }

    public void indentLine(int n) {
        block4: {
            String string;
            block5: {
                String string2;
                block17: {
                    String string3;
                    block10: {
                        int n2;
                        block15: {
                            String string4;
                            int n3;
                            block16: {
                                block13: {
                                    block14: {
                                        block11: {
                                            block12: {
                                                block6: {
                                                    block7: {
                                                        block8: {
                                                            String string5;
                                                            block9: {
                                                                n3 = KeywordMap.c;
                                                                string = this.getLineText(n).trim();
                                                                if (n3 != 0) break block4;
                                                                if (n == 0) break block5;
                                                                string4 = this.getLineText(n - 1);
                                                                string3 = TextUtils.getLeadingWhitespace(string4);
                                                                n2 = string.startsWith("}");
                                                                if (n3 != 0) break block6;
                                                                if (n2 != 0) break block7;
                                                                string5 = string4;
                                                                if (n3 != 0) break block8;
                                                                if (string5.endsWith("{")) break block9;
                                                                n2 = string4.endsWith(":") ? 1 : 0;
                                                                if (n3 != 0) break block6;
                                                                if (n2 == 0) break block7;
                                                            }
                                                            string5 = string3 = string3 + '\t';
                                                        }
                                                        if (n3 == 0) break block10;
                                                    }
                                                    n2 = string.indexOf(125);
                                                }
                                                if (n3 != 0) break block11;
                                                if (n2 == -1) break block12;
                                                n2 = string3.length();
                                                if (n3 != 0) break block11;
                                                if (n2 < 1) break block12;
                                                string3 = string3.substring(0, string3.length() - 1);
                                                if (n3 == 0) break block10;
                                            }
                                            n2 = string4.endsWith("/**") ? 1 : 0;
                                        }
                                        if (n3 != 0) break block13;
                                        if (n2 != 0) break block14;
                                        n2 = string4.endsWith("/*") ? 1 : 0;
                                        if (n3 != 0) break block15;
                                        if (n2 == 0) break block16;
                                    }
                                    n2 = string.startsWith("*") ? 1 : 0;
                                }
                                if (n3 != 0) break block15;
                                if (n2 == 0) break block16;
                                string3 = string3 + " ";
                                if (n3 == 0) break block10;
                            }
                            string2 = string4;
                            if (n3 != 0) break block17;
                            n2 = string2.endsWith("*/") ? 1 : 0;
                        }
                        if (n2 != 0) {
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                    }
                    string2 = string3 + string;
                }
                string = string2;
            }
            this.selectLine(n);
            this.setSelectedText(string);
        }
    }

    public void selectLine(int n) {
        int n2 = this.getLineStartOffset(n);
        int n3 = this.getLineEndOffset(n) + 1;
        if (KeywordMap.c == 0) {
            if (n3 >= this.getDocumentLength()) {
                --n3;
            }
            this.select(n2, n3);
            this.getCaretModel().setOffset(n2);
        }
    }

    public void selectLines(int n, int n2) {
        int n3 = this.getLineEndOffset(n2);
        this.select(this.getLineStartOffset(n), n3);
        this.getCaretModel().setOffset(n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int getSelectionEnd() {
        int n;
        SelectionModel selectionModel = this.getSelectionModel();
        if (KeywordMap.c == 0) {
            if (selectionModel.getSelectionEnd() > this.getSelectionModel().getSelectionStart()) {
                n = this.getSelectionModel().getSelectionEnd();
                return n;
            }
            selectionModel = this.getSelectionModel();
        }
        n = selectionModel.getSelectionStart();
        return n;
    }

    public int getSelectionEnd(int n) {
        int n2 = KeywordMap.c;
        int n3 = n;
        if (n2 == 0) {
            if (n3 == this.getSelectionEndLine()) {
                return this.getSelectionEnd();
            }
            n3 = this.getSelectionModel().isColumnSelectionMode() ? 1 : 0;
        }
        if (n2 == 0) {
            if (n3 != 0) {
                Element element = this._document.getDefaultRootElement();
                int n4 = this.getSelectionEnd() - element.getElement(this.getSelectionEndLine()).getStartOffset();
                Element element2 = element.getElement(n);
                int n5 = element2.getStartOffset();
                int n6 = element2.getEndOffset() - 1;
                return Math.min(n6, n5 + n4);
            }
            n3 = this.getLineEndOffset(n);
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int getSelectionEndLine() {
        int n;
        SelectionModel selectionModel = this.getSelectionModel();
        if (KeywordMap.c == 0) {
            if (selectionModel.getSelectionStartLine() <= this.getSelectionModel().getSelectionEndLine()) {
                n = this.getSelectionModel().getSelectionEndLine();
                return n;
            }
            selectionModel = this.getSelectionModel();
        }
        n = selectionModel.getSelectionStartLine();
        return n;
    }

    public final void setSelectionEnd(int n) {
        this.getSelectionModel().setSelection(this.getSelectionStart(), n);
        this.select(this.getSelectionStart(), n);
    }

    public int getLeadSelectionOffset() {
        int n = KeywordMap.c;
        int n2 = this.getCaretModel().getOffset();
        int n3 = this.getSelectionModel().hasSelection();
        if (n == 0) {
            if (n3 == 0) {
                return n2;
            }
            n3 = n2;
        }
        if (n == 0) {
            if (n3 == this.getSelectionModel().getSelectionEnd()) {
                return this.getSelectionModel().getSelectionStart();
            }
            n3 = this.getSelectionModel().getSelectionEnd();
        }
        return n3;
    }

    public int getAnchorSelectionOffset() {
        int n = KeywordMap.c;
        int n2 = this.getCaretModel().getOffset();
        int n3 = this.getSelectionModel().hasSelection();
        if (n == 0) {
            if (n3 == 0) {
                return n2;
            }
            n3 = n2;
        }
        if (n == 0) {
            if (n3 == this.getSelectionModel().getSelectionStart()) {
                return this.getSelectionModel().getSelectionEnd();
            }
            n3 = this.getSelectionModel().getSelectionStart();
        }
        return n3;
    }

    public final int getMarkPosition() {
        return this.getAnchorSelectionOffset();
    }

    public final void select(int n) {
        this.select(n, n);
    }

    public final void selectAll() {
        this.select(0, this.getDocumentLength());
    }

    public final void selectNone() {
        this.select(this.getCaretModel().getOffset(), this.getCaretModel().getOffset());
    }

    /*
     * Exception decompiling
     */
    public void select(int var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void select(int n, int n2, boolean n3) {
        block6: {
            int n4;
            int n5;
            block5: {
                n5 = KeywordMap.c;
                this.getSelectionModel().setSelection(n, n2);
                n4 = n3;
                if (n5 != 0) break block5;
                if (n4 == 0) break block6;
                this.getCaretModel().setOffset(n2);
                n4 = this.getSelectionStart();
            }
            if (n5 == 0) {
                if (n4 == this.getSelectionEnd()) {
                    this._magicCaret = -1;
                }
                n4 = this.scrollToCaret() ? 1 : 0;
            }
        }
    }

    private void a(int n, int n2) {
        CaretPosition caretPosition = this.getCaretModel().getModelPosition();
        CodeEditor codeEditor = this;
        if (KeywordMap.c == 0) {
            if (codeEditor.getSelectionModel().isColumnSelectionMode()) {
                this.select(n, n2, false);
            }
            codeEditor = this;
        }
        codeEditor.getCaretModel().setModelPosition(new CaretPosition(caretPosition.line, caretPosition.column + 1));
    }

    public final String getSelectedText() {
        return this.getSelectionModel().getSelectedText();
    }

    public void setSelectedText(String string) {
        block10: {
            int n = KeywordMap.c;
            if (!this._editable) {
                throw new InternalError("Text component read only");
            }
            try {
                block12: {
                    block11: {
                        int n2;
                        if (string == null) break block10;
                        CodeEditor codeEditor = this;
                        if (n == 0) {
                            if (codeEditor.getSelectionModel().hasSelection()) {
                                int n3 = this.getSelectionStart();
                                n2 = this.getSelectionEnd();
                                if (n == 0) {
                                    if (n2 == this._document.getEndPosition().getOffset()) {
                                        --n2;
                                        this.getSelectionModel().clearSelection();
                                    }
                                    this._document.remove(n3, n2 - n3);
                                    this._document.insertString(n3, string, null);
                                }
                                if (n == 0) break block10;
                            }
                            codeEditor = this;
                        }
                        CaretPosition caretPosition = codeEditor.getCaretModel().getModelPosition();
                        n2 = this.getLineEndOffset(caretPosition.line);
                        CaretPosition caretPosition2 = this.offsetToModelPosition(n2);
                        if (n != 0) break block11;
                        if (caretPosition.column <= caretPosition2.column) break block12;
                        this._document.insertString(n2, TextUtils.createWhiteSpace(caretPosition.column - caretPosition2.column, this.getTabSize(), false, caretPosition2.column) + string, null);
                    }
                    if (n == 0) break block10;
                }
                this._document.insertString(this.getCaretModel().getOffset(), string, null);
            }
            catch (BadLocationException badLocationException) {
                a.warning(badLocationException.getLocalizedMessage());
                throw new InternalError("Cannot replace selection");
            }
        }
    }

    public final boolean isEditable() {
        return this._editable;
    }

    /*
     * Exception decompiling
     */
    public final void setEditable(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final int getMagicCaretPosition() {
        return this._magicCaret;
    }

    public final void setMagicCaretPosition(int n) {
        this._magicCaret = n;
    }

    public void overwriteSetSelectedText(String string) {
        int n;
        int n2;
        block9: {
            block10: {
                CodeEditor codeEditor;
                block7: {
                    block8: {
                        n2 = KeywordMap.c;
                        codeEditor = this;
                        if (n2 != 0) break block7;
                        if (!codeEditor._overwrite) break block8;
                        n = this.getSelectionStart();
                        if (n2 != 0) break block9;
                        if (n == this.getSelectionEnd()) break block10;
                    }
                    codeEditor = this;
                }
                codeEditor.setSelectedText(string);
                return;
            }
            n = this.getCaretModel().getOffset();
        }
        int n3 = n;
        int n4 = this.getLineEndOffset(this.getCaretModel().getModelPosition().line);
        if (n2 == 0) {
            if (n4 - n3 < string.length()) {
                this.setSelectedText(string);
                return;
            }
            try {
                this._document.remove(n3, string.length());
                this._document.insertString(n3, string, null);
            }
            catch (BadLocationException badLocationException) {
                a.warning(badLocationException.getLocalizedMessage());
            }
        }
    }

    public final boolean isOverwriteEnabled() {
        return this._overwrite;
    }

    public final void setOverwriteEnabled(boolean bl) {
        block3: {
            boolean bl2;
            block2: {
                bl2 = this._overwrite;
                if (KeywordMap.c != 0) break block2;
                if (bl2 == bl) break block3;
                this._overwrite = bl;
                this._painter.invalidateSelectedLines();
            }
            this.firePropertyChange(PROPERTY_OVERWRITE_ENABLED, bl2, bl);
        }
    }

    public final boolean isSelectionRectangular() {
        return this.getSelectionModel().isColumnSelectionMode();
    }

    public final void setSelectionRectangular(boolean bl) {
        this.getSelectionModel().setColumnSelectionMode(bl);
        this._painter.invalidateSelectedLines();
    }

    public final int getBracketPosition() {
        return this.bracketPosition;
    }

    public final int getBracketLine() {
        return this.bracketLine;
    }

    public void undo() {
        this._document.undo();
        this.b();
    }

    public void redo() {
        this._document.redo();
        this.b();
    }

    @Override
    public void addNotify() {
        int n = KeywordMap.c;
        super.addNotify();
        CodeEditor codeEditor = this;
        if (n == 0) {
            if (codeEditor._defaultSettings != null) {
                this._defaultSettings.addPropertyChangeListener(this);
            }
            codeEditor = this;
        }
        if (n == 0) {
            if (codeEditor._localSettings != null) {
                this._localSettings.addPropertyChangeListener(this);
            }
            codeEditor = this;
        }
        codeEditor.blinkCaret();
    }

    @Override
    public void removeNotify() {
        int n = KeywordMap.c;
        super.removeNotify();
        CodeEditor codeEditor = this;
        if (n == 0) {
            if (codeEditor._defaultSettings != null) {
                this._defaultSettings.removePropertyChangeListener(this);
            }
            codeEditor = this;
        }
        if (n == 0) {
            if (codeEditor._localSettings != null) {
                this._localSettings.removePropertyChangeListener(this);
            }
            codeEditor = focusedComponent;
        }
        if (n == 0) {
            if (codeEditor == this) {
                focusedComponent = null;
            }
            codeEditor = this;
        }
        codeEditor.pauseBlink();
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        block11: {
            int n;
            block13: {
                block12: {
                    CodeEditor codeEditor;
                    int n2;
                    block9: {
                        block10: {
                            n2 = KeywordMap.c;
                            codeEditor = this;
                            if (n2 != 0) break block9;
                            if (!codeEditor._searchable.isPopupVisible()) break block10;
                            super.processKeyEvent(keyEvent);
                            if (n2 == 0) break block11;
                        }
                        codeEditor = this;
                    }
                    if (codeEditor.getInputHandler() == null) break block12;
                    n = keyEvent.getID();
                    if (n2 != 0) break block13;
                    switch (n) {
                        case 400: {
                            this.getInputHandler().keyTyped(keyEvent);
                            if (n2 == 0) break;
                        }
                        case 401: {
                            this.getInputHandler().keyPressed(keyEvent);
                            if (n2 == 0) break;
                        }
                        case 402: {
                            this.getInputHandler().keyReleased(keyEvent);
                        }
                    }
                }
                n = keyEvent.isConsumed() ? 1 : 0;
            }
            if (n == 0) {
                super.processKeyEvent(keyEvent);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void updateBracketHighlight(int var1_1) {
        block5: {
            var3_2 = KeywordMap.c;
            v0 = var1_1;
            if (var3_2 != 0) ** GOTO lbl10
            if (v0 == 0) {
                this.bracketLine = -1;
                this.bracketPosition = -1;
                return;
            }
            try {
                v0 = var2_3 = TextUtils.findMatchingBracket(this._document, var1_1 - 1);
lbl10:
                // 2 sources

                if (var3_2 == 0) {
                    if (var2_3 == -1) break block5;
                    this.bracketLine = this.getLineNumber(var2_3);
                    this.bracketPosition = var2_3 - this.getLineStartOffset(this.bracketLine);
                }
                return;
            }
            catch (BadLocationException var2_4) {
                CodeEditor.a.warning(var2_4.getLocalizedMessage());
            }
        }
        this.bracketPosition = -1;
        this.bracketLine = -1;
    }

    protected void documentChanged(DocumentEvent documentEvent) {
        block14: {
            CodeEditor codeEditor;
            block13: {
                int n;
                block11: {
                    int n2;
                    block12: {
                        int n3;
                        int n4;
                        block9: {
                            block10: {
                                block8: {
                                    DocumentEvent.ElementChange elementChange;
                                    DocumentEvent.ElementChange elementChange2;
                                    block6: {
                                        block7: {
                                            n = KeywordMap.c;
                                            elementChange2 = documentEvent.getChange(this._document.getDefaultRootElement());
                                            this.i.documentChanged(documentEvent);
                                            elementChange = elementChange2;
                                            if (n != 0) break block6;
                                            if (elementChange != null) break block7;
                                            n4 = 0;
                                            if (n == 0) break block8;
                                        }
                                        elementChange = elementChange2;
                                    }
                                    n4 = elementChange.getChildrenAdded().length - elementChange2.getChildrenRemoved().length;
                                }
                                n2 = this.getLineNumber(documentEvent.getOffset());
                                n3 = n4;
                                if (n != 0) break block9;
                                if (n3 != 0) break block10;
                                this._painter.invalidateLine(n2);
                                if (n == 0) break block11;
                            }
                            n3 = n2;
                        }
                        if (n3 >= this._firstLine) break block12;
                        this.setFirstLine(this._firstLine + n4);
                        if (n == 0) break block11;
                    }
                    this._painter.invalidateLineRange(this.viewToModelLine(n2), this.viewToModelLine(this.getFirstLine() + this.getVisibleLines()));
                    this.updateScrollBars();
                }
                codeEditor = this;
                if (n != 0) break block13;
                if (!codeEditor.isAutoInspecting()) break block14;
                codeEditor = this;
            }
            codeEditor.inspectCode(documentEvent);
        }
    }

    private boolean c() {
        return this.r;
    }

    private void b(boolean bl) {
        this.r = bl;
    }

    public void pauseBlink() {
        block3: {
            Timer timer;
            block2: {
                this.b(true);
                timer = caretTimer;
                if (KeywordMap.c != 0) break block2;
                if (timer == null) break block3;
                timer = caretTimer;
            }
            timer.restart();
        }
    }

    public boolean isTabAlignment() {
        return this.m;
    }

    public void setTabAlignment(boolean bl) {
        this.m = bl;
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean getFocusCycleRoot() {
        return true;
    }

    public void scrollUpPage() {
        int n2 = this.getFirstLine() - this.getVisibleLines();
        n2 = this.b;
        if (KeywordMap.c == 0) {
            n2 = n2 != 0 ? 1 : 0;
        }
        this.setFirstLine(n + n2);
    }

    public void scrollDownPage() {
        int n2 = this.getFirstLine() + this.getVisibleLines();
        n2 = this.b;
        if (KeywordMap.c == 0) {
            n2 = n2 != 0 ? 1 : 0;
        }
        this.setFirstLine(n - n2);
    }

    public MarginArea getMarginArea() {
        return this._marginArea;
    }

    public void setMarginArea(MarginArea marginArea) {
        this._marginArea = marginArea;
    }

    public void setLineNumberVisible(boolean bl) {
        this._lineNumberMargin.setVisible(bl);
    }

    public boolean isLineNumberVisible() {
        return this._lineNumberMargin.isVisible();
    }

    public LineNumberMargin getLineNumberMargin() {
        return this._lineNumberMargin;
    }

    public CaretModel getCaretModel() {
        CaretModel caretModel = this._caretModel;
        if (KeywordMap.c == 0) {
            if (caretModel == null) {
                this._caretModel = this.e();
                this._caretModel.addCaretListener(this);
            }
            caretModel = this._caretModel;
        }
        return caretModel;
    }

    private DefaultCaretModel e() {
        return new DefaultCaretModel(this);
    }

    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this._selectionModel;
        if (KeywordMap.c == 0) {
            if (selectionModel == null) {
                this._selectionModel = this.f();
                this._selectionModel.addSelectionListener(this);
            }
            selectionModel = this._selectionModel;
        }
        return selectionModel;
    }

    @Override
    public void selectionChanged(SelectionEvent selectionEvent) {
        block4: {
            int n;
            block2: {
                block3: {
                    int n2 = KeywordMap.c;
                    n = selectionEvent.getOldSelectionStart();
                    if (n2 != 0) break block2;
                    if (n != selectionEvent.getNewSelectionStart()) break block3;
                    n = selectionEvent.getOldSelectionEnd();
                    if (n2 != 0) break block2;
                    if (n == selectionEvent.getNewSelectionEnd()) break block4;
                }
                n = this.b(selectionEvent.getOldSelectionStart());
            }
            int n3 = n;
            int n4 = this.b(selectionEvent.getOldSelectionEnd());
            int n5 = this.b(selectionEvent.getNewSelectionStart());
            int n6 = this.b(selectionEvent.getNewSelectionEnd());
            this._painter.invalidateLineRange(n3, n4);
            this._painter.invalidateLineRange(n5, n6);
        }
    }

    @Override
    public void caretUpdated(CaretEvent caretEvent) {
        block14: {
            int n;
            block13: {
                int n2;
                block9: {
                    block10: {
                        CodeEditor codeEditor;
                        block12: {
                            int n3;
                            int n4;
                            block11: {
                                n2 = KeywordMap.c;
                                int n5 = caretEvent.getOldPosition().line;
                                this._painter.invalidateLineRange(n5, n5);
                                int n6 = caretEvent.getNewPosition().line;
                                this._painter.invalidateLineRange(n6, n6);
                                n = this.isBracketHighlightVisible();
                                if (n2 != 0) break block9;
                                if (n == 0) break block10;
                                n4 = this.bracketLine;
                                n3 = -1;
                                if (n2 != 0) break block11;
                                if (n4 != n3) {
                                    this._painter.invalidateLine(this.bracketLine);
                                }
                                this.updateBracketHighlight(this.modelPositionToOffset(caretEvent.getNewPosition()));
                                codeEditor = this;
                                if (n2 != 0) break block12;
                                n4 = codeEditor.bracketLine;
                                n3 = -1;
                            }
                            if (n4 != n3) {
                                this._painter.invalidateLine(this.bracketLine);
                            }
                            codeEditor = this;
                        }
                        codeEditor._marginArea.repaint();
                    }
                    ((DefaultFoldingModel)this.getFoldingModel()).resetCaretPosition();
                    n = this.isVirtualSpaceAllowed() ? 1 : 0;
                }
                if (n2 != 0) break block13;
                if (n != 0) break block14;
                n = caretEvent.getOldPosition().line;
            }
            if (n == caretEvent.getNewPosition().line) {
                this.setMagicCaretPosition(this.columnToX(caretEvent.getNewPosition().line, caretEvent.getNewPosition().column));
            }
        }
    }

    private DefaultSelectionModel f() {
        return new DefaultSelectionModel(this);
    }

    private FoldingSpan a(CaretPosition caretPosition) {
        block19: {
            FoldingSpan foldingSpan;
            block23: {
                int n;
                int n2;
                FoldingSpan[] foldingSpanArray;
                block20: {
                    block21: {
                        int n3;
                        block22: {
                            int n4;
                            int n5;
                            CaretPosition caretPosition2;
                            CaretPosition caretPosition3;
                            int n6;
                            block17: {
                                block18: {
                                    block16: {
                                        n6 = KeywordMap.c;
                                        DefaultFoldingModel defaultFoldingModel = (DefaultFoldingModel)this.getFoldingModel();
                                        foldingSpanArray = defaultFoldingModel.getTopLevelSpans();
                                        if (foldingSpanArray == null) {
                                            return null;
                                        }
                                        int n7 = 0;
                                        int n8 = foldingSpanArray.length - 1;
                                        n2 = 0;
                                        while (n7 <= n8) {
                                            n2 = (n7 + n8) / 2;
                                            foldingSpan = foldingSpanArray[n2];
                                            caretPosition3 = this.offsetToModelPosition(foldingSpan.getEndOffset() - 1);
                                            caretPosition2 = this.modelToViewPosition(caretPosition3);
                                            int n9 = caretPosition2.line;
                                            int n10 = caretPosition.line;
                                            if (n6 == 0) {
                                                if (n9 < n10) {
                                                    n7 = n2 + 1;
                                                    if (n6 == 0) continue;
                                                }
                                                n9 = caretPosition2.line;
                                                n10 = caretPosition.line;
                                            }
                                            if (n6 == 0) {
                                                if (n9 > n10) {
                                                    n8 = n2 - 1;
                                                    if (n6 == 0) continue;
                                                }
                                                n9 = caretPosition2.column;
                                                n10 = caretPosition.column;
                                            }
                                            if (n6 == 0) {
                                                if (n9 < n10) {
                                                    n7 = n2 + 1;
                                                    if (n6 == 0) continue;
                                                }
                                                n9 = caretPosition2.column;
                                                n10 = caretPosition.column;
                                            }
                                            if (n6 == 0) {
                                                if (n9 <= n10) break;
                                                n9 = n2;
                                                n10 = 1;
                                            }
                                            n8 = n9 - n10;
                                            if (n6 == 0) continue;
                                        }
                                        while (n2 >= 0) {
                                            n5 = n2;
                                            if (n6 != 0) break block16;
                                            n4 = foldingSpanArray.length;
                                            if (n6 != 0) break block17;
                                            if (n5 >= n4) break;
                                            n5 = foldingSpanArray[n2].isValid() ? 1 : 0;
                                            if (n6 == 0) {
                                                if (n5 != 0) break;
                                                --n2;
                                                if (n6 == 0) continue;
                                            }
                                            break block16;
                                        }
                                        n5 = n2;
                                    }
                                    if (n6 != 0) break block18;
                                    if (n5 < 0) break block19;
                                    n5 = n2;
                                }
                                n4 = foldingSpanArray.length;
                            }
                            if (n5 >= n4) break block19;
                            foldingSpan = foldingSpanArray[n2];
                            caretPosition3 = this.offsetToModelPosition(foldingSpan.getEndOffset() - 1);
                            caretPosition2 = this.modelToViewPosition(caretPosition3);
                            n = caretPosition2.line;
                            if (n6 != 0) break block20;
                            if (n > caretPosition.line) break block21;
                            n = caretPosition2.line;
                            n3 = caretPosition.line;
                            if (n6 != 0) break block22;
                            if (n != n3) break block23;
                            n = caretPosition2.column;
                            if (n6 != 0) break block20;
                            n3 = caretPosition.column;
                        }
                        if (n <= n3) break block23;
                    }
                    n = --n2;
                }
                if (n >= 0) {
                    return foldingSpanArray[n2];
                }
                return null;
            }
            return foldingSpan;
        }
        return null;
    }

    public CaretPosition viewToModelPosition(CaretPosition caretPosition) {
        int n;
        int n2;
        block9: {
            int n3;
            block8: {
                int n4;
                block4: {
                    block5: {
                        CaretPosition caretPosition2;
                        block6: {
                            FoldingSpan foldingSpan;
                            block7: {
                                n4 = KeywordMap.c;
                                DefaultFoldingModel defaultFoldingModel = (DefaultFoldingModel)this.getFoldingModel();
                                n2 = caretPosition.line;
                                n = caretPosition.column;
                                n3 = defaultFoldingModel.isEnabled();
                                if (n4 != 0) break block4;
                                if (n3 == 0 || (foldingSpan = this.a(caretPosition)) == null) break block5;
                                CaretPosition caretPosition3 = this.offsetToModelPosition(foldingSpan.getEndOffset());
                                CaretPosition caretPosition4 = this.modelToViewPosition(caretPosition3);
                                n2 = caretPosition3.line + (caretPosition.line - caretPosition4.line);
                                n3 = caretPosition4.line;
                                if (n4 != 0) break block4;
                                if (n3 != caretPosition.line) break block5;
                                caretPosition2 = caretPosition;
                                if (n4 != 0) break block6;
                                if (caretPosition2.column < caretPosition4.column) break block7;
                                n = caretPosition3.column + (caretPosition.column - caretPosition4.column);
                                if (n4 == 0) break block5;
                            }
                            caretPosition2 = this.offsetToModelPosition(foldingSpan.getStartOffset());
                        }
                        return caretPosition2;
                    }
                    n3 = n;
                }
                if (n4 != 0) break block8;
                if (n3 >= 0) break block9;
                n3 = 0;
            }
            n = n3;
        }
        return new CaretPosition(n2, n);
    }

    public CaretPosition modelToViewPosition(CaretPosition caretPosition) {
        int n;
        int n2;
        DefaultFoldingModel defaultFoldingModel;
        int n3;
        block12: {
            block11: {
                FoldingSpan foldingSpan;
                n3 = KeywordMap.c;
                defaultFoldingModel = (DefaultFoldingModel)this.getFoldingModel();
                int n4 = defaultFoldingModel.isEnabled();
                if (n3 == 0) {
                    if (n4 == 0) {
                        return new CaretPosition(caretPosition.line, caretPosition.column);
                    }
                    n4 = this.modelPositionToOffset(caretPosition);
                }
                if ((foldingSpan = defaultFoldingModel.getOutermostSpanAtOffset(n2 = n4)) == null) break block11;
                n = n2;
                if (n3 != 0) break block12;
                if (n > foldingSpan.getStartOffset()) {
                    int n5 = n2;
                    int n6 = this.getDocument().getLength() - 1;
                    if (n3 == 0) {
                        if (n5 < n6) {
                            n2 = foldingSpan.getStartOffset();
                            CaretPosition caretPosition2 = this.offsetToModelPosition(n2);
                            return this.modelToViewPosition(caretPosition2);
                        }
                        n5 = foldingSpan.getEndOffset();
                        n6 = 3;
                    }
                    n2 = n5 + n6;
                }
            }
            n = caretPosition.line;
        }
        int n7 = n;
        int n8 = caretPosition.column;
        n7 -= defaultFoldingModel.getFoldedLinesCountBefore(n2);
        FoldingSpan[] foldingSpanArray = defaultFoldingModel.getTopLevelSpans();
        for (int i = defaultFoldingModel.getLastTopLevelIndexBefore(n2); i >= 0; --i) {
            FoldingSpan foldingSpan = foldingSpanArray[i];
            int n9 = foldingSpan.isValid();
            if (n3 == 0) {
                if (n9 == 0) continue;
                n9 = this.getLineNumber(foldingSpan.getEndOffset());
            }
            int n10 = caretPosition.line;
            if (n3 == 0) {
                if (n9 != n10) break;
                n9 = foldingSpan.getEndOffset();
                n10 = n2;
            }
            if (n9 > n10) break;
            CaretPosition caretPosition3 = this.offsetToModelPosition(foldingSpan.getStartOffset());
            CaretPosition caretPosition4 = this.offsetToModelPosition(foldingSpan.getEndOffset());
            n8 += caretPosition3.column + foldingSpan.getDescription().length() - caretPosition4.column;
            n2 = foldingSpan.getStartOffset();
            caretPosition = caretPosition3;
            if (n3 == 0) continue;
        }
        return new CaretPosition(n7, n8);
    }

    public CaretPosition offsetToModelPosition(int n) {
        int n2 = this.b(n);
        int n3 = this.b(n, n2);
        return new CaretPosition(n2, n3);
    }

    public CaretPosition offsetToViewPosition(int n) {
        return this.modelToViewPosition(this.offsetToModelPosition(n));
    }

    public int modelPositionToOffset(CaretPosition caretPosition) {
        int n;
        int n2;
        block17: {
            int n3;
            block18: {
                block19: {
                    int n4;
                    int n5;
                    int n6;
                    block15: {
                        int n7;
                        block16: {
                            n6 = KeywordMap.c;
                            int n8 = this.getLineCount();
                            if (n6 == 0) {
                                if (n8 == 0) {
                                    return 0;
                                }
                                n8 = caretPosition.line;
                            }
                            if (n6 == 0) {
                                if (n8 < 0) {
                                    throw new IndexOutOfBoundsException("Wrong line: " + caretPosition.line);
                                }
                                n8 = caretPosition.column;
                            }
                            if (n6 == 0) {
                                if (n8 < 0) {
                                    throw new IndexOutOfBoundsException("Wrong column:" + caretPosition.column);
                                }
                                n8 = caretPosition.line;
                            }
                            if (n6 == 0) {
                                if (n8 >= this.getLineCount()) {
                                    return this._document.getLength();
                                }
                                n8 = this.getLineStartOffset(caretPosition.line);
                            }
                            n2 = n8;
                            n7 = this.getLineEndOffset(caretPosition.line);
                            n5 = this.getLineLength(caretPosition.line) - 1;
                            n4 = caretPosition.column;
                            if (n6 == 0) {
                                if (n4 == 0) {
                                    return n2;
                                }
                                n4 = n5;
                            }
                            if (n6 == 0) {
                                if (n4 == 0) {
                                    return n2;
                                }
                                n4 = caretPosition.column;
                            }
                            if (n6 != 0) break block15;
                            if (n4 > n7 - n2 - 1) break block16;
                            n = caretPosition.column;
                            if (n6 == 0) break block17;
                        }
                        n4 = this.b(n7, caretPosition.line);
                    }
                    int n9 = n4;
                    n3 = caretPosition.column;
                    if (n6 != 0) break block18;
                    if (n3 <= n9) break block19;
                    n = this.xToOffset(caretPosition.line, this.columnToX(caretPosition.line, n5));
                    if (n6 == 0) break block17;
                }
                n3 = this.xToOffset(caretPosition.line, this.columnToX(caretPosition.line, caretPosition.column));
            }
            n = n3;
        }
        return n2 + n;
    }

    /*
     * Unable to fully structure code
     */
    private int b(int var1_1) {
        var3_2 = KeywordMap.c;
        v0 = var2_3 = this._document.getLength();
        if (var3_2 == 0) {
            if (v0 == 0) {
                return 0;
            }
            v0 = var1_1;
        }
        if (var3_2 == 0) {
            if (v0 >= 0) {
                v1 = var1_1;
                v2 = var2_3;
                if (var3_2 == 0) {
                    if (v1 <= v2) {
                        return this.getLineNumber(var1_1);
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 3 sources

            {
                v1 = this.getLineCount();
                v2 = 1;
            }
            v0 = v1 - v2;
        }
        return v0;
    }

    private int b(int n, int n2) {
        int n3;
        int n4 = KeywordMap.c;
        int n5 = this._document.getLength();
        if (n4 == 0) {
            if (n5 == 0) {
                return 0;
            }
            n5 = this.getLineStartOffset(n2);
        }
        int n6 = n3 = n5;
        int n7 = n;
        if (n4 == 0) {
            if (n6 == n7) {
                return 0;
            }
            n6 = n;
            n7 = n3;
        }
        return n6 - n7;
    }

    public int getTabSize() {
        return this.s;
    }

    public void setTabSize(int n) {
        block3: {
            int n2;
            block2: {
                n2 = this.s;
                if (KeywordMap.c != 0) break block2;
                if (n2 == n) break block3;
                this.s = n;
            }
            this.firePropertyChange(PROPERTY_TAB_SIZE, n2, n);
        }
    }

    public boolean isReplaceTabWithSpace() {
        return this.t;
    }

    public void setReplaceTabWithSpace(boolean bl) {
        block3: {
            boolean bl2;
            block2: {
                bl2 = this.t;
                if (KeywordMap.c != 0) break block2;
                if (bl2 == bl) break block3;
                this.t = bl;
            }
            this.firePropertyChange(PROPERTY_REPLACE_TAB_WITH_SPACE, bl2, bl);
        }
    }

    public int getDefaultLineBreakStyle() {
        int n;
        int n2;
        block9: {
            block10: {
                int n3;
                block7: {
                    block8: {
                        n2 = KeywordMap.c;
                        n3 = SystemInfo.isWindows();
                        if (n2 != 0) break block7;
                        if (n3 != 0) break block8;
                        n = SystemInfo.isMacOSX();
                        if (n2 != 0) break block9;
                        if (n == 0) break block10;
                    }
                    n3 = 0;
                }
                return n3;
            }
            n = SystemInfo.isMacClassic();
        }
        if (n2 == 0) {
            if (n != 0) {
                return 2;
            }
            n = SystemInfo.isUnix();
        }
        if (n2 == 0) {
            if (n != 0) {
                return 1;
            }
            n = 0;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getLineBreakStyle() {
        int n;
        CodeEditor codeEditor = this;
        if (KeywordMap.c == 0) {
            if (codeEditor.u == -1) {
                n = this.getDefaultLineBreakStyle();
                return n;
            }
            codeEditor = this;
        }
        n = codeEditor.u;
        return n;
    }

    public boolean isLineBreakStyleMixed() {
        boolean bl = this.u;
        if (KeywordMap.c == 0) {
            bl = bl;
        }
        return bl;
    }

    public void setLineBreakStyle(int n) {
        block6: {
            int n2;
            block5: {
                int n3 = KeywordMap.c;
                int n4 = n;
                if (n3 == 0) {
                    if (n4 == -2) {
                        n = this.getDefaultLineBreakStyle();
                    }
                    n4 = n2 = this.u;
                }
                if (n3 != 0) break block5;
                if (n2 == n) break block6;
                this.u = n;
            }
            this.firePropertyChange(PROPERTY_LINE_BREAK_STYLE, n2, n);
        }
    }

    private String g() {
        return TextUtils.getLineBreak(1);
    }

    public void discardAllEdits() {
        this.getDocument().getUndoManager().discardAllEdits();
    }

    public void promptGotoLine() {
        Point point;
        final InputPopup inputPopup = new InputPopup(this.getResourceString("CodeEditor.gotoLine"), MessageFormat.format(this.getResourceString("CodeEditor.gotoLine.message"), 1, this.getLineCount()), this.getCaretModel().getModelPosition().line + 1);
        inputPopup.setOwner(this);
        inputPopup.removeExcludedComponent(this);
        try {
            point = this.getLocationOnScreen();
        }
        catch (Exception exception) {
            point = this.getLocation();
        }
        Dimension dimension = inputPopup.getPreferredSize();
        point.x += (this.getWidth() - dimension.width) / 2;
        point.y += (this.getHeight() - dimension.height) / 2;
        inputPopup.getTextField().addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 7299209753351159934L;

            /*
             * Unable to fully structure code
             */
            public void actionPerformed(ActionEvent var1_1) {
                block3: {
                    block4: {
                        block5: {
                            var5_2 = KeywordMap.c;
                            var2_3 = (JTextField)var1_1.getSource();
                            var3_4 = var2_3.getText();
                            if (var5_2 != 0) break block4;
                            if (var3_4 == null) break block5;
                            v0 = var3_4.trim().length();
                            if (var5_2 != 0) ** GOTO lbl11
                            if (v0 <= 0) break block5;
                            try {
                                v0 = Integer.parseInt("" + var3_4);
lbl11:
                                // 2 sources

                                var4_5 = v0;
                                CodeEditor.this.gotoLine(var4_5 - 1);
                                inputPopup.hidePopup();
                                break block3;
                            }
                            catch (NumberFormatException var4_6) {
                                inputPopup.getStatusLabel().setForeground(Color.RED);
                                inputPopup.getStatusLabel().setText(CodeEditor.this.getResourceString("CodeEditor.gotoLine.invalid"));
                                if (var5_2 == 0) break block3;
                            }
                        }
                        inputPopup.getStatusLabel().setForeground(Color.RED);
                    }
                    inputPopup.getStatusLabel().setText(CodeEditor.this.getResourceString("CodeEditor.gotoLine.empty"));
                }
            }
        });
        inputPopup.setTimeout(0);
        inputPopup.showPopup(point.x, point.y, this);
    }

    public void promptGotoLineAtView() {
        Object object = JOptionPane.showInputDialog(this, "Line number: ", "Go to Line at View", 3, null, null, this.getCaretModel().getViewPosition().line + 1);
        if (object != null) {
            try {
                int n = Integer.parseInt("" + object);
                this.gotoLineAtView(n - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void promptGotoOffset() {
        Object object = JOptionPane.showInputDialog(this, "Offset: ", "Go to Offset", 3, null, null, this.getCaretModel().getOffset());
        if (object != null) {
            try {
                int n = Integer.parseInt("" + object);
                this.gotoOffset(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void gotoLine(int n) {
        block6: {
            int n2;
            int n3;
            block5: {
                int n4 = KeywordMap.c;
                n3 = n;
                if (n4 == 0) {
                    if (n3 < 0) {
                        PortingUtils.notifyUser();
                        n = 0;
                    }
                    n3 = n;
                }
                n2 = this.getLineCount() - 1;
                if (n4 != 0) break block5;
                if (n3 <= n2) break block6;
                PortingUtils.notifyUser();
                n3 = this.getLineCount();
                n2 = 1;
            }
            n = n3 - n2;
        }
        CaretPosition caretPosition = this.getCaretModel().getModelPosition();
        this.getCaretModel().setModelPosition(new CaretPosition(n, caretPosition.column));
        this.scrollToCaret();
    }

    public void gotoLineAtView(int n) {
        block6: {
            int n2;
            int n3;
            block5: {
                int n4 = KeywordMap.c;
                n3 = n;
                if (n4 == 0) {
                    if (n3 < 0) {
                        PortingUtils.notifyUser();
                        n = 0;
                    }
                    n3 = n;
                }
                n2 = this.getLineCount() - 1;
                if (n4 != 0) break block5;
                if (n3 <= n2) break block6;
                PortingUtils.notifyUser();
                n3 = this.getLineCount();
                n2 = 1;
            }
            n = n3 - n2;
        }
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        this.getCaretModel().setViewPosition(new CaretPosition(n, caretPosition.column));
        this.scrollToCaret();
    }

    public void gotoOffset(int n) {
        int n2 = KeywordMap.c;
        int n3 = n;
        if (n2 == 0) {
            if (n3 < 0) {
                PortingUtils.notifyUser();
                n = 0;
            }
            n3 = n;
        }
        if (n2 == 0) {
            if (n3 > this.getDocumentLength() - 1) {
                PortingUtils.notifyUser();
                n = this.getDocumentLength() - 1;
            }
            this.getCaretModel().setOffset(n);
            n3 = this.scrollToCaret() ? 1 : 0;
        }
    }

    public MarkerModel getMarkerModel() {
        MarkerModel markerModel = this.g;
        if (KeywordMap.c == 0) {
            if (markerModel == null) {
                this.setMarkerModel(new DefaultMarkerModel());
            }
            markerModel = this.g;
        }
        return markerModel;
    }

    public void setMarkerModel(MarkerModel markerModel) {
        block13: {
            CodeEditor codeEditor;
            int n;
            block12: {
                MarkerModel markerModel2;
                block9: {
                    block11: {
                        block10: {
                            n = KeywordMap.c;
                            markerModel2 = this.g;
                            if (n != 0) break block9;
                            if (markerModel2 == null) break block10;
                            codeEditor = this;
                            if (n != 0) break block11;
                            if (codeEditor.o != null) {
                                this.g.removeMarkerListener(this.o);
                            }
                        }
                        this.g = markerModel;
                        codeEditor = this;
                    }
                    if (n != 0) break block12;
                    markerModel2 = codeEditor.g;
                }
                if (markerModel2 == null) break block13;
                codeEditor = this;
            }
            if (n == 0) {
                if (codeEditor.o == null) {
                    this.o = new MarkerListener(){

                        public void markerChanged(MarkerEvent markerEvent) {
                            int n;
                            int n2;
                            block8: {
                                block7: {
                                    block9: {
                                        Marker marker;
                                        block10: {
                                            n2 = KeywordMap.c;
                                            marker = markerEvent.getMarker();
                                            if (marker == null) break block7;
                                            n = markerEvent.getType();
                                            if (n2 != 0) break block8;
                                            if (n != 0 || CodeEditor.this.getMarkerArea() == null) break block7;
                                            n = marker.getType();
                                            if (n2 != 0) break block9;
                                            if (n != 0) break block10;
                                            CodeEditor.this.getMarkerArea().requireMinimumMode(200);
                                            if (n2 == 0) break block7;
                                        }
                                        n = marker.getType();
                                    }
                                    if (n2 != 0) break block8;
                                    if (n == 1) {
                                        CodeEditor.this.getMarkerArea().requireMinimumMode(100);
                                    }
                                }
                                n = markerEvent.isAdjusting() ? 1 : 0;
                            }
                            if (n == 0) {
                                CodeEditor codeEditor = CodeEditor.this;
                                if (n2 == 0) {
                                    if (codeEditor.getMarkerArea() != null) {
                                        CodeEditor.this.getMarkerArea().repaint();
                                    }
                                    codeEditor = CodeEditor.this;
                                }
                                codeEditor._painter.repaint();
                            }
                        }
                    };
                }
                codeEditor = this;
            }
            codeEditor.g.addMarkerListener(this.o);
        }
    }

    public int getMaxNumberOfClipboards() {
        return this.v;
    }

    public void setMaxNumberOfClipboards(int n) {
        block3: {
            int n2;
            block2: {
                n2 = this.v;
                if (KeywordMap.c != 0) break block2;
                if (n2 == n) break block3;
                this.v = n;
            }
            this.firePropertyChange(PROPERTY_MAX_NUMBER_OF_CLIPBOARDS, n2, n);
        }
    }

    public void setDragEnabled(boolean bl) {
        block5: {
            boolean bl2;
            block4: {
                bl2 = bl;
                if (KeywordMap.c != 0) break block4;
                if (!bl2) break block5;
                bl2 = GraphicsEnvironment.isHeadless();
            }
            if (bl2) {
                throw new HeadlessException();
            }
        }
        this.w = bl;
    }

    public boolean getDragEnabled() {
        return this.w;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._painter.setFont(font);
        this.recalculateVisibleLines();
        this.resetContentSize();
        this.getMarginArea().setFont(font);
    }

    public Searchable getSearchable() {
        return this._searchable;
    }

    /*
     * Unable to fully structure code
     */
    public FindAndReplace getFindAndReplace() {
        var6_1 = KeywordMap.c;
        v0 = this;
        if (var6_1 == 0) {
            if (v0.h == null) {
                this.h = new FindAndReplace();
                this.h.addTarget(new CodeEditorFindAndReplaceTarget(this));
                this.h.addTarget(new CodeEditorSelectionFindAndReplaceTarget(this));
            }
            v0 = this;
        }
        if (var6_1 != 0) ** GOTO lbl31
        if (!v0.getSelectionModel().hasSelection()) ** GOTO lbl-1000
        v0 = this;
        if (var6_1 == 0) {
            ** if (v0.getSelectionStartLine() == this.getSelectionEndLine()) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                v1 = this.h;
                if (var6_1 == 0) {
                    if (v1.getTarget() == null) {
                        var2_3 = var1_2 = this.h.getTargets();
                        var3_4 = var2_3.length;
                        var4_5 = 0;
                        while (var4_5 < var3_4) {
                            var5_6 = var2_3[var4_5];
                            if (var6_1 == 0) {
                                if (var5_6 instanceof CodeEditorSelectionFindAndReplaceTarget) {
                                    this.h.setTarget((FindAndReplaceTarget)var5_6);
                                    if (var6_1 == 0) ** break;
                                } else {
                                    ** GOTO lbl26
                                }
lbl26:
                                // 3 sources

                                ++var4_5;
                            } else {
                                ** GOTO lbl27
                            }
lbl27:
                            // 3 sources

                            if (var6_1 == 0) continue;
                        }
                    } else {
                        ** GOTO lbl-1000
                    }
                } else {
                    ** GOTO lbl28
                }
lbl28:
                // 2 sources

                ** GOTO lbl32
            }
        }
        ** GOTO lbl31
lbl-1000:
        // 7 sources

        {
            v0 = this;
lbl31:
            // 3 sources

            v1 = v0.h;
        }
lbl32:
        // 2 sources

        return v1;
    }

    public Point getCaretLocation() {
        CaretPosition caretPosition = this.getCaretModel().getViewPosition();
        int n = (caretPosition.line - this.getFirstLine()) * this.getLineHeight();
        int n2 = this.columnToX(caretPosition.line, caretPosition.column);
        return new Point(n2, n);
    }

    public Point getCaretLocationOnScreen() {
        Point point = this.getCaretLocation();
        SwingUtilities.convertPointToScreen(point, this.getPainter());
        return point;
    }

    public void showMessage(String string) {
        Point point;
        block6: {
            Point point2;
            block5: {
                Point point3;
                int n;
                int n2;
                block4: {
                    int n3 = KeywordMap.c;
                    this.h();
                    this.d = JidePopupFactory.getSharedInstance().createPopup();
                    this.getCaretModel().addCaretListener(new CaretListener(){

                        public void caretUpdated(CaretEvent caretEvent) {
                            CodeEditor.this.h();
                        }
                    });
                    JLabel jLabel = new JLabel(string);
                    jLabel.setOpaque(true);
                    jLabel.setFont(UIDefaultsLookup.getFont("Label.font").deriveFont(1, 11.0f));
                    jLabel.setBackground(new Color(253, 254, 226));
                    jLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
                    jLabel.setForeground(UIDefaultsLookup.getColor("ToolTip.foreground"));
                    this.d.getContentPane().setLayout(new BorderLayout());
                    this.d.getContentPane().add(jLabel);
                    this.d.setOwner(this);
                    this.d.setPopupBorder(new m_());
                    point = this.getCaretLocation();
                    SwingUtilities.convertPointToScreen(point, this.getPainter());
                    point2 = new Point(this.getWidth(), this.getHeight());
                    SwingUtilities.convertPointToScreen(point2, this);
                    n2 = point.x + this.d.getPreferredSize().width;
                    n = point2.x;
                    if (n3 != 0) break block4;
                    if (n2 > n) {
                        point.x = point2.x - this.d.getPreferredSize().width;
                    }
                    point3 = point;
                    if (n3 != 0) break block5;
                    n2 = point3.y + this.d.getPreferredSize().height;
                    n = point2.y;
                }
                if (n2 <= n) break block6;
                point3 = point;
            }
            point3.y = point2.y - this.d.getPreferredSize().height;
        }
        this.d.setDefaultMoveOperation(0);
        this.d.setTransient(true);
        this.d.showPopup(point.x, point.y + this.getLineHeight());
    }

    private void h() {
        block3: {
            JidePopup jidePopup;
            block2: {
                jidePopup = this.d;
                if (KeywordMap.c != 0) break block2;
                if (jidePopup == null) break block3;
                jidePopup = this.d;
            }
            jidePopup.hidePopupImmediately();
            this.d = null;
        }
    }

    public void find() {
        FindAndReplaceDialog findAndReplaceDialog;
        block10: {
            Window window;
            block9: {
                CodeEditor codeEditor;
                int n;
                block7: {
                    block8: {
                        n = KeywordMap.c;
                        this.getFindAndReplace().setReplace(false);
                        codeEditor = this;
                        if (n != 0) break block7;
                        if (!codeEditor.getSelectionModel().hasSelection()) break block8;
                        codeEditor = this;
                        if (n != 0) break block7;
                        if (codeEditor.getSelectionModel().getSelectionStartLine() == this.getSelectionModel().getSelectionEndLine()) {
                            this.getFindAndReplace().setFindText(this.getSelectedText());
                        }
                    }
                    codeEditor = this;
                }
                if (!((window = JideSwingUtilities.getWindowForComponent(codeEditor)) instanceof Frame)) break block9;
                findAndReplaceDialog = new FindAndReplaceDialog((Frame)window, this.getResourceString("FindAndReplace.findTitle"), this.getFindAndReplace());
                if (n == 0) break block10;
            }
            findAndReplaceDialog = new FindAndReplaceDialog((Dialog)window, this.getResourceString("FindAndReplace.findTitle"), this.getFindAndReplace());
        }
        findAndReplaceDialog.pack();
        findAndReplaceDialog.setLocationRelativeTo(this);
        findAndReplaceDialog.setVisible(true);
    }

    public void findNext() {
        FindAndReplace findAndReplace = this.getFindAndReplace();
        boolean bl = this.getFindAndReplace().isReversed();
        if (KeywordMap.c == 0) {
            bl = !bl;
        }
        findAndReplace.setForward(bl);
        this.getFindAndReplace().searchAgain();
    }

    public void findPrevious() {
        this.getFindAndReplace().setForward(this.getFindAndReplace().isReversed());
        this.getFindAndReplace().searchAgain();
    }

    public void replace() {
        FindAndReplaceDialog findAndReplaceDialog;
        block9: {
            Window window;
            block8: {
                CodeEditor codeEditor;
                int n;
                block6: {
                    block7: {
                        block5: {
                            boolean bl;
                            block4: {
                                n = KeywordMap.c;
                                bl = this.isEditable();
                                if (n != 0) break block4;
                                if (!bl) break block5;
                                codeEditor = this;
                                if (n != 0) break block6;
                                bl = codeEditor.isEnabled();
                            }
                            if (bl) break block7;
                        }
                        PortingUtils.notifyUser();
                        return;
                    }
                    this.getFindAndReplace().setReplace(true);
                    codeEditor = this;
                }
                if (!((window = JideSwingUtilities.getWindowForComponent(codeEditor)) instanceof Frame)) break block8;
                findAndReplaceDialog = new FindAndReplaceDialog((Frame)window, this.getResourceString("FindAndReplace.replaceTitle"), this.getFindAndReplace());
                if (n == 0) break block9;
            }
            findAndReplaceDialog = new FindAndReplaceDialog((Dialog)window, this.getResourceString("FindAndReplace.replaceTitle"), this.getFindAndReplace());
        }
        findAndReplaceDialog.pack();
        findAndReplaceDialog.setLocationRelativeTo(this);
        findAndReplaceDialog.setVisible(true);
    }

    public void quickSearch(String string) {
        this.getSearchable().showPopup(string);
    }

    private static void a(CodeEditor codeEditor, boolean bl, int n) {
        block6: {
            block3: {
                SelectionModel selectionModel;
                int n2;
                block4: {
                    block5: {
                        boolean bl2;
                        block2: {
                            n2 = KeywordMap.c;
                            bl2 = bl;
                            if (n2 != 0) break block2;
                            if (!bl2) break block3;
                            selectionModel = codeEditor.getSelectionModel();
                            if (n2 != 0) break block4;
                            bl2 = selectionModel.isColumnSelectionMode();
                        }
                        if (!bl2) break block5;
                        codeEditor.getSelectionModel().setSelection(n, codeEditor.getCaretModel().getOffset());
                        if (n2 == 0) break block6;
                    }
                    selectionModel = codeEditor.getSelectionModel();
                }
                selectionModel.setSelection(n, codeEditor.getCaretModel().getOffset());
                if (n2 == 0) break block6;
            }
            codeEditor.getSelectionModel().clearSelection();
        }
    }

    public void moveToLineEnd(boolean bl) {
        int n;
        block17: {
            int n2;
            int n3;
            int n4;
            int n5;
            block15: {
                int n6 = KeywordMap.c;
                n = this.getLeadSelectionOffset();
                int n7 = this.getCaretModel().getModelPosition().line;
                if (n7 >= this.getLineCount()) {
                    CaretPosition caretPosition = new CaretPosition(n7, 0);
                    this.getCaretModel().setModelPosition(caretPosition);
                    CodeEditor.a(this, bl, n);
                    this.scrollToCaret();
                    return;
                }
                CaretPosition caretPosition = this.getCaretModel().getViewPosition();
                caretPosition = new CaretPosition(caretPosition.line, com.jidesoft.editor.a.getLastColumnAtVisualLine(this, caretPosition.line));
                CaretPosition caretPosition2 = this.viewToModelPosition(caretPosition);
                n5 = this.modelPositionToOffset(caretPosition2);
                n7 = caretPosition2.line;
                n4 = n5;
                int n8 = this.getLineStartOffset(n7);
                try {
                    String string = this.getDocument().getLineText(n8);
                    for (int i = n4 - 1 - n8; i >= 0; --i) {
                        int n9;
                        int n10;
                        n3 = string.charAt(i);
                        n2 = 32;
                        if (n6 != 0) break block15;
                        if (n6 == 0) {
                            if (n3 != n2) {
                                n10 = string.charAt(i);
                                n9 = 9;
                                if (n6 == 0) {
                                    if (n10 != n9) break;
                                }
                            } else {
                                n10 = i;
                                n9 = n8;
                            }
                        }
                        n4 = n10 + n9;
                        if (n6 == 0) continue;
                        break;
                    }
                }
                catch (BadLocationException badLocationException) {
                    a.warning(badLocationException.getLocalizedMessage());
                }
                n3 = n4;
                if (n6 != 0) break block17;
                n2 = this.getCaretModel().getOffset();
            }
            if (n3 == n2) {
                n4 = n5;
            }
            this.getCaretModel().setOffset(n4);
            n3 = this.scrollToCaret() ? 1 : 0;
        }
        CodeEditor.a(this, bl, n);
    }

    private static int a(CodeEditor codeEditor, int n) {
        int n2;
        int n3 = n2 = CodeEditor.b(codeEditor, n);
        if (KeywordMap.c == 0) {
            if (n3 >= 0) {
                int n4 = CodeEditor.c(codeEditor, n2);
                return codeEditor.offsetToModelPosition((int)n4).column;
            }
            n3 = 0;
        }
        return n3;
    }

    private static int b(CodeEditor codeEditor, int n) {
        int n2 = KeywordMap.c;
        String string = codeEditor.getRawText();
        int n3 = n - 1;
        while (n3 > 0) {
            block6: {
                block7: {
                    int n4;
                    int n5;
                    block9: {
                        int n6;
                        block8: {
                            n6 = string.charAt(n3);
                            if (n2 != 0) break block6;
                            if (n6 == 32) break block7;
                            n5 = n6;
                            n4 = 9;
                            if (n2 != 0) break block8;
                            if (n5 == n4) break block7;
                            n5 = n6;
                            n4 = 13;
                        }
                        if (n2 != 0) break block9;
                        if (n5 == n4) break block7;
                        n5 = n6;
                        n4 = 10;
                    }
                    if (n5 != n4) break;
                }
                --n3;
            }
            if (n2 == 0) continue;
        }
        int n7 = n3;
        if (n2 == 0) {
            if (n7 == -1) {
                return -1;
            }
            n7 = codeEditor.getLineNumber(n3);
        }
        return n7;
    }

    private static int c(CodeEditor codeEditor, int n) {
        int n2;
        block5: {
            int n3 = KeywordMap.c;
            int n4 = codeEditor.getLineStartOffset(n);
            int n5 = codeEditor.getLineEndOffset(n);
            try {
                String string = codeEditor.getDocument().getLineText(n4);
                int n6 = 0;
                while (n6 < n5 - n4) {
                    block7: {
                        block8: {
                            int n7;
                            int n8;
                            block9: {
                                int n9 = string.charAt(n6);
                                if (n3 != 0) break block7;
                                n2 = n9;
                                if (n3 != 0) break block5;
                                if (n2 == 32) break block8;
                                n8 = n9;
                                n7 = 9;
                                if (n3 != 0) break block9;
                                if (n8 == n7) break block8;
                                n8 = n4;
                                n7 = n6;
                            }
                            return n8 + n7;
                        }
                        ++n6;
                    }
                    if (n3 == 0) continue;
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                a.warning(badLocationException.getLocalizedMessage());
            }
            n2 = n5;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    public void moveToLineStart(boolean var1_1) {
        block31: {
            block32: {
                block29: {
                    block30: {
                        block27: {
                            block28: {
                                block23: {
                                    block24: {
                                        block26: {
                                            block25: {
                                                block21: {
                                                    block22: {
                                                        block20: {
                                                            var11_2 = KeywordMap.c;
                                                            var2_3 = this.getLeadSelectionOffset();
                                                            var3_4 = this.getCaretModel().getModelPosition().column;
                                                            var5_6 = this.getCaretModel().getViewPosition();
                                                            for (var4_5 = this.getCaretModel().getModelPosition().line; var4_5 >= 0; --var4_5) {
                                                                v0 = this.modelToViewPosition((CaretPosition)new CaretPosition((int)var4_5, (int)0)).line;
                                                                if (var11_2 == 0 && var11_2 == 0) {
                                                                    if (v0 != var5_6.line) break;
                                                                    if (var11_2 == 0) continue;
                                                                }
                                                                break block20;
                                                            }
                                                            ++var4_5;
                                                            v0 = Boolean.FALSE.equals(this.getClientProperty("InputHandler.homeEnd"));
                                                        }
                                                        if (var11_2 == 0) {
                                                            v0 = v0 == 0 ? 1 : 0;
                                                        }
                                                        v1 = var5_7 = v0;
                                                        if (var11_2 == 0) {
                                                            if (v1 == 0) {
                                                                var6_8 = new CaretPosition(var4_5, 0);
                                                                this.getCaretModel().setModelPosition(var6_8);
                                                                CodeEditor.a(this, var1_1, var2_3);
                                                                this.scrollToCaret();
                                                                return;
                                                            }
                                                            v1 = this.getCaretModel().getOffset();
                                                        }
                                                        var6_9 = v1;
                                                        v2 = var4_5;
                                                        if (var11_2 != 0) break block21;
                                                        if (v2 >= this.getLineCount()) break block22;
                                                        v3 = var6_9;
                                                        if (var11_2 != 0) break block23;
                                                        if (v3 < this.getDocumentLength()) break block24;
                                                    }
                                                    v2 = 0;
                                                }
                                                var7_10 = v2;
                                                v4 = var3_4;
                                                if (var11_2 != 0) break block25;
                                                if (v4 != 0) break block26;
                                                v4 = CodeEditor.a(this, var6_9);
                                            }
                                            var7_10 = v4;
                                        }
                                        var8_12 = new CaretPosition(var4_5, var7_10);
                                        this.getCaretModel().setModelPosition(var8_12);
                                        CodeEditor.a(this, var1_1, var2_3);
                                        this.scrollToCaret();
                                        return;
                                    }
                                    v3 = CodeEditor.c(this, var4_5);
                                }
                                var7_11 = v3;
                                var8_13 = this.getLineEndOffset(var4_5);
                                v5 = var4_5;
                                if (var11_2 != 0) break block27;
                                if (v5 <= 0) break block28;
                                v5 = var8_13;
                                if (var11_2 != 0) break block27;
                                if (v5 == var7_11) {
                                    v5 = var3_4;
                                    if (var11_2 == 0) {
                                        if (v5 == 0) {
                                            var9_14 = CodeEditor.a(this, var6_9);
                                            var10_16 = new CaretPosition(var4_5, var9_14);
                                            this.getCaretModel().setModelPosition(var10_16);
                                            CodeEditor.a(this, var1_1, var2_3);
                                            this.scrollToCaret();
                                            return;
                                        } else {
                                            ** GOTO lbl73
                                        }
                                    } else {
                                        ** GOTO lbl72
                                    }
                                }
                                break block28;
lbl72:
                                // 2 sources

                                break block27;
                            }
                            v5 = this.getLineStartOffset(var4_5);
                        }
                        var9_15 = v5;
                        v6 = var7_11;
                        if (var11_2 != 0) break block29;
                        if (v6 < var6_9) break block30;
                        v7 = var3_4;
                        if (var11_2 != 0) break block31;
                        if (v7 != 0) break block32;
                    }
                    v6 = var7_11;
                }
                var9_15 = v6;
            }
            this.getCaretModel().setOffset(var9_15);
            v7 = (int)this.scrollToCaret();
        }
        CodeEditor.a(this, var1_1, var2_3);
    }

    public void moveToDocumentStart(boolean bl) {
        block3: {
            block2: {
                if (!bl) break block2;
                this.select(this.getMarkPosition(), 0);
                if (KeywordMap.c == 0) break block3;
            }
            this.select(0);
        }
    }

    public void moveToDocumentEnd(boolean bl) {
        block3: {
            block2: {
                if (!bl) break block2;
                this.select(this.getMarkPosition(), this.getDocumentLength());
                if (KeywordMap.c == 0) break block3;
            }
            this.select(this.getDocumentLength());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void moveToNextChar(boolean var1_1) {
        block8: {
            block11: {
                block9: {
                    block10: {
                        var4_2 = KeywordMap.c;
                        var2_3 = this.getCaretModel().getOffset();
                        v0 = this.isVirtualSpaceAllowed();
                        if (var4_2 != 0) break block9;
                        if (v0 == 0) break block10;
                        this.getCaretModel().moveCaret(1, 0, var1_1, false, true);
                        if (var4_2 == 0) break block8;
                    }
                    v0 = var2_3;
                }
                if (var4_2 == 0) {
                    if (v0 == this.getDocumentLength()) {
                        PortingUtils.notifyUser();
                        return;
                    }
                    v0 = (int)var1_1;
                }
                if (var4_2 != 0) ** GOTO lbl23
                if (v0 == 0) break block11;
                this.select(this.getMarkPosition(), var2_3 + 1);
                if (var4_2 == 0) break block8;
            }
            try {
                block13: {
                    block12: {
                        v0 = (int)"\r".equals(this.getDocument().getText(var2_3, 1));
lbl23:
                        // 2 sources

                        if (var4_2 != 0) break block12;
                        if (v0 == 0) break block13;
                        v0 = (int)"\n".equals(this.getDocument().getText(var2_3 + 1, 1));
                    }
                    if (v0 != 0) {
                        this.select(var2_3 + 2);
                        if (var4_2 == 0) break block8;
                    }
                }
                this.select(var2_3 + 1);
            }
            catch (BadLocationException var3_4) {
                CodeEditor.a.warning(var3_4.getLocalizedMessage());
            }
        }
    }

    public void moveToNextLine(boolean bl) {
        block8: {
            int n;
            block12: {
                int n2;
                CodeEditor codeEditor;
                block10: {
                    int n3;
                    block11: {
                        int n4;
                        int n5;
                        int n6;
                        block9: {
                            int n7;
                            int n8;
                            block6: {
                                block7: {
                                    n6 = KeywordMap.c;
                                    n3 = this.getCaretModel().getOffset();
                                    n7 = n8 = this.getCaretModel().getModelPosition().line;
                                    if (n6 == 0) {
                                        if (n7 == this.getLineCount() - 1) {
                                            PortingUtils.notifyUser();
                                            return;
                                        }
                                        n7 = this.isVirtualSpaceAllowed() ? 1 : 0;
                                    }
                                    if (n6 != 0) break block6;
                                    if (n7 == 0) break block7;
                                    this.getCaretModel().moveCaret(0, 1, bl, false, true);
                                    if (n6 == 0) break block8;
                                }
                                n7 = this.getMagicCaretPosition();
                            }
                            n5 = n = n7;
                            n4 = -1;
                            if (n6 != 0) break block9;
                            if (n5 == n4) {
                                n = this.offsetToX(n8, n3 - this.getLineStartOffset(n8));
                            }
                            codeEditor = this;
                            n2 = n8 + 1;
                            if (n6 != 0) break block10;
                            n5 = codeEditor.getLineStartOffset(n2);
                            n4 = this.xToOffset(n8 + 1, n);
                        }
                        n3 = n5 + n4;
                        if (!bl) break block11;
                        this.select(this.getMarkPosition(), n3);
                        if (n6 == 0) break block12;
                    }
                    codeEditor = this;
                    n2 = n3;
                }
                codeEditor.select(n2);
            }
            this.setMagicCaretPosition(n);
        }
    }

    public void moveToNextPage(boolean bl) {
        block7: {
            int n;
            block9: {
                int n2;
                block8: {
                    int n3;
                    int n4;
                    block5: {
                        block6: {
                            n2 = KeywordMap.c;
                            n4 = this.getVisibleLines();
                            n3 = this.isVirtualSpaceAllowed();
                            if (n2 != 0) break block5;
                            if (n3 == 0) break block6;
                            this.getCaretModel().moveCaret(0, n4, bl, false, true);
                            if (n2 == 0) break block7;
                        }
                        n3 = this.getCaretModel().getModelPosition().line;
                    }
                    int n5 = n3;
                    int n6 = this.getLineCount();
                    int n7 = this.getFirstLine();
                    int n8 = (n7 += n4) + n4;
                    if (n2 == 0) {
                        if (n8 >= n6 - 1) {
                            n7 = n6 - n4;
                        }
                        this.setFirstLine(n7);
                        n8 = n = this.getLineStartOffset(Math.min(this.getLineCount() - 1, n5 + n4));
                    }
                    if (n2 != 0) break block8;
                    if (!bl) break block9;
                    this.select(this.getMarkPosition(), n);
                }
                if (n2 == 0) break block7;
            }
            this.select(n);
        }
    }

    public void moveToNextWord(boolean bl) {
        this.moveToNextWord(bl, false);
    }

    public void moveToNextWord(boolean bl, boolean bl2) {
        block15: {
            int n;
            int n2;
            int n3;
            block13: {
                block14: {
                    block12: {
                        String string;
                        int n4;
                        block11: {
                            int n5;
                            int n6;
                            int n7;
                            block10: {
                                n3 = KeywordMap.c;
                                int n8 = this.getCaretModel().getModelPosition().line;
                                int n9 = this.getCaretModel().getOffset();
                                n4 = this.getLineStartOffset(n8);
                                n2 = n9 - n4;
                                string = this.getLineText(n8);
                                n7 = n2;
                                n6 = string.length() - this.g().length();
                                if (n3 != 0) break block10;
                                if (n7 < n6) break block11;
                                n7 = n8;
                                n6 = 1;
                            }
                            int n10 = n5 = n7 + n6;
                            if (n3 == 0) {
                                if (n10 == -1) {
                                    PortingUtils.notifyUser();
                                    return;
                                }
                                n10 = n2 = this.getLineStartOffset(n5);
                            }
                            if (n3 == 0) break block12;
                        }
                        String string2 = (String)this.getDocument().getProperty("nonwordDelimiters");
                        n2 = TextUtils.findWordEnd(string, n2 + 1, string2, true, bl2);
                        n2 += n4;
                    }
                    n = n2;
                    if (n3 != 0) break block13;
                    if (n >= 0) break block14;
                    PortingUtils.notifyUser();
                    if (n3 == 0) break block15;
                }
                n = bl ? 1 : 0;
            }
            if (n3 == 0) {
                if (n != 0) {
                    this.select(this.getMarkPosition(), n2);
                }
                this.getCaretModel().setOffset(n2);
                n = this.scrollToCaret() ? 1 : 0;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void moveToPreviousChar(boolean var1_1) {
        block8: {
            block11: {
                block9: {
                    block10: {
                        var4_2 = KeywordMap.c;
                        v0 = var2_3 = this.getCaretModel().getOffset();
                        if (var4_2 == 0) {
                            if (v0 == 0) {
                                PortingUtils.notifyUser();
                                return;
                            }
                            v0 = (int)this.isVirtualSpaceAllowed();
                        }
                        if (var4_2 != 0) break block9;
                        if (v0 == 0) break block10;
                        this.getCaretModel().moveCaret(-1, 0, var1_1, false, true);
                        if (var4_2 == 0) break block8;
                    }
                    v0 = (int)var1_1;
                }
                if (var4_2 != 0) ** GOTO lbl22
                if (v0 == 0) break block11;
                this.select(this.getMarkPosition(), var2_3 - 1);
                if (var4_2 == 0) break block8;
            }
            try {
                block13: {
                    block12: {
                        v0 = (int)"\r".equals(this.getDocument().getText(var2_3 - 1, 1));
lbl22:
                        // 2 sources

                        if (var4_2 != 0) break block12;
                        if (v0 == 0) break block13;
                        v0 = (int)"\n".equals(this.getDocument().getText(var2_3, 1));
                    }
                    if (v0 != 0) {
                        this.select(var2_3 - 2);
                        if (var4_2 == 0) break block8;
                    }
                }
                this.select(var2_3 - 1);
            }
            catch (BadLocationException var3_4) {
                CodeEditor.a.warning(var3_4.getLocalizedMessage());
            }
        }
    }

    public void moveToPreviousLine(boolean bl) {
        block8: {
            int n;
            block12: {
                int n2;
                CodeEditor codeEditor;
                block10: {
                    int n3;
                    block11: {
                        int n4;
                        int n5;
                        int n6;
                        block9: {
                            int n7;
                            int n8;
                            block6: {
                                block7: {
                                    n6 = KeywordMap.c;
                                    n3 = this.getCaretModel().getOffset();
                                    n7 = n8 = this.getCaretModel().getModelPosition().line;
                                    if (n6 == 0) {
                                        if (n7 == 0) {
                                            PortingUtils.notifyUser();
                                            return;
                                        }
                                        n7 = this.isVirtualSpaceAllowed() ? 1 : 0;
                                    }
                                    if (n6 != 0) break block6;
                                    if (n7 == 0) break block7;
                                    this.getCaretModel().moveCaret(0, -1, bl, false, true);
                                    if (n6 == 0) break block8;
                                }
                                n7 = this.getMagicCaretPosition();
                            }
                            n5 = n = n7;
                            n4 = -1;
                            if (n6 != 0) break block9;
                            if (n5 == n4) {
                                n = this.offsetToX(n8, n3 - this.getLineStartOffset(n8));
                            }
                            codeEditor = this;
                            n2 = n8 - 1;
                            if (n6 != 0) break block10;
                            n5 = codeEditor.getLineStartOffset(n2);
                            n4 = this.xToOffset(n8 - 1, n);
                        }
                        n3 = n5 + n4;
                        if (!bl) break block11;
                        this.select(this.getMarkPosition(), n3);
                        if (n6 == 0) break block12;
                    }
                    codeEditor = this;
                    n2 = n3;
                }
                codeEditor.select(n2);
            }
            this.setMagicCaretPosition(n);
        }
    }

    public void moveToPreviousPage(boolean bl) {
        block7: {
            int n;
            block9: {
                int n2;
                block8: {
                    int n3;
                    int n4;
                    block5: {
                        block6: {
                            n2 = KeywordMap.c;
                            n4 = this.getVisibleLines();
                            n3 = this.isVirtualSpaceAllowed();
                            if (n2 != 0) break block5;
                            if (n3 == 0) break block6;
                            this.getCaretModel().moveCaret(0, -n4, bl, false, true);
                            if (n2 == 0) break block7;
                        }
                        n3 = this.getFirstLine();
                    }
                    int n5 = n3;
                    int n6 = this.getCaretModel().getModelPosition().line;
                    int n7 = n5;
                    if (n2 == 0) {
                        if (n7 < n4) {
                            n5 = n4;
                        }
                        this.setFirstLine(n5 - n4);
                        n7 = n = this.getLineStartOffset(Math.max(0, n6 - n4));
                    }
                    if (n2 != 0) break block8;
                    if (!bl) break block9;
                    this.select(this.getMarkPosition(), n);
                }
                if (n2 == 0) break block7;
            }
            this.select(n);
        }
    }

    public void moveToPreviousWord(boolean bl) {
        this.moveToPreviousWord(bl, false);
    }

    public void moveToPreviousWord(boolean bl, boolean bl2) {
        block17: {
            int n;
            int n2;
            int n3;
            block15: {
                block16: {
                    block14: {
                        String string;
                        int n4;
                        block13: {
                            int n5;
                            int n6;
                            int n7;
                            block12: {
                                n3 = KeywordMap.c;
                                n7 = this.getCaretModel().getModelPosition().line;
                                int n8 = this.getCaretModel().getOffset();
                                n4 = this.getLineStartOffset(n7);
                                n2 = n8 - n4;
                                string = this.getLineText(n7);
                                n6 = n2;
                                if (n3 != 0) break block12;
                                if (n6 != 0) break block13;
                                n6 = n4;
                            }
                            if (n3 == 0) {
                                if (n6 == 0) {
                                    PortingUtils.notifyUser();
                                    return;
                                }
                                n6 = n7 - 1;
                            }
                            int n9 = n5 = n6;
                            int n10 = -1;
                            if (n3 == 0) {
                                if (n9 == n10) {
                                    PortingUtils.notifyUser();
                                    return;
                                }
                                n9 = this.getLineEndOffset(n5);
                                n10 = 1;
                            }
                            n2 = n9 - n10;
                            if (n3 == 0) break block14;
                        }
                        String string2 = (String)this.getDocument().getProperty("nonwordDelimiters");
                        n2 = TextUtils.findWordStart(string, n2 - 1, string2, true, bl2);
                        n2 += n4;
                    }
                    n = n2;
                    if (n3 != 0) break block15;
                    if (n >= 0) break block16;
                    PortingUtils.notifyUser();
                    if (n3 == 0) break block17;
                }
                n = bl ? 1 : 0;
            }
            if (n3 == 0) {
                if (n != 0) {
                    this.select(this.getMarkPosition(), n2);
                }
                this.getCaretModel().setOffset(n2);
                n = this.scrollToCaret() ? 1 : 0;
            }
        }
    }

    public void toggleOverwrite() {
        boolean bl = this.isOverwriteEnabled();
        if (KeywordMap.c == 0) {
            bl = !bl;
        }
        this.setOverwriteEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void splitLine() {
        int n;
        block10: {
            block11: {
                block9: {
                    int n2;
                    block8: {
                        n2 = KeywordMap.c;
                        n = this.isEditable();
                        if (n2 != 0) break block8;
                        if (n == 0) break block9;
                        n = this.isEnabled();
                    }
                    if (n2 != 0) break block10;
                    if (n != 0) break block11;
                }
                PortingUtils.notifyUser();
                return;
            }
            this._document.beginCompoundEdit();
            n = this.getCaretModel().getOffset();
        }
        int n3 = n;
        try {
            int n4 = this.getCaretModel().getModelPosition().line;
            String string = TextUtils.getLeadingWhitespace(this.getLineText(n4));
            this.setSelectedText(this.g());
            int n5 = n4 + 1;
            String string2 = TextUtils.getLeadingWhitespace(this.getLineText(n5));
            try {
                int n6 = this.getCaretModel().getOffset();
                this.getDocument().remove(n6, string2.length());
                this.getDocument().insertString(n6, string, null);
                this.getCaretModel().setOffset(n3);
            }
            catch (BadLocationException badLocationException) {
                a.warning(badLocationException.getLocalizedMessage());
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void insertBreak() {
        block13: {
            block12: {
                block11: {
                    var7_1 = KeywordMap.c;
                    v0 = this.isEditable();
                    if (var7_1 != 0) break block11;
                    if (v0 == 0) break block12;
                    v0 = this.isEnabled();
                }
                if (var7_1 != 0) ** GOTO lbl17
                if (v0 != 0) break block13;
            }
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            this.setSelectedText(this.g());
            v0 = this.getCaretModel().getModelPosition().line;
lbl17:
            // 2 sources

            var1_2 = v0;
            var2_3 = var1_2 - 1;
            if (var7_1 == 0 && var2_3 >= 0) {
                var3_4 = TextUtils.getLeadingWhitespace(this.getLineText(var1_2));
                try {
                    var4_5 = this.getCaretModel().getOffset();
                    this.getDocument().remove(var4_5, var3_4.length());
                    var5_7 = TextUtils.getLeadingWhitespace(this.getLineText(var2_3));
                    this.getDocument().insertString(var4_5, var5_7, null);
                }
                catch (BadLocationException var4_6) {
                    CodeEditor.a.warning(var4_6.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void startNewLine() {
        block8: {
            block7: {
                block6: {
                    var4_1 = KeywordMap.c;
                    v0 = this.isEditable();
                    if (var4_1 != 0) break block6;
                    if (v0 == 0) break block7;
                    v0 = this.isEnabled();
                }
                if (var4_1 != 0) ** GOTO lbl16
                if (v0 != 0) break block8;
            }
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            v0 = this.getCaretModel().getModelPosition().line;
lbl16:
            // 2 sources

            var1_2 = v0;
            var2_3 = TextUtils.getLeadingWhitespace(this.getLineText(var1_2));
            this.gotoEndOfLine();
            this.setSelectedText(this.g() + var2_3);
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void indentSelection() {
        block18: {
            block22: {
                block21: {
                    block20: {
                        var6_1 = KeywordMap.c;
                        v0 = this.isEditable();
                        if (var6_1 != 0) break block20;
                        if (v0 == 0) break block21;
                        v0 = this.isEnabled();
                    }
                    if (var6_1 != 0) ** GOTO lbl16
                    if (v0 != 0) break block22;
                }
                PortingUtils.notifyUser();
                return;
            }
            try {
                block19: {
                    block23: {
                        block24: {
                            block28: {
                                block26: {
                                    block30: {
                                        block29: {
                                            block27: {
                                                block25: {
                                                    this._document.beginCompoundEdit();
                                                    v0 = (int)this.getSelectionModel().hasSelection();
lbl16:
                                                    // 2 sources

                                                    if (var6_1 != 0) break block23;
                                                    if (v0 != 0) break block24;
                                                    var1_2 = null;
                                                    v1 = this.isReplaceTabWithSpace();
                                                    if (var6_1 != 0) break block25;
                                                    if (v1 == 0) break block26;
                                                    v1 = this.getTabSize();
                                                }
                                                v2 = var2_4 = (int)v1;
                                                if (var6_1 != 0) break block27;
                                                if (v2 < 1) break block28;
                                                v2 = (int)this.isTabAlignment();
                                            }
                                            if (var6_1 != 0) break block29;
                                            if (v2 == 0) break block30;
                                            v2 = var2_4 - this.getCaretModel().getViewPosition().column % var2_4;
                                        }
                                        var2_4 = v2;
                                    }
                                    var3_5 = new StringBuffer(var2_4);
                                    for (var4_8 = 0; var4_8 < var2_4; ++var4_8) {
                                        var3_5.append(' ');
                                        if (var6_1 == 0) {
                                            if (var6_1 == 0) continue;
                                        }
                                        break block18;
                                    }
                                    var1_2 = var3_5.toString();
                                    break block28;
                                }
                                var1_2 = "\t";
                            }
                            com.jidesoft.editor.a.insertStringAtCaret(this, var1_2, true, true);
                            if (var6_1 == 0) break block18;
                        }
                        v0 = this.getSelectionEndLine();
                    }
                    var1_3 = v0;
                    var2_4 = this.getSelectionStartLine();
                    try {
                        block32: {
                            block31: {
                                var3_5 = this._document.getText(this.getSelectionEnd() - 1, 1);
                                v3 = var3_5.equals("\n");
                                if (var6_1 != 0) break block31;
                                if (v3) break block32;
                                v3 = var3_5.equals("\r");
                            }
                            if (!v3) break block19;
                        }
                        --var1_3;
                    }
                    catch (BadLocationException var3_6) {
                        CodeEditor.a.warning(var3_6.getLocalizedMessage());
                    }
                }
                for (var3_7 = var2_4; var3_7 <= var1_3; ++var3_7) {
                    this.indentLine(var3_7, false);
                    if (var6_1 == 0 && var6_1 == 0) continue;
                    break;
                }
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void unindentSelection() {
        block18: {
            block17: {
                block16: {
                    var5_1 = KeywordMap.c;
                    v0 = this.isEditable();
                    if (var5_1 != 0) break block16;
                    if (!v0) break block17;
                    v0 = this.isEnabled();
                }
                if (var5_1 != 0) ** GOTO lbl18
                if (v0) break block18;
            }
            PortingUtils.notifyUser();
            return;
        }
        try {
            block14: {
                this._document.beginCompoundEdit();
                v1 = this;
                if (var5_1 != 0) ** GOTO lbl22
                v0 = v1.getSelectionModel().hasSelection();
lbl18:
                // 2 sources

                if (v0) {
                    v2 = this.getSelectionStartLine();
                } else {
                    v1 = this;
lbl22:
                    // 2 sources

                    v2 = v1.getCaretModel().getModelPosition().line;
                }
                var1_2 = v2;
                v3 = this.getSelectionModel().hasSelection();
                if (var5_1 == 0) {
                    v3 = v3 != 0 ? this.getSelectionEndLine() : var1_2;
                }
                var2_3 = v3;
                try {
                    block20: {
                        block19: {
                            var3_4 = this._document.getText(this.getSelectionEnd() - 1, 1);
                            v4 = var3_4.equals("\n");
                            if (var5_1 != 0) break block19;
                            if (v4) break block20;
                            v4 = var3_4.equals("\r");
                        }
                        if (!v4) break block14;
                    }
                    --var2_3;
                }
                catch (BadLocationException var3_5) {
                    CodeEditor.a.warning(var3_5.getLocalizedMessage());
                }
            }
            for (var3_6 = var1_2; var3_6 <= var2_3; ++var3_6) {
                this.indentLine(var3_6, true);
                if (var5_1 == 0 && var5_1 == 0) continue;
                break;
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean indentLine(int var1_1, boolean var2_2) {
        block10: {
            block8: {
                block9: {
                    var8_3 = KeywordMap.c;
                    var3_4 = new int[1];
                    var4_5 = this.getCurrentIndentForLine(var1_1, var3_4);
                    v0 = var2_2;
                    if (var8_3 != 0) break block8;
                    if (v0 == 0) break block9;
                    v1 = var4_5 -= this.getTabSize();
                    if (var8_3 != 0) ** GOTO lbl20
                    if (v1 >= 0) break block10;
                    var4_5 = 0;
                    if (var8_3 == 0) break block10;
                }
                v0 = var4_5 + this.getTabSize();
            }
            var4_5 = v0;
        }
        try {
            this._document.beginCompoundEdit();
            v1 = this.getLineStartOffset(var1_1);
lbl20:
            // 2 sources

            var5_6 = v1;
            try {
                this._document.remove(var5_6, var3_4[0]);
                this._document.insertString(var5_6, TextUtils.createWhiteSpace(var4_5, this.getTabSize(), this.isReplaceTabWithSpace()), null);
            }
            catch (BadLocationException var6_7) {
                CodeEditor.a.warning(var6_7.getLocalizedMessage());
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public int getCurrentIndentForLine(int var1_1, int[] var2_2) {
        block9: {
            var8_3 = KeywordMap.c;
            var3_4 = new Segment();
            v0 = this.getLineText(var1_1, var3_4);
            if (var8_3 == 0) {
                if (v0 == 0) {
                    return 0;
                }
                v0 = this.getTabSize();
            }
            var4_5 = v0;
            var5_6 = 0;
            var6_7 = 0;
            block4: while (var6_7 < var3_4.count) {
                block10: {
                    var7_8 = var3_4.array[var3_4.offset + var6_7];
                    if (var8_3 != 0) ** GOTO lbl19
                    v1 = var7_8;
                    if (var8_3 != 0) break block9;
                    switch (v1) {
                        case 32: {
                            ++var5_6;
lbl19:
                            // 2 sources

                            if (var8_3 == 0) {
                                if (var2_2 == null) break;
                                var2_2[0] = var2_2[0] + 1;
                                if (var8_3 == 0) break;
                            }
                            break block10;
                        }
                        case 9: {
                            var5_6 += var4_5 - var5_6 % var4_5;
                            if (var8_3 == 0) {
                                if (var2_2 == null) break;
                                var2_2[0] = var2_2[0] + 1;
                                if (var8_3 == 0) break;
                            }
                            break block10;
                        }
                        default: {
                            if (var8_3 == 0) break block4;
                        }
                    }
                    ++var6_7;
                }
                if (var8_3 == 0) continue;
            }
            v1 = var5_6;
        }
        return v1;
    }

    private void a(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        block9: {
            int n6;
            int n7;
            block12: {
                block13: {
                    block10: {
                        block11: {
                            n5 = KeywordMap.c;
                            SelectionModel selectionModel = this.getSelectionModel();
                            if (n5 != 0) break block10;
                            if (!selectionModel.hasSelection()) break block11;
                            n7 = selectionModel.isColumnSelectionMode();
                            if (n5 != 0) break block12;
                            if (n7 != 0) break block13;
                        }
                        this.b(string);
                    }
                    return;
                }
                n7 = this.getSelectionStartLine();
            }
            n4 = n7;
            n3 = this.getSelectionEndLine();
            for (n6 = n4; n6 < n3; ++n6) {
                n2 = this.getSelectionStart(n6) + 1;
                n = this.getSelectionEnd(n6 + 1);
                if (n5 == 0) {
                    if (n2 != n) break;
                    if (n5 == 0) continue;
                }
                break block9;
            }
            n2 = n6;
            n = n3;
        }
        if (n5 == 0) {
            if (n2 >= n) {
                this.b(string);
                return;
            }
            this.i();
            n2 = n3 - n4;
            n = 1;
        }
        String[] stringArray = new String[n2 + n];
        for (int i = 0; i < n3 - n4 + 1; ++i) {
            stringArray[i] = string;
            if (n5 == 0) continue;
        }
        int[] nArray = this.a(stringArray, n4);
        this.a(nArray[0], nArray[1]);
        this.scrollToCaret();
    }

    private void i() {
        block5: {
            int n;
            int n2 = KeywordMap.c;
            int n3 = this.getSelectionStartLine();
            int n4 = this.getSelectionEndLine();
            int[] nArray = new int[(n4 - n3 + 1) * 2];
            for (n = n3; n <= n4; ++n) {
                nArray[(n - n3) * 2] = this.getSelectionStart(n);
                nArray[(n - n3) * 2 + 1] = this.getSelectionEnd(n);
                if (n2 == 0) continue;
            }
            int n5 = this.getSelectionStart();
            CaretModel caretModel = this.getCaretModel();
            this.getSelectionModel().clearSelection();
            for (n = n4; n >= n3; --n) {
                try {
                    this.getDocument().remove(nArray[(n - n3) * 2], nArray[(n - n3) * 2 + 1] - nArray[(n - n3) * 2]);
                    if (n2 == 0) {
                        continue;
                    }
                    break block5;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (n2 == 0) continue;
            }
            caretModel.setOffset(n5);
        }
    }

    private void b(String string) {
        com.jidesoft.editor.a.deleteSelectedText(this);
        com.jidesoft.editor.a.insertStringAtCaret(this, string, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void insertChar(String var1_1) {
        block23: {
            block26: {
                block25: {
                    block24: {
                        var7_2 = KeywordMap.c;
                        v0 = this.isEditable();
                        if (var7_2 != 0) break block24;
                        if (v0 == 0) break block25;
                        v0 = this.isEnabled();
                    }
                    if (var7_2 != 0) ** GOTO lbl16
                    if (v0 != 0) break block26;
                }
                PortingUtils.notifyUser();
                return;
            }
            try {
                block34: {
                    block33: {
                        block27: {
                            block21: {
                                block29: {
                                    block31: {
                                        block32: {
                                            block30: {
                                                block28: {
                                                    this._document.beginCompoundEdit();
                                                    v0 = this.getInputHandler().getRepeatCount();
lbl16:
                                                    // 2 sources

                                                    var2_3 = v0;
                                                    v1 = "\t".equals(var1_1);
                                                    if (var7_2 != 0) break block27;
                                                    if (v1 == 0) break block21;
                                                    v1 = this.isReplaceTabWithSpace();
                                                    if (var7_2 != 0) break block27;
                                                    if (v1 == 0) break block21;
                                                    v1 = var3_4 = this.getTabSize();
                                                    if (var7_2 != 0) break block27;
                                                    if (v1 < 1) break block21;
                                                    v2 = this.isTabAlignment();
                                                    if (var7_2 != 0) break block28;
                                                    if (v2 == 0) break block29;
                                                    v2 = var2_3;
                                                }
                                                if (var7_2 != 0) break block30;
                                                if (v2 != 1) break block29;
                                                v2 = (int)this.getSelectionModel().hasSelection();
                                            }
                                            if (var7_2 != 0) break block31;
                                            if (v2 != 0) break block32;
                                            var3_4 -= this.getCaretModel().getViewPosition().column % var3_4;
                                            if (var7_2 == 0) break block29;
                                        }
                                        v2 = var3_4 - this.b(this.getSelectionStart(), this.getSelectionStartLine()) % var3_4;
                                    }
                                    var3_4 = v2;
                                }
                                var4_6 = new StringBuffer(var3_4);
                                for (var5_8 = 0; var5_8 < var3_4; ++var5_8) {
                                    var4_6.append(' ');
                                    if (var7_2 == 0) {
                                        if (var7_2 == 0) continue;
                                    }
                                    break block21;
                                }
                                var1_1 = var4_6.toString();
                            }
                            v1 = this.isEditable();
                        }
                        if (var7_2 != 0) break block33;
                        if (v1 == 0) break block34;
                        v1 = this.isEnabled();
                    }
                    if (v1 != 0) {
                        block22: {
                            var3_5 = new StringBuffer();
                            for (var4_7 = 0; var4_7 < var2_3; ++var4_7) {
                                var3_5.append(var1_1);
                                if (var7_2 == 0) {
                                    if (var7_2 == 0) continue;
                                }
                                break block22;
                            }
                            this.a(var3_5.toString());
                        }
                        if (var7_2 == 0) break block23;
                    }
                }
                PortingUtils.notifyUser();
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void joinLines() {
        block28: {
            block33: {
                block32: {
                    block31: {
                        var7_1 = KeywordMap.c;
                        v0 = this.isEditable();
                        if (var7_1 != 0) break block31;
                        if (v0 == 0) break block32;
                        v0 = this.isEnabled();
                    }
                    if (var7_1 != 0) ** GOTO lbl16
                    if (v0 != 0) break block33;
                }
                PortingUtils.notifyUser();
                return;
            }
            try {
                block35: {
                    block29: {
                        block34: {
                            this._document.beginCompoundEdit();
                            v0 = (int)this.getSelectionModel().hasSelection();
lbl16:
                            // 2 sources

                            if (var7_1 == 0) {
                                if (v0 == 0) {
                                    block27: {
                                        var1_2 = this.getCaretModel().getModelPosition().line;
                                        var2_3 = this.getLineEndOffset(var1_2);
                                        try {
                                            v1 = var1_2;
                                            if (var7_1 == 0) {
                                                if (v1 < 0) break block27;
                                                v1 = var1_2;
                                            }
                                            if (v1 < this.getLineCount() - 1) {
                                                this._document.remove(var2_3, 1 + TextUtils.getLeadingWhitespace(this.getLineText(var1_2 + 1)).length());
                                                this._document.insertString(var2_3, " ", null);
                                            }
                                        }
                                        catch (BadLocationException var3_4) {
                                            CodeEditor.a.warning(var3_4.getLocalizedMessage());
                                        }
                                    }
                                    this.select(var2_3);
                                    if (var7_1 == 0) break block28;
                                }
                                v0 = this.getSelectionEndLine();
                            }
                            if (var7_1 != 0) break block34;
                            if (v0 == this.getSelectionStartLine()) break block35;
                            v0 = this.getSelectionStartLine();
                        }
                        var1_2 = v0;
                        var2_3 = this.getSelectionEndLine();
                        try {
                            block37: {
                                block36: {
                                    var3_5 = this._document.getText(this.getSelectionEnd() - 1, 1);
                                    v2 = var3_5.equals("\n");
                                    if (var7_1 != 0) break block36;
                                    if (v2) break block37;
                                    v2 = var3_5.equals("\r");
                                }
                                if (!v2) break block29;
                            }
                            --var2_3;
                        }
                        catch (BadLocationException var3_6) {
                            CodeEditor.a.warning(var3_6.getLocalizedMessage());
                        }
                    }
                    v3 = var2_3 - var1_2;
                    v4 = 1;
                    if (var7_1 != 0) ** GOTO lbl61
                    if (v3 >= v4) {
                        v3 = var2_3;
                        v4 = 1;
lbl61:
                        // 4 sources

                        for (var3_7 = (v33455) - (v33456); var3_7 >= var1_2; --var3_7) {
                            var4_8 = this.getLineEndOffset(var3_7);
                            try {
                                this._document.remove(var4_8, 1 + TextUtils.getLeadingWhitespace(this.getLineText(var3_7 + 1)).length());
                                this._document.insertString(var4_8, " ", null);
                                if (var7_1 == 0) {
                                    continue;
                                }
                                break;
                            }
                            catch (BadLocationException var5_9) {
                                CodeEditor.a.warning(var5_9.getLocalizedMessage());
                            }
                            if (var7_1 == 0) continue;
                            break;
                        }
                    } else {
                        PortingUtils.notifyUser();
                    }
                    if (var7_1 == 0) break block28;
                }
                PortingUtils.notifyUser();
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void toggleCase() {
        block13: {
            block14: {
                block12: {
                    block11: {
                        var6_1 = KeywordMap.c;
                        v0 = this.isEditable();
                        if (var6_1 != 0) break block11;
                        if (!v0) break block12;
                        v0 = this.isEnabled();
                    }
                    if (var6_1 != 0) break block13;
                    if (v0) break block14;
                }
                PortingUtils.notifyUser();
                return;
            }
            v1 = this.getSelectionModel();
            if (var6_1 != 0) ** GOTO lbl23
            v0 = v1.hasSelection();
        }
        if (!v0) {
            PortingUtils.notifyUser();
            return;
        }
        try {
            block17: {
                block16: {
                    block15: {
                        this._document.beginCompoundEdit();
                        v1 = this.getSelectionModel();
lbl23:
                        // 2 sources

                        var1_2 = v1.getSelectedText();
                        var2_3 = this.getSelectionStart();
                        var3_4 = this.getSelectionEnd();
                        var4_5 = this.getSelectionModel().isColumnSelectionMode();
                        if (var6_1 != 0) break block15;
                        if (!Character.isUpperCase(var1_2.charAt(0))) break block16;
                        this.setSelectedText(var1_2.toLowerCase());
                    }
                    if (var6_1 == 0) break block17;
                }
                this.setSelectedText(var1_2.toUpperCase());
            }
            this.getSelectionModel().setColumnSelectionMode(var4_5);
            this.getSelectionModel().setSelection(var2_3, var3_4);
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void duplicateSelection() {
        block10: {
            block13: {
                block12: {
                    block11: {
                        var4_1 = KeywordMap.c;
                        v0 = this.isEditable();
                        if (var4_1 != 0) break block11;
                        if (!v0) break block12;
                        v1 = this;
                        if (var4_1 != 0) ** GOTO lbl17
                        v0 = v1.isEnabled();
                    }
                    if (v0) break block13;
                }
                PortingUtils.notifyUser();
                return;
            }
            this._document.beginCompoundEdit();
            try {
                block16: {
                    block17: {
                        block20: {
                            block21: {
                                block18: {
                                    block19: {
                                        block15: {
                                            block14: {
                                                v1 = this;
lbl17:
                                                // 2 sources

                                                v2 = var1_2 = v1.getSelectedText();
                                                if (var4_1 != 0) break block14;
                                                if (v2 == null) break block15;
                                                v2 = var1_2;
                                            }
                                            v3 = v2.length();
                                            if (var4_1 != 0) break block16;
                                            if (v3 != 0) break block17;
                                        }
                                        var2_3 = this.getCaretModel().getOffset();
                                        this.selectLine(this.getCaretModel().getModelPosition().line);
                                        v4 = var1_2 = this.getSelectedText();
                                        if (var4_1 != 0) break block18;
                                        if (v4 != null) break block19;
                                        this.setSelectedText("\n");
                                        this.getCaretModel().setOffset(var2_3 + 1);
                                        if (var4_1 == 0) break block20;
                                    }
                                    v4 = var1_2;
                                }
                                if (v4.endsWith("\n")) break block21;
                                this.setSelectedText(var1_2 + "\n" + var1_2);
                                this.getCaretModel().setOffset(var2_3 + var1_2.length() + 1);
                                if (var4_1 == 0) break block20;
                            }
                            this.setSelectedText(var1_2 + var1_2);
                            this.getCaretModel().setOffset(var2_3 + var1_2.length());
                        }
                        if (var4_1 == 0) break block10;
                    }
                    this.setSelectedText(var1_2 + var1_2);
                    v3 = this.getCaretModel().getOffset();
                }
                var2_3 = v3;
                this.select(var2_3 - var1_2.length(), var2_3);
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void backspaceChar() {
        block18: {
            block21: {
                block20: {
                    block19: {
                        var4_1 = KeywordMap.c;
                        v0 = this.isEditable();
                        if (var4_1 != 0) break block19;
                        if (v0 == 0) break block20;
                        v0 = this.isEnabled();
                    }
                    if (var4_1 != 0) ** GOTO lbl16
                    if (v0 != 0) break block21;
                }
                PortingUtils.notifyUser();
                return;
            }
            this._document.beginCompoundEdit();
            try {
                v0 = this.getSelectionStart();
lbl16:
                // 2 sources

                if (var4_1 == 0) {
                    if (v0 != this.getSelectionEnd()) {
                        v1 = this;
                        if (var4_1 == 0) {
                            if (v1.getSelectionModel().isColumnSelectionMode()) {
                                this.i();
                                if (var4_1 == 0) break block18;
                            }
                            v1 = this;
                        }
                        v1.setSelectedText("");
                        if (var4_1 == 0) break block18;
                    }
                    v0 = var1_2 = this.getCaretModel().getOffset();
                }
                if (var4_1 == 0) {
                    if (var1_2 == 0) {
                        PortingUtils.notifyUser();
                        return;
                    }
                    try {
                        this.getDocument().remove(var1_2 - 1, 1);
                    }
                    catch (BadLocationException var2_3) {
                        CodeEditor.a.warning(var2_3.getLocalizedMessage());
                    }
                }
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void backspaceWord() {
        block18: {
            block17: {
                block16: {
                    var8_1 = KeywordMap.c;
                    v0 = this.isEditable();
                    if (var8_1 != 0) break block16;
                    if (v0 == 0) break block17;
                    v0 = this.isEnabled();
                }
                if (var8_1 != 0) ** GOTO lbl16
                if (v0 != 0) break block18;
            }
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            block21: {
                block20: {
                    block19: {
                        v0 = this.getSelectionStart();
lbl16:
                        // 2 sources

                        v1 = var1_2 = v0;
                        if (var8_1 == 0) {
                            if (v1 != this.getSelectionEnd()) {
                                this.setSelectedText("");
                            }
                            v1 = this.getCaretModel().getModelPosition().line;
                        }
                        var2_3 = v1;
                        var3_4 = this.getLineStartOffset(var2_3);
                        var4_5 = var1_2 - var3_4;
                        var5_6 = this.getLineText(this.getCaretModel().getModelPosition().line);
                        v2 = var4_5;
                        if (var8_1 != 0) break block19;
                        if (v2 != 0) break block20;
                        v2 = var3_4;
                    }
                    if (v2 == 0) {
                        PortingUtils.notifyUser();
                        return;
                    }
                    --var4_5;
                    if (var8_1 == 0) break block21;
                }
                var6_7 = (String)this.getDocument().getProperty("nonwordDelimiters");
                var4_5 = TextUtils.findWordStart(var5_6, var4_5, var6_7);
            }
            try {
                this.getDocument().remove(var4_5 + var3_4, var1_2 - (var4_5 + var3_4));
            }
            catch (BadLocationException var6_8) {
                CodeEditor.a.warning(var6_8.getLocalizedMessage());
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void deleteChar() {
        block18: {
            block21: {
                block20: {
                    block19: {
                        var4_1 = KeywordMap.c;
                        v0 = this.isEditable();
                        if (var4_1 != 0) break block19;
                        if (v0 == 0) break block20;
                        v0 = this.isEnabled();
                    }
                    if (var4_1 != 0) ** GOTO lbl16
                    if (v0 != 0) break block21;
                }
                PortingUtils.notifyUser();
                return;
            }
            this._document.beginCompoundEdit();
            try {
                v0 = this.getSelectionStart();
lbl16:
                // 2 sources

                if (var4_1 == 0) {
                    if (v0 != this.getSelectionEnd()) {
                        v1 = this;
                        if (var4_1 == 0) {
                            if (v1.getSelectionModel().isColumnSelectionMode()) {
                                this.i();
                                if (var4_1 == 0) break block18;
                            }
                            v1 = this;
                        }
                        v1.setSelectedText("");
                        if (var4_1 == 0) break block18;
                    }
                    v0 = var1_2 = this.getCaretModel().getOffset();
                }
                if (var4_1 == 0) {
                    if (var1_2 == this.getDocumentLength()) {
                        PortingUtils.notifyUser();
                        return;
                    }
                    try {
                        this.getDocument().remove(var1_2, 1);
                    }
                    catch (BadLocationException var2_3) {
                        CodeEditor.a.warning(var2_3.getLocalizedMessage());
                    }
                }
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void deleteWord() {
        block18: {
            block17: {
                block16: {
                    var8_1 = KeywordMap.c;
                    v0 = this.isEditable();
                    if (var8_1 != 0) break block16;
                    if (v0 == 0) break block17;
                    v0 = this.isEnabled();
                }
                if (var8_1 != 0) ** GOTO lbl16
                if (v0 != 0) break block18;
            }
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            block21: {
                block20: {
                    block19: {
                        v0 = this.getSelectionStart();
lbl16:
                        // 2 sources

                        v1 = var1_2 = v0;
                        if (var8_1 == 0) {
                            if (v1 != this.getSelectionEnd()) {
                                this.setSelectedText("");
                            }
                            v1 = this.getCaretModel().getModelPosition().line;
                        }
                        var2_3 = v1;
                        var3_4 = this.getLineStartOffset(var2_3);
                        var4_5 = var1_2 - var3_4;
                        var5_6 = this.getLineText(this.getCaretModel().getModelPosition().line);
                        v2 = var4_5;
                        v3 = var5_6.length();
                        if (var8_1 != 0) break block19;
                        if (v2 != v3) break block20;
                        v2 = var3_4 + var4_5;
                        v3 = this.getDocumentLength();
                    }
                    if (v2 == v3) {
                        PortingUtils.notifyUser();
                        return;
                    }
                    ++var4_5;
                    if (var8_1 == 0) break block21;
                }
                var6_7 = (String)this.getDocument().getProperty("nonwordDelimiters");
                var4_5 = TextUtils.findWordEnd(var5_6, var4_5, var6_7);
            }
            try {
                this.getDocument().remove(var1_2, var4_5 + var3_4 - var1_2);
            }
            catch (BadLocationException var6_8) {
                CodeEditor.a.warning(var6_8.getLocalizedMessage());
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLine() {
        int n;
        int n2;
        block15: {
            block16: {
                block14: {
                    block13: {
                        n2 = KeywordMap.c;
                        n = this.isEditable();
                        if (n2 != 0) break block13;
                        if (n == 0) break block14;
                        n = this.isEnabled();
                    }
                    if (n2 != 0) break block15;
                    if (n != 0) break block16;
                }
                PortingUtils.notifyUser();
                return;
            }
            n = this.getCaretModel().getModelPosition().line;
        }
        int n3 = n;
        int n4 = this.getLineStartOffset(n3);
        int n5 = this.getLineEndOffset(n3);
        try {
            if (n2 == 0) {
                if (n5 > this.getDocumentLength()) {
                    if (n4 != 0) {
                        --n4;
                    }
                    --n5;
                }
                this._document.beginCompoundEdit();
                try {
                    this._document.remove(n4, n5 - n4);
                }
                catch (BadLocationException badLocationException) {
                    a.warning(badLocationException.getLocalizedMessage());
                }
            }
        }
        finally {
            this._document.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void clipboardCut() {
        block11: {
            block14: {
                block13: {
                    block12: {
                        var2_1 = KeywordMap.c;
                        v0 = this.isEditable();
                        if (var2_1 != 0) break block12;
                        if (!v0) break block13;
                        v0 = this.isEnabled();
                    }
                    if (var2_1 != 0) ** GOTO lbl19
                    if (v0) break block14;
                }
                PortingUtils.notifyUser();
                return;
            }
            this._document.beginCompoundEdit();
            try {
                block15: {
                    this.clipboardCopy();
                    v1 = this;
                    if (var2_1 != 0) break block15;
                    v0 = v1.getSelectionModel().isColumnSelectionMode();
lbl19:
                    // 2 sources

                    if (v0) {
                        this.i();
                        if (var2_1 == 0) break block11;
                    }
                    v1 = this;
                }
                v1.setSelectedText("");
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void clipboardMove(int var1_1) {
        block11: {
            block14: {
                block13: {
                    block12: {
                        var4_2 = KeywordMap.c;
                        v0 = this.isEditable();
                        if (var4_2 != 0) break block12;
                        if (v0 == 0) break block13;
                        v0 = this.isEnabled();
                    }
                    if (var4_2 != 0) ** GOTO lbl16
                    if (v0 != 0) break block14;
                }
                PortingUtils.notifyUser();
                return;
            }
            this._document.beginCompoundEdit();
            try {
                v0 = var1_1;
lbl16:
                // 2 sources

                v1 = this.getSelectionStart();
                if (var4_2 == 0) {
                    if (v0 < v1) {
                        this.clipboardCut();
                        this.getCaretModel().setOffset(var1_1);
                        this.clipboardPaste();
                        if (var4_2 == 0) break block11;
                    }
                    v0 = var1_1;
                    v1 = this.getSelectionEnd();
                }
                if (var4_2 == 0) {
                    if (v0 <= v1) break block11;
                    v0 = this.getSelectionEnd();
                    v1 = this.getSelectionStart();
                }
                var2_3 = Math.abs(v0 - v1);
                this.clipboardCut();
                this.getCaretModel().setOffset(var1_1 - var2_3);
                this.clipboardPaste();
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    public void clipboardCopy() {
        block12: {
            List<Transferable> list;
            StringSelection stringSelection;
            Clipboard clipboard;
            block11: {
                StringBuffer stringBuffer;
                StringBuffer stringBuffer2;
                int n;
                block10: {
                    n = KeywordMap.c;
                    CodeEditor codeEditor = this;
                    if (n == 0) {
                        if (!codeEditor.getSelectionModel().hasSelection()) {
                            this.selectLine(this.getCaretModel().getModelPosition().line);
                        }
                        codeEditor = this;
                    }
                    clipboard = codeEditor.getToolkit().getSystemClipboard();
                    String string = this.getSelectedText();
                    int n2 = this.getInputHandler().getRepeatCount();
                    stringBuffer2 = new StringBuffer();
                    for (int i = 0; i < n2; ++i) {
                        stringBuffer = stringBuffer2.append(string);
                        if (n == 0) {
                            if (n == 0) continue;
                        }
                        break block10;
                    }
                    stringBuffer = new StringBuffer();
                }
                StringBuffer stringBuffer3 = stringBuffer;
                this.exportText(stringBuffer2.toString(), stringBuffer3);
                stringSelection = new StringSelection(stringBuffer3.toString());
                list = this._clipboards;
                if (n != 0) break block11;
                if (list == null) {
                    this._clipboards = new ArrayList<Transferable>();
                }
                this._clipboards.add(0, stringSelection);
                if (n != 0) break block12;
                list = this._clipboards;
            }
            if (list.size() > this.getMaxNumberOfClipboards()) {
                this._clipboards.remove(this._clipboards.size() - 1);
            }
            clipboard.setContents(stringSelection, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void clipboardPaste() {
        block11: {
            block10: {
                block9: {
                    var3_1 = KeywordMap.c;
                    v0 = this.isEditable();
                    if (var3_1 != 0) break block9;
                    if (!v0) break block10;
                    v0 = this.isEnabled();
                }
                if (var3_1 != 0) ** GOTO lbl18
                if (v0) break block11;
            }
            PortingUtils.notifyUser();
            return;
        }
        this._document.beginCompoundEdit();
        try {
            block12: {
                v1 = this;
                if (var3_1 != 0) break block12;
                v0 = v1._editable;
lbl18:
                // 2 sources

                if (v0) {
                    var1_2 = this.getToolkit().getSystemClipboard();
                    this.a(var1_2.getContents(this));
                }
                v1 = this;
            }
            v1._document.endCompoundEdit();
        }
        catch (Throwable var2_3) {
            this._document.endCompoundEdit();
            throw var2_3;
        }
    }

    private void a(Transferable transferable) {
        block7: {
            int n = KeywordMap.c;
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                int n2 = this.getInputHandler().getRepeatCount();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(string);
                    if (n == 0) {
                        if (n == 0) continue;
                    }
                    break block7;
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                this.importText(stringBuffer.toString(), stringBuffer2);
                CodeEditor codeEditor = this;
                if (n == 0) {
                    if (codeEditor.getSelectionModel().isColumnSelectionMode()) {
                        this.getSelectionModel().clearSelection();
                        String[] stringArray = stringBuffer2.toString().split(TextUtils.getLineBreak(1));
                        int[] nArray = this.a(stringArray, this.getCaretModel().getModelPosition().line);
                        this.a(nArray[0], nArray[1]);
                        if (n == 0) break block7;
                    }
                    codeEditor = this;
                }
                codeEditor.setSelectedText(stringBuffer2.toString());
            }
            catch (Exception exception) {
                PortingUtils.notifyUser();
                a.warning(exception.getLocalizedMessage());
            }
        }
    }

    private boolean c(String string) {
        int n;
        block3: {
            char[] cArray;
            int n2 = KeywordMap.c;
            char[] cArray2 = cArray = string.toCharArray();
            int n3 = cArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                block4: {
                    block5: {
                        int n5;
                        block8: {
                            int n6;
                            block7: {
                                int n7;
                                block6: {
                                    n7 = cArray2[n4];
                                    if (n2 != 0) break block4;
                                    n = n7;
                                    if (n2 != 0) break block3;
                                    if (n == 32) break block5;
                                    n5 = n7;
                                    n6 = 9;
                                    if (n2 != 0) break block6;
                                    if (n5 == n6) break block5;
                                    n5 = n7;
                                    n6 = 114;
                                }
                                if (n2 != 0) break block7;
                                if (n5 == n6) break block5;
                                n5 = n7;
                                if (n2 != 0) break block8;
                                n6 = 10;
                            }
                            if (n5 == n6) break block5;
                            n5 = 0;
                        }
                        return n5 != 0;
                    }
                    ++n4;
                }
                if (n2 == 0) continue;
            }
            n = 1;
        }
        return n != 0;
    }

    private int[] a(String[] stringArray, int n) {
        int n2 = KeywordMap.c;
        CaretPosition caretPosition = this.getCaretModel().getModelPosition();
        int[] nArray = new int[2];
        int n3 = -1;
        int n4 = 1;
        Element element = this.getDocument().getDefaultRootElement();
        int n5 = n;
        while (n5 < n + stringArray.length) {
            block15: {
                block11: {
                    int n6;
                    block12: {
                        String string;
                        block13: {
                            StringBuffer stringBuffer;
                            block10: {
                                CodeEditor codeEditor;
                                Element element2;
                                block14: {
                                    if (n5 >= element.getElementCount()) break block11;
                                    string = stringArray[n5 - n];
                                    this.getCaretModel().setModelPosition(new CaretPosition(n5, caretPosition.column));
                                    element2 = element.getElement(n5);
                                    n6 = element2.getEndOffset() - element2.getStartOffset() - 2;
                                    if (n2 != 0) break block12;
                                    if (n6 >= caretPosition.column) break block13;
                                    codeEditor = this;
                                    if (n2 != 0) break block14;
                                    if (codeEditor.c(string)) break block11;
                                    codeEditor = this;
                                }
                                codeEditor.getCaretModel().setModelPosition(new CaretPosition(n5, element2.getEndOffset() - element2.getStartOffset() - 2));
                                stringBuffer = new StringBuffer();
                                for (int i = 0; i < caretPosition.column - element2.getEndOffset() + element2.getStartOffset() + 2; ++i) {
                                    stringBuffer.append(' ');
                                    if (n2 == 0) {
                                        if (n2 == 0) continue;
                                    }
                                    break block10;
                                }
                                if (n5 == element.getElementCount() - 1) {
                                    stringBuffer.deleteCharAt(0);
                                }
                            }
                            string = stringBuffer.toString() + string;
                        }
                        n3 = com.jidesoft.editor.a.insertStringAtCaret(this, string, false, false);
                        if (n2 != 0) break block15;
                        n6 = n4;
                    }
                    if (n6 != 0) {
                        n4 = 0;
                        nArray[0] = n3;
                    }
                }
                ++n5;
            }
            if (n2 == 0) continue;
        }
        int n7 = nArray[0];
        if (n2 == 0) {
            n7 = n7 == -1 ? -1 : n3;
        }
        nArray[1] = n7;
        this.getCaretModel().setModelPosition(caretPosition);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteWithDialog() {
        ClipboardsDialog clipboardsDialog;
        int n;
        block17: {
            Window window;
            block16: {
                CodeEditor codeEditor;
                block14: {
                    block15: {
                        block13: {
                            boolean bl;
                            block12: {
                                n = KeywordMap.c;
                                bl = this.isEditable();
                                if (n != 0) break block12;
                                if (!bl) break block13;
                                codeEditor = this;
                                if (n != 0) break block14;
                                bl = codeEditor.isEnabled();
                            }
                            if (bl) break block15;
                        }
                        PortingUtils.notifyUser();
                        return;
                    }
                    codeEditor = this;
                }
                if (!((window = JideSwingUtilities.getWindowForComponent(codeEditor)) instanceof Frame)) break block16;
                clipboardsDialog = new ClipboardsDialog((Frame)window, this.getResourceString("Clipboard.pasteDialogTitle"), this._clipboards, this._painter.getFont());
                if (n == 0) break block17;
            }
            clipboardsDialog = new ClipboardsDialog((Dialog)window, this.getResourceString("Clipboard.pasteDialogTitle"), this._clipboards, this._painter.getFont());
        }
        clipboardsDialog.pack();
        clipboardsDialog.setLocationRelativeTo(this);
        clipboardsDialog.setVisible(true);
        int n2 = clipboardsDialog.getDialogResult();
        if (n2 == 0) {
            Transferable transferable = clipboardsDialog.getSelectedClipboard();
            if (n == 0 && transferable != null) {
                this._clipboards.remove(transferable);
                this._clipboards.add(0, transferable);
                this._document.beginCompoundEdit();
                try {
                    this.l = true;
                    this.a(transferable);
                }
                finally {
                    this.l = false;
                    this._document.endCompoundEdit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void lineComments() {
        block31: {
            block36: {
                block35: {
                    block34: {
                        var10_1 = KeywordMap.c;
                        v0 = this.isEditable();
                        if (var10_1 != 0) break block34;
                        if (!v0) break block35;
                        v1 = this;
                        if (var10_1 != 0) ** GOTO lbl17
                        v0 = v1.isEnabled();
                    }
                    if (v0) break block36;
                }
                PortingUtils.notifyUser();
                return;
            }
            try {
                block32: {
                    block37: {
                        block38: {
                            this._document.beginCompoundEdit();
                            v1 = this._document.getProperty("lineComment");
lbl17:
                            // 2 sources

                            var1_2 = (String)v1;
                            if (var10_1 != 0 || var1_2 == null) {
                                return;
                            }
                            v2 = this.getSelectionModel().hasSelection();
                            if (var10_1 != 0) break block37;
                            if (v2 != 0) break block38;
                            var2_3 = this.getCaretModel().getModelPosition().line;
                            var3_4 = this.getLineStartOffset(var2_3);
                            var4_5 = this.a(var2_3, var1_2);
                            try {
                                block41: {
                                    block39: {
                                        block40: {
                                            if (var10_1 != 0) break block39;
                                            if (var4_5 == -1) break block40;
                                            this._document.remove(var3_4 + var4_5, var1_2.length());
                                            if (var10_1 == 0) break block41;
                                        }
                                        this._document.insertString(var3_4, var1_2, null);
                                    }
                                    this.getCaretModel().setOffset(var3_4);
                                }
                                this.getCaretModel().moveCaret(0, 1, false, true, true);
                            }
                            catch (BadLocationException var5_9) {
                                CodeEditor.a.warning(var5_9.getLocalizedMessage());
                            }
                            if (var10_1 == 0) break block31;
                        }
                        v2 = this.getSelectionStartLine();
                    }
                    var2_3 = v2;
                    var3_4 = this.getSelectionEndLine();
                    try {
                        block43: {
                            block42: {
                                var4_6 = this._document.getText(this.getSelectionEnd() - 1, 1);
                                v3 = var4_6.equals("\n");
                                if (var10_1 != 0) break block42;
                                if (v3) break block43;
                                v3 = var4_6.equals("\r");
                            }
                            if (!v3) break block32;
                        }
                        --var3_4;
                    }
                    catch (BadLocationException var4_7) {
                        CodeEditor.a.warning(var4_7.getLocalizedMessage());
                    }
                }
                var4_8 = 1;
                var5_10 = var3_4;
                while (var5_10 >= var2_3) {
                    block44: {
                        var6_11 = this.a(var5_10, var1_2);
                        if (var10_1 != 0) break block44;
                        v4 = var6_11;
                        v5 = -1;
                        if (var10_1 != 0) ** GOTO lbl79
                        if (v4 == v5) {
                            var4_8 = 0;
                            if (var10_1 == 0) break;
                        }
                        --var5_10;
                    }
                    if (var10_1 == 0) continue;
                }
                var5_10 = var3_4;
                do {
                    block33: {
                        v4 = var5_10;
                        v5 = var2_3;
lbl79:
                        // 2 sources

                        if (v4 < v5) break block31;
                        var6_11 = this.getLineStartOffset(var5_10);
                        if (var10_1 != 0) break block31;
                        v6 = var4_8;
                        if (var10_1 == 0) {
                            v6 = v6 != 0 ? this.a(var5_10, var1_2) : -1;
                        }
                        var7_12 = v6;
                        try {
                            block46: {
                                block45: {
                                    if (var10_1 != 0) break block45;
                                    if (var7_12 == -1) break block46;
                                    this._document.remove(var6_11 + var7_12, var1_2.length());
                                }
                                if (var10_1 == 0) break block33;
                            }
                            this._document.insertString(var6_11, var1_2, null);
                        }
                        catch (BadLocationException var8_13) {
                            CodeEditor.a.warning(var8_13.getLocalizedMessage());
                        }
                    }
                    --var5_10;
                } while (var10_1 == 0);
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    private int a(int n, String string) {
        String string2 = this.getLineText(n);
        return this.a(string2, string);
    }

    private int a(String string, String string2) {
        int n;
        int n2 = KeywordMap.c;
        String string3 = TextUtils.getLeadingWhitespace(string);
        int n3 = string.length();
        if (n2 == 0) {
            n3 = n3 >= string3.length() + string2.length() ? (int)(string2.equals(string.substring(string3.length(), string3.length() + string2.length())) ? 1 : 0) : 0;
        }
        int n4 = n = n3;
        if (n2 == 0) {
            n4 = n4 != 0 ? string3.length() : -1;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void blockComments() {
        block16: {
            block19: {
                block18: {
                    block17: {
                        var7_1 = KeywordMap.c;
                        v0 = this.isEditable();
                        if (var7_1 != 0) break block17;
                        if (!v0) break block18;
                        v1 = this;
                        if (var7_1 != 0) ** GOTO lbl17
                        v0 = v1.isEnabled();
                    }
                    if (v0) break block19;
                }
                PortingUtils.notifyUser();
                return;
            }
            try {
                this._document.beginCompoundEdit();
                v1 = this._document.getProperty("blockCommentStart");
lbl17:
                // 2 sources

                var1_2 = (String)v1;
                var2_3 = (String)this._document.getProperty("blockCommentEnd");
                if (var7_1 != 0 || var1_2 == null || var2_3 == null) {
                    return;
                }
                v2 = this.getSelectionModel().hasSelection();
                if (var7_1 == 0) {
                    if (v2 == 0) {
                        var3_4 = this.getCaretModel().getOffset();
                        try {
                            this._document.insertString(var3_4, var1_2 + var2_3, null);
                        }
                        catch (BadLocationException var4_5) {
                            CodeEditor.a.warning(var4_5.getLocalizedMessage());
                        }
                        if (var7_1 == 0) break block16;
                    }
                    v2 = this.getSelectionStart();
                }
                var3_4 = v2;
                var4_6 = this.getSelectionEnd();
                try {
                    this._document.insertString(var4_6, var2_3, null);
                    this._document.insertString(var3_4, var1_2, null);
                }
                catch (BadLocationException var5_7) {
                    CodeEditor.a.warning(var5_7.getLocalizedMessage());
                }
            }
            finally {
                this._document.endCompoundEdit();
            }
        }
    }

    private FoldingSpanListener j() {
        FoldingSpanListener foldingSpanListener = this.f;
        if (KeywordMap.c == 0) {
            if (foldingSpanListener == null) {
                this.f = new FoldingSpanListener(){

                    public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
                        if (!foldingSpanEvent.isAdjusting()) {
                            CodeEditor.this.getCaretModel().updateViewPosition();
                            CodeEditor.this._painter.invalidateLineRange(CodeEditor.this.viewToModelLine(CodeEditor.this.getFirstLine()), CodeEditor.this.viewToModelLine(CodeEditor.this.getFirstLine() + CodeEditor.this.getVisibleLines()));
                            CodeEditor.this.i.reset();
                            CodeEditor.this.updateScrollBars();
                        }
                    }
                };
            }
            foldingSpanListener = this.f;
        }
        return foldingSpanListener;
    }

    public FoldingModel getFoldingModel() {
        FoldingModel foldingModel = this.e;
        if (KeywordMap.c == 0) {
            if (foldingModel == null) {
                this.e = new DefaultFoldingModel(this);
                this.e.setEnabled(true);
                this.e.addFoldingSpanListener(this.j());
            }
            foldingModel = this.e;
        }
        return foldingModel;
    }

    public void setFoldingModel(FoldingModel foldingModel) {
        block6: {
            FoldingModel foldingModel2;
            block7: {
                int n;
                block5: {
                    n = KeywordMap.c;
                    foldingModel2 = this.e;
                    if (n != 0) break block5;
                    if (foldingModel2 == foldingModel) break block6;
                    foldingModel2 = this.e;
                }
                if (n == 0) {
                    if (foldingModel2 != null) {
                        this.e.removeFoldingSpanListener(this.j());
                    }
                    foldingModel2 = this.e = foldingModel;
                }
                if (n != 0) break block7;
                if (foldingModel2 == null) break block6;
                foldingModel2 = this.e;
            }
            foldingModel2.addFoldingSpanListener(this.j());
        }
    }

    public void expandFolding() {
        block7: {
            int n;
            int n2;
            block10: {
                block9: {
                    FoldingSpan foldingSpan;
                    FoldingSpan foldingSpan2;
                    block8: {
                        int n3;
                        block6: {
                            n2 = KeywordMap.c;
                            FoldingModel foldingModel = this.getFoldingModel();
                            n3 = foldingModel.isEnabled();
                            if (n2 != 0) break block6;
                            if (n3 == 0) break block7;
                            n3 = this.getCaretModel().getModelPosition().line;
                        }
                        int n4 = n3;
                        foldingSpan = foldingSpan2 = DefaultFoldingModel.findFoldingSpanStartingAtLine(this, n4);
                        if (n2 != 0) break block8;
                        if (foldingSpan == null) break block9;
                        foldingSpan = foldingSpan2;
                    }
                    n = foldingSpan.isExpanded();
                    if (n2 != 0) break block10;
                    if (n != 0) break block9;
                    foldingSpan2.setExpanded(true);
                    if (n2 == 0) break block7;
                }
                n = this.getCaretModel().getOffset();
            }
            int n5 = n;
            FoldingSpan[] foldingSpanArray = DefaultFoldingModel.getFoldingSpanAtOffset(this, n5);
            int n6 = foldingSpanArray.length - 1;
            while (n6 >= 0) {
                FoldingSpan foldingSpan = foldingSpanArray[n6];
                if (n2 == 0) {
                    if (!foldingSpan.isExpanded()) {
                        foldingSpan.setExpanded(true);
                        if (n2 == 0) break;
                    }
                    --n6;
                }
                if (n2 == 0) continue;
            }
        }
    }

    public void collapseFolding() {
        block7: {
            int n;
            int n2;
            block10: {
                block9: {
                    FoldingSpan foldingSpan;
                    FoldingSpan foldingSpan2;
                    block8: {
                        int n3;
                        block6: {
                            n2 = KeywordMap.c;
                            FoldingModel foldingModel = this.getFoldingModel();
                            n3 = foldingModel.isEnabled();
                            if (n2 != 0) break block6;
                            if (n3 == 0) break block7;
                            n3 = this.getCaretModel().getModelPosition().line;
                        }
                        int n4 = n3;
                        foldingSpan = foldingSpan2 = DefaultFoldingModel.findFoldingSpanStartingAtLine(this, n4);
                        if (n2 != 0) break block8;
                        if (foldingSpan == null) break block9;
                        foldingSpan = foldingSpan2;
                    }
                    n = foldingSpan.isExpanded();
                    if (n2 != 0) break block10;
                    if (n == 0) break block9;
                    foldingSpan2.setExpanded(false);
                    if (n2 == 0) break block7;
                }
                n = this.getCaretModel().getOffset();
            }
            int n5 = n;
            FoldingSpan[] foldingSpanArray = DefaultFoldingModel.getFoldingSpanAtOffset(this, n5);
            int n6 = 0;
            while (n6 < foldingSpanArray.length) {
                FoldingSpan foldingSpan = foldingSpanArray[n6];
                if (n2 == 0) {
                    if (foldingSpan.isExpanded()) {
                        foldingSpan.setExpanded(false);
                        if (n2 == 0) break;
                    }
                    ++n6;
                }
                if (n2 == 0) continue;
            }
        }
    }

    public void expandAll() {
        FoldingModel foldingModel = this.getFoldingModel();
        foldingModel.expandAll();
    }

    public void collapseAll() {
        FoldingModel foldingModel = this.getFoldingModel();
        foldingModel.collapseAll();
    }

    public void toggleFoldingSelection() {
        block15: {
            FoldingSpan foldingSpan;
            int n;
            DefaultFoldingModel defaultFoldingModel;
            block14: {
                block13: {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    block12: {
                        block11: {
                            n5 = KeywordMap.c;
                            n4 = this.getSelectionStart();
                            n3 = this.getSelectionEnd();
                            try {
                                int n6 = n4;
                                if (n5 == 0) {
                                    if (n6 >= n3) break block11;
                                    n6 = "\n".equals(this.getDocument().getText(n3 - 1, 1)) ? 1 : 0;
                                }
                                if (n6 != 0) {
                                    --n3;
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                a.warning(badLocationException.getLocalizedMessage());
                            }
                        }
                        n2 = n4;
                        if (n5 != 0) break block12;
                        if (n2 == n3) break block13;
                        defaultFoldingModel = (DefaultFoldingModel)this.getFoldingModel();
                        n = n4;
                        if (n5 != 0) break block14;
                        n2 = defaultFoldingModel.hasAnySpan(n, n3) ? 1 : 0;
                    }
                    if (n2 != 0) break block13;
                    foldingSpan = this.getFoldingModel().addFoldingSpan(n4, n3, "...");
                    foldingSpan.setExpanded(false);
                    int n7 = Math.min(n4 + "...".length(), this.getDocumentLength());
                    this.getCaretModel().setOffset(n7);
                    if (n5 == 0) break block15;
                }
                defaultFoldingModel = (DefaultFoldingModel)this.getFoldingModel();
                n = this.getCaretModel().getOffset();
            }
            if ((foldingSpan = defaultFoldingModel.getOutermostSpanAtOffset(n)) != null) {
                this.getFoldingModel().removeFoldingSpan(foldingSpan);
            }
        }
    }

    public int modelToViewLine(int n) {
        return this.modelToViewPosition((CaretPosition)new CaretPosition((int)n, (int)0)).line;
    }

    public int viewToModelLine(int n) {
        return this.viewToModelPosition((CaretPosition)new CaretPosition((int)n, (int)0)).line;
    }

    @Override
    public void repaint() {
        block3: {
            MarkerArea markerArea;
            block2: {
                super.repaint();
                markerArea = this.getMarkerArea();
                if (KeywordMap.c != 0) break block2;
                if (markerArea == null) break block3;
                markerArea = this.getMarkerArea();
            }
            markerArea.repaint();
        }
    }

    @Override
    public void repaint(long l) {
        block3: {
            MarkerArea markerArea;
            block2: {
                super.repaint(l);
                markerArea = this.getMarkerArea();
                if (KeywordMap.c != 0) break block2;
                if (markerArea == null) break block3;
                markerArea = this.getMarkerArea();
            }
            markerArea.repaint(l);
        }
    }

    public Dimension getContentSize() {
        this.y = this.recalculateContentSize();
        return this.y;
    }

    protected Dimension recalculateContentSize() {
        Dimension dimension = this.i.getContentSize();
        return new Dimension(dimension.width, dimension.height + 10 * this.getLineHeight());
    }

    protected void resetContentSize() {
        block3: {
            k_ k_2;
            block2: {
                k_2 = this.i;
                if (KeywordMap.c != 0) break block2;
                if (k_2 == null) break block3;
                k_2 = this.i;
            }
            k_2.reset();
        }
    }

    @Override
    public void configureStyledLabel(StyledLabel styledLabel, Object object) {
        block17: {
            StringBuffer stringBuffer;
            block19: {
                int n;
                int n2;
                block22: {
                    int n3;
                    block23: {
                        int n4;
                        block24: {
                            int n5;
                            block20: {
                                block21: {
                                    Object object2;
                                    Object object3;
                                    block18: {
                                        boolean bl;
                                        block10: {
                                            block11: {
                                                block12: {
                                                    String string;
                                                    block13: {
                                                        block16: {
                                                            String string2;
                                                            block15: {
                                                                block14: {
                                                                    n2 = KeywordMap.c;
                                                                    styledLabel.clearStyleRanges();
                                                                    stringBuffer = new StringBuffer();
                                                                    bl = object instanceof FindResult;
                                                                    if (n2 != 0) break block10;
                                                                    if (!bl) break block11;
                                                                    object3 = (FindResult)object;
                                                                    string = ((FindResult)object3).getStyledText();
                                                                    if (n2 != 0) break block12;
                                                                    if (string != null) break block13;
                                                                    CaretPosition caretPosition = this.offsetToModelPosition(((FindResult)object3).getStart());
                                                                    stringBuffer.append("{(").append(caretPosition.line + 1).append(", ").append(caretPosition.column + 1).append(") :italic, f:gray}");
                                                                    stringBuffer.append(" ");
                                                                    int n6 = this.getLineStartOffset(caretPosition.line);
                                                                    int n7 = ((FindResult)object3).getStart() - n6;
                                                                    int n8 = ((FindResult)object3).getEnd() - ((FindResult)object3).getStart();
                                                                    string2 = this.getLineText(caretPosition.line);
                                                                    if (n2 != 0) break block14;
                                                                    if (string2.length() < n7 + n8) break block15;
                                                                    stringBuffer.append(StyledLabelBuilder.parseToVoidStyledTextConfusion(string2.substring(0, n7)));
                                                                    stringBuffer.append("{").append(string2.substring(n7, n7 + n8)).append(":bold}");
                                                                    stringBuffer.append(StyledLabelBuilder.parseToVoidStyledTextConfusion(string2.substring(n7 + n8)));
                                                                }
                                                                if (n2 == 0) break block16;
                                                            }
                                                            stringBuffer.append(string2);
                                                        }
                                                        string = stringBuffer.toString();
                                                    }
                                                    StyledLabelBuilder.setStyledText(styledLabel, string);
                                                    ((FindResult)object3).setStyledText(string);
                                                }
                                                if (n2 == 0) break block17;
                                            }
                                            object2 = object;
                                            if (n2 != 0) break block18;
                                            bl = object2 instanceof FindResults;
                                        }
                                        if (!bl) break block19;
                                        object2 = object;
                                    }
                                    object3 = (FindResults)object2;
                                    stringBuffer.append(((FindResults)object3).getName());
                                    n = stringBuffer.length();
                                    n4 = ((FindResults)object3).getNumberOfFindResults();
                                    stringBuffer.append(" (");
                                    n3 = n4;
                                    n5 = 1;
                                    if (n2 != 0) break block20;
                                    if (n3 <= n5) break block21;
                                    stringBuffer.append(n4).append(" ").append(this.getResourceString("FindAndReplace.usages"));
                                    if (n2 == 0) break block22;
                                }
                                n3 = n4;
                                if (n2 != 0) break block23;
                                n5 = 1;
                            }
                            if (n3 != n5) break block24;
                            stringBuffer.append(n4).append(" ").append(this.getResourceString("FindAndReplace.usage"));
                            if (n2 == 0) break block22;
                        }
                        n3 = n4;
                    }
                    if (n3 == 0) {
                        stringBuffer.append(this.getResourceString("FindAndReplace.noUsages"));
                    }
                }
                stringBuffer.append(")");
                styledLabel.setText(stringBuffer.toString());
                styledLabel.addStyleRange(new StyleRange(n, stringBuffer.length() - n, 2, Color.GRAY));
                if (n2 == 0) break block17;
            }
            stringBuffer.append(object);
        }
    }

    private ResourceBundle k() {
        return CodeEditorResource.getResourceBundle(this.getLocale());
    }

    public String getResourceString(String string) {
        return this.k().getString(string);
    }

    public Rectangle modelToView(int n) throws BadLocationException {
        int n2 = this.b(n);
        int n3 = this.offsetToX(n2, n);
        int n4 = this.lineToY(n2);
        return new Rectangle(n3, n4 += this.getPainter().getFontMetrics().getLeading() + this.getPainter().getFontMetrics().getMaxDescent(), this._painter.getFontMetrics().charWidth('w'), this.getLineHeight());
    }

    public Rectangle modelToView(int n, int n2) throws BadLocationException {
        int n3 = this.b(n);
        int n4 = this.b(n2);
        int n5 = n3;
        if (KeywordMap.c == 0) {
            if (n5 != n4) {
                throw new IllegalArgumentException("The start and end offset must be one the same line");
            }
            n5 = this.getLineStartOffset(n3);
        }
        int n6 = n5;
        int n7 = this.offsetToX(n3, n - n6);
        int n8 = this.offsetToX(n3, n2 - n6);
        int n9 = this.lineToY(n3);
        return new Rectangle(n7, n9 += this.getPainter().getFontMetrics().getLeading() + this.getPainter().getFontMetrics().getMaxDescent(), n8 - n7, this.getLineHeight());
    }

    public Highlighter getHighlighter() {
        return this.j;
    }

    public void setHighlighter(Highlighter highlighter) {
        int n = KeywordMap.c;
        Highlighter highlighter2 = this.j;
        if (n == 0) {
            if (highlighter2 != null) {
                this.j.deinstall(this);
            }
            highlighter2 = this.j;
        }
        Highlighter highlighter3 = highlighter2;
        this.j = highlighter;
        CodeEditor codeEditor = this;
        if (n == 0) {
            if (codeEditor.j != null) {
                this.j.install(this);
            }
            codeEditor = this;
        }
        codeEditor.firePropertyChange("highlighter", highlighter3, highlighter);
    }

    protected Highlighter createHighlighter() {
        return new DefaultUIResourceHighlighter();
    }

    public ColumnGuide[] getColumnGuides() {
        List<ColumnGuide> list = this.internalGetColumnGuides();
        return list.toArray(new ColumnGuide[list.size()]);
    }

    protected List<ColumnGuide> internalGetColumnGuides() {
        List<ColumnGuide> list = this.k;
        if (KeywordMap.c == 0) {
            if (list == null) {
                this.k = new ArrayList<ColumnGuide>();
            }
            list = this.k;
        }
        return list;
    }

    public void addColumnGuide(ColumnGuide columnGuide) {
        this.internalGetColumnGuides().add(columnGuide);
        this.getPainter().repaint();
    }

    public void removeColumnGuide(ColumnGuide columnGuide) {
        this.internalGetColumnGuides().remove(columnGuide);
        this.getPainter().repaint();
    }

    public void removeAllColumnGuides() {
        this.internalGetColumnGuides().clear();
        this.getPainter().repaint();
    }

    public void escape() {
        block4: {
            Highlighter highlighter;
            block6: {
                int n;
                block5: {
                    CodeEditor codeEditor;
                    block2: {
                        block3: {
                            n = KeywordMap.c;
                            codeEditor = this;
                            if (n != 0) break block2;
                            if (!codeEditor.getSelectionModel().hasSelection()) break block3;
                            this.getSelectionModel().clearSelection();
                            if (n == 0) break block4;
                        }
                        codeEditor = this;
                    }
                    highlighter = codeEditor.getHighlighter();
                    if (n != 0) break block5;
                    if (highlighter == null) break block4;
                    highlighter = this.getHighlighter();
                }
                if (n != 0) break block6;
                if (highlighter == null) break block4;
                highlighter = this.getHighlighter();
            }
            highlighter.removeAllHighlights();
        }
    }

    public void loadActionMap() {
        ActionMap actionMap = this.getActionMap();
        class A_
        extends AbstractAction {
            private Action a;
            private static final long serialVersionUID = 7860792901523776985L;

            A_(Action action) {
                this.a = action;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.a.actionPerformed(actionEvent);
            }
        }
        actionMap.put("copy", new A_(InputHandler.CLIP_COPY));
        actionMap.put("cut", new A_(InputHandler.CLIP_CUT));
        actionMap.put("paste", new A_(InputHandler.CLIP_PASTE));
        actionMap.put("delete", new A_(InputHandler.DELETE));
        actionMap.put("redo", new A_(InputHandler.REDO));
        actionMap.put("undo", new A_(InputHandler.UNDO));
        actionMap.put("selectAll", new A_(InputHandler.SELECT_ALL));
    }

    private Action d(String string) {
        ActionMap actionMap = this.getActionMap();
        return actionMap.get(string);
    }

    public void setCaretPosition(int n) {
        this.getCaretModel().setOffset(n);
    }

    public int getCaretPosition() {
        return this.getCaretModel().getOffset();
    }

    public JScrollBar getVerticalScrollBar() {
        return this._verticalScrollBar;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this._horizontalScrollBar;
    }

    static /* synthetic */ int access$500(CodeEditor codeEditor, int n, int n2) {
        return codeEditor.b(n, n2);
    }

    static {
        if (!W.a(128)) {
            Lm.showInvalidProductMessage(CodeEditor.class.getName(), 128);
        }
        a = Logger.getLogger(CodeEditor.class.getName());
        LEFT_OF_SCROLLBAR = "los";
        CENTER = "center";
        RIGHT = "right";
        LEFT = "left";
        BOTTOM = "bottom";
        x = new Insets(1, 1, 1, 1);
    }

    public static class DefaultUIResourceHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    private class k_ {
        private boolean a;
        private Dimension b;
        private c c;

        private k_() {
        }

        public void reset() {
            int n = CodeEditor.this.getVisualLineCount();
            this.c = new c(n + 300);
            int[] nArray = new int[n];
            Arrays.fill(nArray, -1);
            this.c.add(nArray);
            this.a = true;
        }

        /*
         * Unable to fully structure code
         */
        public void documentChanged(DocumentEvent var1_1) {
            block10: {
                block8: {
                    block9: {
                        var8_2 = KeywordMap.c;
                        var2_3 = CodeEditor.this.offsetToViewPosition((int)var1_1.getOffset()).line;
                        v0 = var3_4 = var1_1.getOffset() + var1_1.getLength();
                        if (var8_2 == 0) {
                            if (v0 > CodeEditor.this.getDocument().getLength()) {
                                var3_4 = CodeEditor.this.getDocument().getLength();
                            }
                            v0 = CodeEditor.this.offsetToViewPosition((int)var3_4).line;
                        }
                        var5_6 = var4_5 = v0;
                        v1 = this.c.size();
                        v2 = CodeEditor.this.getVisualLineCount();
                        if (var8_2 != 0) break block8;
                        if (v1 == v2) break block9;
                        this.reset();
                        if (var8_2 == 0) break block10;
                    }
                    v1 = var5_6;
                    v2 = var4_5;
                }
                var6_7 = Math.min(v1, v2);
                for (var7_8 = var2_3; var7_8 <= var6_7; ++var7_8) {
                    this.c.set(var7_8, -1);
                    if (var8_2 == 0) {
                        if (var8_2 == 0) continue;
                    }
                    ** GOTO lbl-1000
                }
                v3 = var4_5;
                v4 = var5_6;
                if (var8_2 == 0) {
                    ** if (v3 <= v4) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        var7_9 = new int[var4_5 - var5_6];
                        Arrays.fill((int[])var7_9, (int)-1);
                        this.c.insert((int)(var5_6 + 1), (int[])var7_9);
                        ** GOTO lbl38
                    }
                }
                ** GOTO lbl36
lbl-1000:
                // 2 sources

                {
                    v3 = var5_6;
                    v4 = var4_5;
lbl36:
                    // 2 sources

                    if (v3 > v4) {
                        this.c.remove(var4_5 + 1, var5_6 - var4_5);
                    }
                }
lbl38:
                // 4 sources

                this.a = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void a() {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            block26: {
                n7 = KeywordMap.c;
                k_ k_2 = this;
                if (n7 == 0) {
                    if (!k_2.a) {
                        return;
                    }
                    k_2 = this;
                }
                SyntaxDocument syntaxDocument = k_2.CodeEditor.this.getDocument();
                n6 = this.c.size();
                int n8 = CodeEditor.this.getDocument().getLength();
                n5 = 0;
                n4 = CodeEditor.this._painter.getFontMetrics().charWidth('w');
                block2: for (n3 = 0; n3 < n6; ++n3) {
                    block28: {
                        block27: {
                            n2 = this.c.getQuick(n3);
                            if (n7 != 0) break block26;
                            if (n7 == 0) {
                                if (n2 != -1) continue;
                                n5 = 0;
                                int n9 = n = CodeEditor.this.modelPositionToOffset(CodeEditor.this.viewToModelPosition(new CaretPosition(n3, 0)));
                            }
                            if (n7 != 0) break block27;
                            if (n < n8) break block28;
                            this.c.set(n3, 0);
                        }
                        if (n7 == 0) break;
                    }
                    b b2 = new b(CodeEditor.this, n);
                    while (n < n8) {
                        try {
                            int n10;
                            int n11;
                            block31: {
                                block32: {
                                    int n12;
                                    block35: {
                                        block36: {
                                            block34: {
                                                int n13;
                                                block33: {
                                                    int n14;
                                                    block30: {
                                                        FoldingSpan foldingSpan;
                                                        FoldingSpan foldingSpan2;
                                                        block29: {
                                                            n14 = syntaxDocument.charAt(n);
                                                            if (n >= b2.getEndOffset()) {
                                                                b2.advance();
                                                            }
                                                            foldingSpan = foldingSpan2 = b2.getCurrentFold();
                                                            if (n7 != 0) break block29;
                                                            if (foldingSpan == null) break block30;
                                                            foldingSpan = foldingSpan2;
                                                        }
                                                        String string = foldingSpan.getDescription();
                                                        n5 += n4 * string.length();
                                                        n = foldingSpan2.getEndOffset();
                                                        if (n7 == 0) continue;
                                                    }
                                                    n11 = n14;
                                                    n10 = 9;
                                                    if (n7 == 0) {
                                                        if (n11 == n10) {
                                                            n5 += CodeEditor.this.getTabSize() * n4;
                                                            ++n;
                                                            if (n7 == 0) continue;
                                                        }
                                                        n11 = n14;
                                                        n10 = 10;
                                                    }
                                                    if (n7 != 0) break block31;
                                                    if (n11 != n10) break block32;
                                                    this.c.set(n3, n5);
                                                    n12 = n3 + 1;
                                                    n13 = n6;
                                                    if (n7 != 0) break block33;
                                                    if (n12 >= n13) break block34;
                                                    n12 = this.c.getQuick(n3 + 1);
                                                    if (n7 != 0) break block35;
                                                    n13 = -1;
                                                }
                                                if (n12 == n13) break block36;
                                            }
                                            if (n7 == 0) continue block2;
                                        }
                                        ++n;
                                        n12 = 0;
                                    }
                                    n5 = n12;
                                    ++n3;
                                    if (n7 == 0) continue;
                                }
                                n11 = n5;
                                n10 = n4;
                            }
                            n5 = n11 + n10;
                            ++n;
                        }
                        catch (BadLocationException badLocationException) {
                            a.warning(badLocationException.getLocalizedMessage());
                            if (n7 == 0) continue;
                        }
                    }
                    if (n7 == 0) continue;
                }
                n2 = n6;
            }
            if (n7 == 0) {
                if (n2 > 0) {
                    this.c.set(n6 - 1, n5);
                }
                n3 = n4;
                n2 = n = 0;
            }
            while (n < n6) {
                n3 = Math.max(n3, this.c.getQuick(n));
                ++n;
                if (n7 != 0) return;
                if (n7 == 0) continue;
            }
            this.b = new Dimension(n3, CodeEditor.this.getLineHeight() * n6);
            this.a = false;
        }

        public Dimension getContentSize() {
            this.a();
            return this.b;
        }
    }

    private class m_
    implements Border {
        private m_() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
            graphics.drawLine(0, n4 - 1, n3, n4 - 1);
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4);
            graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
            graphics.drawLine(0, 0, n3, 0);
            graphics.drawLine(0, 0, 0, n4);
        }

        public Insets getBorderInsets(Component component) {
            return x;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class a_
    extends DropTargetAdapter {
        private a_() {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            CodeEditor.this.a(dropTargetDropEvent.getTransferable());
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            boolean bl = CodeEditor.this.hasFocus();
            if (KeywordMap.c == 0 && !bl) {
                bl = CodeEditor.this.requestFocus(true);
            }
            Point point = dropTargetDragEvent.getLocation();
            int n = CodeEditor.this.xyToOffset(point.x, point.y);
            CodeEditor.this.getCaretModel().setOffset(n);
        }
    }

    class o_
    implements MouseWheelListener {
        o_() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            block5: {
                block8: {
                    int n;
                    int n2;
                    block6: {
                        block7: {
                            block2: {
                                block3: {
                                    block4: {
                                        n2 = KeywordMap.c;
                                        n = mouseWheelEvent.isShiftDown();
                                        if (n2 != 0) break block2;
                                        if (n == 0) break block3;
                                        if (mouseWheelEvent.getWheelRotation() <= 0) break block4;
                                        CodeEditor.this.scrollDownPage();
                                        if (n2 == 0) break block5;
                                    }
                                    CodeEditor.this.scrollUpPage();
                                    if (n2 == 0) break block5;
                                }
                                n = mouseWheelEvent.isControlDown();
                            }
                            if (n2 != 0) break block6;
                            if (n == 0) break block7;
                            CodeEditor.this.setFirstLine(CodeEditor.this.getFirstLine() + mouseWheelEvent.getWheelRotation());
                            if (n2 == 0) break block5;
                        }
                        n = mouseWheelEvent.getScrollType();
                    }
                    if (n != 0) break block8;
                    CodeEditor.this.setFirstLine(CodeEditor.this.getFirstLine() + mouseWheelEvent.getUnitsToScroll());
                    if (n2 == 0) break block5;
                }
                CodeEditor.this.setFirstLine(CodeEditor.this.getFirstLine() + 3 * mouseWheelEvent.getWheelRotation());
            }
        }
    }

    class n_
    implements MouseInputListener {
        private boolean a = false;
        private boolean b = false;
        private transient Cursor c = null;

        n_() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void mousePressed(MouseEvent var1_1) {
            block20: {
                block19: {
                    block16: {
                        block17: {
                            block18: {
                                var9_2 = KeywordMap.c;
                                v0 = CodeEditor.this.isEnabled();
                                if (var9_2 == 0) {
                                    if (v0 == 0) {
                                        return;
                                    }
                                    v0 = CodeEditor.this.requestFocusInWindow();
                                }
                                v1 = var2_3 = v0;
                                if (var9_2 == 0) {
                                    if (v1 == 0) {
                                        var3_4 = new Runnable(){

                                            public void run() {
                                                CodeEditor.this.requestFocusInWindow();
                                            }
                                        };
                                        SwingUtilities.invokeLater((Runnable)var3_4);
                                    }
                                    CodeEditor.this.setCaretVisible(true);
                                    CodeEditor.focusedComponent = CodeEditor.this;
                                    v1 = var1_1.getModifiers() & 4;
                                }
                                if (var9_2 != 0) break block16;
                                if (v1 == 0) break block17;
                                v1 = SystemInfo.isJdk15Above();
                                if (var9_2 != 0) break block16;
                                if (v1 == 0) break block17;
                                v2 = var3_4 = CodeEditor.this.getComponentPopupMenu();
                                if (var9_2 != 0) break block18;
                                if (v2 == null) break block17;
                                v2 = var3_4;
                            }
                            v2.show(CodeEditor.this._painter, var1_1.getX(), var1_1.getY());
                            return;
                        }
                        v1 = SwingUtilities.isLeftMouseButton(var1_1);
                    }
                    if (var9_2 != 0) break block19;
                    if (v1 == 0) break block20;
                    v1 = CodeEditor.this.yToLine(var1_1.getY());
                }
                var3_5 = v1;
                var4_6 = CodeEditor.this.viewToModelLine(var3_5);
                v3 = CodeEditor.this;
                if (var9_2 != 0) ** GOTO lbl42
                if (v3.isVirtualSpaceAllowed()) {
                    v4 = CodeEditor.this.xToColumn(var4_6, var1_1.getX());
                } else {
                    v3 = CodeEditor.this;
lbl42:
                    // 2 sources

                    v4 = CodeEditor.access$500(v3, CodeEditor.this.getLineStartOffset(var4_6) + CodeEditor.this.xToOffset(var4_6, var1_1.getX()), var4_6);
                }
                var5_7 = v4;
                var6_8 = CodeEditor.this.viewToModelPosition(new CaretPosition(var3_5, var5_7));
                var7_9 = CodeEditor.this.modelPositionToOffset(var6_8);
                if (var9_2 != 0) ** GOTO lbl50
                switch (var1_1.getClickCount()) {
                    case 1: {
                        this.a(var1_1, var3_5, var5_7, var7_9);
lbl50:
                        // 2 sources

                        if (var9_2 == 0) break;
                    }
                    case 2: {
                        try {
                            this.b(var1_1, var3_5, var5_7, var7_9);
                            break;
                        }
                        catch (BadLocationException var8_10) {
                            CodeEditor.access$600().warning(var8_10.getLocalizedMessage());
                            if (var9_2 == 0) break;
                        }
                    }
                    case 3: {
                        this.c(var1_1, var3_5, var5_7, var7_9);
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            block10: {
                block16: {
                    n_ n_2;
                    block15: {
                        boolean bl;
                        int n;
                        block11: {
                            block12: {
                                block14: {
                                    n_ n_3;
                                    block13: {
                                        block9: {
                                            n = KeywordMap.c;
                                            bl = CodeEditor.this.isEnabled();
                                            if (n == 0) {
                                                if (!bl) {
                                                    return;
                                                }
                                                bl = SwingUtilities.isLeftMouseButton(mouseEvent);
                                            }
                                            if (n != 0) break block9;
                                            if (!bl) break block10;
                                            bl = this.a;
                                        }
                                        if (n != 0) break block11;
                                        if (!bl) break block12;
                                        bl = this.b;
                                        if (n != 0) break block11;
                                        if (!bl) break block12;
                                        int n2 = CodeEditor.this.xyToOffset(mouseEvent.getX(), mouseEvent.getY());
                                        CodeEditor.this.clipboardMove(n2);
                                        n_3 = this;
                                        if (n != 0) break block13;
                                        if (n_3.c == null) break block14;
                                        n_3 = this;
                                    }
                                    n_3.CodeEditor.this._painter.setCursor(this.c);
                                }
                                if (n == 0) break block15;
                            }
                            n_2 = this;
                            if (n != 0) break block16;
                            bl = n_2.a;
                        }
                        if (!bl) break block15;
                        n_2 = this;
                        if (n != 0) break block16;
                        if (!n_2.b) {
                            CodeEditor.this.getSelectionModel().clearSelection();
                        }
                    }
                    this.a = false;
                    n_2 = this;
                }
                n_2.b = false;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void mouseDragged(MouseEvent var1_1) {
            block18: {
                block16: {
                    block17: {
                        block15: {
                            var3_2 = KeywordMap.c;
                            v0 = CodeEditor.this.isEnabled();
                            if (var3_2 == 0) {
                                if (v0 == 0) {
                                    return;
                                }
                                v0 = SystemInfo.isJdk15Above();
                            }
                            if (var3_2 != 0) break block15;
                            if (v0 == 0) ** GOTO lbl-1000
                            v1 = CodeEditor.this;
                            if (var3_2 == 0) {
                                var2_3 = v1.getComponentPopupMenu();
                                ** if (var2_3 == null) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    v0 = (int)var2_3.isVisible();
                                    if (var3_2 == 0) {
                                        if (v0 != 0) {
                                            return;
                                        } else {
                                            ** GOTO lbl-1000
                                        }
                                    } else {
                                        ** GOTO lbl17
                                    }
lbl17:
                                    // 2 sources

                                    ** GOTO lbl21
                                }
                            }
                            ** GOTO lbl20
lbl-1000:
                            // 4 sources

                            {
                                v1 = CodeEditor.this;
lbl20:
                                // 2 sources

                                v0 = v1.xyToOffset(var1_1.getX(), var1_1.getY());
                            }
                        }
                        var2_4 = v0;
                        v2 = this;
                        if (var3_2 != 0) break block16;
                        if (!v2.a) break block17;
                        v3 = this.b;
                        if (var3_2 == 0) {
                            if (!v3) {
                                this.c = CodeEditor.this._painter.getCursor();
                                CodeEditor.this._painter.setCursor(JideCursors.getPredefinedCursor(33));
                            }
                            this.b = true;
                            CodeEditor.this.getCaretModel().setOffset(var2_4);
                            v3 = CodeEditor.this.scrollToCaret();
                        }
                        if (var3_2 == 0) break block18;
                    }
                    v2 = this;
                }
                v4 = v2.CodeEditor.this;
                v5 = var1_1.getModifiers() & 2;
                if (var3_2 == 0) {
                    v5 = v5 != false;
                }
                v4.setSelectionRectangular(v5);
                CodeEditor.this.select(CodeEditor.this.getMarkPosition(), var2_4);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.b = false;
            this.a = false;
            this.c = null;
        }

        private void a(MouseEvent mouseEvent, int n, int n2, int n3) {
            block7: {
                block12: {
                    CodeEditor codeEditor;
                    block13: {
                        block14: {
                            int n4;
                            int n5;
                            block10: {
                                block11: {
                                    block9: {
                                        int n6;
                                        block8: {
                                            block5: {
                                                block6: {
                                                    n5 = KeywordMap.c;
                                                    n4 = mouseEvent.getModifiers() & 1;
                                                    if (n5 != 0) break block5;
                                                    if (n4 == 0) break block6;
                                                    SelectionModel selectionModel = CodeEditor.this.getSelectionModel();
                                                    boolean bl = mouseEvent.getModifiers() & 2;
                                                    if (n5 == 0) {
                                                        bl = bl;
                                                    }
                                                    selectionModel.setColumnSelectionMode(bl);
                                                    CodeEditor.this.select(CodeEditor.this.getMarkPosition(), n3);
                                                    if (n5 == 0) break block7;
                                                }
                                                n4 = n3;
                                            }
                                            n6 = CodeEditor.this.getSelectionStart();
                                            if (n5 != 0) break block8;
                                            if (n4 <= n6) break block9;
                                            n4 = n3;
                                            if (n5 != 0) break block10;
                                            n6 = CodeEditor.this.getSelectionEnd();
                                        }
                                        if (n4 < n6) break block11;
                                    }
                                    CodeEditor.this.getSelectionModel().clearSelection();
                                    if (n5 == 0) break block12;
                                }
                                codeEditor = CodeEditor.this;
                                if (n5 != 0) break block13;
                                n4 = codeEditor.isEditable() ? 1 : 0;
                            }
                            if (n4 == 0) break block14;
                            codeEditor = CodeEditor.this;
                            if (n5 != 0) break block13;
                            if (codeEditor.isEnabled()) {
                                this.a = true;
                            }
                        }
                        codeEditor = CodeEditor.this;
                    }
                    codeEditor.getCaretModel().setOffset(n2);
                }
                CodeEditor.this.getCaretModel().setViewPosition(new CaretPosition(n, n2));
                CodeEditor.this.setMagicCaretPosition(CodeEditor.this.columnToX(n, n2));
            }
        }

        /*
         * Exception decompiling
         */
        private void b(MouseEvent var1_1, int var2_2, int var3_3, int var4_4) throws BadLocationException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void c(MouseEvent mouseEvent, int n, int n2, int n3) {
            block3: {
                int n4;
                CodeEditor codeEditor;
                int n5;
                block4: {
                    int n6;
                    block2: {
                        int n7 = KeywordMap.c;
                        n6 = n5 = CodeEditor.this.getLineStartOffset(n);
                        if (n7 != 0) break block2;
                        if (n6 < 0) break block3;
                        codeEditor = CodeEditor.this;
                        n4 = n;
                        if (n7 != 0) break block4;
                        n6 = codeEditor.getLineText(n4).length();
                    }
                    if (n6 <= 0) break block3;
                    codeEditor = CodeEditor.this;
                    n4 = n5;
                }
                codeEditor.select(n4, CodeEditor.this.getLineEndOffset(n) + 1);
                CodeEditor.this.getCaretModel().setOffset(n5);
            }
        }
    }

    class l_
    implements FocusListener {
        l_() {
        }

        public void focusGained(FocusEvent focusEvent) {
            CodeEditor.this.setCaretVisible(true);
            focusedComponent = CodeEditor.this;
        }

        public void focusLost(FocusEvent focusEvent) {
            CodeEditor.this.setCaretVisible(false);
            focusedComponent = null;
        }
    }

    class j_
    implements DocumentListener {
        j_() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            block6: {
                int n;
                int n2;
                block14: {
                    int n3;
                    block12: {
                        block13: {
                            int n4;
                            int n5;
                            int n6;
                            block11: {
                                int n7;
                                block9: {
                                    block10: {
                                        int n8;
                                        int n9;
                                        block7: {
                                            block8: {
                                                block4: {
                                                    block5: {
                                                        n6 = KeywordMap.c;
                                                        CodeEditor.this.documentChanged(documentEvent);
                                                        n5 = documentEvent.getOffset();
                                                        n4 = documentEvent.getLength();
                                                        n9 = CodeEditor.this.getSelectionModel().hasSelection();
                                                        if (n6 != 0) break block4;
                                                        if (n9 != 0) break block5;
                                                        CodeEditor.this.select(n5 + n4, n5 + n4);
                                                        if (n6 == 0) break block6;
                                                    }
                                                    n9 = CodeEditor.this.getSelectionStart();
                                                }
                                                n8 = n5;
                                                if (n6 != 0) break block7;
                                                if (n9 > n8) break block8;
                                                n7 = CodeEditor.this.getSelectionStart();
                                                if (n6 != 0) break block9;
                                                if (n7 != CodeEditor.this.getSelectionEnd()) break block10;
                                                n7 = CodeEditor.this.getSelectionStart();
                                                if (n6 != 0) break block9;
                                                if (n7 != n5) break block10;
                                            }
                                            n9 = CodeEditor.this.getSelectionStart();
                                            n8 = n4;
                                        }
                                        n2 = n9 + n8;
                                        if (n6 == 0) break block11;
                                    }
                                    n7 = CodeEditor.this.getSelectionStart();
                                }
                                n2 = n7;
                            }
                            n3 = CodeEditor.this.getSelectionEnd();
                            if (n6 != 0) break block12;
                            if (n3 < n5) break block13;
                            n = CodeEditor.this.getSelectionEnd() + n4;
                            if (n6 == 0) break block14;
                        }
                        n3 = CodeEditor.this.getSelectionEnd();
                    }
                    n = n3;
                }
                CodeEditor.this.select(n2, n);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            block6: {
                int n;
                int n2;
                block16: {
                    int n3;
                    block12: {
                        int n4;
                        block13: {
                            int n5;
                            block14: {
                                int n6;
                                int n7;
                                block15: {
                                    int n8;
                                    block11: {
                                        int n9;
                                        block7: {
                                            int n10;
                                            block8: {
                                                block9: {
                                                    int n11;
                                                    block10: {
                                                        int n12;
                                                        block4: {
                                                            block5: {
                                                                n5 = KeywordMap.c;
                                                                CodeEditor.this.documentChanged(documentEvent);
                                                                n7 = documentEvent.getOffset();
                                                                n8 = documentEvent.getLength();
                                                                n12 = CodeEditor.this.getSelectionModel().hasSelection();
                                                                if (n5 != 0) break block4;
                                                                if (n12 != 0) break block5;
                                                                CodeEditor.this.select(n7, n7);
                                                                if (n5 == 0) break block6;
                                                            }
                                                            n12 = CodeEditor.this.getSelectionStart();
                                                        }
                                                        n10 = n12;
                                                        n4 = CodeEditor.this.getSelectionEnd();
                                                        n9 = n10;
                                                        if (n5 != 0) break block7;
                                                        if (n9 <= n7) break block8;
                                                        n11 = n10;
                                                        if (n5 != 0) break block9;
                                                        if (n11 <= n7 + n8) break block10;
                                                        n2 = n10 - n8;
                                                        if (n5 == 0) break block11;
                                                    }
                                                    n11 = n2 = n7;
                                                }
                                                if (n5 == 0) break block11;
                                            }
                                            n9 = n10;
                                        }
                                        n2 = n9;
                                    }
                                    n3 = n4;
                                    if (n5 != 0) break block12;
                                    if (n3 <= n7) break block13;
                                    n6 = n4;
                                    if (n5 != 0) break block14;
                                    if (n6 <= n7 + n8) break block15;
                                    n = n4 - n8;
                                    if (n5 == 0) break block16;
                                }
                                n6 = n = n7;
                            }
                            if (n5 == 0) break block16;
                        }
                        n3 = n4;
                    }
                    n = n3;
                }
                CodeEditor.this.select(n2, n);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    class b_
    extends ComponentAdapter {
        b_() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            CodeEditor.this.recalculateVisibleLines();
            CodeEditor.this._scrollBarsInitialized = true;
        }
    }

    class h_
    implements AdjustmentListener {
        h_() {
        }

        public void adjustmentValueChanged(final AdjustmentEvent adjustmentEvent) {
            if (!CodeEditor.this._scrollBarsInitialized) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    block4: {
                        0 v0;
                        block2: {
                            block3: {
                                int n = KeywordMap.c;
                                v0 = this;
                                if (n != 0) break block2;
                                if (v0.adjustmentEvent.getAdjustable() != CodeEditor.this._verticalScrollBar) break block3;
                                CodeEditor.this.setFirstLine(CodeEditor.this._verticalScrollBar.getValue());
                                if (n == 0) break block4;
                            }
                            v0 = this;
                        }
                        v0.CodeEditor.this.setHorizontalOffset(-CodeEditor.this._horizontalScrollBar.getValue());
                    }
                }
            });
        }
    }

    static class i_
    implements ActionListener {
        i_() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                CodeEditor codeEditor;
                block4: {
                    int n;
                    block2: {
                        n = KeywordMap.c;
                        codeEditor = focusedComponent;
                        if (n != 0) break block2;
                        if (codeEditor == null) break block3;
                        codeEditor = focusedComponent;
                    }
                    if (n != 0) break block4;
                    if (!codeEditor.hasFocus()) break block3;
                    codeEditor = focusedComponent;
                }
                codeEditor.blinkCaret();
            }
        }
    }

    class p_
    implements LayoutManager {
        private Component a;
        private Component b;
        private Component c;
        private Component d;
        private Vector<Component> e = new Vector();

        p_() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLayoutComponent(String string, Component component) {
            int n = KeywordMap.c;
            Object object = component.getTreeLock();
            synchronized (object) {
                block16: {
                    Object object2;
                    block9: {
                        boolean bl;
                        block14: {
                            block15: {
                                block12: {
                                    block13: {
                                        block10: {
                                            block11: {
                                                block7: {
                                                    block8: {
                                                        bl = string.equals(CENTER);
                                                        if (n != 0) break block7;
                                                        if (!bl) break block8;
                                                        this.b = component;
                                                        if (n == 0) break block9;
                                                    }
                                                    bl = string.equals(RIGHT);
                                                }
                                                if (n != 0) break block10;
                                                if (!bl) break block11;
                                                this.c = component;
                                                if (n == 0) break block9;
                                            }
                                            bl = string.equals(BOTTOM);
                                        }
                                        if (n != 0) break block12;
                                        if (!bl) break block13;
                                        this.d = component;
                                        if (n == 0) break block9;
                                    }
                                    bl = string.equals(LEFT);
                                }
                                if (n != 0) break block14;
                                if (!bl) break block15;
                                this.a = component;
                                if (n == 0) break block9;
                            }
                            object2 = string;
                            if (n != 0) break block16;
                            bl = ((String)object2).equals(LEFT_OF_SCROLLBAR);
                        }
                        if (bl) {
                            this.e.addElement(component);
                        }
                    }
                    object2 = object;
                }
                // ** MonitorExit[v1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLayoutComponent(Component component) {
            block14: {
                int n = KeywordMap.c;
                Object object = component.getTreeLock();
                synchronized (object) {
                    p_ p_2;
                    block12: {
                        block13: {
                            Component component2;
                            Component component3;
                            block11: {
                                component3 = this.b;
                                component2 = component;
                                if (n == 0) {
                                    if (component3 == component2) {
                                        this.b = null;
                                    }
                                    component3 = this.c;
                                    component2 = component;
                                }
                                if (n == 0) {
                                    if (component3 == component2) {
                                        this.c = null;
                                    }
                                    component3 = this.d;
                                    component2 = component;
                                }
                                if (n != 0) break block11;
                                if (component3 == component2) {
                                    this.d = null;
                                }
                                p_2 = this;
                                if (n != 0) break block12;
                                component3 = p_2.a;
                                component2 = component;
                            }
                            if (component3 != component2) break block13;
                            this.a = null;
                            if (n == 0) break block14;
                        }
                        p_2 = this;
                    }
                    p_2.e.removeElement(component);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = new Dimension();
                Insets insets = CodeEditor.this.getInsets();
                dimension.width = insets.left + insets.right;
                dimension.height = insets.top + insets.bottom;
                Dimension dimension2 = this.b.getPreferredSize();
                dimension.width += dimension2.width;
                dimension.height += dimension2.height;
                Dimension dimension3 = this.c.getPreferredSize();
                dimension.width += dimension3.width;
                Dimension dimension4 = this.d.getPreferredSize();
                Dimension dimension5 = dimension;
                Object object2 = dimension5;
                Dimension dimension6 = dimension5;
                if (KeywordMap.c == 0) {
                    dimension6.height = ((Dimension)object2).height + dimension4.height;
                    if (this.a != null) {
                        Dimension dimension7 = this.a.getPreferredSize();
                        dimension.width += dimension7.width;
                    }
                    dimension6 = dimension;
                    object2 = object;
                }
                // ** MonitorExit[v1] (shouldn't be in output)
                return dimension6;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension dimension = new Dimension();
                Insets insets = CodeEditor.this.getInsets();
                dimension.width = insets.left + insets.right;
                dimension.height = insets.top + insets.bottom;
                Dimension dimension2 = this.b.getMinimumSize();
                dimension.width += dimension2.width;
                dimension.height += dimension2.height;
                Dimension dimension3 = this.c.getMinimumSize();
                dimension.width += dimension3.width;
                Dimension dimension4 = this.d.getMinimumSize();
                Dimension dimension5 = dimension;
                Object object2 = dimension5;
                Dimension dimension6 = dimension5;
                if (KeywordMap.c == 0) {
                    dimension6.height = ((Dimension)object2).height + dimension4.height;
                    if (this.a != null) {
                        Dimension dimension7 = this.a.getMinimumSize();
                        dimension.width += dimension7.width;
                    }
                    dimension6 = dimension;
                    object2 = object;
                }
                // ** MonitorExit[v1] (shouldn't be in output)
                return dimension6;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void layoutContainer(Container var1_1) {
            var18_2 = KeywordMap.c;
            var2_3 = var1_1.getTreeLock();
            synchronized (var2_3) {
                block21: {
                    block23: {
                        block22: {
                            var3_4 = var1_1.getSize();
                            var4_5 = var1_1.getInsets();
                            var5_6 = var4_5.top;
                            var6_7 = var4_5.left;
                            var7_8 = var4_5.bottom;
                            var8_9 = var4_5.right;
                            v0 = this.a;
                            if (var18_2 != 0) ** GOTO lbl15
                            if (v0 != null) {
                                v0 = this.a;
lbl15:
                                // 2 sources

                                v1 = v0.getPreferredSize().width;
                            } else {
                                v1 = 0;
                            }
                            var9_10 = v1;
                            v2 = this.c;
                            if (var18_2 != 0) ** GOTO lbl23
                            if (v2 != null) {
                                v2 = this.c;
lbl23:
                                // 2 sources

                                v3 = v2.getPreferredSize().width;
                            } else {
                                v3 = 0;
                            }
                            var10_11 = v3;
                            v4 = this.d;
                            if (var18_2 != 0) ** GOTO lbl31
                            if (v4 != null) {
                                v4 = this.d;
lbl31:
                                // 2 sources

                                v5 = v4.getPreferredSize().height;
                            } else {
                                v5 = 0;
                            }
                            var11_12 = v5;
                            var12_13 = var3_4.width - var10_11 - var6_7 - var8_9 - var9_10;
                            var13_14 = var3_4.height - var11_12 - var5_6 - var7_8;
                            v6 = this.a;
                            if (var18_2 == 0) {
                                if (v6 != null) {
                                    this.a.setBounds(var6_7, var5_6, var9_10, var13_14);
                                }
                                var6_7 += var9_10;
                                v6 = this.b;
                            }
                            if (var18_2 != 0) break block22;
                            if (v6 != null) {
                                this.b.setBounds(var6_7, var5_6, var12_13, var13_14);
                            }
                            v7 = this;
                            if (var18_2 != 0) break block23;
                            v6 = v7.c;
                        }
                        if (v6 != null) {
                            this.c.setBounds(var6_7 + var12_13, var5_6, var10_11, var13_14);
                        }
                        v7 = this;
                    }
                    for (Component var15_16 : v7.e) {
                        var16_17 = var15_16.getPreferredSize();
                        var15_16.setBounds(var6_7, var5_6 + var13_14, var16_17.width, var11_12);
                        var6_7 += var16_17.width;
                        if (var18_2 == 0) {
                            if (var18_2 == 0) continue;
                        }
                        break block21;
                    }
                    v8 = this.d;
                    if (var18_2 == 0) {
                        if (v8 != null) {
                            this.d.setBounds(var6_7, var5_6 + var13_14, var3_4.width - var10_11 - var6_7 - var8_9, var11_12);
                        }
                        v8 = var2_3;
                    }
                    // ** MonitorExit[v8] (shouldn't be in output)
                }
                return;
            }
        }
    }
}

