/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe.support;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.common.support.IoServiceListenerSupport;
import org.apache.mina.transport.vmpipe.support.VmPipe;
import org.apache.mina.transport.vmpipe.support.VmPipeFilterChain;
import org.apache.mina.transport.vmpipe.support.VmPipeIdleStatusChecker;
import org.apache.mina.util.Queue;

public class VmPipeSessionImpl
extends BaseIoSession {
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoService service;
    private final IoServiceConfig serviceConfig;
    private final IoServiceListenerSupport serviceListeners;
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final SocketAddress serviceAddress;
    private final IoHandler handler;
    private final VmPipeFilterChain filterChain;
    final VmPipeSessionImpl remoteSession;
    final Object lock;
    final Queue pendingDataQueue;

    public VmPipeSessionImpl(IoService service, IoServiceConfig serviceConfig, IoServiceListenerSupport serviceListeners, Object lock, SocketAddress localAddress, IoHandler handler, VmPipe remoteEntry) throws IOException {
        this.service = service;
        this.serviceConfig = serviceConfig;
        this.serviceListeners = serviceListeners;
        this.lock = lock;
        this.localAddress = localAddress;
        this.remoteAddress = this.serviceAddress = remoteEntry.getAddress();
        this.handler = handler;
        this.filterChain = new VmPipeFilterChain(this);
        this.pendingDataQueue = new Queue();
        this.remoteSession = new VmPipeSessionImpl(this, remoteEntry);
        try {
            service.getFilterChainBuilder().buildFilterChain(this.filterChain);
            serviceConfig.getFilterChainBuilder().buildFilterChain(this.filterChain);
            serviceConfig.getThreadModel().buildFilterChain(this.filterChain);
            serviceListeners.fireSessionCreated(this);
        }
        catch (Throwable t) {
            throw (IOException)new IOException("Failed to create a connector session.").initCause(t);
        }
        VmPipeIdleStatusChecker.getInstance().addSession(this);
    }

    private VmPipeSessionImpl(VmPipeSessionImpl remoteSession, VmPipe entry) throws IOException {
        this.service = entry.getAcceptor();
        this.serviceConfig = entry.getConfig();
        this.serviceListeners = entry.getListeners();
        this.lock = remoteSession.lock;
        this.localAddress = this.serviceAddress = remoteSession.remoteAddress;
        this.remoteAddress = remoteSession.localAddress;
        this.handler = entry.getHandler();
        this.filterChain = new VmPipeFilterChain(this);
        this.remoteSession = remoteSession;
        this.pendingDataQueue = new Queue();
        try {
            entry.getAcceptor().getFilterChainBuilder().buildFilterChain(this.getFilterChain());
            entry.getConfig().getFilterChainBuilder().buildFilterChain(this.getFilterChain());
            entry.getConfig().getThreadModel().buildFilterChain(this.getFilterChain());
            this.serviceListeners.fireSessionCreated(this);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
            IOException e = new IOException("Failed to initialize acceptor session.");
            e.initCause(t);
            throw e;
        }
        VmPipeIdleStatusChecker.getInstance().addSession(this);
    }

    public IoService getService() {
        return this.service;
    }

    IoServiceListenerSupport getServiceListeners() {
        return this.serviceListeners;
    }

    public IoServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public IoSessionConfig getConfig() {
        return CONFIG;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    protected void close0() {
        this.filterChain.fireFilterClose(this);
    }

    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.fireFilterWrite(this, writeRequest);
    }

    public int getScheduledWriteRequests() {
        return 0;
    }

    public int getScheduledWriteBytes() {
        return 0;
    }

    public TransportType getTransportType() {
        return TransportType.VM_PIPE;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public SocketAddress getServiceAddress() {
        return this.serviceAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTrafficMask() {
        if (this.getTrafficMask().isReadable() || this.getTrafficMask().isWritable()) {
            Object[] data;
            Queue queue = this.pendingDataQueue;
            synchronized (queue) {
                data = this.pendingDataQueue.toArray();
                this.pendingDataQueue.clear();
            }
            for (int i = 0; i < data.length; ++i) {
                if (data[i] instanceof IoFilter.WriteRequest) {
                    IoFilter.WriteRequest wr = (IoFilter.WriteRequest)data[i];
                    this.filterChain.doWrite(this, wr);
                    continue;
                }
                this.filterChain.fireMessageReceived(this, data[i]);
            }
        }
    }
}

