/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.support.BaseIoConnector;
import org.apache.mina.common.support.BaseIoConnectorConfig;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.common.support.DefaultConnectFuture;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.support.VmPipe;
import org.apache.mina.transport.vmpipe.support.VmPipeSessionImpl;
import org.apache.mina.util.AnonymousSocketAddress;

public class VmPipeConnector
extends BaseIoConnector {
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoServiceConfig defaultConfig = new BaseIoConnectorConfig(){

        public IoSessionConfig getSessionConfig() {
            return CONFIG;
        }
    };

    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoServiceConfig config) {
        return this.connect(address, null, handler, config);
    }

    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoServiceConfig config) {
        VmPipe entry;
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("address must be VmPipeAddress.");
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        if ((entry = (VmPipe)VmPipeAcceptor.boundHandlers.get(address)) == null) {
            return DefaultConnectFuture.newFailedFuture(new IOException("Endpoint unavailable: " + address));
        }
        DefaultConnectFuture future = new DefaultConnectFuture();
        try {
            VmPipeSessionImpl session = new VmPipeSessionImpl(this, config, this.getListeners(), new Object(), new AnonymousSocketAddress(), handler, entry);
            future.setSession(session);
        }
        catch (IOException e) {
            future.setException(e);
        }
        return future;
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }
}

