/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.support.BaseIoAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketIoProcessor;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.SocketSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.mina.util.NewThreadExecutor;
import org.apache.mina.util.Queue;

public class SocketAcceptor
extends BaseIoAcceptor {
    private static volatile int nextId = 0;
    private final Executor executor;
    private final Object lock = new Object();
    private final int id = nextId++;
    private final String threadName = "SocketAcceptor-" + this.id;
    private SocketAcceptorConfig defaultConfig = new SocketAcceptorConfig();
    private final Map channels = new HashMap();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final SocketIoProcessor[] ioProcessors;
    private final int processorCount;
    private Selector selector;
    private Worker worker;
    private int processorDistributor = 0;

    public SocketAcceptor() {
        this(1, new NewThreadExecutor());
    }

    public SocketAcceptor(int processorCount, Executor executor) {
        if (processorCount < 1) {
            throw new IllegalArgumentException("Must have at least one processor");
        }
        this.executor = executor;
        this.processorCount = processorCount;
        this.ioProcessors = new SocketIoProcessor[processorCount];
        for (int i = 0; i < processorCount; ++i) {
            this.ioProcessors[i] = new SocketIoProcessor("SocketAcceptorIoProcessor-" + this.id + "." + i, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress address, IoHandler handler, IoServiceConfig config) throws IOException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (((InetSocketAddress)address).getPort() == 0) {
            throw new IllegalArgumentException("Unsupported port number: 0");
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        RegistrationRequest request = new RegistrationRequest(address, handler, config);
        Object object = this.registerQueue;
        synchronized (object) {
            this.registerQueue.push(request);
        }
        this.startupWorker();
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        if (request.exception != null) {
            throw request.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startupWorker() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.selector = Selector.open();
                this.worker = new Worker();
                this.executor.execute((Runnable)new NamePreservingRunnable(this.worker));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(SocketAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest request = new CancellationRequest(address);
        try {
            this.startupWorker();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Address not bound: " + address);
        }
        Object object = this.cancelQueue;
        synchronized (object) {
            this.cancelQueue.push(request);
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        if (request.exception != null) {
            request.exception.fillInStackTrace();
            throw request.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAll() {
        ArrayList addresses;
        Map map = this.channels;
        synchronized (map) {
            addresses = new ArrayList(this.channels.keySet());
        }
        Iterator i = addresses.iterator();
        while (i.hasNext()) {
            this.unbind((SocketAddress)i.next());
        }
    }

    private SocketIoProcessor nextProcessor() {
        return this.ioProcessors[this.processorDistributor++ % this.processorCount];
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(SocketAcceptorConfig defaultConfig) {
        if (defaultConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        while (true) {
            RegistrationRequest req;
            Queue queue = this.registerQueue;
            synchronized (queue) {
                req = (RegistrationRequest)this.registerQueue.pop();
            }
            if (req == null) return;
            ServerSocketChannel ssc = null;
            try {
                ssc = ServerSocketChannel.open();
                ssc.configureBlocking(false);
                SocketAcceptorConfig cfg = req.config instanceof SocketAcceptorConfig ? (SocketAcceptorConfig)req.config : (SocketAcceptorConfig)this.getDefaultConfig();
                ssc.socket().setReuseAddress(cfg.isReuseAddress());
                ssc.socket().setReceiveBufferSize(((SocketSessionConfig)cfg.getSessionConfig()).getReceiveBufferSize());
                ssc.socket().bind(req.address, cfg.getBacklog());
                ssc.register(this.selector, 16, req);
                Map map = this.channels;
                synchronized (map) {
                    this.channels.put(req.address, ssc);
                }
                this.getListeners().fireServiceActivated(this, req.address, req.handler, req.config);
                continue;
            }
            catch (IOException e) {
                req.exception = e;
                continue;
            }
            finally {
                RegistrationRequest e = req;
                synchronized (e) {
                    req.done = true;
                    req.notifyAll();
                }
                if (ssc == null || req.exception == null) continue;
                try {
                    ssc.close();
                }
                catch (IOException e2) {
                    ExceptionMonitor.getInstance().exceptionCaught(e2);
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        while (true) {
            ServerSocketChannel ssc;
            CancellationRequest request;
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                request = (CancellationRequest)this.cancelQueue.pop();
            }
            if (request == null) return;
            Object object = this.channels;
            synchronized (object) {
                ssc = (ServerSocketChannel)this.channels.remove(request.address);
            }
            try {
                if (ssc == null) {
                    request.exception = new IllegalArgumentException("Address not bound: " + request.address);
                    continue;
                }
                SelectionKey key = ssc.keyFor(this.selector);
                request.registrationRequest = (RegistrationRequest)key.attachment();
                key.cancel();
                this.selector.wakeup();
                ssc.close();
                continue;
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
                continue;
            }
            finally {
                object = request;
                synchronized (object) {
                    request.done = true;
                    request.notifyAll();
                }
                if (request.exception != null) continue;
                this.getListeners().fireServiceDeactivated(this, request.address, request.registrationRequest.handler, request.registrationRequest.config);
                continue;
            }
            break;
        }
    }

    private static class CancellationRequest {
        private final SocketAddress address;
        private boolean done;
        private RegistrationRequest registrationRequest;
        private RuntimeException exception;

        private CancellationRequest(SocketAddress address) {
            this.address = address;
        }
    }

    private static class RegistrationRequest {
        private final SocketAddress address;
        private final IoHandler handler;
        private final IoServiceConfig config;
        private IOException exception;
        private boolean done;

        private RegistrationRequest(SocketAddress address, IoHandler handler, IoServiceConfig config) {
            this.address = address;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName(SocketAcceptor.this.threadName);
            while (true) {
                try {
                    do {
                        int nKeys = SocketAcceptor.this.selector.select();
                        SocketAcceptor.this.registerNew();
                        SocketAcceptor.this.cancelKeys();
                        if (nKeys <= 0) continue;
                        this.processSessions(SocketAcceptor.this.selector.selectedKeys());
                    } while (!SocketAcceptor.this.selector.keys().isEmpty());
                    Object object = SocketAcceptor.this.lock;
                    synchronized (object) {
                        if (SocketAcceptor.this.selector.keys().isEmpty() && SocketAcceptor.this.registerQueue.isEmpty() && SocketAcceptor.this.cancelQueue.isEmpty()) {
                            SocketAcceptor.this.worker = null;
                            try {
                                SocketAcceptor.this.selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                SocketAcceptor.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processSessions(Set keys) throws IOException {
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                ServerSocketChannel ssc;
                SocketChannel ch;
                SelectionKey key = (SelectionKey)it.next();
                it.remove();
                if (!key.isAcceptable() || (ch = (ssc = (ServerSocketChannel)key.channel()).accept()) == null) continue;
                boolean success = false;
                try {
                    RegistrationRequest req = (RegistrationRequest)key.attachment();
                    SocketSessionImpl session = new SocketSessionImpl(SocketAcceptor.this, SocketAcceptor.this.nextProcessor(), SocketAcceptor.this.getListeners(), req.config, ch, req.handler, req.address);
                    SocketAcceptor.this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
                    req.config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
                    req.config.getThreadModel().buildFilterChain(session.getFilterChain());
                    session.getIoProcessor().addNew(session);
                    success = true;
                }
                catch (Throwable t) {
                    ExceptionMonitor.getInstance().exceptionCaught(t);
                }
                finally {
                    if (success) continue;
                    ch.close();
                }
            }
        }
    }
}

