/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.pagination;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.pagination.Pagination;
import org.displaytag.properties.TableProperties;

public class SmartListHelper {
    private static Log log = LogFactory.getLog((Class)(class$org$displaytag$pagination$SmartListHelper == null ? (class$org$displaytag$pagination$SmartListHelper = SmartListHelper.class$("org.displaytag.pagination.SmartListHelper")) : class$org$displaytag$pagination$SmartListHelper));
    private List fullList;
    private int fullListSize;
    private int pageSize;
    private int pageCount;
    private int currentPage;
    private TableProperties properties = null;
    static /* synthetic */ Class class$org$displaytag$pagination$SmartListHelper;

    public SmartListHelper(List list, int size, TableProperties tableProperties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("new SmartListHelper: list.size= " + list.size() + " page size=" + size));
        }
        if (list == null || size < 1) {
            throw new IllegalArgumentException("Bad arguments passed into SmartListHelper() constructor. List=" + list + ", pagesize=" + size);
        }
        this.properties = tableProperties;
        this.pageSize = size;
        this.fullList = list;
        this.fullListSize = this.fullList != null ? list.size() : 0;
        this.pageCount = this.computedPageCount();
        this.currentPage = 1;
    }

    protected int computedPageCount() {
        int result = 0;
        if (this.fullList != null && this.pageSize > 0) {
            int size = this.fullListSize;
            int div = size / this.pageSize;
            int mod = size % this.pageSize;
            result = mod == 0 ? div : div + 1;
        }
        return result;
    }

    protected int getFirstIndexForCurrentPage() {
        return this.getFirstIndexForPage(this.currentPage);
    }

    protected int getLastIndexForCurrentPage() {
        return this.getLastIndexForPage(this.currentPage);
    }

    protected int getFirstIndexForPage(int pageNumber) {
        return (pageNumber - 1) * this.pageSize;
    }

    protected int getLastIndexForPage(int pageNumber) {
        int firstIndex = this.getFirstIndexForPage(pageNumber);
        int pageIndex = this.pageSize - 1;
        int lastIndex = this.fullListSize - 1;
        return Math.min(firstIndex + pageIndex, lastIndex);
    }

    public List getListForCurrentPage() {
        return this.getListForPage(this.currentPage);
    }

    protected List getListForPage(int pageNumber) {
        log.debug((Object)("getListForPage page=" + pageNumber));
        ArrayList list = new ArrayList(this.pageSize + 1);
        int firstIndex = this.getFirstIndexForPage(pageNumber);
        int lastIndex = this.getLastIndexForPage(pageNumber);
        Iterator iterator = this.fullList.iterator();
        int j = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (j > lastIndex) break;
            if (j >= firstIndex) {
                list.add(object);
            }
            ++j;
        }
        return list;
    }

    public void setCurrentPage(int pageNumber) {
        log.debug((Object)("setCurrentPage: page=" + pageNumber + " of " + this.pageCount));
        this.currentPage = pageNumber < 1 || pageNumber != 1 && pageNumber > this.pageCount ? 1 : pageNumber;
    }

    public String getSearchResultsSummary() {
        if (this.fullListSize == 0) {
            log.debug((Object)"returning paging.banner.no_items_found");
            Object[] objs = new Object[]{this.properties.getPagingItemsName()};
            return MessageFormat.format(this.properties.getPagingFoundNoItems(), objs);
        }
        if (this.fullListSize == 1) {
            log.debug((Object)"returning paging.banner.one_item_found");
            Object[] objs = new Object[]{this.properties.getPagingItemName()};
            return MessageFormat.format(this.properties.getPagingFoundOneItem(), objs);
        }
        if (this.computedPageCount() == 1) {
            Object[] objs = new Object[]{new Integer(this.fullListSize), this.properties.getPagingItemsName(), this.properties.getPagingItemsName()};
            log.debug((Object)"returning paging.banner.all_items_found");
            return MessageFormat.format(this.properties.getPagingFoundAllItems(), objs);
        }
        Object[] objs = new Object[]{new Integer(this.fullListSize), this.properties.getPagingItemsName(), new Integer(this.getFirstIndexForCurrentPage() + 1), new Integer(this.getLastIndexForCurrentPage() + 1)};
        log.debug((Object)"returning paging.banner.some_items_found");
        return MessageFormat.format(this.properties.getPagingFoundSomeItems(), objs);
    }

    public String getPageNavigationBar(String urlFormatString) {
        log.debug((Object)"getPageNavigationBar");
        int maxPages = 8;
        maxPages = this.properties.getPagingGroupSize(maxPages);
        int currentIndex = this.currentPage;
        int count = this.pageCount;
        int startPage = 1;
        int endPage = maxPages;
        Pagination pagination = new Pagination(urlFormatString);
        log.debug((Object)("this.pageCount=" + this.pageCount));
        if (count == 0) {
            pagination.addPage(1, true);
        }
        if (currentIndex < maxPages) {
            startPage = 1;
            endPage = maxPages;
            if (count < endPage) {
                endPage = count;
            }
        } else {
            startPage = currentIndex;
            while (startPage + maxPages > count + 1) {
                --startPage;
            }
            endPage = startPage + (maxPages - 1);
        }
        if (currentIndex != 1) {
            pagination.setFirst(new Integer(1));
            pagination.setPrevious(new Integer(currentIndex - 1));
        }
        int j = startPage;
        while (j <= endPage) {
            log.debug((Object)("adding page " + j));
            pagination.addPage(j, j == currentIndex);
            ++j;
        }
        if (currentIndex != count) {
            pagination.setNext(new Integer(currentIndex + 1));
            pagination.setLast(new Integer(count));
        }
        log.debug((Object)("lPagination.isOnePage()=" + pagination.isOnePage()));
        String bannerFormat = pagination.isOnePage() ? this.properties.getPagingBannerOnePage() : (pagination.isFirst() ? this.properties.getPagingBannerFirst() : (pagination.isLast() ? this.properties.getPagingBannerLast() : this.properties.getPagingBannerFull()));
        log.debug((Object)"getPageNavigationBar end");
        return pagination.getFormattedBanner(this.properties.getPagingPageLink(), this.properties.getPagingPageSelected(), this.properties.getPagingPageSeparator(), bannerFormat);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("fullList", (Object)this.fullList).append("fullListSize", this.fullListSize).append("pageSize", this.pageSize).append("pageCount", this.pageCount).append("properties", (Object)this.properties).append("currentPage", this.currentPage).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

