/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ArrayConverter;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.HexColorConverter;
import com.jidesoft.converter.ObjectConverterManager;
import java.awt.Color;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArrayConverter
extends ArrayConverter {
    public DefaultArrayConverter(String string, Class<?> clazz) {
        super(string, -1, clazz);
    }

    @Override
    public String toString(Object object, ConverterContext converterContext) {
        if (object == null) {
            return "";
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = this.getElementClass() == Object.class ? (Object[])object : new Object[Array.getLength(object)];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = Array.get(object, i);
            }
            return this.arrayToString(objectArray, converterContext);
        }
        return ObjectConverterManager.toString(object, this.getElementClass(), converterContext);
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext converterContext) {
        if (string == null || "".equals(string)) {
            return new Object[0];
        }
        Object[] objectArray = this.arrayFromString(string, converterContext);
        if (objectArray == null) {
            return new Object[0];
        }
        Class<?> clazz = this.getElementClass();
        if (clazz == Object.class) {
            return objectArray;
        }
        Object[] object = objectArray;
        int n = object.length;
        for (int object2 = 0; object2 < n; ++object2) {
            Object object3 = object[object2];
            if (clazz.isAssignableFrom(object3.getClass())) continue;
            return new Object[0];
        }
        Object object4 = Array.newInstance(clazz, objectArray.length);
        for (n = 0; n < objectArray.length; ++n) {
            Object object5 = objectArray[n];
            Array.set(object4, n, object5);
        }
        return object4;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public static void main(String[] stringArray) {
        System.out.println(new DefaultArrayConverter(";", Integer.TYPE).toString(new int[]{2, 3, 2, 4}, null));
        System.out.println(new DefaultArrayConverter(";", Integer.TYPE).fromString("2;3;2;4", null));
        System.out.println(new DefaultArrayConverter(";", Color.class).toString(new Color[]{Color.RED, Color.YELLOW, Color.GREEN}, HexColorConverter.CONTEXT_HEX));
        System.out.println(new DefaultArrayConverter(";", Color.class).fromString("#FF0000;#FFFF00;#00FF00", HexColorConverter.CONTEXT_HEX));
        System.out.println(new DefaultArrayConverter(";", Object.class).fromString("#FF0000;#FFFF00;#00FF00", null));
    }
}

