/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.ems;

import com.tibco.tibjms.admin.DestinationInfo;
import com.tibco.tibjms.admin.DurableInfo;
import com.tibco.tibjms.admin.QueueInfo;
import com.tibco.tibjms.admin.TibjmsAdmin;
import com.tibco.tibjms.admin.TibjmsAdminException;
import com.tibco.tibjms.admin.TopicInfo;
import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.ext.ems.TibcoEMSAdminFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TibcoEMSAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(TibcoEMSAdmin.class);
    private TibcoEMSAdminFactory factory;
    private TibjmsAdmin admin;

    public TibcoEMSAdmin(Hermes hermes, TibcoEMSAdminFactory factory) {
        super(hermes);
        this.factory = factory;
    }

    private synchronized TibjmsAdmin getAdmin() throws JMSException {
        if (this.admin == null) {
            this.admin = this.factory.createAdmin(this.getHermes().getConnectionFactory());
        }
        return this.admin;
    }

    public synchronized void close() throws JMSException {
        try {
            if (this.admin != null) {
                this.admin.close();
                this.admin = null;
            }
        }
        catch (TibjmsAdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }

    public int getDepth(DestinationConfig destination) throws JMSException {
        if (destination.isDurable()) {
            try {
                DurableInfo info = this.getAdmin().getDurable(destination.getClientID(), this.getHermes().getConnection().getClientID());
                if (info != null) {
                    return (int)info.getPendingMessageCount();
                }
                throw new HermesException("No durable information availble for clientID=" + this.getHermes().getConnection().getClientID() + ", durableName=" + destination.getClientID());
            }
            catch (TibjmsAdminException ex) {
                throw new HermesException((Exception)((Object)ex));
            }
        }
        DestinationInfo info = this.getDestinationInfo(destination);
        if (info != null) {
            return (int)info.getPendingMessageCount();
        }
        return 0;
    }

    public Map getStatistics(DestinationConfig destination) throws JMSException {
        try {
            DestinationInfo info = this.getDestinationInfo(destination);
            TreeMap<String, Long> rval = new TreeMap<String, Long>();
            rval.putAll(PropertyUtils.describe((Object)info));
            rval.remove("inboundStatistics");
            rval.remove("outboundStatistics");
            rval.put("inboundByteRate", new Long(info.getInboundStatistics().getByteRate()));
            rval.put("inboundMessageRate", new Long(info.getInboundStatistics().getMessageRate()));
            rval.put("inboundTotalBytes", new Long(info.getInboundStatistics().getTotalBytes()));
            rval.put("inboundTotalMessages", new Long(info.getInboundStatistics().getTotalMessages()));
            rval.put("outboundByteRate", new Long(info.getOutboundStatistics().getByteRate()));
            rval.put("outboundMessageRate", new Long(info.getOutboundStatistics().getMessageRate()));
            rval.put("outboundTotalBytes", new Long(info.getOutboundStatistics().getTotalBytes()));
            rval.put("outboundTotalMessages", new Long(info.getOutboundStatistics().getTotalMessages()));
            return rval;
        }
        catch (IllegalAccessException e) {
            throw new HermesException((Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new HermesException((Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new HermesException((Exception)e);
        }
    }

    private DestinationInfo getDestinationInfo(DestinationConfig dConfig) throws JMSException {
        try {
            if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                return this.getAdmin().getQueue(this.getRealDestinationName(dConfig));
            }
            return this.getAdmin().getTopic(this.getRealDestinationName(dConfig));
        }
        catch (TibjmsAdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }

    private DestinationInfo getDestinationInfo(Destination destination) throws JMSException {
        String name = this.getHermes().getDestinationName(destination);
        try {
            if (destination instanceof Queue) {
                return this.getAdmin().getQueue(name);
            }
            return this.getAdmin().getTopic(name);
        }
        catch (TibjmsAdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }

    public int truncate(DestinationConfig dConfig) throws JMSException {
        try {
            int rval = this.getDepth(dConfig);
            if (dConfig.getDomain().intValue() == Domain.QUEUE.getId()) {
                this.getAdmin().purgeQueue(dConfig.getName());
            } else if (dConfig.isDurable()) {
                this.getAdmin().purgeDurable(dConfig.getClientID(), this.getHermes().getConnection().getClientID());
            } else {
                this.getAdmin().purgeTopic(dConfig.getName());
            }
            return rval;
        }
        catch (TibjmsAdminException e) {
            throw new HermesException((Exception)((Object)e));
        }
    }

    public Collection discoverDestinationConfigs() throws JMSException {
        try {
            DestinationConfig dConfig;
            int i;
            boolean both;
            ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
            boolean bl = both = this.getHermes().getConnectionFactory() instanceof TopicConnectionFactory && this.getHermes().getConnectionFactory() instanceof TopicConnectionFactory;
            if (!(this.getHermes().getConnectionFactory() instanceof TopicConnectionFactory) || both) {
                QueueInfo[] qinfos = this.getAdmin().getQueues();
                for (i = 0; i < qinfos.length; ++i) {
                    if (this.getHermes().getConnectionFactory() instanceof JNDIConnectionFactory) {
                        if (qinfos[i].getJNDINames() == null) continue;
                        for (int j = 0; j < qinfos[i].getJNDINames().length; ++j) {
                            dConfig = HermesBrowser.getConfigDAO().createDestinationConfig();
                            dConfig.setName(qinfos[i].getJNDINames()[j]);
                            dConfig.setDomain(Integer.valueOf(Domain.QUEUE.getId()));
                            rval.add(dConfig);
                        }
                        continue;
                    }
                    DestinationConfig dConfig2 = HermesBrowser.getConfigDAO().createDestinationConfig();
                    dConfig2.setName(qinfos[i].getName());
                    dConfig2.setDomain(Integer.valueOf(Domain.QUEUE.getId()));
                    rval.add(dConfig2);
                }
            }
            if (!(this.getHermes().getConnectionFactory() instanceof QueueConnectionFactory) || both) {
                TopicInfo[] tinfos = this.getAdmin().getTopics();
                for (i = 0; i < tinfos.length; ++i) {
                    if (this.getHermes().getConnectionFactory() instanceof JNDIConnectionFactory) {
                        if (tinfos[i].getJNDINames() == null) continue;
                        for (int j = 0; j < tinfos[i].getJNDINames().length; ++j) {
                            dConfig = HermesBrowser.getConfigDAO().createDestinationConfig();
                            dConfig.setName(tinfos[i].getJNDINames()[j]);
                            dConfig.setDomain(Integer.valueOf(Domain.TOPIC.getId()));
                            rval.add(dConfig);
                            rval.addAll(this.discoverDurableSubscriptions(tinfos[i].getName(), tinfos[i].getJNDINames()[j]));
                        }
                        continue;
                    }
                    DestinationConfig dConfig3 = HermesBrowser.getConfigDAO().createDestinationConfig();
                    dConfig3.setName(tinfos[i].getName());
                    dConfig3.setDomain(Integer.valueOf(Domain.TOPIC.getId()));
                    rval.add(dConfig3);
                    rval.addAll(this.discoverDurableSubscriptions(tinfos[i].getName(), null));
                }
            }
            return rval;
        }
        catch (TibjmsAdminException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HermesException((Exception)((Object)e));
        }
    }

    protected Collection<DestinationConfig> discoverDurableSubscriptions(String topicName, String jndiName) throws JMSException {
        try {
            ArrayList<DestinationConfig> rval = new ArrayList<DestinationConfig>();
            DurableInfo[] dInfos = this.getAdmin().getDurables(topicName);
            for (int j = 0; j < dInfos.length; ++j) {
                DurableInfo dInfo = dInfos[j];
                DestinationConfig dConfig = HermesBrowser.getConfigDAO().createDestinationConfig();
                dConfig.setDurable(Boolean.valueOf(true));
                dConfig.setName(jndiName == null ? dInfo.getTopicName() : jndiName);
                dConfig.setClientID(dInfo.getDurableName());
                dConfig.setSelector(dInfo.getSelector());
                dConfig.setDomain(Integer.valueOf(Domain.TOPIC.getId()));
                rval.add(dConfig);
            }
            return rval;
        }
        catch (TibjmsAdminException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new HermesException((Exception)((Object)e));
        }
    }
}

