/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMapIter;
import org.python.core.PyTuple;
import org.python.core.ThreadState;

public class PyStringMap
extends PyObject {
    private static final int[] primes = new int[]{7, 13, 31, 61, 127, 251, 509, 1021, 2017, 4093, 5987, 9551, 15683, 19609, 31397, 65521, 131071, 262139, 524287, 1048573, 0x1FFFF7, 0x3FFFFD, 0x7FFFF1, 0xFFFFFD, 33554393, 0x3FFFFFB, 134217689, 0xFFFFFC7, 0x1FFFFFFD, 0x3FFFFFDD};
    private transient String[] keys = null;
    private transient PyObject[] values = null;
    private int size;
    private transient int filled;
    private transient int prime = 0;
    private transient int popfinger;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        String[] stringArray = this.keys;
        PyObject[] pyObjectArray = this.values;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            PyObject pyObject = pyObjectArray[i];
            if (pyObject == null) continue;
            objectOutputStream.writeUTF(this.keys[i]);
            objectOutputStream.writeObject(this.values[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.prime = 1;
        this.keys = null;
        this.values = null;
        int n = this.size;
        this.resize(n);
        for (int i = 0; i < n; ++i) {
            String string = objectInputStream.readUTF().intern();
            this.insertkey(string, (PyObject)objectInputStream.readObject());
        }
    }

    public PyStringMap(int n) {
        this.resize(n);
    }

    public PyStringMap() {
        this(4);
    }

    public PyStringMap(PyObject[] pyObjectArray) {
        this(pyObjectArray.length);
        for (int i = 0; i < pyObjectArray.length; i += 2) {
            this.__setitem__(pyObjectArray[i], pyObjectArray[i + 1]);
        }
    }

    public synchronized int __len__() {
        return this.size;
    }

    public synchronized boolean __nonzero__() {
        return this.size != 0;
    }

    public synchronized PyObject __finditem__(String string) {
        String[] stringArray = this.keys;
        int n = stringArray.length;
        int n2 = (System.identityHashCode(string) & Integer.MAX_VALUE) % n;
        int n3 = n / 5;
        String string2;
        while ((string2 = stringArray[n2]) != string) {
            if (string2 == null) {
                return this.values[n2];
            }
            n2 = (n2 + n3) % n;
        }
        return this.values[n2];
    }

    public PyObject __finditem__(PyObject pyObject) {
        if (pyObject instanceof PyString) {
            return this.__finditem__(((PyString)pyObject).internedString());
        }
        return null;
    }

    public PyObject __iter__() {
        return new PyStringMapIter(this.keys, this.values);
    }

    private final void insertkey(String string, PyObject pyObject) {
        String[] stringArray = this.keys;
        int n = stringArray.length;
        int n2 = (System.identityHashCode(string) & Integer.MAX_VALUE) % n;
        int n3 = n / 5;
        int n4 = -1;
        while (true) {
            String string2;
            if ((string2 = stringArray[n2]) == null) {
                if (n4 != -1) break;
                ++this.filled;
                n4 = n2;
                break;
            }
            if (string2 == string) {
                this.values[n2] = pyObject;
                return;
            }
            if (string2 == "<deleted key>" && n4 == -1) {
                n4 = n2;
            }
            n2 = (n2 + n3) % n;
        }
        stringArray[n4] = string;
        this.values[n4] = pyObject;
        ++this.size;
    }

    private final synchronized void resize(int n) {
        int n2;
        for (n2 = this.prime; n2 < primes.length && primes[n2] < n; ++n2) {
        }
        if (primes[n2] < n) {
            throw Py.ValueError("can't make hashtable of size: " + n);
        }
        n = primes[n2];
        this.prime = n2;
        String[] stringArray = this.keys;
        PyObject[] pyObjectArray = this.values;
        this.keys = new String[n];
        this.values = new PyObject[n];
        this.size = 0;
        this.filled = 0;
        if (pyObjectArray != null) {
            int n3 = pyObjectArray.length;
            for (int i = 0; i < n3; ++i) {
                PyObject pyObject = pyObjectArray[i];
                if (pyObject == null) continue;
                this.insertkey(stringArray[i], pyObject);
            }
        }
    }

    public synchronized void __setitem__(String string, PyObject pyObject) {
        if (2 * this.filled > this.keys.length) {
            this.resize(this.keys.length + 1);
        }
        this.insertkey(string, pyObject);
    }

    public void __setitem__(PyObject pyObject, PyObject pyObject2) {
        if (!(pyObject instanceof PyString)) {
            throw Py.TypeError("keys in namespace must be strings");
        }
        this.__setitem__(((PyString)pyObject).internedString(), pyObject2);
    }

    public synchronized void __delitem__(String string) {
        String[] stringArray = this.keys;
        int n = stringArray.length;
        int n2 = (System.identityHashCode(string) & Integer.MAX_VALUE) % n;
        int n3 = n / 5;
        while (true) {
            String string2;
            if ((string2 = stringArray[n2]) == null) {
                throw Py.KeyError(string);
            }
            if (string2 == string) {
                stringArray[n2] = "<deleted key>";
                this.values[n2] = null;
                --this.size;
                break;
            }
            n2 = (n2 + n3) % n;
        }
    }

    public void __delitem__(PyObject pyObject) {
        if (!(pyObject instanceof PyString)) {
            throw Py.KeyError(pyObject.toString());
        }
        this.__delitem__(((PyString)pyObject).internedString());
    }

    public synchronized void clear() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = 0;
    }

    public synchronized String toString() {
        int n;
        ThreadState threadState = Py.getThreadState();
        if (!threadState.enterRepr(this)) {
            return "{...}";
        }
        String[] stringArray = this.keys;
        PyObject[] pyObjectArray = this.values;
        int n2 = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer("{");
        for (n = 0; n < n2; ++n) {
            PyObject pyObject = pyObjectArray[n];
            if (pyObject == null) continue;
            stringBuffer.append("'");
            stringBuffer.append(stringArray[n]);
            stringBuffer.append("': ");
            stringBuffer.append(pyObject.__repr__().toString());
            stringBuffer.append(", ");
        }
        n = stringBuffer.length();
        if (n > 4) {
            stringBuffer.setLength(n - 2);
        }
        stringBuffer.append("}");
        threadState.exitRepr(this);
        return stringBuffer.toString();
    }

    public synchronized int __cmp__(PyObject pyObject) {
        int n;
        if (!(pyObject instanceof PyStringMap) && !(pyObject instanceof PyDictionary)) {
            return -2;
        }
        int n2 = this.__len__();
        if (n2 < (n = pyObject.__len__())) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        PyList pyList = this.keys();
        PyList pyList2 = null;
        pyList2 = pyObject instanceof PyStringMap ? ((PyStringMap)pyObject).keys() : ((PyDictionary)pyObject).keys();
        pyList.sort();
        pyList2.sort();
        for (int i = 0; i < n; ++i) {
            PyObject pyObject2;
            PyObject pyObject3;
            PyObject pyObject4 = pyList.pyget(i);
            int n3 = pyObject4._cmp(pyObject3 = pyList2.pyget(i));
            if (n3 != 0) {
                return n3;
            }
            PyObject pyObject5 = this.__finditem__(pyObject4);
            n3 = pyObject5._cmp(pyObject2 = pyObject.__finditem__(pyObject3));
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    public boolean has_key(PyObject pyObject) {
        return this.__finditem__(pyObject) != null;
    }

    public PyObject get(PyObject pyObject, PyObject pyObject2) {
        PyObject pyObject3 = this.__finditem__(pyObject);
        if (pyObject3 == null) {
            return pyObject2;
        }
        return pyObject3;
    }

    public PyObject get(PyObject pyObject) {
        return this.get(pyObject, Py.None);
    }

    public synchronized PyStringMap copy() {
        int n = this.keys.length;
        PyStringMap pyStringMap = new PyStringMap(n);
        System.arraycopy(this.keys, 0, pyStringMap.keys, 0, n);
        System.arraycopy(this.values, 0, pyStringMap.values, 0, n);
        pyStringMap.filled = this.filled;
        pyStringMap.size = this.size;
        pyStringMap.prime = this.prime;
        return pyStringMap;
    }

    public synchronized void update(PyStringMap pyStringMap) {
        String[] stringArray = pyStringMap.keys;
        PyObject[] pyObjectArray = pyStringMap.values;
        int n = stringArray.length;
        if (2 * this.filled + n > this.keys.length) {
            this.resize(2 * this.filled + n);
        }
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null || string == "<deleted key>") continue;
            this.insertkey(string, pyObjectArray[i]);
        }
    }

    public void update(PyDictionary pyDictionary) {
        Hashtable hashtable = pyDictionary.table;
        Enumeration enumeration = hashtable.keys();
        Enumeration enumeration2 = hashtable.elements();
        int n = hashtable.size();
        for (int i = 0; i < n; ++i) {
            this.__setitem__((PyObject)enumeration.nextElement(), (PyObject)enumeration2.nextElement());
        }
    }

    public PyObject setdefault(PyObject pyObject) {
        return this.setdefault(pyObject, Py.None);
    }

    public PyObject setdefault(PyObject pyObject, PyObject pyObject2) {
        PyObject pyObject3 = this.__finditem__(pyObject);
        if (pyObject3 == null) {
            pyObject3 = pyObject2;
            this.__setitem__(pyObject, pyObject3);
        }
        return pyObject3;
    }

    public synchronized PyObject popitem() {
        Object object;
        if (this.size == 0) {
            throw Py.KeyError("popitem(): dictionary is empty");
        }
        int n = this.popfinger;
        String[] stringArray = this.keys;
        int n2 = stringArray.length;
        if (n >= n2 || n < 0) {
            n = 1;
        }
        while ((object = stringArray[n]) == null || object == "<deleted key>") {
            if (++n < n2) continue;
            n = 0;
        }
        this.popfinger = n + 1;
        object = Py.newString(stringArray[n]);
        PyObject pyObject = this.values[n];
        stringArray[n] = "<deleted key>";
        this.values[n] = null;
        --this.size;
        return new PyTuple(new PyObject[]{object, pyObject});
    }

    public synchronized PyList items() {
        String[] stringArray = this.keys;
        PyObject[] pyObjectArray = this.values;
        int n = stringArray.length;
        PyList pyList = new PyList();
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null || string == "<deleted key>" || this.values[i] == null) continue;
            pyList.append(new PyTuple(new PyObject[]{new PyString(string), pyObjectArray[i]}));
        }
        return pyList;
    }

    synchronized String[] jkeys() {
        String[] stringArray = this.keys;
        int n = stringArray.length;
        String[] stringArray2 = new String[this.size];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null || string == "<deleted key>") continue;
            stringArray2[n2++] = string;
        }
        return stringArray2;
    }

    public synchronized PyList keys() {
        String[] stringArray = this.keys;
        int n = stringArray.length;
        PyList pyList = new PyList();
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null || string == "<deleted key>" || this.values[i] == null) continue;
            pyList.append(new PyString(string));
        }
        return pyList;
    }

    public synchronized PyList values() {
        PyObject[] pyObjectArray = this.values;
        int n = pyObjectArray.length;
        PyList pyList = new PyList();
        for (int i = 0; i < n; ++i) {
            PyObject pyObject = pyObjectArray[i];
            if (pyObject == null) continue;
            pyList.append(pyObject);
        }
        return pyList;
    }

    public synchronized PyObject iteritems() {
        return new PyStringMapIter(this.keys, this.values, 2);
    }

    public synchronized PyObject iterkeys() {
        return new PyStringMapIter(this.keys, this.values, 0);
    }

    public synchronized PyObject itervalues() {
        return new PyStringMapIter(this.keys, this.values, 1);
    }
}

