/*
 * Decompiled with CFR 0.152.
 */
package hermes.ext.activemq;

import hermes.Domain;
import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesException;
import hermes.browser.HermesBrowser;
import hermes.config.DestinationConfig;
import hermes.ext.HermesAdminSupport;
import hermes.ext.activemq.ActiveMQAdminFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.QueueBrowser;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveMQAdmin
extends HermesAdminSupport
implements HermesAdmin {
    private static final Logger log = Logger.getLogger(ActiveMQAdmin.class);
    private JMXServiceURL serviceURL;
    private JMXConnector connector;
    private MBeanServerConnection server;
    private String[] queueProperties = new String[]{"ConsumerCount", "EnqueueCount", "DequeueCount", "MemoryLimit", "MemoryPercentageUsed", "QueueSize"};
    private ActiveMQAdminFactory factory;

    public ActiveMQAdmin(ActiveMQAdminFactory factory, Hermes hermes, String brokerName, JMXServiceURL serviceURL) {
        super(hermes);
        this.serviceURL = serviceURL;
        this.factory = factory;
    }

    public int getDepth(DestinationConfig destination) throws JMSException {
        try {
            if (destination.getDomain().intValue() == Domain.QUEUE.getId()) {
                ObjectName objectName = this.getDestinationObjectName(destination);
                return ((Long)this.getConnection().getAttribute(objectName, "QueueSize")).intValue();
            }
            if (destination.getDomain().intValue() == Domain.TOPIC.getId() && destination.isDurable()) {
                ObjectName objectName = this.getDestinationObjectName(destination);
                return (Integer)this.getConnection().getAttribute(objectName, "PendingQueueSize");
            }
            return 0;
        }
        catch (Exception ex) {
            this.close();
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new HermesException(ex);
        }
    }

    public QueueBrowser createDurableSubscriptionBrowser(DestinationConfig dConfig) throws JMSException {
        try {
            return super.createDurableSubscriptionBrowser(dConfig);
        }
        catch (Exception ex) {
            throw new HermesException(ex);
        }
    }

    public Object getAttributeQuietly(ObjectName objectName, String attribute) {
        try {
            return this.getConnection().getAttribute(objectName, attribute);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
    }

    public Collection<DestinationConfig> discoverDestinationConfigs() throws JMSException {
        HashSet<DestinationConfig> rval = new HashSet<DestinationConfig>();
        try {
            ObjectName[] topics;
            String name;
            ObjectName[] queues;
            for (ObjectName queue : queues = (ObjectName[])this.getConnection().getAttribute(this.getBrokerObjectName(), "Queues")) {
                String name2 = (String)this.getConnection().getAttribute(queue, "Name");
                rval.add(HermesBrowser.getConfigDAO().createDestinationConfig(name2, Domain.QUEUE));
            }
            try {
                ObjectName[] tempQueues;
                for (ObjectName queue : tempQueues = (ObjectName[])this.getConnection().getAttribute(this.getBrokerObjectName(), "TemporaryQueues")) {
                    name = (String)this.getConnection().getAttribute(queue, "Name");
                    rval.add(HermesBrowser.getConfigDAO().createDestinationConfig(name, Domain.QUEUE));
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            for (ObjectName topic : topics = (ObjectName[])this.getConnection().getAttribute(this.getBrokerObjectName(), "Topics")) {
                name = (String)this.getConnection().getAttribute(topic, "Name");
                rval.add(HermesBrowser.getConfigDAO().createDestinationConfig(name, Domain.TOPIC));
            }
        }
        catch (Exception ex) {
            throw new HermesException(ex);
        }
        rval.addAll(this._discoverDurableSubscriptions());
        return rval;
    }

    protected Collection<DestinationConfig> _discoverDurableSubscriptions() throws JMSException {
        DestinationConfig dConfig;
        String subscriptionName;
        String name;
        ObjectName[] subs;
        HashSet<DestinationConfig> rval = new HashSet<DestinationConfig>();
        try {
            for (ObjectName sub : subs = (ObjectName[])this.getConnection().getAttribute(this.getBrokerObjectName(), "DurableTopicSubscribers")) {
                name = (String)this.getConnection().getAttribute(sub, "DestinationName");
                subscriptionName = (String)this.getConnection().getAttribute(sub, "SubscriptionName");
                dConfig = HermesBrowser.getConfigDAO().createDestinationConfig(name, Domain.TOPIC);
                dConfig.setDurable(Boolean.valueOf(true));
                dConfig.setClientID(subscriptionName);
                rval.add(dConfig);
            }
        }
        catch (Exception e) {
            throw new HermesException(e);
        }
        try {
            for (ObjectName sub : subs = (ObjectName[])this.getConnection().getAttribute(this.getBrokerObjectName(), "InactiveDurableTopicSubscribers")) {
                name = (String)this.getConnection().getAttribute(sub, "DestinationName");
                subscriptionName = (String)this.getConnection().getAttribute(sub, "SubscriptionName");
                dConfig = HermesBrowser.getConfigDAO().createDestinationConfig(name, Domain.TOPIC);
                dConfig.setDurable(Boolean.valueOf(true));
                dConfig.setClientID(subscriptionName);
                rval.add(dConfig);
            }
        }
        catch (Exception e) {
            throw new HermesException(e);
        }
        return rval;
    }

    public Map getStatistics(DestinationConfig destination) throws JMSException {
        HashMap<String, Object> rval = new HashMap<String, Object>();
        try {
            ObjectName objectName = this.getDestinationObjectName(destination);
            MBeanInfo objectInfo = this.getConnection().getMBeanInfo(objectName);
            for (MBeanAttributeInfo info : objectInfo.getAttributes()) {
                Object o = this.getConnection().getAttribute(objectName, info.getName());
                rval.put(info.getName(), o);
            }
        }
        catch (Exception ex) {
            this.close();
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new HermesException(ex);
        }
        return rval;
    }

    private ObjectName getDestinationObjectName(DestinationConfig destination) throws MalformedObjectNameException, NullPointerException, JMSException {
        if (destination.getDomain().intValue() == Domain.QUEUE.getId()) {
            return new ObjectName("org.apache.activemq:BrokerName=" + this.factory.getBrokerName() + ",Type=Queue,Destination=" + destination.getName());
        }
        if (destination.isDurable()) {
            try {
                return new ObjectName("org.apache.activemq:BrokerName=" + this.factory.getBrokerName() + ",Type=Subscription,active=true,name=" + this.getHermes().getConnection().getClientID() + "_" + destination.getClientID());
            }
            catch (MalformedObjectNameException e) {
                return new ObjectName("org.apache.activemq:BrokerName=" + this.factory.getBrokerName() + ",Type=Subscription,active=false,name=" + this.getHermes().getConnection().getClientID() + "_" + destination.getClientID());
            }
        }
        return new ObjectName("org.apache.activemq:BrokerName=" + this.factory.getBrokerName() + ",Type=Topic,Destination=" + destination.getName());
    }

    private ObjectName getBrokerObjectName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("org.apache.activemq:BrokerName=" + this.factory.getBrokerName() + ",Type=Broker");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        try {
            if (this.connector != null) {
                this.connector.close();
                log.debug((Object)("closed ActiveMQ JMX connection to " + this.factory.getBrokerName()));
            }
        }
        catch (IOException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.connector = null;
            this.server = null;
        }
    }

    private Map getMap() {
        if (this.factory.getUsername() == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String[]> rval = new HashMap<String, String[]>();
        rval.put("jmx.remote.credentials", new String[]{this.factory.getUsername(), this.factory.getPassword()});
        return rval;
    }

    private synchronized void connect() throws JMSException {
        this.close();
        try {
            this.connector = JMXConnectorFactory.connect(this.serviceURL, this.getMap());
            this.server = this.connector.getMBeanServerConnection();
        }
        catch (Exception ex) {
            throw new HermesException(ex);
        }
    }

    private synchronized MBeanServerConnection getConnection() throws JMSException {
        if (this.server == null) {
            this.connect();
        }
        return this.server;
    }
}

