/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.SmapGenerator;
import org.apache.jasper.compiler.SmapStratum;

public class SmapUtil {
    private static final boolean verbose = false;
    public static final String SMAP_ENCODING = "UTF-8";

    public static String generateSmap(JspCompilationContext ctxt, Node.Nodes pageNodes) throws IOException {
        SmapGenerator g = new SmapGenerator();
        SmapStratum s = new SmapStratum("JSP");
        g.setOutputFileName(SmapUtil.unqualify(ctxt.getServletJavaFileName()));
        SmapUtil.evaluateNodes(pageNodes, s);
        g.addStratum(s, true);
        if (ctxt.getOptions().isSmapDumped()) {
            File outSmap = new File(ctxt.getClassFileName() + ".smap");
            PrintWriter so = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outSmap), SMAP_ENCODING));
            so.print(g.getString());
            so.close();
        }
        return g.getString();
    }

    public static void installSmap(String classFileName, String smap) throws IOException {
        if (smap == null) {
            return;
        }
        File outServlet = new File(classFileName);
        SDEInstaller.install(outServlet, smap.getBytes());
    }

    private static String unqualify(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private static String inputSmapPath(String path) {
        return path.substring(0, path.lastIndexOf(46) + 1) + "smap";
    }

    public static void evaluateNodes(Node.Nodes nodes, SmapStratum s) {
        try {
            nodes.visit(new SmapGenVisitor(s));
        }
        catch (JasperException ex) {}
    }

    static class SmapGenVisitor
    extends Node.Visitor {
        private SmapStratum smap;

        SmapGenVisitor(SmapStratum s) {
            this.smap = s;
        }

        public void visit(Node.Declaration n) throws JasperException {
            this.doSmapText(n);
        }

        public void visit(Node.Expression n) throws JasperException {
            this.doSmapText(n);
        }

        public void visit(Node.Scriptlet n) throws JasperException {
            this.doSmapText(n);
        }

        public void visit(Node.IncludeAction n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.ForwardAction n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.GetProperty n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.SetProperty n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.UseBean n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.PlugIn n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.CustomTag n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.UninterpretedTag n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.JspElement n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.JspText n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.NamedAttribute n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.JspBody n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.InvokeAction n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.DoBodyAction n) throws JasperException {
            this.doSmap(n);
            this.visitBody(n);
        }

        public void visit(Node.TemplateText n) throws JasperException {
            String text = n.getText();
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) > ' ') break;
                ++i;
            }
            if (i < text.length()) {
                this.doSmap(n);
            }
        }

        private void doSmap(Node n, int inLineCount, int outIncrement, int skippedLines) {
            Mark mark = n.getStart();
            if (mark == null) {
                return;
            }
            String unqualifiedName = SmapUtil.unqualify(mark.getFile());
            this.smap.addFile(unqualifiedName, mark.getFile());
            this.smap.addLineData(mark.getLineNumber() + skippedLines, mark.getFile(), inLineCount - skippedLines, n.getBeginJavaLine() + skippedLines, outIncrement);
        }

        private void doSmap(Node n) {
            this.doSmap(n, 1, n.getEndJavaLine() - n.getBeginJavaLine(), 0);
        }

        private void doSmapText(Node n) {
            String text = n.getText();
            int index = 0;
            int next = 0;
            int lineCount = 1;
            int skippedLines = 0;
            boolean slashStarSeen = false;
            boolean beginning = true;
            while ((next = text.indexOf(10, index)) > -1) {
                if (beginning) {
                    String line = text.substring(index, next).trim();
                    if (!slashStarSeen && line.startsWith("/*")) {
                        slashStarSeen = true;
                    }
                    if (slashStarSeen) {
                        ++skippedLines;
                        int endIndex = line.indexOf("*/");
                        if (endIndex >= 0) {
                            slashStarSeen = false;
                            if (endIndex < line.length() - 2) {
                                --skippedLines;
                                beginning = false;
                            }
                        }
                    } else if (line.length() == 0 || line.startsWith("//")) {
                        ++skippedLines;
                    } else {
                        beginning = false;
                    }
                }
                ++lineCount;
                index = next + 1;
            }
            this.doSmap(n, lineCount, 1, skippedLines);
        }
    }

    private static class SDEInstaller {
        static final String nameSDE = "SourceDebugExtension";
        byte[] orig;
        byte[] sdeAttr;
        byte[] gen;
        int origPos = 0;
        int genPos = 0;
        int sdeIndex;

        public static void main(String[] args) throws IOException {
            if (args.length == 2) {
                SDEInstaller.install(new File(args[0]), new File(args[1]));
            } else if (args.length == 3) {
                SDEInstaller.install(new File(args[0]), new File(args[1]), new File(args[2]));
            } else {
                System.err.println("Usage: <command> <input class file> <attribute file> <output class file name>\n<command> <input/output class file> <attribute file>");
            }
        }

        static void install(File inClassFile, File attrFile, File outClassFile) throws IOException {
            new SDEInstaller(inClassFile, attrFile, outClassFile);
        }

        static void install(File inOutClassFile, File attrFile) throws IOException {
            File tmpFile = new File(inOutClassFile.getPath() + "tmp");
            new SDEInstaller(inOutClassFile, attrFile, tmpFile);
            if (!inOutClassFile.delete()) {
                throw new IOException("inOutClassFile.delete() failed");
            }
            if (!tmpFile.renameTo(inOutClassFile)) {
                throw new IOException("tmpFile.renameTo(inOutClassFile) failed");
            }
        }

        static void install(File classFile, byte[] smap) throws IOException {
            File tmpFile = new File(classFile.getPath() + "tmp");
            new SDEInstaller(classFile, smap, tmpFile);
            if (!classFile.delete()) {
                throw new IOException("classFile.delete() failed");
            }
            if (!tmpFile.renameTo(classFile)) {
                throw new IOException("tmpFile.renameTo(classFile) failed");
            }
        }

        SDEInstaller(File inClassFile, byte[] sdeAttr, File outClassFile) throws IOException {
            if (!inClassFile.exists()) {
                throw new FileNotFoundException("no such file: " + inClassFile);
            }
            this.sdeAttr = sdeAttr;
            this.orig = SDEInstaller.readWhole(inClassFile);
            this.gen = new byte[this.orig.length + sdeAttr.length + 100];
            this.addSDE();
            FileOutputStream outStream = new FileOutputStream(outClassFile);
            outStream.write(this.gen, 0, this.genPos);
            outStream.close();
        }

        SDEInstaller(File inClassFile, File attrFile, File outClassFile) throws IOException {
            this(inClassFile, SDEInstaller.readWhole(attrFile), outClassFile);
        }

        static byte[] readWhole(File input) throws IOException {
            FileInputStream inStream = new FileInputStream(input);
            int len = (int)input.length();
            byte[] bytes = new byte[len];
            if (inStream.read(bytes, 0, len) != len) {
                throw new IOException("expected size: " + len);
            }
            inStream.close();
            return bytes;
        }

        void addSDE() throws UnsupportedEncodingException, IOException {
            this.copy(8);
            int constantPoolCountPos = this.genPos;
            int constantPoolCount = this.readU2();
            this.writeU2(constantPoolCount);
            this.sdeIndex = this.copyConstantPool(constantPoolCount);
            if (this.sdeIndex < 0) {
                this.writeUtf8ForSDE();
                this.sdeIndex = constantPoolCount++;
                this.randomAccessWriteU2(constantPoolCountPos, constantPoolCount);
            }
            this.copy(6);
            int interfaceCount = this.readU2();
            this.writeU2(interfaceCount);
            this.copy(interfaceCount * 2);
            this.copyMembers();
            this.copyMembers();
            int attrCountPos = this.genPos;
            int attrCount = this.readU2();
            this.writeU2(attrCount);
            if (!this.copyAttrs(attrCount)) {
                this.randomAccessWriteU2(attrCountPos, ++attrCount);
            }
            this.writeAttrForSDE(this.sdeIndex);
        }

        void copyMembers() {
            int count = this.readU2();
            this.writeU2(count);
            int i = 0;
            while (i < count) {
                this.copy(6);
                int attrCount = this.readU2();
                this.writeU2(attrCount);
                this.copyAttrs(attrCount);
                ++i;
            }
        }

        boolean copyAttrs(int attrCount) {
            boolean sdeFound = false;
            int i = 0;
            while (i < attrCount) {
                int nameIndex = this.readU2();
                if (nameIndex == this.sdeIndex) {
                    sdeFound = true;
                } else {
                    this.writeU2(nameIndex);
                    int len = this.readU4();
                    this.writeU4(len);
                    this.copy(len);
                }
                ++i;
            }
            return sdeFound;
        }

        void writeAttrForSDE(int index) {
            this.writeU2(index);
            this.writeU4(this.sdeAttr.length);
            int i = 0;
            while (i < this.sdeAttr.length) {
                this.writeU1(this.sdeAttr[i]);
                ++i;
            }
        }

        void randomAccessWriteU2(int pos, int val) {
            int savePos = this.genPos;
            this.genPos = pos;
            this.writeU2(val);
            this.genPos = savePos;
        }

        int readU1() {
            return this.orig[this.origPos++] & 0xFF;
        }

        int readU2() {
            int res = this.readU1();
            return (res << 8) + this.readU1();
        }

        int readU4() {
            int res = this.readU2();
            return (res << 16) + this.readU2();
        }

        void writeU1(int val) {
            this.gen[this.genPos++] = (byte)val;
        }

        void writeU2(int val) {
            this.writeU1(val >> 8);
            this.writeU1(val & 0xFF);
        }

        void writeU4(int val) {
            this.writeU2(val >> 16);
            this.writeU2(val & 0xFFFF);
        }

        void copy(int count) {
            int i = 0;
            while (i < count) {
                this.gen[this.genPos++] = this.orig[this.origPos++];
                ++i;
            }
        }

        byte[] readBytes(int count) {
            byte[] bytes = new byte[count];
            int i = 0;
            while (i < count) {
                bytes[i] = this.orig[this.origPos++];
                ++i;
            }
            return bytes;
        }

        void writeBytes(byte[] bytes) {
            int i = 0;
            while (i < bytes.length) {
                this.gen[this.genPos++] = bytes[i];
                ++i;
            }
        }

        int copyConstantPool(int constantPoolCount) throws UnsupportedEncodingException, IOException {
            int sdeIndex = -1;
            int i = 1;
            while (i < constantPoolCount) {
                int tag = this.readU1();
                this.writeU1(tag);
                switch (tag) {
                    case 7: 
                    case 8: {
                        this.copy(2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        this.copy(4);
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.copy(8);
                        ++i;
                        break;
                    }
                    case 1: {
                        int len = this.readU2();
                        this.writeU2(len);
                        byte[] utf8 = this.readBytes(len);
                        String str = new String(utf8, SmapUtil.SMAP_ENCODING);
                        if (str.equals(nameSDE)) {
                            sdeIndex = i;
                        }
                        this.writeBytes(utf8);
                        break;
                    }
                    default: {
                        throw new IOException("unexpected tag: " + tag);
                    }
                }
                ++i;
            }
            return sdeIndex;
        }

        void writeUtf8ForSDE() {
            int len = nameSDE.length();
            this.writeU1(1);
            this.writeU2(len);
            int i = 0;
            while (i < len) {
                this.writeU1(nameSDE.charAt(i));
                ++i;
            }
        }
    }
}

