/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Set;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.TagInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.jasper.servlet.JspServletWrapper;

public class JspCompilationContext {
    private Hashtable tagFileJars;
    private boolean isPackagedTagFile;
    private String className;
    private String jspUri;
    private boolean isErrPage;
    private String basePackageName;
    private String derivedPackageName;
    private String servletJavaFileName;
    private String javaPath;
    private String classFileName;
    private String contentType;
    private ServletWriter writer;
    private Options options;
    private JspServletWrapper jsw;
    private Compiler jspCompiler;
    private String classPath;
    private String baseURI;
    private String baseOutputDir;
    private String outputDir;
    private ServletContext context;
    private URLClassLoader loader;
    private JspRuntimeContext rctxt;
    private int removed = 0;
    private URLClassLoader jspLoader;
    private URL baseUrl;
    private Class servletClass;
    private boolean isTagFile;
    private boolean protoTypeMode;
    private TagInfo tagInfo;
    private JarFile tagFileJar;
    private static final String[] javaKeywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throws", "transient", "try", "void", "volatile", "while"};

    public JspCompilationContext(String jspUri, boolean isErrPage, Options options, ServletContext context, JspServletWrapper jsw, JspRuntimeContext rctxt) {
        this.jspUri = JspCompilationContext.canonicalURI(jspUri);
        this.isErrPage = isErrPage;
        this.options = options;
        this.jsw = jsw;
        this.context = context;
        this.baseURI = jspUri.substring(0, jspUri.lastIndexOf(47) + 1);
        if (this.baseURI == null) {
            this.baseURI = "/";
        } else if (this.baseURI.charAt(0) != '/') {
            this.baseURI = "/" + this.baseURI;
        }
        if (this.baseURI.charAt(this.baseURI.length() - 1) != '/') {
            this.baseURI = this.baseURI + '/';
        }
        this.rctxt = rctxt;
        this.tagFileJars = new Hashtable();
        this.basePackageName = "org.apache.jsp";
    }

    public JspCompilationContext(String tagfile, TagInfo tagInfo, Options options, ServletContext context, JspServletWrapper jsw, JspRuntimeContext rctxt, JarFile tagFileJar) {
        this(tagfile, false, options, context, jsw, rctxt);
        this.isTagFile = true;
        this.tagInfo = tagInfo;
        this.tagFileJar = tagFileJar;
        if (tagFileJar != null) {
            this.isPackagedTagFile = true;
        }
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return this.rctxt.getClassPath();
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return this.rctxt.getParentClassLoader();
    }

    public void setClassLoader(URLClassLoader loader) {
        this.loader = loader;
    }

    public String getOutputDir() {
        if (this.outputDir == null) {
            this.createOutputDir();
        }
        return this.outputDir;
    }

    public Compiler createCompiler() throws JasperException {
        if (this.jspCompiler != null) {
            return this.jspCompiler;
        }
        this.jspCompiler = new Compiler(this, this.jsw);
        return this.jspCompiler;
    }

    public Compiler getCompiler() {
        return this.jspCompiler;
    }

    public String resolveRelativeUri(String uri) {
        if (uri.startsWith("/") || uri.startsWith(File.separator)) {
            return uri;
        }
        return this.baseURI + uri;
    }

    public InputStream getResourceAsStream(String res) {
        return this.context.getResourceAsStream(JspCompilationContext.canonicalURI(res));
    }

    public URL getResource(String res) throws MalformedURLException {
        return this.context.getResource(JspCompilationContext.canonicalURI(res));
    }

    public Set getResourcePaths(String path) {
        return this.context.getResourcePaths(JspCompilationContext.canonicalURI(path));
    }

    public String getRealPath(String path) {
        if (this.context != null) {
            return this.context.getRealPath(path);
        }
        return path;
    }

    public Hashtable getTagFileJars() {
        return this.tagFileJars;
    }

    public JarFile getTagFileJar() {
        return this.tagFileJar;
    }

    public String getServletClassName() {
        if (this.className != null) {
            return this.className;
        }
        if (this.isTagFile) {
            this.className = this.tagInfo.getTagClassName();
            int lastIndex = this.className.lastIndexOf(46);
            if (lastIndex != -1) {
                this.className = this.className.substring(lastIndex + 1);
            }
        } else {
            int iSep = this.jspUri.lastIndexOf(47) + 1;
            int iEnd = this.jspUri.length();
            StringBuffer modifiedClassName = new StringBuffer(this.jspUri.length() - iSep);
            if (!Character.isJavaIdentifierStart(this.jspUri.charAt(iSep))) {
                modifiedClassName.append('_');
            }
            int i = iSep;
            while (i < iEnd) {
                char ch = this.jspUri.charAt(i);
                if (Character.isJavaIdentifierPart(ch) && ch != '_') {
                    modifiedClassName.append(ch);
                } else if (ch == '.') {
                    modifiedClassName.append('_');
                } else {
                    modifiedClassName.append(JspCompilationContext.mangleChar(ch));
                }
                ++i;
            }
            this.className = modifiedClassName.toString();
        }
        return this.className;
    }

    public void setServletClassName(String className) {
        this.className = className;
    }

    public String getJspFile() {
        return this.jspUri;
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public void setErrorPage(boolean isErrPage) {
        this.isErrPage = isErrPage;
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    public boolean isPrototypeMode() {
        return this.protoTypeMode;
    }

    public void setPrototypeMode(boolean pm) {
        this.protoTypeMode = pm;
    }

    public String getServletPackageName() {
        String dPackageName = this.getDerivedPackageName();
        if (dPackageName.length() == 0) {
            return this.basePackageName;
        }
        return this.basePackageName + '.' + this.getDerivedPackageName();
    }

    private String getDerivedPackageName() {
        if (this.derivedPackageName == null) {
            StringBuffer modifiedPackageName = new StringBuffer();
            int iSep = this.jspUri.lastIndexOf(47);
            int nameStart = 1;
            int i = 1;
            while (i < iSep) {
                char ch = this.jspUri.charAt(i);
                if (i == nameStart && !Character.isJavaIdentifierStart(ch)) {
                    modifiedPackageName.append('_');
                }
                if (Character.isJavaIdentifierPart(ch) && ch != '_') {
                    modifiedPackageName.append(ch);
                } else if (ch == '/') {
                    if (JspCompilationContext.isJavaKeyword(this.jspUri.substring(nameStart, i))) {
                        modifiedPackageName.append('_');
                    }
                    nameStart = i + 1;
                    modifiedPackageName.append('.');
                } else {
                    modifiedPackageName.append(JspCompilationContext.mangleChar(ch));
                }
                ++i;
            }
            if (nameStart < iSep && JspCompilationContext.isJavaKeyword(this.jspUri.substring(nameStart, iSep))) {
                modifiedPackageName.append('_');
            }
            this.derivedPackageName = modifiedPackageName.toString();
        }
        return this.derivedPackageName;
    }

    public void setServletPackageName(String servletPackageName) {
        this.basePackageName = servletPackageName;
    }

    public String getServletJavaFileName() {
        if (this.servletJavaFileName == null) {
            this.servletJavaFileName = this.getOutputDir() + this.getServletClassName() + ".java";
        } else {
            File outDirFile = new File(this.outputDir);
            if (!outDirFile.exists()) {
                outDirFile.mkdirs();
            }
        }
        return this.servletJavaFileName;
    }

    public void setServletJavaFileName(String servletJavaFileName) {
        this.servletJavaFileName = servletJavaFileName;
    }

    public Options getOptions() {
        return this.options;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public JspRuntimeContext getRuntimeContext() {
        return this.rctxt;
    }

    public String getJavaPath() {
        if (this.javaPath != null) {
            return this.javaPath;
        }
        if (this.isTagFile()) {
            String tagName = this.tagInfo.getTagClassName();
            this.javaPath = tagName.replace('.', '/') + ".java";
        } else {
            this.javaPath = this.getServletPackageName().replace('.', '/') + '/' + this.getServletClassName() + ".java";
        }
        return this.javaPath;
    }

    public String getClassFileName() {
        if (this.classFileName == null) {
            this.classFileName = this.getOutputDir() + this.getServletClassName() + ".class";
        } else {
            File outDirFile = new File(this.outputDir);
            if (!outDirFile.exists()) {
                outDirFile.mkdirs();
            }
        }
        return this.classFileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }

    public String[] getTldLocation(String uri) throws JasperException {
        String[] location = this.getOptions().getTldLocationsCache().getLocation(uri);
        return location;
    }

    public boolean keepGenerated() {
        return this.getOptions().getKeepGenerated();
    }

    public void incrementRemoved() {
        if (this.removed > 1) {
            this.jspCompiler.removeGeneratedFiles();
            if (this.rctxt != null) {
                this.rctxt.removeWrapper(this.jspUri);
            }
        }
        ++this.removed;
    }

    public boolean isRemoved() {
        return this.removed > 1;
    }

    public void compile() throws JasperException, FileNotFoundException {
        this.createCompiler();
        if (this.isPackagedTagFile || this.jspCompiler.isOutDated()) {
            try {
                this.jspCompiler.compile();
                this.jsw.setReload(true);
            }
            catch (JasperException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new JasperException(Localizer.getMessage("jsp.error.unable.compile"), (Throwable)ex);
            }
        }
    }

    public Class load() throws JasperException, FileNotFoundException {
        try {
            this.jspLoader = new JasperLoader(new URL[]{this.baseUrl}, this.getClassLoader(), this.rctxt.getPermissionCollection(), this.rctxt.getCodeSource());
            String name = this.isTagFile() ? this.tagInfo.getTagClassName() : this.getServletPackageName() + "." + this.getServletClassName();
            this.servletClass = this.jspLoader.loadClass(name);
        }
        catch (ClassNotFoundException cex) {
            throw new JasperException(Localizer.getMessage("jsp.error.unable.load"), (Throwable)cex);
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.unable.compile"), (Throwable)ex);
        }
        this.removed = 0;
        return this.servletClass;
    }

    private void createOutputDir() {
        String path = null;
        if (this.isTagFile()) {
            String tagName = this.tagInfo.getTagClassName();
            path = tagName.replace('.', '/');
            path = path.substring(0, path.lastIndexOf(47));
        } else {
            path = this.getServletPackageName().replace('.', '/');
        }
        try {
            this.baseUrl = this.options.getScratchDir().toURL();
            String outUrlString = this.baseUrl.toString() + '/' + path;
            URL outUrl = new URL(outUrlString);
            File outDirFile = new File(outUrl.getFile());
            if (!outDirFile.exists()) {
                outDirFile.mkdirs();
            }
            this.outputDir = outDirFile.toString() + File.separator;
        }
        catch (Exception e) {
            throw new IllegalStateException("No output directory: " + e.getMessage());
        }
    }

    private static final String mangleChar(char ch) {
        char[] result = new char[]{'_', Character.forDigit(ch >> 12 & 0xF, 16), Character.forDigit(ch >> 8 & 0xF, 16), Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
        return new String(result);
    }

    private static final boolean isPathSeparator(char c) {
        return c == '/' || c == '\\';
    }

    /*
     * Unable to fully structure code
     */
    private static final String canonicalURI(String s) {
        if (s == null) {
            return null;
        }
        result = new StringBuffer();
        len = s.length();
        pos = 0;
        block4: while (pos < len) {
            c = s.charAt(pos);
            if (!JspCompilationContext.isPathSeparator(c)) ** GOTO lbl-1000
            while (pos + 1 < len && JspCompilationContext.isPathSeparator(s.charAt(pos + 1))) {
                ++pos;
            }
            if (pos + 1 >= len || s.charAt(pos + 1) != '.') ** GOTO lbl-1000
            if (pos + 2 >= len) break;
            switch (s.charAt(pos + 2)) {
                case '/': 
                case '\\': {
                    pos += 2;
                    break;
                }
                case '.': {
                    if (pos + 3 < len && JspCompilationContext.isPathSeparator(s.charAt(pos + 3))) {
                        pos += 3;
                        separatorPos = result.length() - 1;
                        while (separatorPos >= 0 && !JspCompilationContext.isPathSeparator(result.charAt(separatorPos))) {
                            --separatorPos;
                        }
                        if (separatorPos < 0) continue block4;
                        result.setLength(separatorPos);
                        break;
                    }
                }
                default: lbl-1000:
                // 3 sources

                {
                    result.append(c);
                    ++pos;
                }
            }
        }
        return result.toString();
    }

    private static boolean isJavaKeyword(String key) {
        int i = 0;
        int j = javaKeywords.length;
        while (i < j) {
            int k = (i + j) / 2;
            int result = javaKeywords[k].compareTo(key);
            if (result == 0) {
                return true;
            }
            if (result < 0) {
                i = k + 1;
                continue;
            }
            j = k;
        }
        return false;
    }
}

