/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector.parser;

import com.codestreet.selector.parser.IExpression;
import com.codestreet.selector.parser.IValueProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Identifier
implements IExpression {
    private final String id_;
    private final boolean jmsHeader_;
    private static Set jmsHeadersSet_;
    private static Set reservedNamesSet_;
    private static Map idMap_;

    static {
        idMap_ = new HashMap();
        String[] jmsHeaders_ = new String[]{"JMSDeliveryMode", "JMSPriority", "JMSMessageID", "JMSTimestamp", "JMSCorrelationID", "JMSType", "JMSRedelivered", "JMSExpiration"};
        jmsHeadersSet_ = new HashSet<String>(Arrays.asList(jmsHeaders_));
        String[] reservedNames_ = new String[]{"NULL", "TRUE", "FALSE", "NULL", "NOT", "AND", "OR", "BETWEEN", "LIKE", "IN", "IS", "ESCAPE"};
        reservedNamesSet_ = new HashSet<String>(Arrays.asList(reservedNames_));
    }

    public static synchronized Identifier valueOf(String id) {
        if (reservedNamesSet_.contains(id)) {
            throw new IllegalArgumentException("Identifier name cannot be a reserved name: " + id);
        }
        Identifier instance = (Identifier)idMap_.get(id);
        if (instance == null) {
            instance = new Identifier(id);
            idMap_.put(id, instance);
        }
        return instance;
    }

    private Identifier(String id) {
        this.id_ = id;
        this.jmsHeader_ = jmsHeadersSet_.contains(id);
    }

    public String getIdentifier() {
        return this.id_;
    }

    public boolean isJMSHeader() {
        return this.jmsHeader_;
    }

    public Object eval(Map identifiers) {
        return this.getValue(identifiers);
    }

    public Object eval(IValueProvider provider, Object corr) {
        return provider.getValue(this, corr);
    }

    Object getValue(Map identifiers) {
        return identifiers.get(this.id_);
    }

    public String toString() {
        return this.id_;
    }
}

