/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector.jms;

import com.codestreet.selector.parser.IValueProvider;
import com.codestreet.selector.parser.Identifier;
import com.codestreet.selector.parser.NumericValue;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;

public class ValueProvider
implements IValueProvider {
    private final Message msg_;

    public static IValueProvider valueOf(Message msg) {
        return new ValueProvider(msg);
    }

    private ValueProvider(Message msg) {
        this.msg_ = msg;
    }

    public Object getValue(Object identifier, Object correlation) {
        try {
            Object value = ValueProvider.getValue(this.msg_, (Identifier)identifier);
            if (value instanceof Integer) {
                return new NumericValue((Integer)value);
            }
            if (value instanceof Float) {
                return new NumericValue((Float)value);
            }
            if (value instanceof Double) {
                return new NumericValue((Double)value);
            }
            if (value instanceof Long) {
                return new NumericValue((Long)value);
            }
            if (value instanceof Short) {
                return new NumericValue((Short)value);
            }
            if (value instanceof Byte) {
                return new NumericValue((Byte)value);
            }
            return value;
        }
        catch (JMSException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    private static Object getValue(Message msg, Identifier identifier) throws JMSException {
        Message workMsg = msg;
        if (identifier.isJMSHeader()) {
            return ValueProvider.getHeaderValue(workMsg, identifier);
        }
        String fldName = identifier.getIdentifier();
        int ind = fldName.indexOf(46);
        if (ind >= 0) {
            if (ind == 0) {
                fldName = fldName.substring(1);
            }
            StringTokenizer strTok = new StringTokenizer(identifier.getIdentifier(), ".", false);
            while (strTok.hasMoreTokens()) {
                if (!(workMsg instanceof MapMessage)) {
                    return null;
                }
                MapMessage mapMsg = (MapMessage)workMsg;
                fldName = strTok.nextToken();
                Object nestedMsg = mapMsg.getObject(fldName);
                if (strTok.hasMoreTokens()) {
                    if (!(nestedMsg instanceof MapMessage)) {
                        return null;
                    }
                    workMsg = (Message)nestedMsg;
                    continue;
                }
                return nestedMsg;
            }
        }
        if (workMsg.propertyExists(fldName)) {
            return workMsg.getObjectProperty(fldName);
        }
        return null;
    }

    private static Object getHeaderValue(Message msg, Identifier identifier) throws JMSException {
        String prop = identifier.getIdentifier();
        if (prop.equals("JMSMessageID")) {
            return msg.getJMSMessageID();
        }
        if (prop.equals("JMSPriority")) {
            return new Integer(msg.getJMSPriority());
        }
        if (prop.equals("JMSTimestamp")) {
            return new Long(msg.getJMSTimestamp());
        }
        if (prop.equals("JMSCorrelationID")) {
            return msg.getJMSCorrelationID();
        }
        if (prop.equals("JMSDeliveryMode")) {
            return new Integer(msg.getJMSDeliveryMode());
        }
        if (prop.equals("JMSRedelivered")) {
            return new Boolean(msg.getJMSRedelivered());
        }
        if (prop.equals("JMSType")) {
            return msg.getJMSType();
        }
        if (prop.equals("JMSExpiration")) {
            return new Long(msg.getJMSExpiration());
        }
        throw new IllegalStateException("Invalid JMS property referenced: " + prop);
    }
}

