/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.localserver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.junit.Before;

public abstract class ServerTestBase
extends BasicServerTestBase {
    protected SchemeRegistry supportedSchemes;
    protected HttpParams defaultParams;
    protected BasicHttpProcessor httpProcessor;
    protected BasicHttpContext httpContext;
    protected HttpRequestExecutor httpExecutor;

    @Before
    public void setUp() throws Exception {
        if (this.defaultParams == null) {
            this.defaultParams = new SyncBasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)this.defaultParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)this.defaultParams, (String)"UTF-8");
            HttpProtocolParams.setUserAgent((HttpParams)this.defaultParams, (String)"TestAgent/1.1");
            HttpProtocolParams.setUseExpectContinue((HttpParams)this.defaultParams, (boolean)false);
        }
        if (this.supportedSchemes == null) {
            this.supportedSchemes = new SchemeRegistry();
            PlainSocketFactory sf = PlainSocketFactory.getSocketFactory();
            this.supportedSchemes.register(new Scheme("http", 80, (SchemeSocketFactory)sf));
        }
        if (this.httpProcessor == null) {
            this.httpProcessor = new BasicHttpProcessor();
            this.httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestContent());
            this.httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestConnControl());
        }
        this.httpContext = new BasicHttpContext(null);
        if (this.httpExecutor == null) {
            this.httpExecutor = new HttpRequestExecutor();
        }
        if (this.localServer == null) {
            this.localServer = new LocalTestServer(null, null);
            this.localServer.registerDefaultHandlers();
        }
        this.localServer.start();
    }

    protected DefaultHttpClientConnection connectTo(HttpHost target) throws Exception {
        return this.connectTo(target, this.defaultParams);
    }

    protected DefaultHttpClientConnection connectTo(HttpHost target, HttpParams params) throws Exception {
        Scheme schm = this.supportedSchemes.get(target.getSchemeName());
        int port = schm.resolvePort(target.getPort());
        DefaultHttpClientConnection conn = new DefaultHttpClientConnection();
        InetSocketAddress address = new InetSocketAddress(InetAddress.getByName(target.getHostName()), port);
        Socket sock = schm.getSchemeSocketFactory().connectSocket(null, address, null, params);
        conn.bind(sock, params);
        return conn;
    }
}

