/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.localserver;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolException;
import org.apache.http.util.EncodingUtils;

public class BasicAuthTokenExtractor {
    public String extract(HttpRequest request) throws HttpException {
        String s;
        String auth = null;
        Header h = request.getFirstHeader("Authorization");
        if (h != null && (s = h.getValue()) != null) {
            auth = s.trim();
        }
        if (auth != null) {
            int i = auth.indexOf(32);
            if (i == -1) {
                throw new ProtocolException("Invalid Authorization header: " + auth);
            }
            String authscheme = auth.substring(0, i);
            if (authscheme.equalsIgnoreCase("basic")) {
                String s2 = auth.substring(i + 1).trim();
                try {
                    byte[] credsRaw = EncodingUtils.getAsciiBytes((String)s2);
                    Base64 codec = new Base64();
                    auth = EncodingUtils.getAsciiString((byte[])codec.decode(credsRaw));
                }
                catch (DecoderException ex) {
                    throw new ProtocolException("Malformed BASIC credentials");
                }
            }
        }
        return auth;
    }
}

