/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.desktop.standalone;

import java.beans.PropertyVetoException;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

public class MostRecentlyUsedOrderDesktopManager
implements DesktopManager {
    Deque<JInternalFrame> mostRecentlyUsedFrames = new ArrayDeque<JInternalFrame>();
    private DesktopManager delegate;
    private boolean isClosingFrame;

    public MostRecentlyUsedOrderDesktopManager(DesktopManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public void activateFrame(JInternalFrame f) {
        if (f == null || this.isClosingFrame) {
            return;
        }
        this.delegate.activateFrame(f);
        if (!this.mostRecentlyUsedFrames.isEmpty() && f.equals(this.mostRecentlyUsedFrames.getFirst())) {
            this.selectTopFrame(null);
            return;
        }
        if (!this.mostRecentlyUsedFrames.isEmpty() && this.mostRecentlyUsedFrames.contains(f)) {
            this.mostRecentlyUsedFrames.remove(f);
        }
        JInternalFrame previousTop = this.mostRecentlyUsedFrames.isEmpty() ? null : this.mostRecentlyUsedFrames.getFirst();
        this.mostRecentlyUsedFrames.addFirst(f);
        this.selectTopFrame(previousTop);
    }

    @Override
    public void beginDraggingFrame(JComponent f) {
        this.delegate.beginDraggingFrame(f);
    }

    @Override
    public void beginResizingFrame(JComponent f, int direction) {
        this.delegate.beginResizingFrame(f, direction);
    }

    @Override
    public void deactivateFrame(JInternalFrame f) {
        this.delegate.deactivateFrame(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFrame(JInternalFrame f) {
        this.mostRecentlyUsedFrames.remove(f);
        try {
            this.isClosingFrame = true;
            this.delegate.closeFrame(f);
        }
        finally {
            this.isClosingFrame = false;
        }
        this.selectTopFrame(f);
    }

    @Override
    public void iconifyFrame(JInternalFrame f) {
        this.mostRecentlyUsedFrames.remove(f);
        this.selectTopFrame(f);
        this.delegate.iconifyFrame(f);
    }

    @Override
    public void maximizeFrame(JInternalFrame f) {
        this.delegate.maximizeFrame(f);
    }

    @Override
    public void minimizeFrame(JInternalFrame f) {
        this.delegate.minimizeFrame(f);
    }

    @Override
    public void openFrame(JInternalFrame f) {
        this.delegate.openFrame(f);
    }

    @Override
    public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        this.delegate.resizeFrame(f, newX, newY, newWidth, newHeight);
    }

    @Override
    public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        this.delegate.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
    }

    @Override
    public void deiconifyFrame(JInternalFrame f) {
        this.delegate.deiconifyFrame(f);
        this.activateFrame(f);
    }

    @Override
    public void dragFrame(JComponent f, int newX, int newY) {
        this.delegate.dragFrame(f, newX, newY);
    }

    @Override
    public void endDraggingFrame(JComponent f) {
        this.delegate.endDraggingFrame(f);
    }

    @Override
    public void endResizingFrame(JComponent f) {
        this.delegate.endResizingFrame(f);
    }

    protected void selectTopFrame(JInternalFrame previousTopFrame) {
        try {
            if (this.mostRecentlyUsedFrames.isEmpty()) {
                return;
            }
            JInternalFrame topFrame = this.mostRecentlyUsedFrames.getFirst();
            if (previousTopFrame != null && !previousTopFrame.equals(topFrame) && previousTopFrame.isSelected()) {
                previousTopFrame.setSelected(false);
            }
            if (!topFrame.isSelected()) {
                topFrame.setSelected(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }
}

