/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.swing;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.swing.ModalFrameUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ModalFrameDialog {
    private JFrame frame;
    private JTextField textField;
    private JButton okButton;
    private JButton cancelButton;
    private String retValue = null;

    public static String showInputDialog(Frame parent, String question, String title, String initialValue) {
        ModalFrameDialog dialog = new ModalFrameDialog(question, title, initialValue);
        dialog.show(parent);
        return dialog.retValue;
    }

    private ModalFrameDialog(String question, String title, String initialValue) {
        this.textField = new JTextField(initialValue, 20);
        if (initialValue != null) {
            this.textField.setSelectionStart(0);
            this.textField.setSelectionEnd(initialValue.length());
        }
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JLabel iconLabel = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
        iconLabel.setVerticalAlignment(1);
        iconLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(new BorderLayout());
        outerPanel.add((Component)iconLabel, "West");
        outerPanel.add((Component)innerPanel, "Center");
        outerPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        innerPanel.add((Component)new JLabel(question), "North");
        innerPanel.add((Component)this.textField, "Center");
        innerPanel.add((Component)buttonPanel, "South");
        this.frame = new JFrame(title);
        this.frame.getContentPane().add(outerPanel);
        this.frame.getRootPane().setDefaultButton(this.okButton);
        this.frame.pack();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalFrameDialog.this.close(ModalFrameDialog.this.textField.getText());
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalFrameDialog.this.close(null);
            }
        });
    }

    private void show(Frame parent) {
        UISupport.centerDialog(this.frame, parent);
        ModalFrameUtil.showAsModal(this.frame, parent);
    }

    private void close(String retValue) {
        this.retValue = retValue;
        this.frame.setVisible(false);
        this.frame.dispose();
    }
}

