/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.scripting;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import java.util.Stack;

public class ScriptEnginePool {
    private Stack<SoapUIScriptEngine> scriptEngines = new Stack();
    private String script;
    private ModelItem modelItem;
    private int borrowed;
    private String id;

    public ScriptEnginePool(ModelItem modelItem) {
        this.modelItem = modelItem;
    }

    public ScriptEnginePool(String id) {
        this.id = id;
    }

    public void setScript(String script) {
        this.script = script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnScriptEngine(SoapUIScriptEngine scriptEngine) {
        ScriptEnginePool scriptEnginePool = this;
        synchronized (scriptEnginePool) {
            this.scriptEngines.push(scriptEngine);
            --this.borrowed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoapUIScriptEngine getScriptEngine() {
        ScriptEnginePool scriptEnginePool = this;
        synchronized (scriptEnginePool) {
            if (this.scriptEngines.isEmpty()) {
                if (this.modelItem != null) {
                    this.scriptEngines.push(SoapUIScriptEngineRegistry.create(this.modelItem));
                } else {
                    this.scriptEngines.push(SoapUIScriptEngineRegistry.getFactory(this.id).createScriptEngine(null));
                }
            }
            SoapUIScriptEngine result = this.scriptEngines.pop();
            if (this.script != null) {
                result.setScript(this.script);
            }
            ++this.borrowed;
            return result;
        }
    }

    public void release() {
        int waitcount = 10;
        while (this.borrowed > 0 && waitcount-- > 0) {
            try {
                System.out.println("Waiting for " + this.borrowed + " script engines");
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                SoapUI.logError(e);
            }
        }
        for (SoapUIScriptEngine scriptEngine : this.scriptEngines) {
            scriptEngine.release();
        }
        this.scriptEngines.clear();
        if (this.borrowed > 0) {
            System.out.println("Failed to release " + this.borrowed + " script engines");
        }
    }
}

