/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.registry;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.panels.request.views.html.HttpHtmlResponseViewFactory;
import com.eviware.soapui.impl.rest.panels.request.views.json.JsonResponseViewFactory;
import com.eviware.soapui.impl.support.http.HttpRequestContentViewFactory;
import com.eviware.soapui.support.editor.registry.EditorViewFactory;
import com.eviware.soapui.support.editor.views.xml.raw.RawXmlEditorFactory;
import com.eviware.soapui.support.editor.views.xml.source.XmlSourceEditorViewFactory;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistryListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EditorViewFactoryRegistry
implements SoapUIFactoryRegistryListener {
    private static EditorViewFactoryRegistry instance;
    private List<EditorViewFactory> factories = new ArrayList<EditorViewFactory>();

    public EditorViewFactoryRegistry() {
        this.addFactory(new XmlSourceEditorViewFactory());
        this.addFactory(new HttpRequestContentViewFactory());
        this.addFactory(new JsonResponseViewFactory());
        this.addFactory(new HttpHtmlResponseViewFactory());
        this.addFactory(new RawXmlEditorFactory());
        for (EditorViewFactory factory : SoapUI.getFactoryRegistry().getFactories(EditorViewFactory.class)) {
            this.addFactory(factory);
        }
        SoapUI.getFactoryRegistry().addFactoryRegistryListener(this);
    }

    public void addFactory(EditorViewFactory factory) {
        this.factories.add(factory);
    }

    public void setFactory(String viewId, EditorViewFactory factory) {
        for (int c = 0; c < this.factories.size(); ++c) {
            if (!this.factories.get(c).getViewId().equals(viewId)) continue;
            this.factories.set(c, factory);
        }
    }

    public static final EditorViewFactoryRegistry getInstance() {
        if (instance == null) {
            instance = new EditorViewFactoryRegistry();
        }
        return instance;
    }

    public EditorViewFactory[] getFactories() {
        return this.factories.toArray(new EditorViewFactory[this.factories.size()]);
    }

    public EditorViewFactory[] getFactoriesOfType(Class<?> type) {
        ArrayList<EditorViewFactory> result = new ArrayList<EditorViewFactory>();
        for (EditorViewFactory factory : this.factories) {
            if (!Arrays.asList(factory.getClass().getInterfaces()).contains(type)) continue;
            result.add(factory);
        }
        return result.toArray(new EditorViewFactory[result.size()]);
    }

    public void removeFactory(EditorViewFactory factory) {
        this.factories.remove(factory);
    }

    @Override
    public void factoryAdded(Class<?> factoryType, Object factory) {
        if (factoryType.isAssignableFrom(EditorViewFactory.class)) {
            this.addFactory((EditorViewFactory)factory);
        }
    }

    @Override
    public void factoryRemoved(Class<?> factoryType, Object factory) {
        if (factoryType.isAssignableFrom(EditorViewFactory.class)) {
            this.removeFactory((EditorViewFactory)factory);
        }
    }
}

