/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.swing.SwingWorkerDelegator;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDialog
extends JDialog
implements XProgressDialog,
XProgressMonitor {
    private JProgressBar progressBar;
    private JButton cancelButton;
    private Worker worker;

    public ProgressDialog(String title, String label, int length, String initialValue, boolean allowCancel) throws HeadlessException {
        super(UISupport.getMainFrame(), title, true);
        this.setDefaultCloseOperation(0);
        this.progressBar = new JProgressBar(0, length);
        JPanel panel = UISupport.createProgressBarPanel(this.progressBar, 10, true);
        this.progressBar.setString(initialValue);
        this.getContentPane().setLayout(new BorderLayout());
        JLabel progressLabel = new JLabel(label);
        progressLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.getContentPane().add((Component)progressLabel, "North");
        this.getContentPane().add((Component)panel, "Center");
        if (allowCancel) {
            ButtonBarBuilder builder = ButtonBarBuilder.createLeftToRightBuilder();
            builder.addGlue();
            this.cancelButton = new JButton(new CancelAction());
            builder.addFixed((JComponent)this.cancelButton);
            builder.addGlue();
            builder.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.getContentPane().add((Component)builder.getPanel(), "South");
        }
        this.pack();
    }

    @Override
    public void run(Worker worker) {
        this.worker = worker;
        SwingWorkerDelegator swingWorker = new SwingWorkerDelegator(this, this, worker){

            @Override
            public void finished() {
                super.finished();
                ProgressDialog.this.worker = null;
            }
        };
        swingWorker.start();
        this.setVisible(true);
    }

    @Override
    public void setProgress(final int value, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setValue(value);
                ProgressDialog.this.progressBar.setString(string);
                ProgressDialog.this.pack();
            }
        });
    }

    @Override
    public void setDeterminate() {
        this.progressBar.setIndeterminate(false);
    }

    public void setIndeterminate() {
        this.progressBar.setIndeterminate(true);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            UISupport.centerDialog(this);
        }
        super.setVisible(visible);
    }

    @Override
    public void setCancelLabel(String label) {
        if (this.cancelButton != null) {
            this.cancelButton.setText(label);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressDialog.this.worker.onCancel();
        }
    }
}

