/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.support.DocumentListenerAdapter;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.text.Document;

public class JFriendlyTextField
extends JTextField {
    private String helpString;
    private Color originalColor;
    private Color greyColor = new Color(170, 170, 170);
    private Boolean updateInProgress = false;

    private boolean isItOnlyHelpStr() {
        return this.helpString.equals(this.getText());
    }

    private void setHelpString() {
        this.setText(this.helpString);
        this.setFont(this.getFont().deriveFont(2));
        this.setForeground(this.greyColor);
        this.select(0, 0);
        this.updateInProgress = false;
    }

    private void setCustomString(String customString) {
        this.setText(customString);
        this.setFont(this.getFont().deriveFont(0));
        this.setForeground(this.originalColor);
        this.updateInProgress = false;
    }

    public JFriendlyTextField(final String helpString) {
        this.helpString = helpString;
        this.originalColor = this.getForeground();
        this.setToolTipText(helpString);
        this.setHelpString();
        this.setBorder(new LineBorder(this.greyColor, 1));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JFriendlyTextField.this.isItOnlyHelpStr()) {
                    JFriendlyTextField.this.select(0, 0);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JFriendlyTextField.this.isItOnlyHelpStr()) {
                    JFriendlyTextField.this.select(0, 0);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (JFriendlyTextField.this.isItOnlyHelpStr()) {
                    JFriendlyTextField.this.select(0, 0);
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getSource() instanceof JTextField) {
                    ((JTextField)e.getSource()).select(0, 0);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.addKeyListener(new KeyListener(){

            private void CommonKeyPress(KeyEvent e) {
                if (JFriendlyTextField.this.isItOnlyHelpStr() && (e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 36 || e.getKeyCode() == 35 || e.getKeyCode() == 127)) {
                    JFriendlyTextField.this.select(0, 0);
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.CommonKeyPress(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.CommonKeyPress(e);
            }
        });
        this.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                try {
                    String fullText = document.getText(0, document.getLength());
                    if (!JFriendlyTextField.this.updateInProgress.booleanValue()) {
                        String fullTextTemp;
                        if ("".equals(fullText)) {
                            JFriendlyTextField.this.updateInProgress = true;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JFriendlyTextField.this.setHelpString();
                                }
                            });
                        } else if (fullText.contains(helpString) && !"".equals(fullTextTemp = fullText.replace(helpString, ""))) {
                            JFriendlyTextField.this.updateInProgress = true;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JFriendlyTextField.this.setCustomString(fullTextTemp);
                                }
                            });
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

