/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JFormComponent;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileFormComponent
extends JPanel
implements JFormComponent {
    private JTextField textField;
    private AbstractWsdlModelItem<?> modelItem;

    public FileFormComponent(String tooltip) {
        ButtonBarBuilder builder = new ButtonBarBuilder((JPanel)this);
        this.textField = new JTextField(30);
        this.textField.setToolTipText(tooltip);
        builder.addGriddedGrowing((JComponent)this.textField);
        builder.addRelatedGap();
        builder.addFixed((JComponent)new JButton(new SelectFileAction()));
    }

    @Override
    public void setValue(String value) {
        this.textField.setText(value);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    @Override
    public String getValue() {
        return this.textField.getText();
    }

    public void setFile(File file) {
        this.setValue(file.getAbsolutePath());
    }

    public void setModelItem(AbstractWsdlModelItem<?> modelItem) {
        this.modelItem = modelItem;
    }

    public class SelectFileAction
    extends AbstractAction {
        public SelectFileAction() {
            super("Browse...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value = FileFormComponent.this.getValue();
            File file = UISupport.getFileDialogs().open(this, "Select file", null, null, StringUtils.hasContent(value) ? value : PathUtils.getExpandedResourceRoot(FileFormComponent.this.modelItem));
            if (file != null) {
                FileFormComponent.this.setFile(file);
            }
        }
    }
}

