/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.ui;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class XPathCellRender
extends AbstractCellEditor
implements TableCellEditor,
MouseListener,
WindowFocusListener {
    protected JPanel panel = new JPanel();
    JTextArea textArea;
    private JTextField textField;
    protected JFrame frame;
    private JButton resizeBtn;
    protected int mouseX;
    protected int mouseY;

    public XPathCellRender() {
        this.panel.setLayout(new BorderLayout());
        this.textArea = new JTextArea(4, 5);
        this.textArea.setWrapStyleWord(true);
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                switch (evt.getKeyCode()) {
                    case 27: {
                        XPathCellRender.this.frame.setVisible(false);
                    }
                }
            }
        });
        this.panel.add((Component)new JScrollPane(this.textArea), "Center");
        this.panel.setPreferredSize(new Dimension(200, 100));
        this.panel.setMinimumSize(new Dimension(200, 100));
        JXToolBar toolbar = this.initToolbar(UISupport.createToolbar());
        this.panel.add((Component)toolbar, "South");
        this.frame = new JFrame();
        this.frame.addWindowFocusListener(this);
        this.frame.setContentPane(this.panel);
        this.frame.setAlwaysOnTop(true);
        this.frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.frame.setDefaultCloseOperation(1);
        this.frame.setUndecorated(true);
        this.textField = new JTextField();
        this.textField.addMouseListener(this);
    }

    protected JXToolBar initToolbar(JXToolBar toolbar) {
        this.resizeBtn = UISupport.createToolbarButton(UISupport.createImageIcon("/icon_resize.gif"));
        this.resizeBtn.setCursor(new Cursor(5));
        this.resizeBtn.setContentAreaFilled(false);
        this.resizeBtn.setBorder(null);
        this.resizeBtn.setToolTipText("Drag to resize...");
        this.resizeBtn.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                XPathCellRender.this.frame.setSize(XPathCellRender.this.frame.getWidth() - XPathCellRender.this.mouseX + e.getX(), XPathCellRender.this.frame.getHeight() - XPathCellRender.this.mouseY + e.getY());
            }
        });
        this.resizeBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                XPathCellRender.this.mouseX = e.getX();
                XPathCellRender.this.mouseY = e.getY();
            }
        });
        toolbar.add((Component)UISupport.createToolbarButton(new SaveXPathAction()), true);
        toolbar.add((Component)UISupport.createToolbarButton(new CancelXPathAction()), true);
        toolbar.addGlue();
        toolbar.add(this.resizeBtn);
        toolbar.setFloatable(false);
        return toolbar;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String val = (String)table.getModel().getValueAt(row, column);
        this.textField.setText(val);
        return this.textField;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.frame.isVisible()) {
            this.textArea.setText(this.textField.getText().replaceAll(";", ";\n"));
            Point position = this.textField.getLocationOnScreen();
            this.frame.setBounds(position.x, position.y, this.frame.getWidth(), this.frame.getHeight());
            this.frame.pack();
            this.frame.setVisible(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.frame.setVisible(false);
    }

    private class CancelXPathAction
    extends AbstractAction {
        public CancelXPathAction() {
            super("Cancel");
            this.putValue("SmallIcon", UISupport.createImageIcon("/rest_method.gif"));
            this.putValue("ShortDescription", "Cancel Changes");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XPathCellRender.this.frame.setVisible(false);
        }
    }

    private class SaveXPathAction
    extends AbstractAction {
        public SaveXPathAction() {
            super("Save");
            this.putValue("SmallIcon", UISupport.createImageIcon("/disk_multiple.png"));
            this.putValue("ShortDescription", "Save XPath");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            XPathCellRender.this.textField.setText(XPathCellRender.this.textArea.getText());
            XPathCellRender.this.frame.setVisible(false);
        }
    }
}

