/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.ui;

import com.eviware.soapui.config.MaliciousAttachmentSecurityScanConfig;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.impl.swing.JFormDialog;
import javax.swing.JComponent;

public class MaliciousAttachmentAdvancedSettingsPanel {
    private JFormDialog dialog;
    private MaliciousAttachmentSecurityScanConfig config;

    public MaliciousAttachmentAdvancedSettingsPanel(MaliciousAttachmentSecurityScanConfig config) {
        this.config = config;
        this.dialog = (JFormDialog)ADialogBuilder.buildDialog(AdvancedSettings.class);
        this.initDialog();
    }

    private void initDialog() {
        this.dialog.setValue("Request timeout(ms)", String.valueOf(this.config.getRequestTimeout()));
        this.dialog.getFormField("Request timeout(ms)").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                if (newValue == null || newValue.trim().length() == 0) {
                    return;
                }
                try {
                    int val = Integer.valueOf(newValue);
                    MaliciousAttachmentAdvancedSettingsPanel.this.config.setRequestTimeout(val);
                }
                catch (Exception e) {
                    UISupport.showErrorMessage("Request timeout value must be integer number");
                }
            }
        });
    }

    public JComponent getPanel() {
        return this.dialog.getPanel();
    }

    public MaliciousAttachmentSecurityScanConfig getConfig() {
        return this.config;
    }

    public void setConfig(MaliciousAttachmentSecurityScanConfig config) {
        this.config = config;
    }

    public void release() {
        this.dialog.release();
        this.dialog = null;
        this.config = null;
    }

    @AForm(description="Malicious Attachment Configuration", name="Malicious Attachment Configuration")
    protected static interface AdvancedSettings {
        @AField(description="Request timeout(ms)", name="Request timeout(ms)", type=AField.AFieldType.INT)
        public static final String REQUEST_TIMEOUT = "Request timeout(ms)";
    }
}

