/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.ui;

import com.eviware.soapui.config.FuzzerScanConfig;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.impl.swing.JFormDialog;

public class FuzzerScanAdvancedConfigPanel {
    private JFormDialog dialog;
    private FuzzerScanConfig fuzzerScanConfig;

    public FuzzerScanAdvancedConfigPanel(FuzzerScanConfig fuzzerScanConfig) {
        this.fuzzerScanConfig = fuzzerScanConfig;
        this.initDialog();
    }

    public JFormDialog getDialog() {
        return this.dialog;
    }

    private JFormDialog initDialog() {
        this.dialog = (JFormDialog)ADialogBuilder.buildDialog(AdvancedSettings.class);
        this.minimalField(this.fuzzerScanConfig);
        this.maximalField(this.fuzzerScanConfig);
        this.numberOfRequestField(this.fuzzerScanConfig);
        return this.dialog;
    }

    private void minimalField(final FuzzerScanConfig fuzzerScanConfig) {
        XFormField minimal = this.dialog.getFormField("Minimal length");
        minimal.setValue(String.valueOf(fuzzerScanConfig.getMinimal()));
        minimal.addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                try {
                    if ("".equals(newValue)) {
                        return;
                    }
                    Integer.valueOf(newValue);
                    fuzzerScanConfig.setMinimal(Integer.valueOf(newValue));
                }
                catch (Exception e) {
                    UISupport.showErrorMessage("Value must be integer number");
                }
            }
        });
    }

    private void maximalField(final FuzzerScanConfig fuzzerScanConfig) {
        XFormField maximal = this.dialog.getFormField("Maximal length");
        maximal.setValue(String.valueOf(fuzzerScanConfig.getMaximal()));
        maximal.addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                try {
                    if ("".equals(newValue)) {
                        return;
                    }
                    Integer.valueOf(newValue);
                    fuzzerScanConfig.setMaximal(Integer.valueOf(newValue));
                }
                catch (Exception e) {
                    UISupport.showErrorMessage("Value must be integer number");
                }
            }
        });
    }

    private void numberOfRequestField(final FuzzerScanConfig fuzzerScanConfig) {
        XFormField numberOfRequest = this.dialog.getFormField("Number of Requests");
        numberOfRequest.setValue(String.valueOf(fuzzerScanConfig.getNumberOfRequest()));
        numberOfRequest.addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                try {
                    if ("".equals(newValue)) {
                        return;
                    }
                    Integer.valueOf(newValue);
                    fuzzerScanConfig.setNumberOfRequest(Integer.valueOf(newValue));
                }
                catch (Exception e) {
                    UISupport.showErrorMessage("Value must be integer number");
                }
            }
        });
    }

    @AForm(description="Fuzzer Scan", name="Fuzzer Scan")
    protected static interface AdvancedSettings {
        @AField(description="Minimal length of Fuzzed value", name="Minimal length", type=AField.AFieldType.INT)
        public static final String MINIMAL = "Minimal length";
        @AField(description="Maximal length of Fuzzed value", name="Maximal length", type=AField.AFieldType.INT)
        public static final String MAXIMAL = "Maximal length";
        @AField(description="Number of Fuzzed Requests to do", name="Number of Requests", type=AField.AFieldType.INT)
        public static final String NUMBER_OF_REQUEST = "Number of Requests";
    }
}

