/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.registry;

import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.registry.AbstractSecurityScanFactory;
import com.eviware.soapui.security.scan.AbstractSecurityScan;
import com.eviware.soapui.security.scan.SQLInjectionScan;

public class SQLInjectionScanFactory
extends AbstractSecurityScanFactory {
    public SQLInjectionScanFactory() {
        super("SQLInjectionScan", "SQL Injection", "Preforms a scan for SQL Injection Vulnerabilities", "/sql_injection_scan.gif");
    }

    @Override
    public boolean canCreate(TestStep testStep) {
        return testStep instanceof WsdlTestRequestStep || testStep instanceof RestTestRequestStep || testStep instanceof HttpTestRequestStep;
    }

    @Override
    public AbstractSecurityScan buildSecurityScan(TestStep testStep, SecurityScanConfig config, ModelItem parent) {
        return new SQLInjectionScan(testStep, config, parent, "/sql_injection_scan.gif");
    }

    @Override
    public SecurityScanConfig createNewSecurityScan(String name) {
        SecurityScanConfig securityCheckConfig = SecurityScanConfig.Factory.newInstance();
        securityCheckConfig.setType("SQLInjectionScan");
        securityCheckConfig.setName(name);
        return securityCheckConfig;
    }
}

