/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.boundary;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.xml.XmlObjectTreeModel;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.TreeMap;
import javax.swing.tree.TreePath;
import javax.wsdl.Definition;
import org.apache.xmlbeans.XmlException;

public class SchemeTypeExtractor {
    private WsdlRequest request;
    private TreeMap<String, NodeInfo> nodes;

    public SchemeTypeExtractor(WsdlTestRequest request) {
        this.request = request;
    }

    public SchemeTypeExtractor(TestStep testStep) {
        if (testStep instanceof WsdlTestRequestStep) {
            this.request = ((WsdlTestRequestStep)testStep).getHttpRequest();
        }
    }

    public String getTypeFor(String name) throws Exception {
        NodeInfo node = this.nodes.get(name);
        if (node == null) {
            return null;
        }
        return node.getType();
    }

    public TreeMap<String, NodeInfo> getParams() {
        return this.nodes;
    }

    public TreeMap<String, NodeInfo> extract() throws XmlException, Exception {
        XmlObjectTreeModel model = new XmlObjectTreeModel(this.request.getOperation().getInterface().getDefinitionContext().getSchemaTypeSystem(), XmlUtils.createXmlObject(this.request.getRequestContent()));
        this.nodes = this.getElements(model.getRootNode());
        for (NodeInfo node : this.nodes.values()) {
            this.printNode(node);
        }
        return this.nodes;
    }

    private void printNode(NodeInfo node) {
        XmlObjectTreeModel.XmlTreeNode mynode = node.node;
        System.out.println(mynode.getNodeName());
        System.out.println(node.getType());
        System.out.println(node.xpath);
    }

    public TreeMap<String, NodeInfo> getVariableSet() {
        return this.nodes;
    }

    TreeMap<String, NodeInfo> getElements(XmlObjectTreeModel.XmlTreeNode rootXmlTreeNode) {
        TreeMap<String, NodeInfo> result = new TreeMap<String, NodeInfo>();
        for (int cnt = 0; cnt < rootXmlTreeNode.getChildCount(); ++cnt) {
            XmlObjectTreeModel.XmlTreeNode xmlTreeNodeChild = rootXmlTreeNode.getChild(cnt);
            if (xmlTreeNodeChild.getChildCount() > 0) {
                result.putAll(this.getElements(rootXmlTreeNode.getChild(cnt)));
                continue;
            }
            if (xmlTreeNodeChild.getSchemaType() == null || !xmlTreeNodeChild.getSchemaType().isPrimitiveType()) continue;
            result.put(xmlTreeNodeChild.getDomNode().getLocalName(), new NodeInfo(rootXmlTreeNode.getChild(cnt)));
        }
        return result;
    }

    private String declareXPathNamespaces(Definition definition) {
        StringBuilder result = new StringBuilder();
        for (Object shortName : definition.getNamespaces().keySet()) {
            result.append("declare namespace ").append(shortName.toString()).append("='").append(definition.getNamespaces().get(shortName).toString()).append("';");
        }
        return result.toString();
    }

    public class NodeInfo {
        private String name;
        private String text;
        private TreePath treePath;
        private XmlObjectTreeModel.XmlTreeNode node;
        private String xpath;
        private String type;
        private boolean selected = false;

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public TreePath getTreePath() {
            return this.treePath;
        }

        public String getXPath() {
            return this.xpath;
        }

        public NodeInfo(String name, String text, TreePath treePath, XmlObjectTreeModel.XmlTreeNode node, String xpath) {
            this.name = name;
            this.text = text;
            this.treePath = treePath;
            this.node = node;
            this.xpath = xpath;
        }

        public NodeInfo(XmlObjectTreeModel.XmlTreeNode child) {
            this.name = child.getNodeName();
            this.text = child.getNodeText();
            this.treePath = child.getTreePath();
            this.type = child.getSchemaType().toString();
            this.node = child;
            this.xpath = XmlUtils.createXPath(child.getDomNode(), true, false, false, null);
        }

        public String getType() {
            return this.type;
        }

        public String getSimpleName() {
            return this.node.getDomNode().getLocalName();
        }
    }
}

