/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.plugins;

import com.eviware.soapui.SoapUI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class ProductBodyguard
extends Provider {
    private X509Certificate providerCert = null;

    public ProductBodyguard() {
        super("SoapUIOSPluginSignChecker", 1.0, "Plugin signature validity checker");
    }

    private static X509Certificate setupProviderCert() throws IOException, CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(ProductBodyguard.class.getResourceAsStream("/com/eviware/soapui/plugins/PublicKey.key"));
    }

    public final synchronized boolean isKnown(File plugin) {
        JarVerifier jv = new JarVerifier(plugin);
        try {
            if (this.providerCert == null) {
                this.providerCert = ProductBodyguard.setupProviderCert();
            }
            jv.verify(this.providerCert);
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return false;
        }
        return true;
    }

    private class JarVerifier {
        private JarFile jarFile = null;

        JarVerifier(File jarURL) {
            try {
                this.jarFile = new JarFile(jarURL);
            }
            catch (IOException e) {
                SoapUI.logError(e);
            }
        }

        public void verify(X509Certificate targetCert) throws IOException {
            if (targetCert == null) {
                throw new SecurityException("The certificate is not specified.");
            }
            try {
                if (this.jarFile == null) {
                    throw new SecurityException("The plugin is not accessible.");
                }
            }
            catch (Exception ex) {
                SecurityException se = new SecurityException();
                se.initCause(ex);
                throw se;
            }
            Vector<JarEntry> entriesVec = new Vector<JarEntry>();
            Manifest man = this.jarFile.getManifest();
            if (man == null) {
                throw new SecurityException("The plugin '" + this.jarFile.getName() + "' is not signed");
            }
            byte[] buffer = new byte[8192];
            Enumeration<JarEntry> entries = this.jarFile.entries();
            while (entries.hasMoreElements()) {
                int n;
                JarEntry je = entries.nextElement();
                if (je.isDirectory()) continue;
                entriesVec.addElement(je);
                InputStream is = this.jarFile.getInputStream(je);
                while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                }
                is.close();
            }
            Enumeration e = entriesVec.elements();
            while (e.hasMoreElements()) {
                X509Certificate[] certChain;
                JarEntry je = (JarEntry)e.nextElement();
                Certificate[] certs = je.getCertificates();
                if (certs == null || certs.length == 0) {
                    if (je.getName().startsWith("META-INF")) continue;
                    throw new SecurityException("The plugin '" + this.jarFile.getName() + "' has unsigned class files.");
                }
                int startIndex = 0;
                boolean signedAsExpected = false;
                while ((certChain = this.getAChain(certs, startIndex)) != null) {
                    if (certChain[0].equals(targetCert)) {
                        signedAsExpected = true;
                        break;
                    }
                    startIndex += certChain.length;
                }
                if (signedAsExpected) continue;
                throw new SecurityException("The plugin '" + this.jarFile.getName() + "' is not signed by SmartBear Software");
            }
        }

        private X509Certificate[] getAChain(Certificate[] certs, int startIndex) {
            int i;
            if (startIndex > certs.length - 1) {
                return null;
            }
            for (i = startIndex; i < certs.length - 1 && ((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
            }
            int certChainSize = i - startIndex + 1;
            X509Certificate[] ret = new X509Certificate[certChainSize];
            for (int j = 0; j < certChainSize; ++j) {
                ret[j] = (X509Certificate)certs[startIndex + j];
            }
            return ret;
        }

        protected void finalize() throws Throwable {
            this.jarFile.close();
        }
    }
}

