/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.support;

import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.model.mock.MockDispatcher;
import com.eviware.soapui.model.mock.MockResult;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.list.TreeList;

public abstract class AbstractMockDispatcher
implements MockDispatcher {
    private final List<WsdlMockResult> mockResults = Collections.synchronizedList(new TreeList());
    private long maxResults = 100L;
    private int removed = 0;
    private boolean logEnabled = true;

    public MockResult dispatchGetRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        throw new DispatchException("Unsupported HTTP Method: GET");
    }

    public MockResult dispatchPostRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        throw new DispatchException("Unsupported HTTP Method: POST");
    }

    public MockResult dispatchHeadRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        throw new DispatchException("Unsupported HTTP Method: HEAD");
    }

    public MockResult dispatchPutRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        throw new DispatchException("Unsupported HTTP Method: PUT");
    }

    public MockResult dispatchDeleteRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        throw new DispatchException("Unsupported HTTP Method: DELETE");
    }

    public MockResult dispatchPatchRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        throw new DispatchException("Unsupported HTTP Method: PATCH");
    }

    @Override
    public MockResult dispatchRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        String method = request.getMethod();
        if (method.equals("POST")) {
            return this.dispatchPostRequest(request, response);
        }
        if (method.equals("GET")) {
            return this.dispatchGetRequest(request, response);
        }
        if (method.equals("HEAD")) {
            return this.dispatchHeadRequest(request, response);
        }
        if (method.equals("PUT")) {
            return this.dispatchPutRequest(request, response);
        }
        if (method.equals("DELETE")) {
            return this.dispatchDeleteRequest(request, response);
        }
        if (method.equals("PATCH")) {
            return this.dispatchPatchRequest(request, response);
        }
        throw new DispatchException("Unsupported HTTP Method: " + method);
    }

    public synchronized void addMockResult(WsdlMockResult mockResult) {
        if (this.maxResults > 0L && this.logEnabled) {
            this.mockResults.add(mockResult);
        }
        while ((long)this.mockResults.size() > this.maxResults) {
            this.mockResults.remove(0);
            ++this.removed;
        }
    }

    @Override
    public MockResult getMockResultAt(int index) {
        return index <= this.removed ? null : this.mockResults.get(index - this.removed);
    }

    @Override
    public int getMockResultCount() {
        return this.mockResults.size() + this.removed;
    }

    @Override
    public synchronized void clearResults() {
        this.mockResults.clear();
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    @Override
    public synchronized void setMaxResults(long maxNumberOfResults) {
        this.maxResults = maxNumberOfResults;
        while ((long)this.mockResults.size() > maxNumberOfResults) {
            this.mockResults.remove(0);
            ++this.removed;
        }
    }

    @Override
    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }
}

