/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.PropertiesStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.impl.wsdl.support.PathPropertyExternalDependency;
import com.eviware.soapui.impl.wsdl.support.XmlBeansPropertiesTestPropertyHolder;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.BeanPathPropertySupport;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.types.StringList;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;

public class WsdlPropertiesTestStep
extends WsdlTestStep
implements MutableTestPropertyHolder {
    private PropertiesStepConfig propertiesStepConfig;
    private ImageIcon okIcon;
    private ImageIcon failedIcon;
    private XmlBeansPropertiesTestPropertyHolder propertyHolderSupport;
    private BeanPathPropertySupport sourceProperty;
    private BeanPathPropertySupport targetProperty;
    public static final String SOURCE_PROPERTY = WsdlPropertiesTestStep.class.getName() + "@source";
    public static final String TARGET_PROPERTY = WsdlPropertiesTestStep.class.getName() + "@target";

    public WsdlPropertiesTestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, true, forLoadTest);
        if (!forLoadTest) {
            this.okIcon = UISupport.createImageIcon("/properties_step.png");
            this.failedIcon = UISupport.createImageIcon("/failed_properties_step.png");
            this.setIcon(this.okIcon);
        }
        if (config.getConfig() == null) {
            this.propertiesStepConfig = (PropertiesStepConfig)config.addNewConfig().changeType(PropertiesStepConfig.type);
            this.propertiesStepConfig.addNewProperties();
            this.propertiesStepConfig.setCreateMissingOnLoad(true);
        } else {
            this.propertiesStepConfig = (PropertiesStepConfig)config.getConfig().changeType(PropertiesStepConfig.type);
            if (!this.propertiesStepConfig.isSetProperties()) {
                this.propertiesStepConfig.addNewProperties();
            }
            if (!this.propertiesStepConfig.isSetSaveFirst()) {
                this.propertiesStepConfig.setSaveFirst(true);
            }
        }
        this.propertyHolderSupport = new XmlBeansPropertiesTestPropertyHolder(this, this.propertiesStepConfig.getProperties());
        this.sourceProperty = new BeanPathPropertySupport(this, this.propertiesStepConfig, "source");
        this.targetProperty = new BeanPathPropertySupport(this, this.propertiesStepConfig, "target");
    }

    @Override
    public TestStepResult run(TestCaseRunner testRunner, TestCaseRunContext testRunContext) {
        WsdlTestStepResult result;
        block6: {
            String source;
            result = new WsdlTestStepResult(this);
            if (this.okIcon != null) {
                this.setIcon(this.okIcon);
            }
            result.setStatus(TestStepResult.TestStepStatus.OK);
            result.startTimer();
            if (this.isSaveFirst()) {
                this.saveDuringRun(result, testRunContext);
            }
            if (StringUtils.hasContent(source = this.sourceProperty.expand(testRunContext))) {
                try {
                    int cnt = this.loadProperties(source, this.isCreateMissingOnLoad());
                    result.setStatus(TestStepResult.TestStepStatus.OK);
                    result.addMessage("Loaded " + cnt + " properties from [" + source + "]");
                }
                catch (IOException e) {
                    result.stopTimer();
                    result.addMessage("Failed to load properties from [" + source + "]");
                    result.setStatus(TestStepResult.TestStepStatus.FAILED);
                    result.setError(e);
                    if (this.failedIcon == null) break block6;
                    this.setIcon(this.failedIcon);
                }
            }
        }
        if (!this.isSaveFirst()) {
            this.saveDuringRun(result, testRunContext);
        }
        result.stopTimer();
        return result;
    }

    private boolean saveDuringRun(WsdlTestStepResult result, TestCaseRunContext context) {
        String target = this.targetProperty.expand(context);
        if (StringUtils.hasContent(target)) {
            try {
                int cnt = this.saveProperties(target);
                result.setStatus(TestStepResult.TestStepStatus.OK);
                result.addMessage("Saved " + cnt + " properties to [" + target + "]");
            }
            catch (IOException e) {
                result.stopTimer();
                result.addMessage("Failed to save properties to [" + target + "]");
                result.setStatus(TestStepResult.TestStepStatus.FAILED);
                result.setError(e);
                if (this.failedIcon != null) {
                    this.setIcon(this.failedIcon);
                }
                return false;
            }
        }
        return true;
    }

    private int saveProperties(String target) throws IOException {
        return this.propertyHolderSupport.saveTo(System.getProperty(target, target));
    }

    private int loadProperties(String source, boolean createMissing) throws IOException {
        Properties props = new Properties(){
            public StringList names = new StringList();

            @Override
            public synchronized Object put(Object key, Object value) {
                this.names.add(key.toString());
                return super.put(key, value);
            }

            @Override
            public Enumeration<?> propertyNames() {
                return Collections.enumeration(this.names);
            }
        };
        InputStream in = this.getPropertiesInputStream(source);
        props.load(in);
        in.close();
        int cnt = 0;
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            TestProperty property = this.getProperty(name);
            if (property != null) {
                property.setValue(props.get(name).toString());
                ++cnt;
                continue;
            }
            if (!createMissing) continue;
            this.addProperty(name).setValue(props.get(name).toString());
            ++cnt;
        }
        return cnt;
    }

    private InputStream getPropertiesInputStream(String source) throws IOException {
        URL url;
        String fileProperty = System.getProperty(source);
        if (fileProperty != null) {
            source = fileProperty;
        }
        try {
            url = new URL(source);
        }
        catch (MalformedURLException e) {
            url = new URL("file:" + source);
        }
        return url.openStream();
    }

    public TestProperty getTestStepPropertyAt(int index) {
        return this.propertyHolderSupport.getPropertyAt(index);
    }

    public int getStepPropertyCount() {
        return this.propertyHolderSupport.getPropertyCount();
    }

    public String getSource() {
        return this.sourceProperty.get();
    }

    public void setSource(String source) {
        this.sourceProperty.set(source, true);
    }

    public String getTarget() {
        return this.targetProperty.get();
    }

    @Override
    public String getLabel() {
        String str = super.getName() + " (" + this.getPropertyCount() + ")";
        if (this.isDisabled()) {
            str = str + " (disabled)";
        }
        return str;
    }

    public void setTarget(String target) {
        this.targetProperty.set(target, true);
    }

    @Override
    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.propertiesStepConfig = (PropertiesStepConfig)config.getConfig().changeType(PropertiesStepConfig.type);
        this.propertyHolderSupport.resetPropertiesConfig(this.propertiesStepConfig.getProperties());
        this.sourceProperty.setConfig(this.propertiesStepConfig);
        this.targetProperty.setConfig(this.propertiesStepConfig);
    }

    public int loadProperties(boolean createMissing) throws IOException {
        return this.loadProperties(this.sourceProperty.expand(), createMissing);
    }

    public int saveProperties() throws IOException {
        String target = PropertyExpander.expandProperties(this, this.targetProperty.expand());
        return this.saveProperties(target);
    }

    public boolean isCreateMissingOnLoad() {
        return this.propertiesStepConfig.getCreateMissingOnLoad();
    }

    public void setCreateMissingOnLoad(boolean b) {
        this.propertiesStepConfig.setCreateMissingOnLoad(b);
    }

    public boolean isSaveFirst() {
        return this.propertiesStepConfig.getSaveFirst();
    }

    public void setSaveFirst(boolean b) {
        this.propertiesStepConfig.setSaveFirst(b);
    }

    public boolean isDiscardValuesOnSave() {
        return this.propertiesStepConfig.getDiscardValuesOnSave();
    }

    public void setDiscardValuesOnSave(boolean b) {
        this.propertiesStepConfig.setDiscardValuesOnSave(b);
    }

    @Override
    public void setPropertyValue(String name, String value) {
        if (this.isCreateMissingOnLoad() && this.getProperty(name) == null) {
            this.addProperty(name);
        }
        this.propertyHolderSupport.setPropertyValue(name, value);
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        if (this.isDiscardValuesOnSave()) {
            this.clearPropertyValues();
        }
    }

    public void clearPropertyValues() {
        for (TestProperty property : this.propertyHolderSupport.getProperties().values()) {
            property.setValue(null);
        }
    }

    @Override
    public boolean renameProperty(String name, String newName) {
        return PropertyExpansionUtils.renameProperty(this.propertyHolderSupport.getProperty(name), newName, this.getTestCase()) != null;
    }

    @Override
    public TestProperty addProperty(String name) {
        String oldLabel = this.getLabel();
        TestProperty property = this.propertyHolderSupport.addProperty(name);
        this.notifyPropertyChanged(WsdlTestStep.LABEL_PROPERTY, oldLabel, this.getLabel());
        return property;
    }

    @Override
    public void addTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.addTestPropertyListener(listener);
    }

    @Override
    public Map<String, TestProperty> getProperties() {
        return this.propertyHolderSupport.getProperties();
    }

    @Override
    public TestProperty getProperty(String name) {
        return this.propertyHolderSupport.getProperty(name);
    }

    @Override
    public TestProperty getPropertyAt(int index) {
        return this.propertyHolderSupport.getPropertyAt(index);
    }

    @Override
    public List<TestProperty> getPropertyList() {
        return this.propertyHolderSupport.getPropertyList();
    }

    @Override
    public int getPropertyCount() {
        return this.propertyHolderSupport.getPropertyCount();
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyHolderSupport.getPropertyNames();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.propertyHolderSupport.getPropertyValue(name);
    }

    @Override
    public TestProperty removeProperty(String propertyName) {
        String oldLabel = this.getLabel();
        TestProperty result = this.propertyHolderSupport.removeProperty(propertyName);
        this.notifyPropertyChanged(WsdlTestStep.LABEL_PROPERTY, oldLabel, this.getLabel());
        return result;
    }

    @Override
    public void removeTestPropertyListener(TestPropertyListener listener) {
        this.propertyHolderSupport.removeTestPropertyListener(listener);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertyHolderSupport.hasProperty(name);
    }

    public void addExternalDependency(List<ExternalDependency> dependencies) {
        super.addExternalDependencies(dependencies);
        dependencies.add(new PathPropertyExternalDependency(this.targetProperty));
        dependencies.add(new PathPropertyExternalDependency(this.sourceProperty));
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        this.targetProperty.resolveFile(context, "Missing target property file", "properties", "Properties Files (*.properties)", true);
        this.sourceProperty.resolveFile(context, "Missing source property file", "properties", "Properties Files (*.properties)", true);
    }

    @Override
    public void moveProperty(String propertyName, int targetIndex) {
        this.propertyHolderSupport.moveProperty(propertyName, targetIndex);
    }

    public String getSource(boolean expand) {
        return expand ? this.sourceProperty.expand() : this.getSource();
    }

    public String getTarget(boolean expand) {
        return expand ? this.targetProperty.expand() : this.getTarget();
    }
}

