/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.entries;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.WSSEntryConfig;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssContainerListenerAdapter;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssEntryBase;
import com.eviware.soapui.impl.wsdl.support.wss.support.KeystoresComboBoxModel;
import com.eviware.soapui.impl.wsdl.support.wss.support.WSPartsTable;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.soapui.support.xml.XmlUtils;
import com.jgoodies.binding.PresentationModel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.CallbackLookup;
import org.apache.ws.security.message.DOMCallbackLookup;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureEntry
extends WssEntryBase {
    private static final String DEFAULT_OPTION = "<default>";
    public static final String TYPE = "Signature";
    private String crypto;
    private int keyIdentifierType = 0;
    private String signatureAlgorithm;
    private boolean useSingleCert;
    private String signatureCanonicalization;
    private String digestAlgorithm;
    private String customTokenValueType;
    private String customTokenId;
    private List<StringToStringMap> parts = new ArrayList<StringToStringMap>();
    private WssEntryBase.KeyAliasComboBoxModel keyAliasComboBoxModel;
    private InternalWssContainerListener wssContainerListener;
    private JTextField customTokenValueTypeField;
    private JTextField customTokenIdField;

    @Override
    public void init(WSSEntryConfig config, OutgoingWss container) {
        super.init(config, container, TYPE);
    }

    @Override
    protected JComponent buildUI() {
        SimpleBindingForm form = new SimpleBindingForm(new PresentationModel((Object)this));
        form.addSpace(5);
        this.wssContainerListener = new InternalWssContainerListener();
        this.getWssContainer().addWssContainerListener(this.wssContainerListener);
        form.appendComboBox("crypto", "Keystore", new KeystoresComboBoxModel(this.getWssContainer(), this.getWssContainer().getCryptoByName(this.crypto), true), "Selects the Keystore containing the key to use for signing").addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SignatureEntry.this.keyAliasComboBoxModel.update(SignatureEntry.this.getWssContainer().getCryptoByName(SignatureEntry.this.crypto));
            }
        });
        this.keyAliasComboBoxModel = new WssEntryBase.KeyAliasComboBoxModel(this, this.getWssContainer().getCryptoByName(this.crypto));
        form.appendComboBox("username", "Alias", this.keyAliasComboBoxModel, "The alias for the key to use for encryption");
        form.appendPasswordField("password", "Password", "The certificate password");
        JComboBox keyIdentifierTypeComboBox = form.appendComboBox("keyIdentifierType", "Key Identifier Type", new Integer[]{1, 2, 3, 4, 8, 12}, "Sets which key identifier to use");
        keyIdentifierTypeComboBox.setRenderer(new WssEntryBase.KeyIdentifierTypeRenderer(this));
        keyIdentifierTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SignatureEntry.this.initCustomTokenState();
            }
        });
        form.appendComboBox("signatureAlgorithm", "Signature Algorithm", new String[]{DEFAULT_OPTION, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/2000/09/xmldsig#hmac-sha1", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512", "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160", "http://www.w3.org/2001/04/xmldsig-more#hmac-md5", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#rsa-md5", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160"}, "Set the name of the signature encryption algorithm to use");
        form.appendComboBox("signatureCanonicalization", "Signature Canonicalization", new String[]{DEFAULT_OPTION, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "http://www.w3.org/2001/10/xml-exc-c14n#", "http://www.w3.org/2001/10/xml-exc-c14n#WithComments"}, "Set the canonicalization method to use.");
        form.appendComboBox("digestAlgorithm", "Digest Algorithm", new String[]{DEFAULT_OPTION, "http://www.w3.org/2001/04/xmldsig-more#md5", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmldsig-more#sha384", "http://www.w3.org/2001/04/xmlenc#sha512", "http://www.w3.org/2001/04/xmlenc#ripemd160"}, "Set the digest algorithm to use");
        form.appendCheckBox("useSingleCert", "Use Single Certificate", "Use single certificate for signing");
        this.customTokenIdField = form.appendTextField("customTokenId", "Custom Key Identifier", "Use a custom key identifier for signing");
        this.customTokenValueTypeField = form.appendTextField("customTokenValueType", "Custom Key Identifier ValueType", "Specify the custom key identifier value type");
        this.initCustomTokenState();
        form.append("Parts", new WSPartsTable(this.parts, this));
        return new JScrollPane(form.getPanel());
    }

    @Override
    public void release() {
        if (this.wssContainerListener != null) {
            this.getWssContainer().removeWssContainerListener(this.wssContainerListener);
        }
    }

    private void initCustomTokenState() {
        boolean enabled = this.keyIdentifierType == 12;
        this.customTokenValueTypeField.setEnabled(enabled);
        this.customTokenIdField.setEnabled(enabled);
    }

    @Override
    protected void load(XmlObjectConfigurationReader reader) {
        this.crypto = reader.readString("crypto", null);
        this.keyIdentifierType = this.readKeyIdentifierType(reader);
        this.signatureAlgorithm = reader.readString("signatureAlgorithm", null);
        this.signatureCanonicalization = reader.readString("signatureCanonicalization", null);
        this.useSingleCert = reader.readBoolean("useSingleCert", false);
        this.digestAlgorithm = reader.readString("digestAlgorithm", null);
        this.customTokenValueType = reader.readString("customTokenValueType", null);
        this.customTokenId = reader.readString("customTokenId", null);
        this.parts = this.readTableValues(reader, "signaturePart");
    }

    @Override
    protected void save(XmlObjectConfigurationBuilder builder) {
        builder.add("crypto", this.crypto);
        builder.add("keyIdentifierType", this.keyIdentifierType);
        builder.add("signatureAlgorithm", this.signatureAlgorithm);
        builder.add("signatureCanonicalization", this.signatureCanonicalization);
        builder.add("useSingleCert", this.useSingleCert);
        builder.add("digestAlgorithm", this.digestAlgorithm);
        builder.add("customTokenValueType", this.customTokenValueType);
        builder.add("customTokenId", this.customTokenId);
        this.saveTableValues(builder, this.parts, "signaturePart");
    }

    @Override
    public void process(WSSecHeader secHeader, Document doc, PropertyExpansionContext context) {
        block13: {
            StringWriter writer = null;
            try {
                Vector<WSEncryptionPart> wsParts;
                WssCrypto wssCrypto = this.getWssContainer().getCryptoByName(this.crypto);
                if (wssCrypto == null) {
                    throw new Exception("Missing crypto [" + this.crypto + "] for signature entry");
                }
                WSSecSignature wssSign = new WSSecSignature();
                wssSign.setUserInfo(context.expand(this.getUsername()), context.expand(this.getPassword()));
                if (this.keyIdentifierType != 0) {
                    wssSign.setKeyIdentifierType(this.keyIdentifierType);
                }
                if (StringUtils.hasContent(this.signatureAlgorithm) && !this.signatureAlgorithm.equals(DEFAULT_OPTION)) {
                    wssSign.setSignatureAlgorithm(this.signatureAlgorithm);
                }
                if (StringUtils.hasContent(this.signatureCanonicalization) && !this.signatureCanonicalization.equals(DEFAULT_OPTION)) {
                    wssSign.setSigCanonicalization(this.signatureCanonicalization);
                }
                wssSign.setUseSingleCertificate(this.useSingleCert);
                if (StringUtils.hasContent(this.digestAlgorithm)) {
                    wssSign.setDigestAlgo(this.digestAlgorithm);
                }
                if (this.keyIdentifierType == 12) {
                    if (StringUtils.hasContent(this.customTokenId)) {
                        wssSign.setCustomTokenId(context.expand(this.customTokenId));
                    }
                    if (StringUtils.hasContent(this.customTokenValueType)) {
                        wssSign.setCustomTokenValueType(context.expand(this.customTokenValueType));
                    }
                }
                if (!(wsParts = this.createWSParts(this.parts)).isEmpty()) {
                    wssSign.setParts(wsParts);
                }
                writer = new StringWriter();
                XmlUtils.serialize(doc, (Writer)writer);
                wssSign.setCallbackLookup((CallbackLookup)new BinarySecurityTokenDOMCallbackLookup(doc, wssSign));
                wssSign.build(doc, wssCrypto.getCrypto(), secHeader);
            }
            catch (Exception e) {
                SoapUI.logError(e);
                if (writer == null || writer.getBuffer().length() <= 0) break block13;
                try {
                    doc.replaceChild(doc.importNode(XmlUtils.parseXml(writer.toString()).getDocumentElement(), true), doc.getDocumentElement());
                }
                catch (Exception e1) {
                    SoapUI.logError(e1);
                }
            }
        }
    }

    @Override
    protected void addPropertyExpansions(PropertyExpansionsResult result) {
        super.addPropertyExpansions(result);
    }

    public String getCrypto() {
        return this.crypto;
    }

    public void setCrypto(String crypto) {
        this.crypto = crypto;
        this.saveConfig();
    }

    public int getKeyIdentifierType() {
        return this.keyIdentifierType;
    }

    public void setKeyIdentifierType(int keyIdentifierType) {
        this.keyIdentifierType = keyIdentifierType;
        this.saveConfig();
    }

    public String getSignatureAlgorithm() {
        return StringUtils.isNullOrEmpty(this.signatureAlgorithm) ? DEFAULT_OPTION : this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        if (DEFAULT_OPTION.equals(signatureAlgorithm)) {
            signatureAlgorithm = null;
        }
        this.signatureAlgorithm = signatureAlgorithm;
        this.saveConfig();
    }

    public String getDigestAlgorithm() {
        return StringUtils.isNullOrEmpty(this.digestAlgorithm) ? DEFAULT_OPTION : this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        if (DEFAULT_OPTION.equals(digestAlgorithm)) {
            digestAlgorithm = null;
        }
        this.digestAlgorithm = digestAlgorithm;
        this.saveConfig();
    }

    public String getSignatureCanonicalization() {
        return StringUtils.isNullOrEmpty(this.signatureCanonicalization) ? DEFAULT_OPTION : this.signatureCanonicalization;
    }

    public void setSignatureCanonicalization(String signatureCanonicalization) {
        if (DEFAULT_OPTION.equals(signatureCanonicalization)) {
            signatureCanonicalization = null;
        }
        this.signatureCanonicalization = signatureCanonicalization;
        this.saveConfig();
    }

    public boolean isUseSingleCert() {
        return this.useSingleCert;
    }

    public void setUseSingleCert(boolean useSingleCert) {
        this.useSingleCert = useSingleCert;
        this.saveConfig();
    }

    public String getCustomTokenId() {
        return this.customTokenId;
    }

    public void setCustomTokenId(String customTokenId) {
        this.customTokenId = customTokenId;
        this.saveConfig();
    }

    public String getCustomTokenValueType() {
        return this.customTokenValueType;
    }

    public void setCustomTokenValueType(String customTokenValueType) {
        this.customTokenValueType = customTokenValueType;
        this.saveConfig();
    }

    public void setParts(List<StringToStringMap> parts) {
        this.parts = parts;
        this.saveConfig();
    }

    private static class BinarySecurityTokenDOMCallbackLookup
    extends DOMCallbackLookup {
        private final WSSecSignature wssSign;

        public BinarySecurityTokenDOMCallbackLookup(Document doc, WSSecSignature wssSign) {
            super(doc);
            this.wssSign = wssSign;
        }

        public List<Element> getElements(String localname, String namespace) throws WSSecurityException {
            List elements = super.getElements(localname, namespace);
            if (elements.isEmpty() && "BinarySecurityToken".equals(localname) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(namespace)) {
                try {
                    DOMResult result = new DOMResult();
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.transform(new DOMSource(this.wssSign.getBinarySecurityTokenElement()), result);
                    return Collections.singletonList(((Document)result.getNode()).getDocumentElement());
                }
                catch (TransformerException e) {
                    SoapUI.logError(e);
                }
            }
            return elements;
        }
    }

    private final class InternalWssContainerListener
    extends WssContainerListenerAdapter {
        private InternalWssContainerListener() {
        }

        @Override
        public void cryptoUpdated(WssCrypto crypto) {
            if (crypto.getLabel().equals(SignatureEntry.this.getCrypto())) {
                SignatureEntry.this.keyAliasComboBoxModel.update(crypto);
            }
        }
    }
}

