/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.crypto;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.KeyMaterialCryptoConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.impl.wsdl.support.PathPropertyExternalDependency;
import com.eviware.soapui.impl.wsdl.support.wss.DefaultWssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.crypto.CryptoType;
import com.eviware.soapui.impl.wsdl.teststeps.BeanPathPropertySupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.ssl.KeyStoreBuilder;
import org.apache.commons.ssl.ProbablyBadPasswordException;
import org.apache.commons.ssl.Util;
import org.apache.log4j.Logger;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.util.Loader;

public class KeyMaterialWssCrypto
implements WssCrypto {
    private static final String JCEKS_KEYSTORE_TYPE = "jceks";
    private static final String JCEKS_FILE_EXTENSION = "jck";
    private static final String PKCS12_KEYSTORE_TYPE = "pkcs12";
    private static final String PKCS12_FILE_EXTENSION = "pk12";
    private KeyMaterialCryptoConfig config;
    private final WssContainer container;
    private KeyStore keyStore;
    private BeanPathPropertySupport sourceProperty;
    private static final Logger log = Logger.getLogger(KeyMaterialWssCrypto.class);

    public KeyMaterialWssCrypto(KeyMaterialCryptoConfig config2, WssContainer container, String source, String password, CryptoType type) {
        this(config2, container);
        this.setSource(source);
        this.setPassword(password);
        this.setType(type);
    }

    public KeyMaterialWssCrypto(KeyMaterialCryptoConfig cryptoConfig, WssContainer container2) {
        this.config = cryptoConfig;
        this.container = container2;
        this.sourceProperty = new BeanPathPropertySupport((AbstractWsdlModelItem)this.container.getModelItem(), this.config, "source"){

            @Override
            protected void notifyUpdate(String value, String old) {
                KeyMaterialWssCrypto.this.getWssContainer().fireCryptoUpdated(KeyMaterialWssCrypto.this);
            }
        };
    }

    public Merlin getCrypto() {
        try {
            Properties properties = new Properties();
            properties.put("org.apache.ws.security.crypto.merlin.keystore.provider", "this");
            if (this.getType() == CryptoType.TRUSTSTORE) {
                properties.put("org.apache.ws.security.crypto.merlin.truststore.file", this.sourceProperty.expand());
            } else {
                properties.put("org.apache.ws.security.crypto.merlin.keystore.file", this.sourceProperty.expand());
                if (StringUtils.hasContent(this.getDefaultAlias())) {
                    properties.put("org.apache.ws.security.crypto.merlin.keystore.alias", this.getDefaultAlias());
                }
            }
            KeyMaterialCrypto keyMaterialCrypto = new KeyMaterialCrypto(properties);
            return keyMaterialCrypto;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getLabel() {
        String source = this.getSource();
        int ix = source.lastIndexOf(File.separatorChar);
        if (ix == -1) {
            ix = source.lastIndexOf(47);
        }
        if (ix != -1) {
            source = source.substring(ix + 1);
        }
        return source;
    }

    @Override
    public String getSource() {
        return this.sourceProperty.expand();
    }

    public void udpateConfig(KeyMaterialCryptoConfig config) {
        this.config = config;
        this.sourceProperty.setConfig(config);
    }

    public void setSource(String source) {
        this.sourceProperty.set(source, true);
        this.keyStore = null;
    }

    public KeyStore load() throws Exception {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        try {
            UISupport.setHourglassCursor();
            String crypotFilePath = this.sourceProperty.expand();
            String fileExtension = Files.getFileExtension((String)crypotFilePath);
            String keystoreType = this.fileExtensionToKeystoreType(fileExtension);
            ClassLoader loader = Loader.getClassLoader(KeyMaterialWssCrypto.class);
            InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)crypotFilePath);
            this.keyStore = KeyStore.getInstance(keystoreType);
            char[] password = null;
            if (!StringUtils.isNullOrEmpty(this.getPassword())) {
                password = this.getPassword().toCharArray();
            }
            this.keyStore.load(input, password);
            KeyStore keyStore = this.keyStore;
            return keyStore;
        }
        catch (Exception exceptionFromNormalLoad) {
            log.warn((Object)("Using fallback method to load keystore/truststore due to: " + exceptionFromNormalLoad.getMessage()));
            try {
                KeyStore fileExtension = this.keyStore = this.fallbackLoad();
                return fileExtension;
            }
            catch (Exception exceptionFromFallbackLoad) {
                this.keyStore = null;
                SoapUI.logError(exceptionFromFallbackLoad, "Could not load keystore/truststore");
                throw new Exception(exceptionFromFallbackLoad);
            }
        }
        finally {
            UISupport.resetCursor();
        }
    }

    @Nonnull
    private String fileExtensionToKeystoreType(String fileExtension) {
        if (fileExtension.equals(PKCS12_FILE_EXTENSION)) {
            return PKCS12_KEYSTORE_TYPE;
        }
        if (fileExtension.equals(JCEKS_FILE_EXTENSION)) {
            return JCEKS_KEYSTORE_TYPE;
        }
        return KeyStore.getDefaultType();
    }

    @Nullable
    @Deprecated
    private KeyStore fallbackLoad() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, ProbablyBadPasswordException, UnrecoverableKeyException, FileNotFoundException {
        KeyStore fallbackKeystore = null;
        fallbackKeystore = StringUtils.hasContent(this.getDefaultAlias()) && StringUtils.hasContent(this.getAliasPassword()) ? KeyStoreBuilder.build((byte[])Util.streamToBytes((InputStream)new FileInputStream(this.sourceProperty.expand())), (byte[])this.getDefaultAlias().getBytes(), (char[])this.getPassword().toCharArray(), (char[])this.getAliasPassword().toCharArray()) : KeyStoreBuilder.build((byte[])Util.streamToBytes((InputStream)new FileInputStream(this.sourceProperty.expand())), StringUtils.hasContent(this.getPassword()) ? this.getPassword().toCharArray() : null);
        return fallbackKeystore;
    }

    @Override
    public String getStatus() {
        try {
            if (StringUtils.hasContent(this.getSource())) {
                this.load();
                return "OK";
            }
            return "<unavailable>";
        }
        catch (Exception e) {
            return "<error: " + e.getMessage() + ">";
        }
    }

    @Override
    public String getPassword() {
        return this.config.getPassword();
    }

    public String getAliasPassword() {
        return this.config.getAliasPassword();
    }

    public String getDefaultAlias() {
        return this.config.getDefaultAlias();
    }

    public void setAliasPassword(String arg0) {
        this.config.setAliasPassword(arg0);
    }

    public void setDefaultAlias(String arg0) {
        this.config.setDefaultAlias(arg0);
    }

    public void setPassword(String arg0) {
        this.config.setPassword(arg0);
        this.keyStore = null;
        this.getWssContainer().fireCryptoUpdated(this);
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public DefaultWssContainer getWssContainer() {
        return (DefaultWssContainer)this.container;
    }

    public String getCryptoProvider() {
        return this.config.getCryptoProvider();
    }

    public void setCryptoProvider(String provider) {
        this.config.setCryptoProvider(provider);
        this.keyStore = null;
        this.getWssContainer().fireCryptoUpdated(this);
    }

    @Override
    public CryptoType getType() {
        String typeConfig = this.config.getType();
        if (typeConfig == null) {
            typeConfig = CryptoType.KEYSTORE.name();
        }
        CryptoType type = CryptoType.valueOf(typeConfig);
        return type;
    }

    public void setType(@Nonnull CryptoType type) {
        this.config.setType(type.name());
    }

    public void resolve(ResolveContext<?> context) {
        this.sourceProperty.resolveFile(context, "Missing keystore/certificate file");
    }

    public void addExternalDependency(List<ExternalDependency> dependencies) {
        dependencies.add(new PathPropertyExternalDependency(this.sourceProperty));
    }

    private class KeyMaterialCrypto
    extends Merlin {
        private KeyMaterialCrypto(Properties properties) throws CredentialException, IOException {
            super(properties);
        }

        public KeyStore load(InputStream input, String storepass, String provider, String type) throws CredentialException {
            if ("this".equals(provider)) {
                try {
                    return KeyMaterialWssCrypto.this.load();
                }
                catch (Exception e) {
                    throw new CredentialException(0, null, (Throwable)e);
                }
            }
            return super.load(input, storepass, provider, type);
        }

        public String getCryptoProvider() {
            return KeyMaterialWssCrypto.this.config.getCryptoProvider();
        }
    }
}

