/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wsrm;

import com.eviware.soapui.impl.wsdl.support.wsrm.WsrmConfig;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class WsrmBuilder {
    private static final String WSRM_CREATE_SEQUENCE = "CreateSequence";
    private static final String WSRM_EXPIRES = "Expires";
    private static final String WSRM_ACKNOWLEDGMENTS_TO = "AcksTo";
    private static final String WSRM_CLOSE_SEQUENCE = "CloseSequence";
    private static final String WSRM_IDENTIFIER = "Identifier";
    private static final String WSRM_LAST_MESSAGE = "LastMsgNumber";
    private WsrmConfig wsrmConfig;

    public WsrmBuilder(WsrmConfig wsrmConfig) {
        this.wsrmConfig = wsrmConfig;
    }

    public XmlObject constructSequenceRequest() {
        XmlObject object = XmlObject.Factory.newInstance();
        XmlCursor cursor = object.newCursor();
        cursor.insertNamespace("wsrm", this.wsrmConfig.getVersionNameSpace());
        cursor.beginElement(WSRM_CREATE_SEQUENCE, this.wsrmConfig.getVersionNameSpace());
        cursor.insertElementWithText(WSRM_ACKNOWLEDGMENTS_TO, this.wsrmConfig.getAckTo());
        if (this.wsrmConfig.getSequenceExpires() != null) {
            cursor.insertElementWithText(WSRM_EXPIRES, this.wsrmConfig.getSequenceExpires().toString());
        }
        cursor.dispose();
        return object;
    }

    public XmlObject constructSequenceClose() {
        XmlObject object = XmlObject.Factory.newInstance();
        XmlCursor cursor = object.newCursor();
        cursor.toNextToken();
        cursor.insertNamespace("wsrm", this.wsrmConfig.getVersionNameSpace());
        cursor.beginElement(WSRM_CLOSE_SEQUENCE, this.wsrmConfig.getVersionNameSpace());
        cursor.insertElementWithText(WSRM_IDENTIFIER, this.wsrmConfig.getSequenceIdentifier());
        cursor.insertElementWithText(WSRM_LAST_MESSAGE, "1");
        cursor.dispose();
        return object;
    }
}

