/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.metrics;

import com.eviware.soapui.impl.wsdl.submit.transports.http.support.metrics.NanoStopwatch;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.metrics.Stopwatch;
import com.eviware.soapui.support.DateUtil;
import java.util.Date;
import org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.http.io.HttpTransportMetrics;

public class SoapUIMetrics
extends HttpConnectionMetricsImpl {
    private long timestamp = -1L;
    private int httpStatus = -1;
    private long contentLength = -1L;
    private String httpMethod = "";
    private String ipAddress = "";
    private int port = -1;
    private final Stopwatch readTimer = new NanoStopwatch();
    private final Stopwatch totalTimer = new NanoStopwatch();
    private final Stopwatch DNSTimer = new NanoStopwatch();
    private final Stopwatch connectTimer = new NanoStopwatch();
    private final Stopwatch timeToFirstByteTimer = new NanoStopwatch();
    private boolean done = false;

    public SoapUIMetrics(HttpTransportMetrics inTransportMetric, HttpTransportMetrics outTransportMetric) {
        super(inTransportMetric, outTransportMetric);
    }

    public void reset() {
        this.readTimer.reset();
        this.totalTimer.reset();
        this.DNSTimer.reset();
        this.connectTimer.reset();
        this.timeToFirstByteTimer.reset();
        this.httpStatus = -1;
        this.contentLength = -1L;
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public static String formatTimestamp(long timestamp) {
        return DateUtil.formatFull(new Date(timestamp));
    }

    public Stopwatch getDNSTimer() {
        return this.DNSTimer;
    }

    public Stopwatch getTimeToFirstByteTimer() {
        return this.timeToFirstByteTimer;
    }

    public Stopwatch getConnectTimer() {
        return this.connectTimer;
    }

    public Stopwatch getReadTimer() {
        return this.readTimer;
    }

    public Stopwatch getTotalTimer() {
        return this.totalTimer;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getFormattedTimeStamp() {
        return DateUtil.formatFull(new Date(this.getTimestamp()));
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port, int defaultPort) {
        this.port = port != -1 ? port : defaultPort;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("timestamp:").append(this.getFormattedTimeStamp()).append(";status:").append(this.getHttpStatus()).append(";length:").append(this.getContentLength()).append(";DNS time:").append(this.getDNSTimer().getDuration()).append(" ms;connect time:").append(this.getConnectTimer().getDuration()).append(" ms;time to first byte:").append(this.getTimeToFirstByteTimer().getDuration()).append(" ms;read time:").append(this.getReadTimer().getDuration()).append(" ms;total time:").append(this.getTotalTimer().getDuration());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoapUIMetrics)) {
            return false;
        }
        SoapUIMetrics that = (SoapUIMetrics)((Object)o);
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

