/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RemoveEmptyContentRequestFilter
extends AbstractRequestFilter {
    private static final Logger log = Logger.getLogger(RemoveEmptyContentRequestFilter.class);

    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> wsdlRequest) {
        if (wsdlRequest != null && !wsdlRequest.isRemoveEmptyContent()) {
            return;
        }
        String content = (String)context.getProperty("requestContent");
        if (!StringUtils.hasContent(content)) {
            return;
        }
        String soapNamespace = null;
        String newContent = null;
        if (wsdlRequest instanceof WsdlRequest) {
            soapNamespace = ((WsdlRequest)wsdlRequest).getOperation().getInterface().getSoapVersion().getEnvelopeNamespace();
        }
        while (!content.equals(newContent)) {
            if (newContent != null) {
                content = newContent;
            }
            newContent = RemoveEmptyContentRequestFilter.removeEmptyContent(content, soapNamespace, context.hasProperty("RemoveEmptyXsiNil"));
            if (context.hasProperty("RemoveEmptyRecursive")) continue;
        }
        if (newContent != null) {
            context.setProperty("requestContent", newContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeEmptyContent(String content, String soapNamespace, boolean removeXsiNil) {
        XmlCursor cursor = null;
        try {
            XmlObject xmlObject = XmlUtils.createXmlObject(content);
            cursor = xmlObject.newCursor();
            cursor.toNextToken();
            cursor.toNextToken();
            boolean removed = false;
            while (!cursor.isEnddoc()) {
                boolean flag = false;
                if (cursor.isContainer() && (soapNamespace == null || !soapNamespace.equals(cursor.getName().getNamespaceURI()))) {
                    Element elm = (Element)cursor.getDomNode();
                    NamedNodeMap attributes = elm.getAttributes();
                    if (attributes != null && attributes.getLength() > 0) {
                        for (int c = 0; c < attributes.getLength(); ++c) {
                            Node node = attributes.item(c);
                            if (node.getNodeValue() != null && node.getNodeValue().trim().length() != 0) continue;
                            cursor.removeAttribute(XmlUtils.getQName(node));
                            removed = true;
                        }
                    }
                    if (removeXsiNil && attributes.getNamedItem("xsi:nil") != null && (attributes.getLength() == 1 || attributes.getLength() == 2 && attributes.getNamedItem("xmlns:xsi") != null)) {
                        attributes.removeNamedItem("xsi:nil");
                        attributes.removeNamedItem("xmlns:xsi");
                        removed = true;
                    }
                    if (attributes.getLength() == 0 && (cursor.getTextValue() == null || cursor.getTextValue().trim().length() == 0) && XmlUtils.getFirstChildElement(elm) == null && cursor.removeXml()) {
                        removed = true;
                        flag = true;
                    }
                }
                if (flag) continue;
                cursor.toNextToken();
            }
            if (removed) {
                String string = xmlObject.xmlText();
                return string;
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return content;
    }
}

