/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractWssRequestFilter
extends AbstractRequestFilter {
    private static final String REQUEST_CONTENT_HASH_CODE = "requestContentHashCode";
    public static final String WSS_DOC = "WsSecurityAuthenticationRequestFilter@Document";
    protected static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    protected static DocumentBuilder db;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Document getWssDocument(SubmitContext context) throws SAXException, IOException {
        String request = (String)context.getProperty("requestContent");
        Document doc = (Document)context.getProperty(WSS_DOC);
        if (doc == null || ((Integer)context.getProperty(REQUEST_CONTENT_HASH_CODE)).intValue() != request.hashCode()) {
            DocumentBuilder documentBuilder = db;
            synchronized (documentBuilder) {
                doc = db.parse(new InputSource(new StringReader(request)));
                context.setProperty(REQUEST_CONTENT_HASH_CODE, new Integer(request.hashCode()));
                context.setProperty(WSS_DOC, doc);
            }
        }
        return doc;
    }

    protected static void updateWssDocument(SubmitContext context, Document dom) throws IOException {
        StringWriter writer = new StringWriter();
        XmlUtils.serialize(dom, (Writer)writer);
        String request = writer.toString();
        context.setProperty("requestContent", request);
        context.setProperty(REQUEST_CONTENT_HASH_CODE, new Integer(request.hashCode()));
    }

    @Override
    public void afterRequest(SubmitContext context, Response response) {
        context.removeProperty(WSS_DOC);
    }

    static {
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            SoapUI.logError(e);
        }
    }
}

