/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.testcase;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.panels.testcase.JTestRunLog;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.DateUtil;
import java.util.Date;
import javax.swing.SwingUtilities;

public class TestRunLogTestRunListener
extends TestRunListenerAdapter {
    protected final JTestRunLog runLog;
    protected final boolean clearOnRun;

    public TestRunLogTestRunListener(JTestRunLog runLog, boolean clearOnRun) {
        this.runLog = runLog;
        this.clearOnRun = clearOnRun;
    }

    @Override
    public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
        if (SoapUI.getTestMonitor().hasRunningLoadTest(testRunner.getTestCase()) || SoapUI.getTestMonitor().hasRunningSecurityTest(testRunner.getTestCase())) {
            return;
        }
        if (this.clearOnRun) {
            this.runLog.clear();
        }
        String testCaseName = testRunner.getTestCase().getName();
        this.runLog.addBoldText("TestCase [" + testCaseName + "] started at " + DateUtil.formatExtraFull(new Date()));
        this.runLog.setStepIndex(0);
    }

    @Override
    public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
        if (SoapUI.getTestMonitor().hasRunningLoadTest(testRunner.getTestCase()) || SoapUI.getTestMonitor().hasRunningSecurityTest(testRunner.getTestCase())) {
            return;
        }
        WsdlTestCaseRunner wsdlRunner = (WsdlTestCaseRunner)testRunner;
        String testCaseName = testRunner.getTestCase().getName();
        if (testRunner.getStatus() == TestRunner.Status.CANCELED) {
            this.runLog.addText("TestCase [" + testCaseName + "] canceled [" + testRunner.getReason() + "], time taken = " + wsdlRunner.getTimeTaken());
        } else if (testRunner.getStatus() == TestRunner.Status.FAILED) {
            String msg = wsdlRunner.getReason();
            if (wsdlRunner.getError() != null) {
                if (msg != null) {
                    msg = msg + ":";
                }
                msg = msg + wsdlRunner.getError();
            }
            this.runLog.addText("TestCase [" + testCaseName + "] failed [" + msg + "], time taken = " + wsdlRunner.getTimeTaken());
        } else {
            this.runLog.addText("TestCase [" + testCaseName + "] finished with status [" + (Object)((Object)testRunner.getStatus()) + "], time taken = " + wsdlRunner.getTimeTaken());
        }
    }

    @Override
    public synchronized void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, final TestStepResult stepResult) {
        if (SoapUI.getTestMonitor().hasRunningLoadTest(testRunner.getTestCase()) || SoapUI.getTestMonitor().hasRunningSecurityTest(testRunner.getTestCase())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestRunLogTestRunListener.this.runLog.addTestStepResult(stepResult);
            }
        });
    }
}

